/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import java.net.URI;
import mdoc.Reporter;
import mdoc.internal.markdown.DeadLinkInfo;
import mdoc.internal.markdown.DocumentLinks;
import metaconfig.internal.Levenshtein$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.meta.inputs.Position;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LinkHygiene$ {
    public static final LinkHygiene$ MODULE$ = new LinkHygiene$();

    public List<DeadLinkInfo> lint(List<DocumentLinks> docs, boolean verbose) {
        Set isValidHeading = docs.iterator().flatMap((Function1 & Serializable)x$1 -> x$1.absoluteDefinitions()).toSet();
        return docs.map((Function1 & Serializable)doc -> {
            URI enclosingDocument = doc.relpath().toURI(false);
            return new Tuple2(doc, (Object)enclosingDocument);
        }).flatMap((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                DocumentLinks doc = (DocumentLinks)tuple2._1();
                URI enclosingDocument = (URI)tuple2._2();
                return doc.references().flatMap((Function1 & Serializable)reference -> MODULE$.resolve(enclosingDocument, reference.url()).withFilter((Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)LinkHygiene$.$anonfun$lint$5(uri))).withFilter((Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)LinkHygiene$.$anonfun$lint$6(isValidHeading, uri))).map((Function1 & Serializable)uri -> {
                    Object object;
                    Object object2;
                    boolean isAbsolutePath = uri.getPath().startsWith("/");
                    if (verbose) {
                        String headings = ((IterableOnceOps)((IterableOnceOps)isValidHeading.map((Function1 & Serializable)x$2 -> x$2.toString())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n  ");
                        object2 = "\nisValidHeading:\n  " + headings;
                    } else {
                        object2 = "";
                    }
                    String debug = object2;
                    Seq candidates = ((IterableOnceOps)isValidHeading.map((Function1 & Serializable)x$3 -> x$3.toString())).toSeq();
                    Option<String> option = MODULE$.closestCandidate(uri.toString(), (Seq<String>)candidates);
                    if (None$.MODULE$.equals(option)) {
                        object = ".";
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        String similar = (String)some.value();
                        object = ", did you mean '" + similar + "'?";
                    } else {
                        throw new MatchError(option);
                    }
                    String help = object;
                    Object hint = isAbsolutePath ? " To fix this problem, either make the link relative or turn it into complete URL such as http://example.com" + uri + "." : "";
                    return new DeadLinkInfo(reference.pos(), "Unknown link '" + uri + "'" + help + (String)hint + debug);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void report(boolean asError, List<DeadLinkInfo> deadLinks, Reporter reporter) {
        if (asError) {
            Function2 & Serializable intersect = (Function2 & Serializable)(pos, msg) -> {
                reporter.error(pos, msg);
                return BoxedUnit.UNIT;
            };
            deadLinks.foreach((Function1 & Serializable)deadLink -> {
                LinkHygiene$.printDeadLink$1(intersect, deadLink);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Function2 & Serializable intersect = (Function2 & Serializable)(pos, msg) -> {
            reporter.warning(pos, msg);
            return BoxedUnit.UNIT;
        };
        deadLinks.foreach((Function1 & Serializable)deadLink -> {
            LinkHygiene$.printDeadLink$1(intersect, deadLink);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> closestCandidate(String query, Seq<String> candidates) {
        if (candidates.isEmpty()) {
            return None$.MODULE$;
        }
        String candidate = (String)((IterableOps)candidates.sortBy((Function1 & Serializable)s2 -> BoxesRunTime.boxToInteger((int)Levenshtein$.MODULE$.distance(query, s2)), (Ordering)Ordering.Int$.MODULE$)).head();
        int maxLength = query.length() + candidate.length();
        int minDifference = package$.MODULE$.abs(query.length() - candidate.length());
        double difference = (double)Levenshtein$.MODULE$.distance(candidate, query) - (double)minDifference;
        double ratio = ((double)maxLength - difference) / (double)maxLength;
        if (ratio > 0.9) {
            return new Some((Object)candidate);
        }
        return None$.MODULE$;
    }

    private Option<URI> resolve(URI baseUri, String reference) {
        Some some;
        try {
            some = new Some((Object)baseUri.resolve(reference).normalize());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$lint$5(URI uri) {
        return uri.getScheme() == null && uri.getHost() == null;
    }

    public static final /* synthetic */ boolean $anonfun$lint$6(Set isValidHeading$1, URI uri) {
        return !isValidHeading$1.apply((Object)uri);
    }

    private static final void printDeadLink$1(Function2 print, DeadLinkInfo deadLink) {
        DeadLinkInfo deadLinkInfo = deadLink;
        if (deadLinkInfo == null) {
            throw new MatchError((Object)deadLinkInfo);
        }
        Position pos = deadLinkInfo.ref();
        String msg = deadLinkInfo.msg();
        Tuple2 tuple2 = new Tuple2((Object)pos, (Object)msg);
        Position pos2 = (Position)tuple2._1();
        String msg2 = (String)tuple2._2();
        print.apply((Object)pos2, (Object)msg2);
    }

    private LinkHygiene$() {
    }
}

