/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import coursierapi.Dependency;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Feedback$;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import metaconfig.ConfError;
import metaconfig.ConfError$;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.runtime.ModuleSerializationProxy;

public final class Context$
implements Serializable {
    public static final Context$ MODULE$ = new Context$();

    public Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> $lessinit$greater$default$4() {
        return (Map)Map$.MODULE$.empty();
    }

    public Configured<Context> fromSettings(Settings settings, Reporter reporter) {
        if (settings.in().isEmpty()) {
            return Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("in"));
        }
        if (settings.out().isEmpty()) {
            return Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("out"));
        }
        if (settings.in().length() != settings.out().length()) {
            return Configured$.MODULE$.error(Feedback$.MODULE$.inputDifferentLengthOutput(settings.in(), settings.out()));
        }
        List errors = settings.outputByInput().iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                AbsolutePath input = (AbsolutePath)tuple2._1();
                AbsolutePath output = (AbsolutePath)tuple2._2();
                return MODULE$.validateInputOutputPair(settings, input, output);
            }
            throw new MatchError((Object)tuple2);
        }).toList();
        List list = (List)errors.flatten(Predef$.MODULE$.$conforms());
        if (Nil$.MODULE$.equals(list)) {
            Context context = this.fromOptions(settings, reporter);
            settings.onLoad(reporter);
            if (reporter.hasErrors()) {
                return Configured$.MODULE$.error("Failed to load modifiers");
            }
            return Configured$.MODULE$.ok((Object)context);
        }
        return ((ConfError)list.foldLeft((Object)ConfError$.MODULE$.empty(), (Function2 & Serializable)(x$2, x$3) -> x$2.combine(x$3))).notOk();
    }

    private boolean assumedRegularFile(Settings settings, AbsolutePath absPath) {
        String extension = PathIO$.MODULE$.extension(absPath.toNIO());
        return settings.markdownExtensions().toSet().contains((Object)extension);
    }

    private Option<ConfError> validateInputOutputPair(Settings settings, AbsolutePath input, AbsolutePath output) {
        if (!Files.exists(input.toNIO(), new LinkOption[0])) {
            return new Some((Object)ConfError$.MODULE$.fileDoesNotExist(input.toNIO()));
        }
        AbsolutePath absolutePath = input;
        AbsolutePath absolutePath2 = output;
        if (!(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null)) {
            return new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.inputEqualOutput(input)));
        }
        if (output.toNIO().startsWith(input.toNIO()) && !this.assumedRegularFile(settings, output)) {
            return new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outSubdirectoryOfIn(input.toNIO(), output.toNIO())));
        }
        if (input.isFile() && output.isDirectory()) {
            return new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeDirectory(input, output)));
        }
        if (input.isDirectory() && output.isFile()) {
            return new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeRegularFile(input, output)));
        }
        return None$.MODULE$;
    }

    public Context fromCompiler(Settings options, Reporter reporter, MarkdownCompiler compiler) {
        return new Context(options, reporter, compiler, this.$lessinit$greater$default$4());
    }

    public Context fromOptions(Settings options, Reporter reporter) {
        MarkdownCompiler compiler = MarkdownBuilder$.MODULE$.fromClasspath(options.classpath(), options.scalacOptions());
        return this.fromCompiler(options, reporter, compiler);
    }

    public Reporter fromOptions$default$2() {
        return ConsoleReporter$.MODULE$.default();
    }

    public Context apply(Settings settings, Reporter reporter, MarkdownCompiler compiler, Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> compilers) {
        return new Context(settings, reporter, compiler, compilers);
    }

    public Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> apply$default$4() {
        return (Map)Map$.MODULE$.empty();
    }

    public Option<Tuple4<Settings, Reporter, MarkdownCompiler, Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler>>> unapply(Context x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.settings(), (Object)x$0.reporter(), (Object)x$0.compiler(), x$0.compilers()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Context$.class);
    }

    private Context$() {
    }
}

