/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.FileHasher;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DeadLinkInfo;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\u000f\u001e\u0005\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\b\u007f\u0001\u0001\r\u0011\"\u0003A\u0011\u001dI\u0005\u00011A\u0005\n)Ca\u0001\u0015\u0001!B\u0013\t\u0005\"B)\u0001\t\u0013\u0011\u0006\"B*\u0001\t\u0003!\u0006\"\u0002-\u0001\t\u0003I\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00022\u0001\t\u0003\u0019\u0007\"B3\u0001\t\u00031\u0007\"B;\u0001\t\u0003!\u0006\"\u0002<\u0001\t\u0003!\u0006bB<\u0001\u0005\u0004%\t\u0001\u001f\u0005\b\u0003[\u0001\u0001\u0015!\u0003z\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAa!a\u0010\u0001\t\u0003\u0011\u0006BBA!\u0001\u0011\u0005!\u000b\u0003\u0004\u0002D\u0001!\tA\u0015\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ti\u0006\u0001C\u0001\u0003?:q!a\u0019\u001e\u0011\u0003\t)G\u0002\u0004\u001d;!\u0005\u0011q\r\u0005\u0007ae!\t!!\u001b\t\u000f\u0005-\u0014\u0004\"\u0001\u0002n\t9Q*Y5o\u001fB\u001c(B\u0001\u0010 \u0003\r\u0019G.\u001b\u0006\u0003A\u0005\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002E\u0005!Q\u000eZ8d\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019wN\u001c;fqR\u0004\"!\f\u0018\u000e\u0003uI!aL\u000f\u0003\u000f\r{g\u000e^3yi\u00061A(\u001b8jiz\"\"AM\u001a\u0011\u00055\u0002\u0001\"B\u0016\u0003\u0001\u0004a\u0013\u0001C:fiRLgnZ:\u0016\u0003Y\u0002\"!L\u001c\n\u0005aj\"\u0001C*fiRLgnZ:\u0002\u0011I,\u0007o\u001c:uKJ,\u0012a\u000f\t\u0003yuj\u0011!I\u0005\u0003}\u0005\u0012\u0001BU3q_J$XM]\u0001\u000bY&4XM]3m_\u0006$W#A!\u0011\u0007\u0019\u0012E)\u0003\u0002DO\t1q\n\u001d;j_:\u0004\"!R$\u000e\u0003\u0019S!aP\u0010\n\u0005!3%A\u0003'jm\u0016\u0014V\r\\8bI\u0006qA.\u001b<fe\u0016dw.\u00193`I\u0015\fHCA&O!\t1C*\u0003\u0002NO\t!QK\\5u\u0011\u001dye!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003-a\u0017N^3sK2|\u0017\r\u001a\u0011\u0002\u001fM$\u0018M\u001d;MSZ,'/\u001a7pC\u0012$\u0012aS\u0001\u0005Y&tG\u000fF\u0001V!\tic+\u0003\u0002X;\t!Q\t_5u\u00039A\u0017M\u001c3mK6\u000b'o\u001b3po:$\"!\u0016.\t\u000bmS\u0001\u0019\u0001/\u0002\t\u0019LG.\u001a\t\u0003[uK!AX\u000f\u0003\u0013%s\u0007/\u001e;GS2,\u0017!\u00055b]\u0012dWMU3hk2\f'OR5mKR\u0011Q+\u0019\u0005\u00067.\u0001\r\u0001X\u0001\u000bQ\u0006tG\r\\3GS2,GCA+e\u0011\u0015YF\u00021\u0001]\u0003%9(/\u001b;f!\u0006$\b\u000eF\u0002LO\"DQaW\u0007A\u0002qCQ![\u0007A\u0002)\faa\u001d;sS:<\u0007CA6s\u001d\ta\u0007\u000f\u0005\u0002nO5\taN\u0003\u0002pG\u00051AH]8pizJ!!]\u0014\u0002\rA\u0013X\rZ3g\u0013\t\u0019HO\u0001\u0004TiJLgn\u001a\u0006\u0003c\u001e\nAcZ3oKJ\fG/Z\"p[BdW\r^3TSR,\u0017a\u0001:v]\u00061\u0001.Y:iKN,\u0012!\u001f\t\u0007u~\f\u0019!!\u0006\u000e\u0003mT!\u0001`?\u0002\u000f5,H/\u00192mK*\u0011apJ\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0001w\n\u0019Q*\u00199\u0011\t\u0005\u0015\u0011\u0011C\u0007\u0003\u0003\u000fQ1aWA\u0005\u0015\u0011\tY!!\u0004\u0002\u00079LwN\u0003\u0002\u0002\u0010\u0005!!.\u0019<b\u0013\u0011\t\u0019\"a\u0002\u0003\tA\u000bG\u000f\u001b\t\u0005\u0003/\tI#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u001dA\u0017m\u001d5j]\u001eTA!a\b\u0002\"\u00059q/\u0019;dQ\u0016\u0014(\u0002BA\u0012\u0003K\tq!\\3uQZLgN\u0003\u0002\u0002(\u0005\u0011\u0011n\\\u0005\u0005\u0003W\tIB\u0001\u0005GS2,\u0007*Y:i\u0003\u001dA\u0017m\u001d5fg\u0002\n\u0001\u0003[1oI2,w+\u0019;dQ\u00163XM\u001c;\u0015\u0007-\u000b\u0019\u0004C\u0004\u00026I\u0001\r!a\u000e\u0002\u000b\u00154XM\u001c;\u0011\t\u0005e\u00121H\u0007\u0003\u0003;IA!!\u0010\u0002\u001e\t!B)\u001b:fGR|'/_\"iC:<W-\u0012<f]R\faB];o\r&dWmV1uG\",'/A\u0006dY\u0016\f'oU2sK\u0016t\u0017!F<bSRLgn\u001a$pe\u001aKG.Z\"iC:<Wm]\u0001\u000eG>l\u0007/\u001b7fI\u001aKG.Z:\u0015\u000b-\u000bI%a\u0015\t\u000f\u0005-c\u00031\u0001\u0002N\u0005\ta\u000eE\u0002'\u0003\u001fJ1!!\u0015(\u0005\rIe\u000e\u001e\u0005\b\u0003+2\u0002\u0019AA,\u0003\u0015!\u0018.\\3s!\ri\u0013\u0011L\u0005\u0004\u00037j\"!\u0002+j[\u0016\u0014\u0018AD2p[BLG.\u001b8h\r&dWm\u001d\u000b\u0004\u0017\u0006\u0005\u0004bBA&/\u0001\u0007\u0011QJ\u0001\b\u001b\u0006Lgn\u00149t!\ti\u0013d\u0005\u0002\u001aKQ\u0011\u0011QM\u0001\baJ|7-Z:t)\u0019\ti%a\u001c\u0002~!1Ag\u0007a\u0001\u0003c\u0002R!a\u001d\u0002zYj!!!\u001e\u000b\u0005\u0005]\u0014AC7fi\u0006\u001cwN\u001c4jO&!\u00111PA;\u0005)\u0019uN\u001c4jOV\u0014X\r\u001a\u0005\u0006sm\u0001\ra\u000f")
public final class MainOps {
    private final Context context;
    private Option<LiveReload> livereload;
    private final Map<Path, FileHash> hashes;

    public static int process(Configured<Settings> settings, Reporter reporter) {
        return MainOps$.MODULE$.process(settings, reporter);
    }

    public Settings settings() {
        return this.context.settings();
    }

    public Reporter reporter() {
        return this.context.reporter();
    }

    private Option<LiveReload> livereload() {
        return this.livereload;
    }

    private void livereload_$eq(Option<LiveReload> x$1) {
        this.livereload = x$1;
    }

    private void startLivereload() {
        if (this.settings().noLivereload()) {
            return;
        }
        List list = this.settings().out();
        if (Nil$.MODULE$.equals(list)) {
            this.reporter().error("Can't start LiveReload server since --out is empty. To fix this problem, specify an --out argument.");
            return;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            AbsolutePath out = (AbsolutePath)colon2.head();
            List tail = colon2.next$access$1();
            if (tail.nonEmpty()) {
                this.reporter().warning("Starting LiveReload server at directory " + out + " and ignoring --out value(s) " + tail.mkString(", ") + ". To LiveReload another directory, place that directory as the first --out argument.");
            }
            UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(out.toNIO(), this.settings().host(), this.settings().port(), this.reporter(), UndertowLiveReload$.MODULE$.apply$default$5());
            livereload.start();
            this.livereload_$eq((Option<LiveReload>)new Some((Object)livereload));
            return;
        }
        throw new MatchError((Object)list);
    }

    public Exit lint() {
        return (Exit)this.settings().out().foldLeft((Object)Exit$.MODULE$.success(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Exit acc = (Exit)tuple2._1();
                AbsolutePath out = (AbsolutePath)tuple2._2();
                if (out.isDirectory() && !this.settings().noLinkHygiene()) {
                    List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite(this.settings());
                    List<DeadLinkInfo> results = LinkHygiene$.MODULE$.lint(docs, this.settings().verbose());
                    LinkHygiene$.MODULE$.report(this.settings().checkLinkHygiene(), results, this.reporter());
                    if (this.settings().checkLinkHygiene() && results.nonEmpty()) {
                        return acc.merge(Exit$.MODULE$.error());
                    }
                    return acc.merge(Exit$.MODULE$.success());
                }
                return Exit$.MODULE$.success();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public synchronized Exit handleMarkdown(InputFile file) {
        boolean fileHasErrors;
        int originalErrors = this.reporter().errorCount();
        if (this.settings().verbose()) {
            this.reporter().info("Compiling " + file.inputFile());
        }
        Timer timer = new Timer();
        String source = FileIO$.MODULE$.slurp(file.inputFile(), this.settings().charset());
        Input.VirtualFile input = new Input.VirtualFile(file.inputFile().toString(), source);
        String md = Markdown$.MODULE$.toMarkdown((Input)input, this.context, file, (scala.collection.immutable.Map<String, String>)this.settings().site(), this.reporter(), this.settings());
        boolean bl = fileHasErrors = this.reporter().errorCount() > originalErrors;
        if (!fileHasErrors) {
            this.writePath(file, md);
            if (this.settings().verbose()) {
                this.reporter().info("  done => " + file.outputFile() + " (" + timer + ")");
            }
            this.livereload().foreach((Function1 & Serializable)x$1 -> {
                x$1.reload(file.outputFile().toNIO());
                return BoxedUnit.UNIT;
            });
        }
        if (this.reporter().hasErrors()) {
            return Exit$.MODULE$.error();
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleRegularFile(InputFile file) {
        block0: {
            Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
            Files.copy(file.inputFile().toNIO(), file.outputFile().toNIO(), StandardCopyOption.REPLACE_EXISTING);
            if (!this.settings().verbose()) break block0;
            this.reporter().info("Copied    " + file.outputFile().toNIO());
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        try {
            if (!this.settings().isIncluded(file.relpath())) {
                exit = Exit$.MODULE$.success();
            } else {
                String extension = PathIO$.MODULE$.extension(file.inputFile().toNIO());
                exit = this.settings().isMarkdownFileExtension().apply((Object)extension) ? this.handleMarkdown(file) : this.handleRegularFile(file);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                new FileException(file.inputFile(), throwable2).printStackTrace();
                exit = Exit$.MODULE$.error();
            }
            throw throwable;
        }
        return exit;
    }

    public void writePath(InputFile file, String string) {
        if (this.settings().check()) {
            String expected;
            if (!file.outputFile().isFile()) {
                return;
            }
            String string2 = expected = FileIO$.MODULE$.slurp(file.outputFile(), this.settings().charset());
            String string3 = string;
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String filename = file.outputFile().toString();
                String diff = DiffUtils$.MODULE$.unifiedDiff(filename + " (on disk)", filename + " (expected output)", (List<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(expected)).toList(), (List<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(string)).toList(), 3);
                this.reporter().error("--test failed! To fix this problem, re-generate the documentation\n" + diff);
                return;
            }
            return;
        }
        if (file.outputFile().isDirectory()) {
            this.reporter().error("can't write output file '" + file.outputFile() + "' because it's a directory. To fix this problem, either remove this directory or point the --out argument to another path.");
            return;
        }
        Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
        Files.write(file.outputFile().toNIO(), string.getBytes(this.settings().charset()), new OpenOption[0]);
    }

    public Exit generateCompleteSite() {
        List files = (List)IO$.MODULE$.inputFiles(this.settings()).sorted(InputFile$.MODULE$.ordering());
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Exit accum = (Exit)tuple2._1();
                InputFile file = (InputFile)tuple2._2();
                Exit fileExit = this.handleFile(file);
                return accum.merge(fileExit);
            }
            throw new MatchError((Object)tuple2);
        });
        Exit exitLint = exit.merge(this.lint());
        if (files.isEmpty()) {
            this.reporter().error("no input files: " + this.settings().in());
        } else {
            this.compiledFiles(n, timer);
        }
        return exitLint;
    }

    public Exit run() {
        this.settings().out().foreach((Function1 & Serializable)out -> {
            MainOps.$anonfun$run$1(this, out);
            return BoxedUnit.UNIT;
        });
        if (this.settings().watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings().isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            return Exit$.MODULE$.success();
        }
        return isOk;
    }

    public Map<Path, FileHash> hashes() {
        return this.hashes;
    }

    public void handleWatchEvent(DirectoryChangeEvent event) {
        AbsolutePath path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory());
        Option option = this.settings().toInputFile(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            InputFile inputFile = (InputFile)some.value();
            Map<Path, FileHash> map = this.hashes();
            synchronized (map) {
                Option oldHash = this.hashes().get((Object)event.path());
                FileHash newHash = FileHasher.DEFAULT_FILE_HASHER.hash(event.path());
                if (!oldHash.contains((Object)newHash)) {
                    String string = PathIO$.MODULE$.extension(event.path());
                    String string2 = "md";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.clearScreen();
                    }
                    this.hashes().put((Object)event.path(), (Object)newHash);
                    this.reporter().reset();
                    Timer timer = new Timer();
                    this.compilingFiles(1);
                    this.handleFile(inputFile);
                    this.lint();
                    this.compiledFiles(1, timer);
                    this.waitingForFileChanges();
                }
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create((List<AbsolutePath>)this.settings().in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)(Function1 & Serializable)event -> {
            this.handleWatchEvent(event);
            return BoxedUnit.UNIT;
        });
        watcher.watchUntilInterrupted();
        this.livereload().foreach((Function1 & Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter().println("Waiting for file changes (press enter to interrupt)");
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter().errorCount());
        String warnings = this.reporter().hasWarnings() ? ", " + Messages$.MODULE$.count("warning", this.reporter().warningCount()) : "";
        this.reporter().info("Compiled in " + timer + " (" + errors + warnings + ")");
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter().info("Compiling " + files + " to " + this.settings().out().mkString(", "));
    }

    public static final /* synthetic */ void $anonfun$run$1(MainOps $this, AbsolutePath out) {
        if ($this.settings().cleanTarget() && Files.exists(out.toNIO(), new LinkOption[0])) {
            IO$.MODULE$.cleanTarget(out);
            return;
        }
    }

    public MainOps(Context context) {
        this.context = context;
        this.livereload = None$.MODULE$;
        this.hashes = (Map)Map$.MODULE$.empty();
    }
}

