/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.metals.JarTopLevels$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.OverriddenSymbol;
import scala.meta.internal.mtags.ResolvedOverriddenSymbol;
import scala.meta.internal.mtags.UnresolvedOverriddenSymbol;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u00194A\u0001C\u0005\u0001%!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003S\u0001\u0011\u00051\u000bC\u0003\\\u0001\u0011EA\fC\u0003`\u0001\u0011E\u0001\rC\u0003d\u0001\u0011\u0005AM\u0001\tKCJ$\u0016\u0010]3IS\u0016\u0014\u0018M]2is*\u0011!bC\u0001\u0007[\u0016$\u0018\r\\:\u000b\u00051i\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00059y\u0011\u0001B7fi\u0006T\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\tq\"\u0003\u0002\u0017\u001f\t1\u0011I\\=SK\u001a\fAaY8o]B\u0019A#G\u000e\n\u0005iy!!\u0003$v]\u000e$\u0018n\u001c81!\ta\u0012%D\u0001\u001e\u0015\tqr$A\u0002tc2T\u0011\u0001I\u0001\u0005U\u00064\u0018-\u0003\u0002#;\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\t)s\u0005\u0005\u0002'\u00015\t\u0011\u0002C\u0003\u0018\u0005\u0001\u0007\u0001$\u0001\thKR$\u0016\u0010]3IS\u0016\u0014\u0018M]2isR\u0011!\u0006\u0015\t\u0004)-j\u0013B\u0001\u0017\u0010\u0005\u0019y\u0005\u000f^5p]B\u0019aFN\u001d\u000f\u0005=\"dB\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0012\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u00026\u001f\u00059\u0001/Y2lC\u001e,\u0017BA\u001c9\u0005\u0011a\u0015n\u001d;\u000b\u0005Uz\u0001#\u0002\u000b;y\tS\u0015BA\u001e\u0010\u0005\u0019!V\u000f\u001d7fgA\u0011Q\bQ\u0007\u0002})\u0011q(D\u0001\u0003S>L!!\u0011 \u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0011\u0005\r;eB\u0001#F!\t\u0001t\"\u0003\u0002G\u001f\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1u\u0002\u0005\u0002L\u001d6\tAJ\u0003\u0002N\u0017\u0005)Q\u000e^1hg&\u0011q\n\u0014\u0002\u0011\u001fZ,'O]5eI\u0016t7+_7c_2DQ!U\u0002A\u0002q\n1A[1s\u0003Q\tG\r\u001a+za\u0016D\u0015.\u001a:be\u000eD\u00170\u00138g_R\u0019AkV-\u0011\u0005Q)\u0016B\u0001,\u0010\u0005\rIe\u000e\u001e\u0005\u00061\u0012\u0001\r\u0001P\u0001\u0005a\u0006$\b\u000eC\u0003[\t\u0001\u0007Q&\u0001\busB,w\f[5fe\u0006\u00148\r[=\u0002\r\u0005$GMS1s)\tif\fE\u0002\u0015WQCQ\u0001W\u0003A\u0002q\nA\u0003];u)f\u0004X\rS5fe\u0006\u00148\r[=J]\u001a|Gc\u0001+bE\")\u0011K\u0002a\u0001)\")!L\u0002a\u0001[\u0005aq-\u001a;N\tV\"\u0015nZ3tiR\u0011!)\u001a\u0005\u00061\u001e\u0001\r\u0001\u0010")
public class JarTypeHierarchy {
    private final Function0<Connection> conn;

    public Option<List<Tuple3<AbsolutePath, String, OverriddenSymbol>>> getTypeHierarchy(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select th.symbol, th.parent_name, th.path, th.is_resolved\n            |from indexed_jar ij\n            |left join type_hierarchy th\n            |on ij.id=th.jar\n            |where ij.type_hierarchy_indexed=true and ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$7 -> {
                x$7.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null && rs.getString(4) != null) {
                    String symbol = rs.getString(1);
                    String parentName = rs.getString(2);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(3), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    boolean isResolved = rs.getBoolean(4);
                    ResolvedOverriddenSymbol overridden = isResolved ? new ResolvedOverriddenSymbol(parentName) : new UnresolvedOverriddenSymbol(parentName);
                    return toplevels.$plus$eq((Object)new Tuple3((Object)path2, (Object)symbol, (Object)overridden));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$8 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTypeHierarchy"), new Line(208), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public int addTypeHierarchyInfo(AbsolutePath path2, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        Option<Object> jar = this.addJar(path2);
        return BoxesRunTime.unboxToInt((Object)jar.map((Function1)(JFunction1.mcII.sp & Serializable)x$9 -> this.putTypeHierarchyInfo(x$9, type_hierarchy)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public Option<Object> addJar(AbsolutePath path2) {
        Some some;
        try (Statement jarStmt = null;){
            try {
                jarStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5, type_hierarchy_indexed) values (?, ?)", 1);
                jarStmt.setString(1, this.getMD5Digest(path2));
                jarStmt.setBoolean(2, true);
                jarStmt.executeUpdate();
                ResultSet rs = jarStmt.getGeneratedKeys();
                rs.next();
                some = new Some((Object)BoxesRunTime.boxToInteger((int)rs.getInt("id")));
            }
            catch (JdbcSQLIntegrityConstraintViolationException e) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("addJar"), new Line(236), MDC$.MODULE$.instance());
                some = None$.MODULE$;
            }
        }
        return some;
    }

    public int putTypeHierarchyInfo(int jar, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        if (type_hierarchy.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                try {
                    symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into type_hierarchy (symbol, parent_name, path, jar, is_resolved) values (?, ?, ?, ?, ?)");
                    type_hierarchy.foreach((Function1 & Serializable)x0$1 -> {
                        JarTypeHierarchy.$anonfun$putTypeHierarchyInfo$1(symbolStmt, jar, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                catch (JdbcBatchUpdateException e) {
                    scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("putTypeHierarchyInfo"), new Line(273), MDC$.MODULE$.instance());
                    n = 0;
                }
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public String getMD5Digest(AbsolutePath path2) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path2.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(path2.toString() + ":" + attributes.lastModifiedTime().toMillis() + ":" + attributes.size());
    }

    public static final /* synthetic */ void $anonfun$putTypeHierarchyInfo$1(ObjectRef symbolStmt$2, int jar$4, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple3._1();
            String symbol = (String)tuple3._2();
            OverriddenSymbol overridden = (OverriddenSymbol)tuple3._3();
            ((PreparedStatement)symbolStmt$2.elem).setString(1, symbol);
            OverriddenSymbol overriddenSymbol = overridden;
            if (overriddenSymbol instanceof ResolvedOverriddenSymbol) {
                ResolvedOverriddenSymbol resolvedOverriddenSymbol = (ResolvedOverriddenSymbol)overriddenSymbol;
                String name = resolvedOverriddenSymbol.symbol();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setInt(3, 0);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, true);
            } else if (overriddenSymbol instanceof UnresolvedOverriddenSymbol) {
                UnresolvedOverriddenSymbol unresolvedOverriddenSymbol = (UnresolvedOverriddenSymbol)overriddenSymbol;
                String name = unresolvedOverriddenSymbol.name();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, false);
            } else {
                throw new MatchError((Object)overriddenSymbol);
            }
            ((PreparedStatement)symbolStmt$2.elem).setString(3, path2.toString());
            ((PreparedStatement)symbolStmt$2.elem).setInt(4, jar$4);
            ((PreparedStatement)symbolStmt$2.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public JarTypeHierarchy(Function0<Connection> conn) {
        this.conn = conn;
    }
}

