/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.internal.process.SystemProcess;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public final class ManifestJar$ {
    public static final ManifestJar$ MODULE$ = new ManifestJar$();

    public SystemProcess withTempManifestJar(Seq<Path> classpath, Function1<AbsolutePath, SystemProcess> op, ExecutionContext ec) {
        AbsolutePath manifestJar = this.createManifestJar(AbsolutePath$.MODULE$.apply(Files.createTempFile("jvm-forker-manifest", ".jar", new FileAttribute[0]).toAbsolutePath(), AbsolutePath$.MODULE$.workingDirectory()), classpath);
        SystemProcess process = (SystemProcess)op.apply((Object)manifestJar);
        process.complete().onComplete((Function1 & Serializable)x0$1 -> {
            ManifestJar$.$anonfun$withTempManifestJar$1(manifestJar, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        return process;
    }

    public AbsolutePath createManifestJar(AbsolutePath manifestJar, Seq<Path> classpath) {
        if (!MetalsEnrichments$.MODULE$.XtensionAbsolutePath(manifestJar).exists()) {
            MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(manifestJar).touch();
            manifestJar.toNIO().toFile().deleteOnExit();
        }
        String classpathStr = ((IterableOnceOps)classpath.map((Function1 & Serializable)path2 -> URIEncoderDecoder$.MODULE$.encode(path2.toUri().toString()))).mkString(" ");
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpathStr);
        OutputStream out = Files.newOutputStream(manifestJar.toNIO(), new OpenOption[0]);
        Using$.MODULE$.resource((Object)new JarOutputStream(out, manifest), (Function1 & Serializable)x -> (JarOutputStream)Predef$.MODULE$.identity(x), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return manifestJar;
    }

    public static final /* synthetic */ void $anonfun$withTempManifestJar$1(AbsolutePath manifestJar$1, Try x0$1) {
        Try try_ = x0$1;
        MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(manifestJar$1).delete();
    }

    private ManifestJar$() {
    }
}

