/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.meta.inputs.Input;
import scala.meta.internal.metals.Classfile$;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.Messages$WorkspaceSymbolDependencies$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.SemanticdbDefinition;
import scala.meta.internal.metals.SemanticdbDefinition$;
import scala.meta.internal.metals.WorkspaceSearchVisitor$;
import scala.meta.internal.metals.WorkspaceSymbolQuery;
import scala.meta.internal.mtags.GlobalSymbolIndex;
import scala.meta.internal.mtags.Symbol;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.SymbolSearchVisitor;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\u0010 \u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011\u0011\u0004!\u0011!Q\u0001\f\u0015DQ\u0001\u001b\u0001\u0005\u0002%Dqa\u001d\u0001C\u0002\u0013%A\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B;\t\u0011\u0005\u0015\u0001A1A\u0005\nQDq!a\u0002\u0001A\u0003%Q\u000fC\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f!A\u0011Q\u0005\u0001!\u0002\u0013\ti\u0001C\u0004\u0002(\u0001!\t!!\u000b\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA\u001e\u0001\u0001\u0006I!!\u000e\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003\u0002CA2\u0001\u0001\u0006I!a\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\ti\f\u0001C!\u0003\u007fCq!!1\u0001\t\u0013\t\u0019mB\u0005\u0002J~\t\t\u0011#\u0001\u0002L\u001aAadHA\u0001\u0012\u0003\ti\r\u0003\u0004i7\u0011\u0005\u0011Q\u001b\u0005\n\u0003/\\\u0012\u0013!C\u0001\u00033\u0014acV8sWN\u0004\u0018mY3TK\u0006\u00148\r\u001b,jg&$xN\u001d\u0006\u0003A\u0005\na!\\3uC2\u001c(B\u0001\u0012$\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0013&\u0003\u0011iW\r^1\u000b\u0003\u0019\nQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001SA\u0011!&L\u0007\u0002W)\u0011AfI\u0001\u0003a\u000eL!AL\u0016\u0003'MKXNY8m'\u0016\f'o\u00195WSNLGo\u001c:\u0002\u0013]|'o[:qC\u000e,\u0007CA\u00195\u001b\u0005\u0011$BA\u001a$\u0003\tIw.\u0003\u00026e\ta\u0011IY:pYV$X\rU1uQ\u0006)\u0011/^3ssB\u0011\u0001(O\u0007\u0002?%\u0011!h\b\u0002\u0015/>\u00148n\u001d9bG\u0016\u001c\u00160\u001c2pYF+XM]=\u0002\u000bQ|7.\u001a8\u0011\u0005u2U\"\u0001 \u000b\u0005}\u0002\u0015a\u00026t_:\u0014\bo\u0019\u0006\u0003\u0003\n\u000bQ\u0001\\:qi)T!a\u0011#\u0002\u000f\u0015\u001cG.\u001b9tK*\tQ)A\u0002pe\u001eL!a\u0012 \u0003\u001b\r\u000bgnY3m\u0007\",7m[3s\u0003\u0015Ig\u000eZ3y!\tQU*D\u0001L\u0015\ta\u0015%A\u0003ni\u0006<7/\u0003\u0002O\u0017\n\tr\t\\8cC2\u001c\u00160\u001c2pY&sG-\u001a=\u0002'M\fg/Z\"mCN\u001ch)\u001b7f)>$\u0015n]6\u0011\u0005E\u0013V\"A\u0013\n\u0005M+#a\u0002\"p_2,\u0017M\\\u0001\u000fe\u0016\u001cX\u000f\u001c;Pe\u0012,'/\u001b8h!\r1f,\u0019\b\u0003/rs!\u0001W.\u000e\u0003eS!AW\u0014\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013BA/&\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0011=\u0013H-\u001a:j]\u001eT!!X\u0013\u0011\u0005)\u0013\u0017BA2L\u0005A\u0019\u00160\u001c2pY\u0012+g-\u001b8ji&|g.\u0001\u0002sGB\u0011\u0001HZ\u0005\u0003O~\u0011QBU3q_J$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0004k[:|\u0007/\u001d:\u0015\u0005-d\u0007C\u0001\u001d\u0001\u0011\u0015!\u0007\u0002q\u0001f\u0011\u0015y\u0003\u00021\u00011\u0011\u00151\u0004\u00021\u00018\u0011\u0015Y\u0004\u00021\u0001=\u0011\u0015A\u0005\u00021\u0001J\u0011\u0015y\u0005\u00021\u0001Q\u0011\u001d!\u0006\u0002%AA\u0002U\u000bQB\u001a:p[^{'o[:qC\u000e,W#A;\u0011\u0007Y\\X0D\u0001x\u0015\tA\u00180\u0001\u0003vi&d'\"\u0001>\u0002\t)\fg/Y\u0005\u0003y^\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u0005y|X\"\u0001!\n\u0007\u0005\u0005\u0001IA\tTs6\u0014w\u000e\\%oM>\u0014X.\u0019;j_:\faB\u001a:p[^{'o[:qC\u000e,\u0007%A\u0007ge>l7\t\\1tgB\fG\u000f[\u0001\u000fMJ|Wn\u00117bgN\u0004\u0018\r\u001e5!\u0003E\u0011WO\u001a4fe\u0016$7\t\\1tgB\fG\u000f[\u000b\u0003\u0003\u001b\u0001BA^>\u0002\u0010A9\u0011+!\u0005\u0002\u0016\u0005U\u0011bAA\nK\t1A+\u001e9mKJ\u0002B!a\u0006\u0002 9!\u0011\u0011DA\u000e!\tAV%C\u0002\u0002\u001e\u0015\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000fK\u0005\u0011\"-\u001e4gKJ,Gm\u00117bgN\u0004\u0018\r\u001e5!\u0003)\tG\u000e\u001c*fgVdGo\u001d\u000b\u0003\u0003W\u0001BAVA\u0017{&\u0019\u0011q\u00061\u0003\u0007M+\u0017/\u0001\u0007cs:\u000bW.\u001a'f]\u001e$\b.\u0006\u0002\u00026I1\u0011qGA\u001f\u0003\u00132a!!\u000f\u0012\u0001\u0005U\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014!\u00042z\u001d\u0006lW\rT3oORD\u0007\u0005\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019%_\u0001\u0005Y\u0006tw-\u0003\u0003\u0002H\u0005\u0005#AB(cU\u0016\u001cG\u000f\u0005\u0003w\u0003\u0017j\u0018bAA'o\nQ1i\\7qCJ\fGo\u001c:\u0002\u0013%\u001ch+[:ji\u0016$WCAA*!\u0015\t)&a\u00181\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003;*\u0013AC2pY2,7\r^5p]&!\u0011\u0011MA,\u0005\r\u0019V\r^\u0001\u000bSN4\u0016n]5uK\u0012\u0004\u0013A\u00033fM&t\u0017\u000e^5p]RA\u0011\u0011NA8\u0003g\n9\b\u0005\u0003R\u0003W\n\u0017bAA7K\t1q\n\u001d;j_:Dq!!\u001d\u0015\u0001\u0004\t)\"A\u0002qW\u001eDq!!\u001e\u0015\u0001\u0004\t)\"\u0001\u0005gS2,g.Y7f\u0011\u0015AE\u00031\u0001J\u0003I\u0019\bn\\;mIZK7/\u001b;QC\u000e\\\u0017mZ3\u0015\u0007A\u000bi\bC\u0004\u0002rU\u0001\r!!\u0006\u0002)YL7/\u001b;X_J\\7\u000f]1dKNKXNY8m))\t\u0019)!#\u0002\u001e\u0006\u0005\u00161\u0016\t\u0004#\u0006\u0015\u0015bAADK\t\u0019\u0011J\u001c;\t\u000f\u0005-e\u00031\u0001\u0002\u000e\u0006!\u0001/\u0019;i!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000bAAZ5mK*\u0019\u0011qS=\u0002\u00079Lw.\u0003\u0003\u0002\u001c\u0006E%\u0001\u0002)bi\"Dq!a(\u0017\u0001\u0004\t)\"\u0001\u0004ts6\u0014w\u000e\u001c\u0005\b\u0003G3\u0002\u0019AAS\u0003\u0011Y\u0017N\u001c3\u0011\u0007y\f9+C\u0002\u0002*\u0002\u0013!bU=nE>d7*\u001b8e\u0011\u001d\tiK\u0006a\u0001\u0003_\u000bQA]1oO\u0016\u00042A`AY\u0013\r\t\u0019\f\u0011\u0002\u0006%\u0006tw-Z\u0001\u000fm&\u001c\u0018\u000e^\"mCN\u001ch-\u001b7f)\u0019\t\u0019)!/\u0002<\"9\u0011\u0011O\fA\u0002\u0005U\u0001bBA;/\u0001\u0007\u0011QC\u0001\fSN\u001c\u0015M\\2fY2,G\rF\u0001Q\u0003=)\u0007\u0010]1oI\u000ec\u0017m]:gS2,GCBAB\u0003\u000b\f9\rC\u0004\u0002re\u0001\r!!\u0006\t\u000f\u0005U\u0014\u00041\u0001\u0002\u0016\u00051rk\u001c:lgB\f7-Z*fCJ\u001c\u0007NV5tSR|'\u000f\u0005\u000297M\u00191$a4\u0011\u0007E\u000b\t.C\u0002\u0002T\u0016\u0012a!\u00118z%\u00164GCAAf\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u001c\u0016\u0004+\u0006u7FAAp!\u0011\t\t/a;\u000e\u0005\u0005\r(\u0002BAs\u0003O\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%X%\u0001\u0006b]:|G/\u0019;j_:LA!!<\u0002d\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class WorkspaceSearchVisitor
extends SymbolSearchVisitor {
    private final AbsolutePath workspace;
    private final WorkspaceSymbolQuery query;
    private final CancelChecker token;
    private final GlobalSymbolIndex index;
    private final boolean saveClassFileToDisk;
    private final Ordering<SymbolDefinition> resultOrdering;
    private final ReportContext rc;
    private final ArrayList<SymbolInformation> fromWorkspace;
    private final ArrayList<SymbolInformation> fromClasspath;
    private final ArrayList<Tuple2<String, String>> bufferedClasspath;
    private final Comparator<SymbolInformation> byNameLength;
    private final Set<AbsolutePath> isVisited;

    public static Ordering<SymbolDefinition> $lessinit$greater$default$6() {
        return WorkspaceSearchVisitor$.MODULE$.$lessinit$greater$default$6();
    }

    private ArrayList<SymbolInformation> fromWorkspace() {
        return this.fromWorkspace;
    }

    private ArrayList<SymbolInformation> fromClasspath() {
        return this.fromClasspath;
    }

    private ArrayList<Tuple2<String, String>> bufferedClasspath() {
        return this.bufferedClasspath;
    }

    public Seq<SymbolInformation> allResults() {
        Object object;
        if (this.fromWorkspace().isEmpty()) {
            this.bufferedClasspath().forEach((Consumer<Tuple2<String, String>>)((Consumer<Tuple2>)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String pkg = (String)tuple2._1();
                    String name = (String)tuple2._2();
                    this.expandClassfile(pkg, name);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        this.fromWorkspace().sort(this.byNameLength());
        this.fromClasspath().sort(this.byNameLength());
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        result.addAll(this.fromWorkspace());
        result.addAll(this.fromClasspath());
        if (!this.bufferedClasspath().isEmpty() && this.fromClasspath().isEmpty()) {
            AbsolutePath dependencies = this.workspace.resolve(Directories$.MODULE$.workspaceSymbol());
            if (!dependencies.isFile()) {
                MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dependencies).writeText(Messages$WorkspaceSymbolDependencies$.MODULE$.title());
            }
            object = BoxesRunTime.boxToBoolean((boolean)result.add(new SymbolInformation(Messages$WorkspaceSymbolDependencies$.MODULE$.title(), SymbolKind.Event, new Location(dependencies.toURI().toString(), new Range(new Position(0, 0), new Position(0, 0))))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return MetalsEnrichments$.MODULE$.ListHasAsScala(result).asScala().toSeq();
    }

    private Comparator<SymbolInformation> byNameLength() {
        return this.byNameLength;
    }

    private Set<AbsolutePath> isVisited() {
        return this.isVisited;
    }

    private Option<SymbolDefinition> definition(String pkg, String filename, GlobalSymbolIndex index) {
        List list;
        String nme = Classfile$.MODULE$.name(filename);
        Symbol tpe = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor.Type(nme)));
        List forTpe = index.definitions(tpe);
        if (forTpe.isEmpty()) {
            Symbol term = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor.Term(nme)));
            list = index.definitions(term);
        } else {
            list = forTpe;
        }
        List defs = list;
        return ((LinearSeqOps)defs.sorted(this.resultOrdering)).headOption();
    }

    public boolean shouldVisitPackage(String pkg) {
        return true;
    }

    public int visitWorkspaceSymbol(Path path2, String symbol, SymbolKind kind, Range range) {
        Tuple2 tuple2 = Scala.DescriptorParser$.MODULE$.apply(symbol);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Scala.Descriptor desc = (Scala.Descriptor)tuple2._1();
        String owner = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)desc, (Object)owner);
        Scala.Descriptor desc2 = (Scala.Descriptor)tuple22._1();
        String owner2 = (String)tuple22._2();
        this.fromWorkspace().add(new SymbolInformation(desc2.name().value(), kind, new Location(path2.toUri().toString(), range), owner2.replace('/', '.')));
        return 1;
    }

    public int visitClassfile(String pkg, String filename) {
        if (this.fromWorkspace().isEmpty() || this.query.isClasspath()) {
            return this.expandClassfile(pkg, filename);
        }
        this.bufferedClasspath().add((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pkg), (Object)filename));
        return 1;
    }

    public boolean isCancelled() {
        return MetalsEnrichments$.MODULE$.XtensionCancelChecker(this.token).isCancelled();
    }

    private int expandClassfile(String pkg, String filename) {
        BooleanRef isHit = BooleanRef.create((boolean)false);
        this.definition(pkg, filename, this.index).withFilter((Function1 & Serializable)defn -> BoxesRunTime.boxToBoolean((boolean)WorkspaceSearchVisitor.$anonfun$expandClassfile$1(this, defn))).foreach((Function1 & Serializable)defn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$2(this, isHit, defn);
            return BoxedUnit.UNIT;
        });
        if (isHit.elem) {
            return 1;
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$expandClassfile$1(WorkspaceSearchVisitor $this, SymbolDefinition defn) {
        return !$this.isVisited().apply((Object)defn.path());
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$3(WorkspaceSearchVisitor $this, SymbolDefinition defn$1, BooleanRef isHit$1, SemanticdbDefinition semanticDefn) {
        if (MetalsEnrichments$.MODULE$.XtensionWorkspaceSymbolQuery($this.query).matches(semanticDefn.info())) {
            AbsolutePath path2 = $this.saveClassFileToDisk ? MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(defn$1.path()).toFileOnDisk($this.workspace) : defn$1.path();
            String uri = path2.toURI().toString();
            $this.fromClasspath().add(semanticDefn.toLsp(uri));
            isHit$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$2(WorkspaceSearchVisitor $this, BooleanRef isHit$1, SymbolDefinition defn) {
        $this.isVisited().$plus$eq((Object)defn.path());
        Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(defn.path()).toInput();
        SemanticdbDefinition$.MODULE$.foreach(input, defn.dialect(), false, (Function1 & Serializable)semanticDefn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$3($this, defn, isHit$1, semanticDefn);
            return BoxedUnit.UNIT;
        }, $this.rc);
    }

    public WorkspaceSearchVisitor(AbsolutePath workspace, WorkspaceSymbolQuery query, CancelChecker token, GlobalSymbolIndex index, boolean saveClassFileToDisk, Ordering<SymbolDefinition> resultOrdering, ReportContext rc) {
        this.workspace = workspace;
        this.query = query;
        this.token = token;
        this.index = index;
        this.saveClassFileToDisk = saveClassFileToDisk;
        this.resultOrdering = resultOrdering;
        this.rc = rc;
        this.fromWorkspace = new ArrayList();
        this.fromClasspath = new ArrayList();
        this.bufferedClasspath = new ArrayList();
        this.byNameLength = new Comparator<SymbolInformation>(null){

            public Comparator<SymbolInformation> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<SymbolInformation> thenComparing(Comparator<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<SymbolInformation> thenComparingInt(ToIntFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<SymbolInformation> thenComparingLong(ToLongFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<SymbolInformation> thenComparingDouble(ToDoubleFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(SymbolInformation x, SymbolInformation y) {
                return Integer.compare(x.getName().length(), y.getName().length());
            }
        };
        this.isVisited = (Set)Set$.MODULE$.empty();
    }
}

