/*
 * Decompiled with CFR 0.152.
 */
package moped.json;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import moped.cli.Application;
import moped.internal.diagnostics.TypeMismatchDiagnostic;
import moped.internal.json.DrillIntoJson$;
import moped.json.Cursor;
import moped.json.DecodingContext;
import moped.json.ErrorResult;
import moped.json.JsonArray;
import moped.json.JsonBoolean;
import moped.json.JsonDecoder;
import moped.json.JsonElement;
import moped.json.JsonMember;
import moped.json.JsonNull;
import moped.json.JsonNumber;
import moped.json.JsonObject;
import moped.json.JsonString;
import moped.json.Result;
import moped.json.Result$;
import moped.json.SelectIndexCursor;
import moped.json.SelectMemberCursor;
import moped.json.ValueResult;
import moped.reporters.Diagnostic;
import moped.reporters.Diagnostic$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class JsonDecoder$ {
    public static final JsonDecoder$ MODULE$ = new JsonDecoder$();
    private static JsonDecoder<Path> pathJsonDecoder;
    private static final JsonDecoder<JsonElement> jsonElementJsonDecoder;
    private static final JsonDecoder<JsonString> jsonStringDecoder;
    private static final JsonDecoder<Object> intJsonDecoder;
    private static final JsonDecoder<Object> longJsonDecoder;
    private static final JsonDecoder<Object> doubleJsonDecoder;
    private static final JsonDecoder<Object> floatJsonDecoder;
    private static final JsonDecoder<String> stringJsonDecoder;
    private static final JsonDecoder<Object> booleanJsonDecoder;
    private static final JsonDecoder<BoxedUnit> unitJsonDecoder;
    private static final JsonDecoder<Application> applicationJsonDecoder;
    private static volatile boolean bitmap$0;

    static {
        jsonElementJsonDecoder = new JsonDecoder<JsonElement>(){

            public final <B> JsonDecoder<B> map(Function1<JsonElement, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<JsonElement, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public final Result<JsonElement> decode(DecodingContext context) {
                return JsonDecoder$.moped$json$JsonDecoder$$$anonfun$jsonElementJsonDecoder$1(context);
            }
            {
                JsonDecoder.$init$(this);
            }
        };
        jsonStringDecoder = MODULE$.fromJson("String", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof JsonString) {
                    JsonString jsonString = (JsonString)A1;
                    return (B1)new ValueResult<JsonString>(jsonString);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(JsonElement x1) {
                JsonElement jsonElement = x1;
                return jsonElement instanceof JsonString;
            }
        });
        intJsonDecoder = MODULE$.fromJson("Int", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof JsonNumber) {
                    JsonNumber jsonNumber = (JsonNumber)A1;
                    double value = jsonNumber.value();
                    return (B1)new ValueResult<Integer>(BoxesRunTime.boxToInteger((int)((int)value)));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(JsonElement x2) {
                JsonElement jsonElement = x2;
                return jsonElement instanceof JsonNumber;
            }
        });
        longJsonDecoder = MODULE$.fromJson("Long", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof JsonNumber) {
                    JsonNumber jsonNumber = (JsonNumber)A1;
                    double value = jsonNumber.value();
                    return (B1)new ValueResult<Long>(BoxesRunTime.boxToLong((long)((long)value)));
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(JsonElement x3) {
                JsonElement jsonElement = x3;
                return jsonElement instanceof JsonNumber;
            }
        });
        doubleJsonDecoder = MODULE$.fromJson("Double", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                if (A1 instanceof JsonNumber) {
                    JsonNumber jsonNumber = (JsonNumber)A1;
                    double value = jsonNumber.value();
                    return (B1)new ValueResult<Double>(BoxesRunTime.boxToDouble((double)value));
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(JsonElement x4) {
                JsonElement jsonElement = x4;
                return jsonElement instanceof JsonNumber;
            }
        });
        floatJsonDecoder = MODULE$.fromJson("Float", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                if (A1 instanceof JsonNumber) {
                    JsonNumber jsonNumber = (JsonNumber)A1;
                    double value = jsonNumber.value();
                    return (B1)new ValueResult<Float>(BoxesRunTime.boxToFloat((float)((float)value)));
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(JsonElement x5) {
                JsonElement jsonElement = x5;
                return jsonElement instanceof JsonNumber;
            }
        });
        stringJsonDecoder = MODULE$.fromJson("String", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                if (A1 instanceof JsonString) {
                    JsonString jsonString = (JsonString)A1;
                    String value = jsonString.value();
                    return (B1)new ValueResult<String>(value);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(JsonElement x6) {
                JsonElement jsonElement = x6;
                return jsonElement instanceof JsonString;
            }
        });
        booleanJsonDecoder = MODULE$.fromJson("Boolean", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                A1 A1 = x7;
                if (A1 instanceof JsonBoolean) {
                    JsonBoolean jsonBoolean = (JsonBoolean)A1;
                    boolean value = jsonBoolean.value();
                    return (B1)new ValueResult<Boolean>(BoxesRunTime.boxToBoolean((boolean)value));
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(JsonElement x7) {
                JsonElement jsonElement = x7;
                return jsonElement instanceof JsonBoolean;
            }
        });
        unitJsonDecoder = MODULE$.constant(BoxedUnit.UNIT);
        applicationJsonDecoder = new JsonDecoder<Application>(){

            public final <B> JsonDecoder<B> map(Function1<Application, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<Application, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public Result<Application> decode(DecodingContext context) {
                Application app = context.app();
                if (context.json().isObject()) {
                    return DrillIntoJson$.MODULE$.decodeMember(context, "cwd", app.env().workingDirectory(), JsonDecoder$.MODULE$.pathJsonDecoder()).map((Function1 & Serializable)cwd -> app.withEnv(app.env().withWorkingDirectory((Path)cwd)));
                }
                if (context.json().isNull()) {
                    return new ValueResult<Application>(context.app());
                }
                return new ErrorResult(Diagnostic$.MODULE$.typeMismatch("Object", context));
            }
            {
                JsonDecoder.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$1(moped.cli.Application java.nio.file.Path )}, serializedLambda);
            }
        };
    }

    public <A> JsonDecoder<A> apply(JsonDecoder<A> ev) {
        return ev;
    }

    public <A> Result<A> decode(DecodingContext context, JsonDecoder<A> ev) {
        return ev.decode(context);
    }

    public <A> JsonDecoder<A> constant(A value) {
        return new JsonDecoder<A>(value){
            private final Object value$1;

            public final <B> JsonDecoder<B> map(Function1<A, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<A, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public final Result<A> decode(DecodingContext context) {
                return JsonDecoder$.moped$json$JsonDecoder$$$anonfun$constant$1(context, this.value$1);
            }
            {
                this.value$1 = value$1;
                JsonDecoder.$init$(this);
            }
        };
    }

    public <A> JsonDecoder<A> fromJson(String expected, PartialFunction<JsonElement, Result<A>> fn) {
        return new JsonDecoder<A>(fn, expected){
            private final PartialFunction fn$3;
            private final String expected$1;

            public final <B> JsonDecoder<B> map(Function1<A, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<A, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public final Result<A> decode(DecodingContext context) {
                return JsonDecoder$.moped$json$JsonDecoder$$$anonfun$fromJson$1(context, this.fn$3, this.expected$1);
            }
            {
                this.fn$3 = fn$3;
                this.expected$1 = expected$1;
                JsonDecoder.$init$(this);
            }
        };
    }

    public JsonDecoder<JsonElement> jsonElementJsonDecoder() {
        return jsonElementJsonDecoder;
    }

    public JsonDecoder<JsonString> jsonStringDecoder() {
        return jsonStringDecoder;
    }

    public JsonDecoder<Object> intJsonDecoder() {
        return intJsonDecoder;
    }

    public JsonDecoder<Object> longJsonDecoder() {
        return longJsonDecoder;
    }

    public JsonDecoder<Object> doubleJsonDecoder() {
        return doubleJsonDecoder;
    }

    public JsonDecoder<Object> floatJsonDecoder() {
        return floatJsonDecoder;
    }

    public JsonDecoder<String> stringJsonDecoder() {
        return stringJsonDecoder;
    }

    public JsonDecoder<Object> booleanJsonDecoder() {
        return booleanJsonDecoder;
    }

    public JsonDecoder<BoxedUnit> unitJsonDecoder() {
        return unitJsonDecoder;
    }

    private JsonDecoder<Path> pathJsonDecoder$lzycompute() {
        JsonDecoder$ jsonDecoder$ = this;
        synchronized (jsonDecoder$) {
            if (!bitmap$0) {
                pathJsonDecoder = this.stringJsonDecoder().flatMap((Function1 & Serializable)path -> Result$.MODULE$.fromUnsafe((Function0 & Serializable)() -> Paths.get(path, new String[0])));
                bitmap$0 = true;
            }
        }
        return pathJsonDecoder;
    }

    public JsonDecoder<Path> pathJsonDecoder() {
        if (!bitmap$0) {
            return this.pathJsonDecoder$lzycompute();
        }
        return pathJsonDecoder;
    }

    public JsonDecoder<Application> applicationJsonDecoder() {
        return applicationJsonDecoder;
    }

    public <C, A> JsonDecoder<C> arrayJsonDecoder(JsonDecoder<A> ev, Factory<A, C> factory) {
        return new JsonDecoder<C>(factory, ev){
            private final Factory factory$1;
            private final JsonDecoder ev$1;

            public final <B> JsonDecoder<B> map(Function1<C, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<C, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public final Result<C> decode(DecodingContext context) {
                return JsonDecoder$.moped$json$JsonDecoder$$$anonfun$arrayJsonDecoder$1(context, this.factory$1, this.ev$1);
            }
            {
                this.factory$1 = factory$1;
                this.ev$1 = ev$1;
                JsonDecoder.$init$(this);
            }
        };
    }

    public <A> JsonDecoder<Map<String, A>> objectJsonDecoder(JsonDecoder<A> ev) {
        return new JsonDecoder<Map<String, A>>(ev){
            private final JsonDecoder ev$2;

            public final <B> JsonDecoder<B> map(Function1<Map<String, A>, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<Map<String, A>, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public final Result<Map<String, A>> decode(DecodingContext context) {
                return JsonDecoder$.moped$json$JsonDecoder$$$anonfun$objectJsonDecoder$1(context, this.ev$2);
            }
            {
                this.ev$2 = ev$2;
                JsonDecoder.$init$(this);
            }
        };
    }

    public <A> JsonDecoder<Option<A>> optionJsonDecoder(JsonDecoder<A> ev) {
        return new JsonDecoder<Option<A>>(ev){
            private final JsonDecoder ev$3;

            public final <B> JsonDecoder<B> map(Function1<Option<A>, B> fn) {
                return JsonDecoder.map$(this, fn);
            }

            public final <B> JsonDecoder<B> flatMap(Function1<Option<A>, Result<B>> fn) {
                return JsonDecoder.flatMap$(this, fn);
            }

            public final Result<Option<A>> decode(DecodingContext context) {
                return JsonDecoder$.moped$json$JsonDecoder$$$anonfun$optionJsonDecoder$1(context, this.ev$3);
            }
            {
                this.ev$3 = ev$3;
                JsonDecoder.$init$(this);
            }
        };
    }

    public static final /* synthetic */ Result moped$json$JsonDecoder$$$anonfun$constant$1(DecodingContext x$1, Object value$1) {
        return new ValueResult<Object>(value$1);
    }

    public static final /* synthetic */ Result moped$json$JsonDecoder$$$anonfun$fromJson$1(DecodingContext context, PartialFunction fn$3, String expected$1) {
        return (Result)fn$3.applyOrElse((Object)context.json(), (Function1 & Serializable)x$2 -> new ErrorResult(new TypeMismatchDiagnostic(expected$1, context)));
    }

    public static final /* synthetic */ Result moped$json$JsonDecoder$$$anonfun$jsonElementJsonDecoder$1(DecodingContext context) {
        return new ValueResult<JsonElement>(context.json());
    }

    public static final /* synthetic */ Result moped$json$JsonDecoder$$$anonfun$arrayJsonDecoder$1(DecodingContext context, Factory factory$1, JsonDecoder ev$1) {
        JsonElement jsonElement = context.json();
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            List<JsonElement> value = jsonArray.elements();
            Builder successValues = factory$1.newBuilder();
            Builder errors = package$.MODULE$.List().newBuilder();
            successValues.sizeHint(value.length());
            ((List)value.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    JsonElement value = (JsonElement)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Cursor cursor = new SelectIndexCursor(i).withParent(context.cursor());
                    Result result = ev$1.decode(context.withJson(value).withCursor(cursor));
                    if (result instanceof ErrorResult) {
                        ErrorResult errorResult = (ErrorResult)result;
                        Diagnostic e = errorResult.error();
                        return (Builder)errors.$plus$eq((Object)e);
                    }
                    if (result instanceof ValueResult) {
                        ValueResult valueResult = (ValueResult)result;
                        Object e = valueResult.value();
                        return (Builder)successValues.$plus$eq(e);
                    }
                    throw new MatchError(result);
                }
                throw new MatchError((Object)tuple2);
            });
            Option<Diagnostic> option = Diagnostic$.MODULE$.fromDiagnostics((List<Diagnostic>)((List)errors.result()));
            if (option instanceof Some) {
                Some some = (Some)option;
                Diagnostic x = (Diagnostic)some.value();
                return new ErrorResult(x);
            }
            if (None$.MODULE$.equals(option)) {
                return new ValueResult<Object>(successValues.result());
            }
            throw new MatchError(option);
        }
        return new ErrorResult(new TypeMismatchDiagnostic("Array", context));
    }

    public static final /* synthetic */ Result moped$json$JsonDecoder$$$anonfun$objectJsonDecoder$1(DecodingContext context, JsonDecoder ev$2) {
        JsonElement jsonElement = context.json();
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            List<JsonMember> members = jsonObject.members();
            Builder successValues = Predef$.MODULE$.Map().newBuilder();
            ListBuffer errors = ListBuffer$.MODULE$.empty();
            members.foreach((Function1 & Serializable)member -> {
                Cursor cursor = new SelectMemberCursor(member.key().value()).withParent(context.cursor());
                Result result = ev$2.decode(context.withJson(member.value()).withCursor(cursor));
                if (result instanceof ErrorResult) {
                    ErrorResult errorResult = (ErrorResult)result;
                    Diagnostic error = errorResult.error();
                    return (Builder)errors.$plus$eq((Object)error);
                }
                if (result instanceof ValueResult) {
                    ValueResult valueResult = (ValueResult)result;
                    Object value = valueResult.value();
                    return (Builder)successValues.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)member.key().value()), value));
                }
                throw new MatchError(result);
            });
            Option<Diagnostic> option = Diagnostic$.MODULE$.fromDiagnostics((List<Diagnostic>)errors.result());
            if (option instanceof Some) {
                Some some = (Some)option;
                Diagnostic x = (Diagnostic)some.value();
                return new ErrorResult(x);
            }
            if (None$.MODULE$.equals(option)) {
                return new ValueResult<Object>(successValues.result());
            }
            throw new MatchError(option);
        }
        return new ErrorResult(new TypeMismatchDiagnostic("Object", context));
    }

    public static final /* synthetic */ Result moped$json$JsonDecoder$$$anonfun$optionJsonDecoder$1(DecodingContext context, JsonDecoder ev$3) {
        JsonElement jsonElement = context.json();
        if (jsonElement instanceof JsonNull) {
            return new ValueResult<None$>(None$.MODULE$);
        }
        return ev$3.decode(context).map((Function1 & Serializable)x$3 -> new Some(x$3));
    }

    private JsonDecoder$() {
    }
}

