/*
 * Decompiled with CFR 0.152.
 */
package moped.json;

import java.io.Serializable;
import moped.json.Cursor;
import moped.json.JsonArray;
import moped.json.JsonBoolean;
import moped.json.JsonElement;
import moped.json.JsonMember;
import moped.json.JsonNull;
import moped.json.JsonNumber;
import moped.json.JsonObject;
import moped.json.JsonPrimitive;
import moped.json.JsonString;
import moped.json.NoCursor;
import moped.json.SelectIndexCursor;
import moped.json.SelectMemberCursor;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005A4AAD\b\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)q\u0004\u0001C\u0001S!)\u0001\u0007\u0001C\u0001c!)q\u0007\u0001C\u0001q!)a\b\u0001C\u0001\u007f!)Q\t\u0001C\u0001\r\")A\n\u0001C\u0001\u001b\")1\u000b\u0001C\u0001)\")!\f\u0001C\u00017\")a\f\u0001C\u0001?\")!\r\u0001C\u0001G\")\u0011\u000e\u0001C\u0001U\ni!j]8o)J\fg/\u001a:tKJT!\u0001E\t\u0002\t)\u001cxN\u001c\u0006\u0002%\u0005)Qn\u001c9fI\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\tiJ\fg/\u001a:tKR\u0011\u0011\u0005\n\t\u0003-\tJ!aI\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\t\u0001\rAJ\u0001\u0002KB\u0011adJ\u0005\u0003Q=\u00111BS:p]\u0016cW-\\3oiR\u0019\u0011EK\u0016\t\u000b\u0015\u001a\u0001\u0019\u0001\u0014\t\u000b1\u001a\u0001\u0019A\u0017\u0002\r\r,(o]8s!\tqb&\u0003\u00020\u001f\t11)\u001e:t_J\f\u0011\u0003\u001e:bm\u0016\u00148/\u001a)sS6LG/\u001b<f)\r\t#G\u000e\u0005\u0006K\u0011\u0001\ra\r\t\u0003=QJ!!N\b\u0003\u001b)\u001bxN\u001c)sS6LG/\u001b<f\u0011\u0015aC\u00011\u0001.\u00031!(/\u0019<feN,g*\u001e7m)\r\t\u0013(\u0010\u0005\u0006K\u0015\u0001\rA\u000f\t\u0003=mJ!\u0001P\b\u0003\u0011)\u001bxN\u001c(vY2DQ\u0001L\u0003A\u00025\na\u0002\u001e:bm\u0016\u00148/\u001a(v[\n,'\u000fF\u0002\"\u0001\u0012CQ!\n\u0004A\u0002\u0005\u0003\"A\b\"\n\u0005\r{!A\u0003&t_:tU/\u001c2fe\")AF\u0002a\u0001[\u0005yAO]1wKJ\u001cXMQ8pY\u0016\fg\u000eF\u0002\"\u000f.CQ!J\u0004A\u0002!\u0003\"AH%\n\u0005){!a\u0003&t_:\u0014un\u001c7fC:DQ\u0001L\u0004A\u00025\na\u0002\u001e:bm\u0016\u00148/Z*ue&tw\rF\u0002\"\u001dJCQ!\n\u0005A\u0002=\u0003\"A\b)\n\u0005E{!A\u0003&t_:\u001cFO]5oO\")A\u0006\u0003a\u0001[\u0005iAO]1wKJ\u001cX-\u0011:sCf$2!I+Z\u0011\u0015)\u0013\u00021\u0001W!\tqr+\u0003\u0002Y\u001f\tI!j]8o\u0003J\u0014\u0018-\u001f\u0005\u0006Y%\u0001\r!L\u0001\u0012iJ\fg/\u001a:tK6+WNY3s\u0017\u0016LHcA\u0011];\")QE\u0003a\u0001\u001f\")AF\u0003a\u0001[\u0005\u0019BO]1wKJ\u001cX-T3nE\u0016\u0014h+\u00197vKR\u0019\u0011\u0005Y1\t\u000b\u0015Z\u0001\u0019\u0001\u0014\t\u000b1Z\u0001\u0019A\u0017\u0002\u001dQ\u0014\u0018M^3sg\u0016lU-\u001c2feR\u0019\u0011\u0005\u001a5\t\u000b\u0015b\u0001\u0019A3\u0011\u0005y1\u0017BA4\u0010\u0005)Q5o\u001c8NK6\u0014WM\u001d\u0005\u0006Y1\u0001\r!L\u0001\u000fiJ\fg/\u001a:tK>\u0013'.Z2u)\r\t3n\u001c\u0005\u0006K5\u0001\r\u0001\u001c\t\u0003=5L!A\\\b\u0003\u0015)\u001bxN\\(cU\u0016\u001cG\u000fC\u0003-\u001b\u0001\u0007Q\u0006")
public class JsonTraverser {
    public void traverse(JsonElement e) {
        this.traverse(e, new NoCursor());
    }

    public void traverse(JsonElement e, Cursor cursor) {
        JsonElement jsonElement = e;
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            this.traversePrimitive(jsonPrimitive, cursor);
            return;
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            this.traverseArray(jsonArray, cursor);
            return;
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            this.traverseObject(jsonObject, cursor);
            return;
        }
        throw new MatchError((Object)jsonElement);
    }

    public void traversePrimitive(JsonPrimitive e, Cursor cursor) {
        JsonPrimitive jsonPrimitive = e;
        if (jsonPrimitive instanceof JsonNull) {
            JsonNull jsonNull = (JsonNull)jsonPrimitive;
            this.traverseNull(jsonNull, cursor);
            return;
        }
        if (jsonPrimitive instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)jsonPrimitive;
            this.traverseNumber(jsonNumber, cursor);
            return;
        }
        if (jsonPrimitive instanceof JsonBoolean) {
            JsonBoolean jsonBoolean = (JsonBoolean)jsonPrimitive;
            this.traverseBoolean(jsonBoolean, cursor);
            return;
        }
        if (jsonPrimitive instanceof JsonString) {
            JsonString jsonString = (JsonString)jsonPrimitive;
            this.traverseString(jsonString, cursor);
            return;
        }
        throw new MatchError((Object)jsonPrimitive);
    }

    public void traverseNull(JsonNull e, Cursor cursor) {
    }

    public void traverseNumber(JsonNumber e, Cursor cursor) {
    }

    public void traverseBoolean(JsonBoolean e, Cursor cursor) {
    }

    public void traverseString(JsonString e, Cursor cursor) {
    }

    public void traverseArray(JsonArray e, Cursor cursor) {
        ((List)e.elements().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            JsonTraverser.$anonfun$traverseArray$1(this, cursor, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void traverseMemberKey(JsonString e, Cursor cursor) {
        this.traverseString(e, cursor);
    }

    public void traverseMemberValue(JsonElement e, Cursor cursor) {
        this.traverse(e, cursor);
    }

    public void traverseMember(JsonMember e, Cursor cursor) {
        this.traverseMemberKey(e.key(), cursor);
        this.traverseMemberValue(e.value(), new SelectMemberCursor(e.key().value()).withParent(cursor));
    }

    public void traverseObject(JsonObject e, Cursor cursor) {
        e.members().foreach((Function1 & Serializable)m -> {
            this.traverseMember(m, cursor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$traverseArray$1(JsonTraverser $this, Cursor cursor$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            JsonElement e = (JsonElement)tuple2._1();
            int i = tuple2._2$mcI$sp();
            $this.traverse(e, new SelectIndexCursor(i).withParent(cursor$1));
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

