/*
 * Decompiled with CFR 0.152.
 */
package munit.diff;

import java.util.List;
import munit.diff.DiffUtils$;
import munit.diff.Patch;
import munit.diff.console.AnsiColors$;
import munit.diff.console.Printers$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\r\u001b\u0001}A\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005W!Aq\u0007\u0001BC\u0002\u0013\u0005!\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u001dy\u0004A1A\u0005\u0002)Ba\u0001\u0011\u0001!\u0002\u0013Y\u0003bB!\u0001\u0005\u0004%\tA\u000b\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u0016\t\u000f\r\u0003!\u0019!C\u0001\t\"1a\n\u0001Q\u0001\n\u0015Cqa\u0014\u0001C\u0002\u0013\u0005A\t\u0003\u0004Q\u0001\u0001\u0006I!\u0012\u0005\b#\u0002\u0011\r\u0011\"\u0001+\u0011\u0019\u0011\u0006\u0001)A\u0005W!)1\u000b\u0001C\u0001)\")\u0001\f\u0001C\u00013\"9a\fAI\u0001\n\u0003y\u0006\"\u00026\u0001\t\u0003Y\u0007\"\u00027\u0001\t\u0013i\u0007\"\u0002<\u0001\t\u00139\b\"B=\u0001\t\u0013Q\b\"\u0002@\u0001\t\u0013y\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\u0005\t&4gM\u0003\u0002\u001c9\u0005!A-\u001b4g\u0015\u0005i\u0012!B7v]&$8\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002\"O%\u0011\u0001F\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\t_\n$\u0018-\u001b8fIV\t1\u0006\u0005\u0002-g9\u0011Q&\r\t\u0003]\tj\u0011a\f\u0006\u0003ay\ta\u0001\u0010:p_Rt\u0014B\u0001\u001a#\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0012\u0013!C8ci\u0006Lg.\u001a3!\u0003!)\u0007\u0010]3di\u0016$\u0017!C3ya\u0016\u001cG/\u001a3!\u0003\u0019a\u0014N\\5u}Q\u00191(\u0010 \u0011\u0005q\u0002Q\"\u0001\u000e\t\u000b%*\u0001\u0019A\u0016\t\u000b]*\u0001\u0019A\u0016\u0002\u001b=\u0014G/Y5oK\u0012\u001cE.Z1o\u00039y'\r^1j]\u0016$7\t\\3b]\u0002\nQ\"\u001a=qK\u000e$X\rZ\"mK\u0006t\u0017AD3ya\u0016\u001cG/\u001a3DY\u0016\fg\u000eI\u0001\u000e_\n$\u0018-\u001b8fI2Kg.Z:\u0016\u0003\u0015\u00032AR&,\u001d\t9\u0015J\u0004\u0002/\u0011&\t1%\u0003\u0002KE\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u0005\r\u0019V-\u001d\u0006\u0003\u0015\n\nab\u001c2uC&tW\r\u001a'j]\u0016\u001c\b%A\u0007fqB,7\r^3e\u0019&tWm]\u0001\u000fKb\u0004Xm\u0019;fI2Kg.Z:!\u0003-)h.\u001b4jK\u0012$\u0015N\u001a4\u0002\u0019Ut\u0017NZ5fI\u0012KgM\u001a\u0011\u0002\u000f%\u001cX)\u001c9usV\tQ\u000b\u0005\u0002\"-&\u0011qK\t\u0002\b\u0005>|G.Z1o\u00031\u0019'/Z1uKJ+\u0007o\u001c:u)\rY#\f\u0018\u0005\u00067F\u0001\raK\u0001\u0006i&$H.\u001a\u0005\b;F\u0001\n\u00111\u0001V\u0003i\u0001(/\u001b8u\u001f\n$\u0018-\u001b8fI\u0006\u001b8\u000b\u001e:ja6\u000b'oZ5o\u0003Y\u0019'/Z1uKJ+\u0007o\u001c:uI\u0011,g-Y;mi\u0012\u0012T#\u00011+\u0005U\u000b7&\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!C;oG\",7m[3e\u0015\t9'%\u0001\u0006b]:|G/\u0019;j_:L!!\u001b3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bde\u0016\fG/\u001a#jM\u001a|e\u000e\\=SKB|'\u000f\u001e\u000b\u0002W\u0005!\u0012\r\u001d9f]\u0012$\u0015N\u001a4P]2L(+\u001a9peR$\"A\\9\u0011\u0005\u0005z\u0017B\u00019#\u0005\u0011)f.\u001b;\t\u000bI$\u0002\u0019A:\u0002\u0005M\u0014\u0007C\u0001$u\u0013\t)XJA\u0007TiJLgn\u001a\"vS2$WM]\u0001\u000eCN\u001cFO]5q\u001b\u0006\u0014x-\u001b8\u0015\u0005-B\b\"B\u0015\u0016\u0001\u0004Y\u0013A\u00025fC\u0012,'\u000fF\u0002twvDQ\u0001 \fA\u0002-\n\u0011\u0001\u001e\u0005\u0006eZ\u0001\ra]\u0001\u0012GJ,\u0017\r^3V]&4\u0017.\u001a3ES\u001a4G#B\u0016\u0002\u0002\u0005\u0015\u0001BBA\u0002/\u0001\u0007Q)\u0001\u0005pe&<\u0017N\\1m\u0011\u0019\t9a\u0006a\u0001\u000b\u00069!/\u001a<jg\u0016$\u0017AD:qY&$\u0018J\u001c;p\u0019&tWm\u001d\u000b\u0004\u000b\u00065\u0001BBA\b1\u0001\u00071&\u0001\u0004tiJLgn\u001a")
public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq<String> obtainedLines;
    private final Seq<String> expectedLines;
    private final String unifiedDiff;

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty() ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (this.obtainedClean().length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(this.obtainedClean())) : sb.append(this.obtainedClean());
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        this.header("Diff", sb);
        String red = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.LightRed());
        String reset = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset());
        String green = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.LightGreen());
        sb.append(new java.lang.StringBuilder(25).append(" (").append(red).append("- obtained").append(reset).append(", ").append(green).append("+ expected").append(reset).append(")").toString());
        sb.append("\n");
        sb.append(this.unifiedDiff());
    }

    private String asStripMargin(String obtained) {
        if (!obtained.contains("\n")) {
            return Printers$.MODULE$.print(obtained);
        }
        StringBuilder out = new StringBuilder();
        Iterator lines = new StringOps(Predef$.MODULE$.augmentString(obtained.trim())).linesIterator();
        String head = lines.hasNext() ? (String)lines.next() : "";
        out.append(new java.lang.StringBuilder(9).append("    \"\"\"|").append(head).append("\n").toString());
        lines.foreach((Function1 & java.io.Serializable & Serializable)line -> out.append("       |").append(line).append("\n"));
        out.append("       |\"\"\".stripMargin");
        return out.toString();
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.c(new java.lang.StringBuilder(3).append("=> ").append(t).toString(), AnsiColors$.MODULE$.Bold()));
    }

    private String createUnifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch<String> diff = DiffUtils$.MODULE$.diff((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava());
        String result = diff.getDeltas().isEmpty() ? "" : ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils$.MODULE$.generateUnifiedDiff("obtained", "expected", (List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), diff, 1)).asScala()).iterator().drop(2).filterNot((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("@@"))).map((Function1 & java.io.Serializable & Serializable)line -> {
            if (line.isEmpty()) {
                return line;
            }
            if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).last()) == ' ') {
                return new java.lang.StringBuilder(1).append((String)line).append("\u2219").toString();
            }
            return line;
        }).map((Function1 & java.io.Serializable & Serializable)line -> {
            if (line.startsWith("-")) {
                return AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightRed());
            }
            if (line.startsWith("+")) {
                return AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightGreen());
            }
            return line;
        }).mkString("\n");
        return result;
    }

    private Seq<String> splitIntoLines(String string) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.trim().replace("\r\n", "\n").split("\n"))).toIndexedSeq();
    }

    public Diff(String obtained, String expected) {
        this.obtained = obtained;
        this.expected = expected;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = this.splitIntoLines(this.obtainedClean());
        this.expectedLines = this.splitIntoLines(this.expectedClean());
        this.unifiedDiff = this.createUnifiedDiff(this.obtainedLines(), this.expectedLines());
    }
}

