/*
 * Decompiled with CFR 0.152.
 */
package munit.diff;

import java.io.Serializable;
import java.util.List;
import munit.diff.DiffUtils$;
import munit.diff.Patch;
import munit.diff.console.AnsiColors$;
import munit.diff.console.Printers$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\r\u001b\u0001}A\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\ty\u0001\u0011\t\u0011)A\u0005i!AQ\b\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u00035\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u001d)\u0005A1A\u0005\u0002MBaA\u0012\u0001!\u0002\u0013!\u0004bB$\u0001\u0005\u0004%\ta\r\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u001b\t\u000f%\u0003!\u0019!C\u0001\u0015\"1a\n\u0001Q\u0001\n-Cqa\u0014\u0001C\u0002\u0013\u0005!\n\u0003\u0004Q\u0001\u0001\u0006Ia\u0013\u0005\b#\u0002\u0011\r\u0011\"\u00014\u0011\u0019\u0011\u0006\u0001)A\u0005i!)1\u000b\u0001C\u0001)\")\u0001\f\u0001C\u00013\"9a\fAI\u0001\n\u0003y\u0006\"\u00026\u0001\t\u0003Y\u0007\"\u00027\u0001\t\u0013i\u0007\"\u0002<\u0001\t\u00139\b\"B=\u0001\t\u0013Q\b\"\u0002@\u0001\t\u0013y\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\u0005\t&4gM\u0003\u0002\u001c9\u0005!A-\u001b4g\u0015\u0005i\u0012!B7v]&$8\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(_9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003Wy\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u00059\u0012\u0013a\u00029bG.\fw-Z\u0005\u0003aE\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!A\f\u0012\u0002\u0011=\u0014G/Y5oK\u0012,\u0012\u0001\u000e\t\u0003ker!AN\u001c\u0011\u0005%\u0012\u0013B\u0001\u001d#\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u0012\u0013!C8ci\u0006Lg.\u001a3!\u0003!)\u0007\u0010]3di\u0016$\u0017!C3ya\u0016\u001cG/\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011i\u0011#\u0011\u0005\t\u0003Q\"\u0001\u000e\t\u000bI*\u0001\u0019\u0001\u001b\t\u000bu*\u0001\u0019\u0001\u001b\u0002\u001b=\u0014G/Y5oK\u0012\u001cE.Z1o\u00039y'\r^1j]\u0016$7\t\\3b]\u0002\nQ\"\u001a=qK\u000e$X\rZ\"mK\u0006t\u0017AD3ya\u0016\u001cG/\u001a3DY\u0016\fg\u000eI\u0001\u000e_\n$\u0018-\u001b8fI2Kg.Z:\u0016\u0003-\u00032a\n'5\u0013\ti\u0015GA\u0002TKF\fab\u001c2uC&tW\r\u001a'j]\u0016\u001c\b%A\u0007fqB,7\r^3e\u0019&tWm]\u0001\u000fKb\u0004Xm\u0019;fI2Kg.Z:!\u0003-)h.\u001b4jK\u0012$\u0015N\u001a4\u0002\u0019Ut\u0017NZ5fI\u0012KgM\u001a\u0011\u0002\u000f%\u001cX)\u001c9usV\tQ\u000b\u0005\u0002\"-&\u0011qK\t\u0002\b\u0005>|G.Z1o\u00031\u0019'/Z1uKJ+\u0007o\u001c:u)\r!$\f\u0018\u0005\u00067F\u0001\r\u0001N\u0001\u0006i&$H.\u001a\u0005\b;F\u0001\n\u00111\u0001V\u0003i\u0001(/\u001b8u\u001f\n$\u0018-\u001b8fI\u0006\u001b8\u000b\u001e:ja6\u000b'oZ5o\u0003Y\u0019'/Z1uKJ+\u0007o\u001c:uI\u0011,g-Y;mi\u0012\u0012T#\u00011+\u0005U\u000b7&\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!C;oG\",7m[3e\u0015\t9'%\u0001\u0006b]:|G/\u0019;j_:L!!\u001b3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bde\u0016\fG/\u001a#jM\u001a|e\u000e\\=SKB|'\u000f\u001e\u000b\u0002i\u0005!\u0012\r\u001d9f]\u0012$\u0015N\u001a4P]2L(+\u001a9peR$\"A\\9\u0011\u0005\u0005z\u0017B\u00019#\u0005\u0011)f.\u001b;\t\u000bI$\u0002\u0019A:\u0002\u0005M\u0014\u0007CA\u0014u\u0013\t)\u0018GA\u0007TiJLgn\u001a\"vS2$WM]\u0001\u000eCN\u001cFO]5q\u001b\u0006\u0014x-\u001b8\u0015\u0005QB\b\"\u0002\u001a\u0016\u0001\u0004!\u0014A\u00025fC\u0012,'\u000fF\u0002twvDQ\u0001 \fA\u0002Q\n\u0011\u0001\u001e\u0005\u0006eZ\u0001\ra]\u0001\u0012GJ,\u0017\r^3V]&4\u0017.\u001a3ES\u001a4G#\u0002\u001b\u0002\u0002\u0005\u0015\u0001BBA\u0002/\u0001\u00071*\u0001\u0005pe&<\u0017N\\1m\u0011\u0019\t9a\u0006a\u0001\u0017\u00069!/\u001a<jg\u0016$\u0017AD:qY&$\u0018J\u001c;p\u0019&tWm\u001d\u000b\u0004\u0017\u00065\u0001BBA\b1\u0001\u0007A'\u0001\u0004tiJLgn\u001a")
public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq<String> obtainedLines;
    private final Seq<String> expectedLines;
    private final String unifiedDiff;

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(title)) ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (this.obtainedClean().length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(this.obtainedClean())) : sb.append(this.obtainedClean());
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        this.header("Diff", sb);
        String red = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.LightRed());
        String reset = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset());
        String green = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.LightGreen());
        sb.append(new java.lang.StringBuilder(25).append(" (").append(red).append("- obtained").append(reset).append(", ").append(green).append("+ expected").append(reset).append(")").toString());
        sb.append("\n");
        sb.append(this.unifiedDiff());
    }

    private String asStripMargin(String obtained) {
        if (!obtained.contains("\n")) {
            return Printers$.MODULE$.print(obtained);
        }
        StringBuilder out = new StringBuilder();
        Iterator lines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(obtained.trim()));
        String head = lines.hasNext() ? (String)lines.next() : "";
        out.append(new java.lang.StringBuilder(9).append("    \"\"\"|").append(head).append("\n").toString());
        lines.foreach((Function1 & Serializable)line -> out.append("       |").append(line).append("\n"));
        out.append("       |\"\"\".stripMargin");
        return out.toString();
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.c(new java.lang.StringBuilder(3).append("=> ").append(t).toString(), AnsiColors$.MODULE$.Bold()));
    }

    private String createUnifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch<String> diff = DiffUtils$.MODULE$.diff((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava());
        String result = diff.getDeltas().isEmpty() ? "" : ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils$.MODULE$.generateUnifiedDiff("obtained", "expected", (List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), diff, 1)).asScala()).iterator().drop(2).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("@@"))).map((Function1 & Serializable)line -> {
            if (line.isEmpty()) {
                return line;
            }
            if (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(line)) == ' ') {
                return new java.lang.StringBuilder(1).append((String)line).append("\u2219").toString();
            }
            return line;
        }).map((Function1 & Serializable)line -> {
            if (line.startsWith("-")) {
                return AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightRed());
            }
            if (line.startsWith("+")) {
                return AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightGreen());
            }
            return line;
        }).mkString("\n");
        return result;
    }

    private Seq<String> splitIntoLines(String string) {
        return ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])string.trim().replace("\r\n", "\n").split("\n")));
    }

    public Diff(String obtained, String expected) {
        this.obtained = obtained;
        this.expected = expected;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = this.splitIntoLines(this.obtainedClean());
        this.expectedLines = this.splitIntoLines(this.expectedClean());
        this.unifiedDiff = this.createUnifiedDiff(this.obtainedLines(), this.expectedLines());
    }
}

