/*
 * Decompiled with CFR 0.152.
 */
package munit.diff;

import java.util.ArrayList;
import java.util.List;
import munit.diff.ChangeDelta;
import munit.diff.Chunk;
import munit.diff.DeleteDelta;
import munit.diff.Delta;
import munit.diff.DiffAlgorithm;
import munit.diff.DiffNode;
import munit.diff.DifferentiationFailedException;
import munit.diff.Equalizer;
import munit.diff.Equalizer$;
import munit.diff.InsertDelta;
import munit.diff.Patch;
import munit.diff.PathNode;
import munit.diff.Snake;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i3A\u0001C\u0005\u0001\u001d!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003*\u0001\u0011\u0005Q\u0006C\u0003\u000b\u0001\u0011\u0005c\u0006C\u0003?\u0001\u0011%q\bC\u0003J\u0001\u0011%!\nC\u0003W\u0001\u0011\u0005qKA\u0005Ns\u0016\u00148\u000fR5gM*\u0011!bC\u0001\u0005I&4gMC\u0001\r\u0003\u0015iWO\\5u\u0007\u0001)\"a\u0004\u000f\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0004/aQR\"A\u0005\n\u0005eI!!\u0004#jM\u001a\fEnZ8sSRDW\u000e\u0005\u0002\u001c91\u0001A!B\u000f\u0001\u0005\u0004q\"!\u0001+\u0012\u0005}\u0011\u0003CA\t!\u0013\t\t#CA\u0004O_RD\u0017N\\4\u0011\u0005E\u0019\u0013B\u0001\u0013\u0013\u0005\r\te._\u0001\nKF,\u0018\r\\5{KJ\u00042aF\u0014\u001b\u0013\tA\u0013BA\u0005FcV\fG.\u001b>fe\u00061A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0007]\u0001!\u0004C\u0003&\u0005\u0001\u0007a\u0005F\u0001,)\ry#\u0007\u0010\t\u0004/AR\u0012BA\u0019\n\u0005\u0015\u0001\u0016\r^2i\u0011\u0015\u0019D\u00011\u00015\u0003!y'/[4j]\u0006d\u0007cA\u001b;55\taG\u0003\u00028q\u0005!Q\u000f^5m\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\t1K7\u000f\u001e\u0005\u0006{\u0011\u0001\r\u0001N\u0001\be\u00164\u0018n]3e\u00035\u0011W/\u001b7e%\u00164\u0018n]5p]R!q\u0006Q#H\u0011\u0015\tU\u00011\u0001C\u0003\u0015y\u0006/\u0019;i!\t92)\u0003\u0002E\u0013\tA\u0001+\u0019;i\u001d>$W\rC\u0003G\u000b\u0001\u0007A'\u0001\u0003pe&<\u0007\"\u0002%\u0006\u0001\u0004!\u0014a\u0001:fm\u0006Y1m\u001c9z\u001f\u001a\u0014\u0016M\\4f)\u0011Yej\u0014+\u0011\u0007Ub%$\u0003\u0002Nm\tI\u0011I\u001d:bs2K7\u000f\u001e\u0005\u0006g\u0019\u0001\r\u0001\u000e\u0005\u0006!\u001a\u0001\r!U\u0001\nMJ|W.\u00138eKb\u0004\"!\u0005*\n\u0005M\u0013\"aA%oi\")QK\u0002a\u0001#\u0006\u0011Ao\\\u0001\nEVLG\u000e\u001a)bi\"$2A\u0011-Z\u0011\u00151u\u00011\u00015\u0011\u0015Au\u00011\u00015\u0001")
public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Equalizer<T> equalizer;

    @Override
    public Patch<T> diff(List<T> original, List<T> revised) {
        Patch patch;
        try {
            patch = this.buildRevision(this.buildPath(original, revised), original, revised);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            patch = new Patch();
        }
        return patch;
    }

    private Patch<T> buildRevision(PathNode _path, List<T> orig, List<T> rev) {
        PathNode path = _path;
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev();
        }
        while (path != null && path.prev() != null && path.prev().j() >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i();
            int j = path.j();
            path = path.prev();
            int ianchor = path.i();
            int janchor = path.j();
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            Delta delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev();
        }
        return patch;
    }

    private ArrayList<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }

    public PathNode buildPath(List<T> orig, List<T> rev) {
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                int i = 0;
                if (k == -d || k != d && diagonal[kminus].i() < diagonal[kplus].i()) {
                    i = diagonal[kplus].i();
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i() + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equalizer.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.i()) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public MyersDiff(Equalizer<T> equalizer) {
        this.equalizer = equalizer;
    }

    public MyersDiff() {
        this(Equalizer$.MODULE$.default());
    }
}

