/*
 * Decompiled with CFR 0.152.
 */
package munit.diff;

import java.io.Serializable;
import munit.diff.Diff$;
import munit.diff.DiffOptions;
import munit.diff.DiffOptions$;
import munit.diff.console.AnsiColors$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final DiffOptions options;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq obtainedLines;
    private final Seq expectedLines;
    private final String unifiedDiff;

    public static Diff apply(String string, String string2, DiffOptions diffOptions) {
        return Diff$.MODULE$.apply(string, string2, diffOptions);
    }

    public Diff(String obtained, String expected, DiffOptions options) {
        this.obtained = obtained;
        this.expected = expected;
        this.options = options;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = Diff$.MODULE$.munit$diff$Diff$$$splitIntoLines(this.obtainedClean());
        this.expectedLines = Diff$.MODULE$.munit$diff$Diff$$$splitIntoLines(this.expectedClean());
        this.unifiedDiff = Diff$.MODULE$.munit$diff$Diff$$$createUnifiedDiff(this.expectedLines(), this.obtainedLines(), this.diffOptions());
    }

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public DiffOptions options() {
        return this.options;
    }

    public Diff(String obtained, String expected) {
        this(obtained, expected, (DiffOptions)Predef$.MODULE$.implicitly((Object)DiffOptions$.MODULE$.default()));
    }

    private DiffOptions diffOptions() {
        return this.options();
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        StringBuilder sb = new StringBuilder();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(title))) {
            sb.append(title).append("\n");
        }
        if (this.obtainedClean().length() < 1000) {
            Diff$.MODULE$.munit$diff$Diff$$$header("Obtained", sb, this.diffOptions());
            sb.append("\n");
            sb.append(Diff$.MODULE$.munit$diff$Diff$$$asStripMargin(this.obtainedClean(), printObtainedAsStripMargin));
            sb.append("\n");
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createReport(String title) {
        return this.createReport(title, this.options().obtainedAsStripMargin());
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        Diff$.MODULE$.munit$diff$Diff$$$header("Diff", sb, this.diffOptions());
        sb.append(" (");
        AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.LightRed(), this.options().ansi(), (Function1<StringBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> _$1.append("- expected"), sb);
        sb.append(", ");
        AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.LightGreen(), this.options().ansi(), (Function1<StringBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.append("+ obtained"), sb);
        sb.append(")\n");
        sb.append(this.unifiedDiff());
    }
}

