/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import munit.Clue;
import munit.Clues;
import munit.EmptyPrinter$;
import munit.Location;
import munit.Printable;
import munit.Printer;
import munit.internal.Compat$;
import munit.internal.console.AnsiColors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class Printers$ {
    public static final Printers$ MODULE$ = new Printers$();

    public void log(Object any, Printer printer, Location loc) {
        Predef$.MODULE$.println((Object)loc.toString());
        Predef$.MODULE$.println((Object)this.print(any, printer));
    }

    public Printer log$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    public String print(Object any, Printer printer) {
        IntRef height = IntRef.create((int)printer.height());
        StringBuilder out = new StringBuilder();
        int indentStep = 2;
        this.loop$1(any, 0, height, out, indentStep, printer);
        return AnsiColors$.MODULE$.filterAnsi(out.toString());
    }

    public Printer print$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    private <T> void printApply(String prefix, Iterator<T> it, StringBuilder out, int indent, int nextIndent, String open, String close, String comma, Function1<T, BoxedUnit> fn) {
        out.append(prefix);
        out.append(open);
        if (it.hasNext()) {
            this.printNewline(out, nextIndent);
            while (it.hasNext()) {
                Object value = it.next();
                fn.apply(value);
                if (it.hasNext()) {
                    out.append(comma);
                    this.printNewline(out, nextIndent);
                    continue;
                }
                this.printNewline(out, indent);
            }
        }
        out.append(close);
    }

    private <T> String printApply$default$6() {
        return "(";
    }

    private <T> String printApply$default$7() {
        return ")";
    }

    private <T> String printApply$default$8() {
        return ",";
    }

    private void printNewline(StringBuilder out, int indent) {
        out.append("\n");
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
    }

    private void printString(String string, StringBuilder out, Printer printer) {
        boolean isMultiline = printer.isMultiline(string);
        if (isMultiline) {
            out.append('\"');
            out.append('\"');
            out.append('\"');
            out.append(string);
            out.append('\"');
            out.append('\"');
            out.append('\"');
        } else {
            out.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                this.printChar(string.charAt(i), out);
            }
            out.append('\"');
        }
    }

    private StringBuilder printChar(char c, StringBuilder sb) {
        StringBuilder stringBuilder;
        char c2 = c;
        switch (c2) {
            case '\"': {
                stringBuilder = sb.append("\\\"");
                break;
            }
            case '\'': {
                stringBuilder = sb.append("\\'");
                break;
            }
            case '\\': {
                stringBuilder = sb.append("\\\\");
                break;
            }
            case '\b': {
                stringBuilder = sb.append("\\b");
                break;
            }
            case '\f': {
                stringBuilder = sb.append("\\f");
                break;
            }
            case '\n': {
                stringBuilder = sb.append("\\n");
                break;
            }
            case '\r': {
                stringBuilder = sb.append("\\r");
                break;
            }
            case '\t': {
                stringBuilder = sb.append("\\t");
                break;
            }
            default: {
                boolean isUnicode = false;
                if (c2 < ' ' || c2 > '~' && isUnicode) {
                    stringBuilder = sb.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c2)})));
                    break;
                }
                stringBuilder = sb.append(c2);
                break;
            }
        }
        return stringBuilder;
    }

    public static final /* synthetic */ void $anonfun$print$1(Printers$ $this, StringBuilder out$1, int nextIndent$1, IntRef height$1, int indentStep$1, Printer printer$1, Clue clue) {
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(clue.source())) ? out$1.append(clue.source()) : BoxedUnit.UNIT;
        Object object2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(clue.valueType())) ? out$1.append(": ").append(clue.valueType()) : BoxedUnit.UNIT;
        out$1.append(" = ");
        $this.loop$1(clue.value(), nextIndent$1, height$1, out$1, indentStep$1, printer$1);
    }

    public static final /* synthetic */ void $anonfun$print$2(Printers$ $this, int nextIndent$1, StringBuilder out$1, IntRef height$1, int indentStep$1, Printer printer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        $this.loop$1(key, nextIndent$1, height$1, out$1, indentStep$1, printer$1);
        out$1.append(" -> ");
        $this.loop$1(value, nextIndent$1, height$1, out$1, indentStep$1, printer$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$print$6(Printers$ $this, StringBuilder out$1, int nextIndent$1, IntRef height$1, int indentStep$1, Printer printer$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object value = tuple2._1();
        String key = (String)tuple2._2();
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(key)) ? out$1.append(key).append(" = ") : BoxedUnit.UNIT;
        $this.loop$1(value, nextIndent$1, height$1, out$1, indentStep$1, printer$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void loop$1(Object a, int indent, IntRef height$1, StringBuilder out$1, int indentStep$1, Printer printer$1) {
        block39: {
            --height$1.elem;
            if (height$1.elem < 0) {
                out$1.append("...");
                return;
            }
            int nextIndent = indent + indentStep$1;
            boolean isDone = printer$1.print(a, out$1, indent);
            if (isDone) break block39;
            Object object = a;
            if (object == null) {
                out$1.append("null");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Printable) {
                Printable printable = (Printable)object;
                printable.print(out$1, indent);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                out$1.append('\'');
                this.printChar(c, out$1);
                out$1.append('\'');
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToByte((byte)by)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToShort((short)s)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToLong((long)l)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToFloat((float)f)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToDouble((double)d)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String) {
                String string = (String)object;
                this.printString(string, out$1, printer$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Clues) {
                Clues clues = (Clues)object;
                this.printApply("Clues", clues.values().iterator(), out$1, indent, nextIndent, " {", "}", "", (Function1 & Serializable)clue -> {
                    Printers$.$anonfun$print$1(this, out$1, nextIndent, height$1, indentStep$1, printer$1, clue);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(object)) {
                out$1.append("None");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Nil$.MODULE$.equals(object)) {
                out$1.append("Nil");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                this.printApply(Compat$.MODULE$.collectionClassName((Iterable<?>)map), map.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)x0$1 -> {
                    Printers$.$anonfun$print$2(this, nextIndent, out$1, height$1, indentStep$1, printer$1, x0$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                this.printApply(Compat$.MODULE$.collectionClassName(iterable), iterable.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)value -> {
                    this.loop$1(value, nextIndent, height$1, out$1, indentStep$1, printer$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                this.printApply("Array", ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(object2)), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)value -> {
                    this.loop$1(value, nextIndent, height$1, out$1, indentStep$1, printer$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Iterator) {
                BoxedUnit boxedUnit;
                Iterator iterator = (Iterator)object;
                if (iterator.isEmpty()) {
                    out$1.append("empty iterator");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    out$1.append("non-empty iterator");
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (object instanceof Product) {
                Product product = (Product)object;
                Iterator<String> elementNames = Compat$.MODULE$.productElementNames(product);
                Iterator infiniteElementNames = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> elementNames.hasNext() ? (String)elementNames.next() : "");
                this.printApply(product.productPrefix(), product.productIterator().zip((IterableOnce)infiniteElementNames), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)x0$2 -> {
                    Printers$.$anonfun$print$6(this, out$1, nextIndent, height$1, indentStep$1, printer$1, x0$2);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                out$1.append(a.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Printers$() {
    }
}

