/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Path;
import munit.Clues;
import munit.Clues$;
import munit.Location;
import munit.diff.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.io.PlatformIO$Files$;
import munit.internal.io.PlatformIO$Path$;
import munit.internal.io.PlatformIO$Paths$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005y4A!\u0003\u0006\u0001#!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003B\u0002'\u0001A\u0003%!\u0006C\u0003N\u0001\u0011\u0005a\nC\u0003V\u0001\u0011\u0005a\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0004p\u0001E\u0005I\u0011\u00019\t\u000fm\u0004\u0011\u0013!C\u0001y\n)A*\u001b8fg*\u00111\u0002D\u0001\bG>t7o\u001c7f\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\u0005y\u0011!B7v]&$8\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001aC9\u0011!d\b\b\u00037yi\u0011\u0001\b\u0006\u0003;A\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005\u0001\"\u0012a\u00029bG.\fw-Z\u0005\u0003E\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\t\u000b\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005Q\u0011!\u00034jY\u0016\u001c\u0017m\u00195f+\u0005Q\u0003\u0003B\u00161e\u0005k\u0011\u0001\f\u0006\u0003[9\nq!\\;uC\ndWM\u0003\u00020)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Eb#aA'baB\u00111G\u0010\b\u0003imr!!N\u001d\u000f\u0005YBdBA\u000e8\u0013\u0005y\u0011BA\u0007\u000f\u0013\tQD\"\u0001\u0002j_&\u0011A(P\u0001\u000b!2\fGOZ8s[&{%B\u0001\u001e\r\u0013\ty\u0004I\u0001\u0003QCRD'B\u0001\u001f>!\r\u0019\"\tR\u0005\u0003\u0007R\u0011Q!\u0011:sCf\u0004\"!R%\u000f\u0005\u0019;\u0005CA\u000e\u0015\u0013\tAE#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u0015\u0003)1\u0017\u000e\\3dC\u000eDW\rI\u0001\u000bM>\u0014X.\u0019;QCRDGC\u0001#P\u0011\u0015\u0001F\u00011\u0001R\u0003!awnY1uS>t\u0007C\u0001*T\u001b\u0005q\u0011B\u0001+\u000f\u0005!aunY1uS>t\u0017\u0001\u00034j]\u0012\u0004\u0016\r\u001e5\u0015\tI:\u0016l\u0017\u0005\u00061\u0016\u0001\r\u0001R\u0001\u0004G^$\u0007\"\u0002.\u0006\u0001\u0004!\u0015\u0001\u00029bi\"DQ\u0001X\u0003A\u0002u\u000b1!\\1y!\t\u0019b,\u0003\u0002`)\t\u0019\u0011J\u001c;\u0002\u0015\u0019|'/\\1u\u0019&tW\rF\u0003EE\u000e,'\u000eC\u0003Q\r\u0001\u0007\u0011\u000bC\u0003e\r\u0001\u0007A)A\u0004nKN\u001c\u0018mZ3\t\u000f\u00194\u0001\u0013!a\u0001O\u0006)1\r\\;fgB\u0011!\u000b[\u0005\u0003S:\u0011Qa\u00117vKNDqa\u001b\u0004\u0011\u0002\u0003\u0007A.\u0001\u0003b]NL\u0007CA\nn\u0013\tqGCA\u0004C_>dW-\u00198\u0002)\u0019|'/\\1u\u0019&tW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005\t(FA4sW\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003%)hn\u00195fG.,GM\u0003\u0002y)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i,(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!bm\u001c:nCRd\u0015N\\3%I\u00164\u0017-\u001e7uIQ*\u0012! \u0016\u0003YJ\u0004")
public class Lines
implements Serializable {
    private final Map<Path, String[]> filecache = (Map)Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatPath(Location location) {
        return location.path();
    }

    public Path findPath(String cwd, String path, int max) {
        Path p = PlatformIO$Paths$.MODULE$.get(cwd).resolve(path);
        if (PlatformIO$Files$.MODULE$.exists(p)) {
            return p;
        }
        if (max < 1) {
            throw package$.MODULE$.error(new StringBuilder(14).append(path).append(" was not found").toString());
        }
        if (cwd.contains("\\")) {
            return this.findPath(Lines.getParentPath$1(cwd, "\\"), path, max - 1);
        }
        return this.findPath(Lines.getParentPath$1(cwd, "/"), path, max - 1);
    }

    public String formatLine(Location location, String message, Clues clues, boolean ansi) {
        String string;
        try {
            Object object;
            Path path = this.findPath(((Object)PlatformIO$Path$.MODULE$.workingDirectory()).toString(), location.path(), 3);
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable)() -> (String[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(PlatformIO$Files$.MODULE$.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])lines), location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = Integer.toString(location.line() + 1).length() + 1;
                boolean isMultilineMessage = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(message), '\n');
                out.append(this.formatPath(location)).append(':').append(location.line());
                Object object2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(message)) && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n');
                AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.Reversed(), ansi, (Function1 & Serializable)x$1 -> {
                    Lines.$anonfun$formatLine$2(location, slice, width, x$1);
                    return BoxedUnit.UNIT;
                }, out);
                Object object3 = slice.length >= 3 ? out.append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]) : BoxedUnit.UNIT;
                Object object4 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                string = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            }
            throw throwable;
        }
        return string;
    }

    public Clues formatLine$default$3() {
        return Clues$.MODULE$.empty();
    }

    public boolean formatLine$default$4() {
        return true;
    }

    private static final String getParentPath$1(String somePath, String sep) {
        String somePath1 = somePath.endsWith(sep) ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(somePath), sep.length()) : somePath;
        String string = sep;
        String string2 = "\\";
        String sep1 = !(string != null ? !string.equals(string2) : string2 != null) ? "\\\\" : sep;
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])somePath1.split(sep1)), 1)).mkString(sep);
    }

    private static final String format$1(int n, int width$1) {
        return StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString()), width$1, ' ');
    }

    public static final /* synthetic */ void $anonfun$formatLine$2(Location location$1, String[] slice$1, int width$1, scala.collection.mutable.StringBuilder x$1) {
        x$1.append(Lines.format$1(location$1.line(), width$1)).append(slice$1[1]);
    }
}

