/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.Location;
import munit.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;

public class GenericTest<T>
implements Serializable {
    private final String name;
    private final Function0 body;
    private final Set tags;
    private final Location location;

    public <T> GenericTest(String name, Function0<T> body, Set<Tag> tags, Location location) {
        this.name = name;
        this.body = body;
        this.tags = tags;
        this.location = location;
    }

    public String name() {
        return this.name;
    }

    public Function0<T> body() {
        return this.body;
    }

    public Set<Tag> tags() {
        return this.tags;
    }

    public Location location() {
        return this.location;
    }

    public <T> GenericTest(String name, Function0<T> body, Location loc) {
        this(name, body, (Set<Tag>)Predef$.MODULE$.Set().empty(), loc);
    }

    public GenericTest<T> withName(String newName) {
        return this.copy(newName, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public <A> GenericTest<A> withBody(Function0<A> newBody) {
        return this.copy(this.copy$default$1(), newBody, this.copy$default$3(), this.copy$default$4());
    }

    public GenericTest<T> withTags(Set<Tag> newTags) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), newTags, this.copy$default$4());
    }

    public GenericTest<T> tag(Tag newTag) {
        return this.withTags((Set<Tag>)((Set)this.tags().$plus((Object)newTag)));
    }

    public GenericTest<T> withLocation(Location newLocation) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newLocation);
    }

    public <A> GenericTest<A> withBodyMap(Function1<T, A> newBody) {
        return this.withBody((Function0 & Serializable)() -> newBody.apply(this.body().apply()));
    }

    private <A> GenericTest<A> copy(String name, Function0<A> body, Set<Tag> tags, Location location) {
        return new GenericTest<A>(name, body, tags, location);
    }

    private <A> String copy$default$1() {
        return this.name();
    }

    private <A> Function0<T> copy$default$2() {
        return this.body();
    }

    private <A> Set<Tag> copy$default$3() {
        return this.tags();
    }

    private <A> Location copy$default$4() {
        return this.location();
    }

    public String toString() {
        return "GenericTest(" + this.name() + ", " + this.tags() + ", " + this.location() + ")";
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public Annotation[] annotations() {
        ArrayBuffer buf = new ArrayBuffer(this.tags().size() + 1);
        buf.$plus$plus$eq(this.tags());
        buf.$plus$eq((Object)this.location());
        return (Annotation[])buf.toArray(ClassTag$.MODULE$.apply(Annotation.class));
    }
}

