/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import munit.Location;
import munit.Tag;
import munit.TestOptions$;
import munit.package$;
import scala.Predef$;
import scala.collection.immutable.Set;

public final class TestOptions
implements Serializable {
    private final String name;
    private final Set tags;
    private final Location location;

    public static TestOptions apply(String string, Location location) {
        return TestOptions$.MODULE$.apply(string, location);
    }

    public static TestOptions testOptionsFromString(String string, Location location) {
        return TestOptions$.MODULE$.testOptionsFromString(string, location);
    }

    public TestOptions(String name, Set<Tag> tags, Location location) {
        this.name = name;
        this.tags = tags;
        this.location = location;
    }

    public String name() {
        return this.name;
    }

    public Set<Tag> tags() {
        return this.tags;
    }

    public Location location() {
        return this.location;
    }

    public TestOptions(String name, Location loc) {
        this(name, (Set<Tag>)Predef$.MODULE$.Set().empty(), loc);
    }

    public TestOptions withName(String newName) {
        return this.copy(newName, this.copy$default$2(), this.copy$default$3());
    }

    public TestOptions withTags(Set<Tag> newTags) {
        return this.copy(this.copy$default$1(), newTags, this.copy$default$3());
    }

    public TestOptions withLocation(Location newLocation) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), newLocation);
    }

    public TestOptions fail() {
        return this.tag(package$.MODULE$.Fail());
    }

    public TestOptions flaky() {
        return this.tag(package$.MODULE$.Flaky());
    }

    public TestOptions ignore() {
        return this.tag(package$.MODULE$.Ignore());
    }

    public TestOptions only() {
        return this.tag(package$.MODULE$.Only());
    }

    public TestOptions tag(Tag t) {
        Set set = (Set)this.tags().$plus((Object)t);
        String string = this.copy$default$1();
        Location location = this.copy$default$3();
        return this.copy(string, (Set<Tag>)set, location);
    }

    private TestOptions copy(String name, Set<Tag> tags, Location location) {
        return new TestOptions(name, tags, location);
    }

    private String copy$default$1() {
        return this.name();
    }

    private Set<Tag> copy$default$2() {
        return this.tags();
    }

    private Location copy$default$3() {
        return this.location();
    }

    public String toString() {
        return "TestOptions(" + this.name() + ", " + this.tags() + ", " + this.location() + ")";
    }
}

