/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.AfterEach;
import munit.AnyFixture;
import munit.BeforeEach;
import munit.Exceptions$;
import munit.FailSuiteException;
import munit.Fixture;
import munit.FunSuite;
import munit.Location$;
import munit.MUnitRunner$;
import munit.Suite;
import munit.Tag;
import munit.Test;
import munit.TestValues;
import munit.TestValues$;
import munit.internal.Compat$;
import munit.internal.FutureCompat$;
import munit.internal.PlatformCompat$;
import munit.internal.console.Printers$;
import munit.internal.console.StackTraces$;
import munit.internal.junitinterface.Configurable;
import munit.internal.junitinterface.Settings;
import munit.package$;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class MUnitRunner
extends Runner
implements Filterable,
Configurable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MUnitRunner.class.getDeclaredField("munitFixtures$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MUnitRunner.class.getDeclaredField("munitTests$lzy1"));
    private final Class cls;
    private final Suite suite;
    private final ExecutionContext ec;
    private volatile Settings settings;
    public volatile boolean munit$MUnitRunner$$suiteAborted;
    private final Map<Test, Description> descriptions;
    private final Set<String> testNames;
    private volatile Object munitTests$lzy1;
    private Fixture<BoxedUnit> suiteFixtureBefore;
    private Fixture<BoxedUnit> suiteFixtureAfter;
    private volatile Object munitFixtures$lzy1;

    public MUnitRunner(Class<? extends Suite> cls, Function0<Suite> newInstance) {
        this.cls = cls;
        this.suite = (Suite)newInstance.apply();
        this.ec = this.suite().munitExecutionContext();
        this.settings = Settings.defaults();
        this.munit$MUnitRunner$$suiteAborted = false;
        this.descriptions = (Map)Map$.MODULE$.empty();
        this.testNames = (Set)Set$.MODULE$.empty();
        this.suiteFixtureBefore = new Fixture<BoxedUnit>(this){
            private final /* synthetic */ MUnitRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.cls().getName());
            }

            public void apply() {
            }

            public void beforeAll() {
                this.$outer.suite().beforeAll();
            }

            public void beforeEach(BeforeEach context) {
                this.$outer.suite().beforeEach(context);
            }
        };
        this.suiteFixtureAfter = new Fixture<BoxedUnit>(this){
            private final /* synthetic */ MUnitRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.cls().getName());
            }

            public void apply() {
            }

            public void afterEach(AfterEach context) {
                this.$outer.suite().afterEach(context);
            }

            public void afterAll() {
                this.$outer.suite().afterAll();
            }
        };
    }

    public Class<? extends Suite> cls() {
        return this.cls;
    }

    public MUnitRunner(Class<? extends Suite> cls) {
        this(MUnitRunner$.MODULE$.munit$MUnitRunner$$$ensureEligibleConstructor(cls), MUnitRunner.MUnitRunner$superArg$1(cls));
    }

    public Suite suite() {
        return this.suite;
    }

    private ArrayBuffer<Test> munitTests() {
        Object object = this.munitTests$lzy1;
        if (object instanceof ArrayBuffer) {
            return (ArrayBuffer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ArrayBuffer)this.munitTests$lzyINIT1();
    }

    private Object munitTests$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.munitTests$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ArrayBuffer arrayBuffer = null;
                    try {
                        arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(this.suite().munitTests());
                        object2 = arrayBuffer == null ? LazyVals.NullValue$.MODULE$ : arrayBuffer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.munitTests$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return arrayBuffer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private List<AnyFixture<?>> munitFixtures() {
        Object object = this.munitFixtures$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.munitFixtures$lzyINIT1();
    }

    private Object munitFixtures$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.munitFixtures$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        List list2 = this.suite().munitFixtures().toList();
                        list = scala.package$.MODULE$.Nil().$colon$colon(this.suiteFixtureAfter).$colon$colon$colon(list2).$colon$colon(this.suiteFixtureBefore);
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                        this.suiteFixtureAfter = null;
                        this.suiteFixtureBefore = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.munitFixtures$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.munitFixtures$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void filter(Filter filter) {
        ArrayBuffer newTests = (ArrayBuffer)this.munitTests().filter((Function1 & Serializable)t -> filter.shouldRun(this.createTestDescription((Test)t)));
        this.munitTests().clear();
        this.munitTests().$plus$plus$eq((IterableOnce)newTests);
    }

    public void configure(Settings settings) {
        this.settings = settings;
    }

    private Description createTestDescription(Test test) {
        return (Description)this.descriptions.getOrElseUpdate((Object)test, () -> this.createTestDescription$$anonfun$1(test));
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.cls());
        try {
            ArrayBuffer suiteTests = (ArrayBuffer)StackTraces$.MODULE$.dropOutside(this::$anonfun$4);
            suiteTests.iterator().map((Function1 & Serializable)test -> this.createTestDescription((Test)test)).foreach((Function1)(JProcedure1 & Serializable)x$0 -> description.addChild(x$0));
        }
        catch (Throwable ex) {
            this.munit$MUnitRunner$$trimStackTrace(ex);
            ex.printStackTrace();
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        PlatformCompat$.MODULE$.awaitResult(this.runAsync(notifier));
    }

    public Future<BoxedUnit> runAsync(RunNotifier notifier) {
        Description description = this.getDescription();
        if (PlatformCompat$.MODULE$.isIgnoreSuite(this.cls()) || this.munitTests().isEmpty()) {
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        notifier.fireTestSuiteStarted(description);
        return FutureCompat$.MODULE$.ExtensionFuture(this.runAll(notifier)).transformCompat((Function1 & Serializable)result -> {
            result.failed().foreach((Function1)(JProcedure1 & Serializable)ex -> this.fireFailedHiddenTest(notifier, "unexpected error running tests", (Throwable)ex));
            notifier.fireTestSuiteFinished(description);
            return Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }, this.ec);
    }

    private Future<List<Try<Object>>> runTests(RunNotifier notifier) {
        return this.sequenceFutures(this.munitTests().iterator().map((Function1 & Serializable)t -> this.runTest(notifier, (Test)t)));
    }

    private <A> Future<List<Try<A>>> sequenceFutures(Iterator<Future<A>> futures) {
        return this.loop$1(futures, ListBuffer$.MODULE$.empty());
    }

    private Option<Duration> munitTimeout() {
        Suite suite = this.suite();
        if (suite instanceof FunSuite) {
            FunSuite funSuite = (FunSuite)suite;
            return Some$.MODULE$.apply((Object)funSuite.munitTimeout());
        }
        return None$.MODULE$;
    }

    private Future<BoxedUnit> runAll(RunNotifier notifier) {
        return this.runBeforeAll(notifier).flatMap((Function1 & Serializable)beforeAll -> (beforeAll.isSuccess() ? this.runTests(notifier) : Future$.MODULE$.successful((Object)scala.package$.MODULE$.Nil())).flatMap((Function1 & Serializable)x$12 -> {
            List list = x$12;
            return this.runAfterAll(notifier, (BeforeAllResult)beforeAll).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }, this.ec);
        }, this.ec), this.ec);
    }

    private Future<BeforeAllResult> runBeforeAll(RunNotifier notifier) {
        Future result = this.sequenceFutures(this.munitFixtures().iterator().map((Function1 & Serializable)f -> this.runHiddenTest(notifier, new StringBuilder(11).append("beforeAll(").append(f.fixtureName()).append(")").toString(), (Function0<Object>)(Function0 & Serializable)() -> f.beforeAll()).map((Function1 & Serializable)isSuccess -> MUnitRunner.$anonfun$5$$anonfun$2(f, BoxesRunTime.unboxToBoolean((Object)isSuccess)), this.ec)));
        return result.map((Function1 & Serializable)results -> {
            List loadedFixtures = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    Tuple2 tuple2;
                    Try try_ = x;
                    if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                        AnyFixture fixture = (AnyFixture)tuple2._1();
                        if (BoxesRunTime.unboxToBoolean((Object)tuple2._2())) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Tuple2 tuple2;
                    Try try_ = x;
                    if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                        AnyFixture fixture = (AnyFixture)tuple2._1();
                        if (BoxesRunTime.unboxToBoolean((Object)tuple2._2())) {
                            return fixture;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            List errors = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        return ex;
                    }
                    return function1.apply((Object)x);
                }
            });
            boolean isSuccess = loadedFixtures.length() == results.length();
            return new BeforeAllResult(this, isSuccess, loadedFixtures, (List<Throwable>)errors);
        }, this.ec);
    }

    private Future<BoxedUnit> runAfterAll(RunNotifier notifier, BeforeAllResult beforeAll) {
        return this.sequenceFutures(beforeAll.loadedFixtures().iterator().map((Function1 & Serializable)f -> this.runHiddenTest(notifier, new StringBuilder(10).append("afterAll(").append(f.fixtureName()).append(")").toString(), (Function0<Object>)(Function0 & Serializable)() -> f.afterAll()))).map((Function1)(JProcedure1 & Serializable)_$1 -> {}, this.ec);
    }

    private Future<BeforeAllResult> runBeforeEach(Test test) {
        BeforeEach context = new BeforeEach(test);
        ListBuffer fixtures = ListBuffer$.MODULE$.empty();
        return this.sequenceFutures(this.munitFixtures().iterator().map((Function1 & Serializable)f -> this.valueTransform((Function0<Object>)(Function0 & Serializable)() -> f.beforeEach(context)).map((Function1 & Serializable)_$2 -> f, this.ec))).map((Function1 & Serializable)results -> {
            List loadedFixtures = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        AnyFixture f = (AnyFixture)((Success)try_).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        AnyFixture f = (AnyFixture)((Success)try_).value();
                        return f;
                    }
                    return function1.apply((Object)x);
                }
            });
            List errors = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        return ex;
                    }
                    return function1.apply((Object)x);
                }
            });
            boolean isSuccess = loadedFixtures.length() == results.length();
            return new BeforeAllResult(this, isSuccess, loadedFixtures, (List<Throwable>)errors);
        }, this.ec);
    }

    private Future<BoxedUnit> runAfterEach(Test test, List<AnyFixture<?>> fixtures) {
        AfterEach context = new AfterEach(test);
        return this.sequenceFutures(fixtures.iterator().map((Function1 & Serializable)f -> this.valueTransform((Function0<Object>)(Function0 & Serializable)() -> f.afterEach(context)))).map((Function1)(JProcedure1 & Serializable)_$3 -> {}, this.ec);
    }

    private Future<Object> runTest(RunNotifier notifier, Test test) {
        Future future;
        Description description = this.createTestDescription(test);
        if (this.munit$MUnitRunner$$suiteAborted) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)((Object)new FailSuiteException("Suite has been aborted", test.location()))));
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (test.tags().apply((Object)package$.MODULE$.Ignore())) {
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        notifier.fireTestStarted(description);
        Serializable onError = new Serializable(notifier, description, this){
            private final RunNotifier notifier$9;
            private final Description description$4;
            private final /* synthetic */ MUnitRunner $outer;
            {
                this.notifier$9 = notifier$14;
                this.description$4 = description$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    return true;
                }
                if (throwable instanceof StackOverflowError) {
                    StackOverflowError ex = (StackOverflowError)throwable;
                    return true;
                }
                Throwable ex = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    this.$outer.munit$MUnitRunner$$trimStackTrace((Throwable)ex);
                    this.notifier$9.fireTestAssumptionFailed(new Failure(this.description$4, (Throwable)ex));
                    return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    return this.$outer.munit$MUnitRunner$$_$handleNonFatalOrStackOverflow$1(this.description$4, this.notifier$9, ex);
                }
                if (throwable instanceof StackOverflowError) {
                    StackOverflowError ex = (StackOverflowError)throwable;
                    return this.$outer.munit$MUnitRunner$$_$handleNonFatalOrStackOverflow$1(this.description$4, this.notifier$9, ex);
                }
                Throwable ex = throwable;
                this.$outer.munit$MUnitRunner$$suiteAborted = true;
                this.notifier$9.fireTestFailure(new Failure(this.description$4, ex));
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        };
        try {
            future = this.runTestBody(notifier, description, test).recoverWith((PartialFunction)onError, this.ec);
        }
        catch (Throwable ex$) {
            Serializable $1$ = onError;
            if ($1$.isDefinedAt(ex$)) {
                future = (Future)$1$.apply(ex$);
            }
            throw ex$;
        }
        Future result = future;
        return result.map((Function1 & Serializable)_$4 -> {
            notifier.fireTestFinished(description);
            return !test.tags().apply((Object)package$.MODULE$.Pending());
        }, this.ec);
    }

    private Future<Object> futureFromAny(Object any) {
        Object object = any;
        if (object instanceof Future) {
            Future f = (Future)object;
            return f;
        }
        return Future$.MODULE$.successful(any);
    }

    private Future<BoxedUnit> runTestBody(RunNotifier notifier, Description description, Test test) {
        Future result = this.runBeforeEach(test).flatMap((Function1 & Serializable)beforeEach -> {
            List<Throwable> list = beforeEach.errors();
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List<Throwable> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return FutureCompat$.MODULE$.ExtensionFuture((Future)StackTraces$.MODULE$.dropOutside(() -> MUnitRunner.$anonfun$6$$anonfun$1(test))).transformWithCompat((Function1 & Serializable)result -> FutureCompat$.MODULE$.ExtensionFuture(this.runAfterEach(test, beforeEach.loadedFixtures())).transformCompat((Function1 & Serializable)_$5 -> result, this.ec), this.ec);
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                Throwable error = (Throwable)colon2.head();
                List errors = list3;
                errors.foreach((Function1)(JProcedure1 & Serializable)err -> error.addSuppressed((Throwable)err));
                try {
                    Future<BoxedUnit> future = this.runAfterEach(test, beforeEach.loadedFixtures());
                }
                finally {
                    throw error;
                }
            }
            throw new MatchError(list);
        }, this.ec);
        return result.map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof TestValues.FlakyFailure) {
                TestValues.FlakyFailure f = (TestValues.FlakyFailure)object;
                this.munit$MUnitRunner$$trimStackTrace((Throwable)((Object)f));
                notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)((Object)f)));
                return;
            }
            Tag tag = TestValues$.MODULE$.Ignore();
            Object object2 = object;
            if (!(tag != null ? !((Object)tag).equals(object2) : object2 != null)) {
                notifier.fireTestIgnored(description);
                return;
            }
            if (test.tags().apply((Object)package$.MODULE$.Pending())) {
                notifier.fireTestIgnored(description);
                return;
            }
        }, this.ec);
    }

    private Future<Object> runHiddenTest(RunNotifier notifier, String name, Function0<Object> thunk) {
        Future future;
        try {
            future = (Future)StackTraces$.MODULE$.dropOutside(() -> this.runHiddenTest$$anonfun$1(thunk, notifier, name));
        }
        catch (Throwable ex) {
            this.fireFailedHiddenTest(notifier, name, ex);
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return future;
    }

    private void fireFailedHiddenTest(RunNotifier notifier, String name, Throwable ex) {
        Test test = new Test(name, (Function0<Future<Object>>)(Function0 & Serializable)() -> {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }, (scala.collection.immutable.Set<Tag>)Predef$.MODULE$.Set().empty(), Location$.MODULE$.empty());
        Description description = this.createTestDescription(test);
        notifier.fireTestStarted(description);
        this.munit$MUnitRunner$$trimStackTrace(ex);
        notifier.fireTestFailure(new Failure(description, Exceptions$.MODULE$.rootCause(ex)));
        notifier.fireTestFinished(description);
    }

    public void munit$MUnitRunner$$trimStackTrace(Throwable ex) {
        if (this.settings.trimStackTraces()) {
            StackTraces$.MODULE$.trimStackTrace(ex);
            return;
        }
    }

    private Future<Object> valueTransform(Function0<Object> thunk) {
        Suite suite = this.suite();
        if (suite instanceof FunSuite) {
            FunSuite funSuite = (FunSuite)suite;
            return funSuite.munitValueTransform((Function0)thunk);
        }
        return this.futureFromAny(thunk.apply());
    }

    private static Function0<Suite> MUnitRunner$superArg$1(Class<? extends Suite> cls) {
        return (Function0 & Serializable)() -> (Suite)cls.newInstance();
    }

    private static final /* synthetic */ String $anonfun$2(String escapedName$1, int x$1) {
        int n = x$1;
        if (0 == n) {
            return escapedName$1;
        }
        int n2 = n;
        return new StringBuilder(1).append(escapedName$1).append("-").append(n2).toString();
    }

    private final Description createTestDescription$$anonfun$1(Test test$1) {
        String escapedName = Printers$.MODULE$.escapeNonVisible(test$1.name());
        String testName = (String)Option$.MODULE$.option2Iterable(Compat$.MODULE$.LazyList().from(0).map((Function1 & Serializable)x$1 -> MUnitRunner.$anonfun$2(escapedName, BoxesRunTime.unboxToInt((Object)x$1))).find((Function1 & Serializable)candidate -> !this.testNames.contains(candidate))).head();
        this.testNames.$plus$eq((Object)testName);
        Description desc = Description.createTestDescription(this.cls(), (String)testName, (Annotation[])test$1.annotations());
        return desc;
    }

    private final ArrayBuffer $anonfun$4() {
        return this.munitTests();
    }

    private final Future loop$1(Iterator it, ListBuffer acc) {
        Option option;
        Future future;
        while (true) {
            if (!it.hasNext()) {
                return Future$.MODULE$.successful((Object)acc.toList());
            }
            future = (Future)it.next();
            option = future.value();
            if (!(option instanceof Some)) break;
            Try value = (Try)((Some)option).value();
            acc.$plus$eq((Object)value);
        }
        if (None$.MODULE$.equals(option)) {
            return future.flatMap((Function1 & Serializable)t -> {
                acc.$plus$eq((Object)Success$.MODULE$.apply(t));
                return this.loop$1(it, acc);
            }, this.ec);
        }
        throw new MatchError((Object)option);
    }

    private static final /* synthetic */ Tuple2 $anonfun$5$$anonfun$2(AnyFixture f$2, boolean isSuccess) {
        AnyFixture anyFixture = (AnyFixture)Predef$.MODULE$.ArrowAssoc((Object)f$2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)anyFixture, (Object)BoxesRunTime.boxToBoolean((boolean)isSuccess));
    }

    public final Future munit$MUnitRunner$$_$handleNonFatalOrStackOverflow$1(Description description$3, RunNotifier notifier$8, Throwable ex) {
        this.munit$MUnitRunner$$trimStackTrace(ex);
        Throwable cause = Exceptions$.MODULE$.rootCause(ex);
        Failure failure = new Failure(description$3, cause);
        Throwable throwable = cause;
        if (throwable instanceof AssumptionViolatedException) {
            notifier$8.fireTestAssumptionFailed(failure);
        } else if (throwable instanceof FailSuiteException) {
            this.munit$MUnitRunner$$suiteAborted = true;
            notifier$8.fireTestFailure(failure);
        } else {
            notifier$8.fireTestFailure(failure);
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private static final Future $anonfun$6$$anonfun$1(Test test$4) {
        return (Future)test$4.body().apply();
    }

    private final Future runHiddenTest$$anonfun$1(Function0 thunk$1, RunNotifier notifier$12, String name$1) {
        return FutureCompat$.MODULE$.ExtensionFuture(this.valueTransform((Function0<Object>)thunk$1)).transformCompat((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object value = ((Success)try_).value();
                return Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (try_ instanceof scala.util.Failure) {
                Throwable exception = ((scala.util.Failure)try_).exception();
                this.fireFailedHiddenTest(notifier$12, name$1, exception);
                return Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            throw new MatchError((Object)try_);
        }, this.ec);
    }

    public class BeforeAllResult {
        private final boolean isSuccess;
        private final List loadedFixtures;
        private final List errors;
        private final /* synthetic */ MUnitRunner $outer;

        public BeforeAllResult(MUnitRunner $outer, boolean isSuccess, List<AnyFixture<?>> loadedFixtures, List<Throwable> errors) {
            this.isSuccess = isSuccess;
            this.loadedFixtures = loadedFixtures;
            this.errors = errors;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public List<AnyFixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        public List<Throwable> errors() {
            return this.errors;
        }

        public final /* synthetic */ MUnitRunner munit$MUnitRunner$BeforeAllResult$$$outer() {
            return this.$outer;
        }
    }

    public class BeforeEachResult {
        private final Option error;
        private final List loadedFixtures;
        private final /* synthetic */ MUnitRunner $outer;

        public BeforeEachResult(MUnitRunner $outer, Option<Throwable> error, List<AnyFixture<?>> loadedFixtures) {
            this.error = error;
            this.loadedFixtures = loadedFixtures;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Option<Throwable> error() {
            return this.error;
        }

        public List<AnyFixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        public final /* synthetic */ MUnitRunner munit$MUnitRunner$BeforeEachResult$$$outer() {
            return this.$outer;
        }
    }
}

