/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import munit.Clues;
import munit.Location;
import munit.Printable;
import munit.diff.EmptyPrinter$;
import munit.diff.Printer;
import munit.diff.console.AnsiColors$;
import munit.internal.Compat$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Printers$
implements Serializable {
    public static final Printers$ MODULE$ = new Printers$();

    private Printers$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Printers$.class);
    }

    public void log(Object any, Printer printer, Location loc) {
        Predef$.MODULE$.println((Object)loc.toString());
        Predef$.MODULE$.println((Object)this.print(any, printer));
    }

    public Printer log$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    public String print(Object any, Printer printer) {
        IntRef height = IntRef.create((int)printer.height());
        StringBuilder out = new StringBuilder();
        int indentStep = 2;
        this.loop$1(height, out, indentStep, printer, any, 0);
        return AnsiColors$.MODULE$.filterAnsi(out.toString());
    }

    public Printer print$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    private <T> void printApply(String prefix, Iterator<T> it, StringBuilder out, int indent, int nextIndent, String open, String close, String comma, Function1<T, BoxedUnit> fn) {
        out.append(prefix);
        out.append(open);
        if (it.hasNext()) {
            this.printNewline(out, nextIndent);
            while (it.hasNext()) {
                Object value = it.next();
                fn.apply(value);
                if (it.hasNext()) {
                    out.append(comma);
                    this.printNewline(out, nextIndent);
                    continue;
                }
                this.printNewline(out, indent);
            }
        }
        out.append(close);
    }

    private <T> String printApply$default$6() {
        return "(";
    }

    private <T> String printApply$default$7() {
        return ")";
    }

    private <T> String printApply$default$8() {
        return ",";
    }

    private void printNewline(StringBuilder out, int indent) {
        out.append("\n");
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
    }

    public String escapeNonVisible(String string) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            StringBuilder stringBuilder;
            char ch = string.charAt(i);
            char c = ch;
            if ('\"' == c || '\'' == c) {
                stringBuilder = out.append(ch);
                continue;
            }
            munit.diff.console.Printers$.MODULE$.printChar(ch, out, false);
            stringBuilder = BoxedUnit.UNIT;
        }
        return out.toString();
    }

    private static final String $anonfun$1(Iterator elementNames$1) {
        if (elementNames$1.hasNext()) {
            return (String)elementNames$1.next();
        }
        return "";
    }

    private final void loop$1(IntRef height$1, StringBuilder out$1, int indentStep$1, Printer printer$1, Object a, int indent) {
        --height$1.elem;
        if (height$1.elem < 0) {
            out$1.append("...");
            return;
        }
        int nextIndent = indent + indentStep$1;
        boolean isDone = printer$1.print(a, out$1, indent);
        if (!isDone) {
            Object object = a;
            if (object == null) {
                out$1.append("null");
                return;
            }
            if (object instanceof Printable) {
                Printable x = (Printable)object;
                x.print(out$1, indent);
                return;
            }
            if (object instanceof Character) {
                StringBuilder stringBuilder;
                char x = BoxesRunTime.unboxToChar((Object)object);
                out$1.append('\'');
                if (x == '\'') {
                    stringBuilder = out$1.append("\\'");
                } else {
                    munit.diff.console.Printers$.MODULE$.printChar(x, out$1, munit.diff.console.Printers$.MODULE$.printChar$default$3());
                    stringBuilder = BoxedUnit.UNIT;
                }
                out$1.append('\'');
                return;
            }
            if (object instanceof Byte) {
                byte x = BoxesRunTime.unboxToByte((Object)object);
                out$1.append(BoxesRunTime.boxToByte((byte)x).toString());
                return;
            }
            if (object instanceof Short) {
                short x = BoxesRunTime.unboxToShort((Object)object);
                out$1.append(BoxesRunTime.boxToShort((short)x).toString());
                return;
            }
            if (object instanceof Integer) {
                int x = BoxesRunTime.unboxToInt((Object)object);
                out$1.append(BoxesRunTime.boxToInteger((int)x).toString());
                return;
            }
            if (object instanceof Long) {
                long x = BoxesRunTime.unboxToLong((Object)object);
                out$1.append(BoxesRunTime.boxToLong((long)x).toString());
                return;
            }
            if (object instanceof Float) {
                float x = BoxesRunTime.unboxToFloat((Object)object);
                out$1.append(BoxesRunTime.boxToFloat((float)x).toString());
                return;
            }
            if (object instanceof Double) {
                double x = BoxesRunTime.unboxToDouble((Object)object);
                out$1.append(BoxesRunTime.boxToDouble((double)x).toString());
                return;
            }
            if (object instanceof String) {
                String x = (String)object;
                munit.diff.console.Printers$.MODULE$.printString(x, out$1, printer$1);
                return;
            }
            if (object instanceof Clues) {
                Clues x = (Clues)object;
                this.printApply("Clues", (Iterator)x.values().iterator(), out$1, indent, nextIndent, " {", "}", "", (Function1)(JProcedure1 & Serializable)clue -> {
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(clue.source()))) {
                        out$1.append(clue.source());
                    }
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(clue.valueType()))) {
                        out$1.append(": ").append(clue.valueType());
                    }
                    out$1.append(" = ");
                    this.loop$1(height$1, out$1, indentStep$1, printer$1, clue.value(), nextIndent);
                });
                return;
            }
            if (None$.MODULE$.equals(object)) {
                out$1.append("None");
                return;
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            Object object2 = object;
            if (!(nil$ != null ? !nil$.equals(object2) : object2 != null)) {
                out$1.append("Nil");
                return;
            }
            if (object instanceof Map) {
                Map x = (Map)object;
                this.printApply(Compat$.MODULE$.collectionClassName((Iterable<?>)x), (Iterator)x.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        this.loop$1(height$1, out$1, indentStep$1, printer$1, key, nextIndent);
                        out$1.append(" -> ");
                        this.loop$1(height$1, out$1, indentStep$1, printer$1, value, nextIndent);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            if (object instanceof Iterable) {
                Iterable x = (Iterable)object;
                this.printApply(Compat$.MODULE$.collectionClassName(x), (Iterator)x.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)(JProcedure1 & Serializable)value -> this.loop$1(height$1, out$1, indentStep$1, printer$1, value, nextIndent));
                return;
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object x = object;
                Object object3 = Predef$.MODULE$.genericArrayOps(x);
                this.printApply("Array", (Iterator)ArrayOps$.MODULE$.iterator$extension(object3), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)(JProcedure1 & Serializable)value -> this.loop$1(height$1, out$1, indentStep$1, printer$1, value, nextIndent));
                return;
            }
            if (object instanceof Iterator) {
                Iterator it = (Iterator)object;
                if (it.isEmpty()) {
                    out$1.append("empty iterator");
                    return;
                }
                out$1.append("non-empty iterator");
                return;
            }
            if (object instanceof Product) {
                Product p = (Product)object;
                Iterator<String> elementNames = Compat$.MODULE$.productElementNames(p);
                Iterator infiniteElementNames = package$.MODULE$.Iterator().continually(() -> Printers$.$anonfun$1(elementNames));
                this.printApply(p.productPrefix(), (Iterator)p.productIterator().zip((IterableOnce)infiniteElementNames), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object value = tuple2._1();
                        String key = (String)tuple2._2();
                        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(key))) {
                            out$1.append(key).append(" = ");
                        }
                        this.loop$1(height$1, out$1, indentStep$1, printer$1, value, nextIndent);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            out$1.append(a.toString());
            return;
        }
    }
}

