/*
 * Decompiled with CFR 0.152.
 */
package munit.internal;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import munit.IgnoreSuite;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.Task;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class PlatformCompat$
implements Serializable {
    private static final ExecutionContext executionContext;
    private static final ScheduledExecutorService sh;
    public static final PlatformCompat$ MODULE$;

    private PlatformCompat$() {
    }

    static {
        MODULE$ = new PlatformCompat$();
        executionContext = ExecutionContext$.MODULE$.global();
        sh = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            public AtomicInteger counter() {
                return this.counter;
            }

            public int threadNumber() {
                return this.counter().incrementAndGet();
            }

            public Thread newThread(Runnable r) {
                return new Thread(r, this){
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        super(r$1, new StringBuilder(16).append("munit-scheduler-").append($outer.threadNumber()).toString());
                        this.setDaemon(true);
                        this.setPriority(5);
                    }
                };
            }
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlatformCompat$.class);
    }

    public ExecutionContext executionContext() {
        return executionContext;
    }

    public <T> T awaitResult(Awaitable<T> awaitable) {
        return (T)Await$.MODULE$.result(awaitable, (Duration)Duration$.MODULE$.Inf());
    }

    public Future<BoxedUnit> executeAsync(Task task, EventHandler eventHandler, Logger[] loggers) {
        task.execute(eventHandler, loggers);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public <T> Future<T> waitAtMost(Function0<Future<T>> startFuture, Duration duration, ExecutionContext ec) {
        if (!duration.isFinite()) {
            return (Future)startFuture.apply();
        }
        Promise onComplete = Promise$.MODULE$.apply();
        ScheduledFuture<Object> timeout = sh.schedule(() -> {
            onComplete.tryFailure((Throwable)new TimeoutException(new StringBuilder(21).append("test timed out after ").append(duration).toString()));
            return BoxedUnit.UNIT;
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        ec.execute(() -> {
            try {
                ((Future)startFuture.apply()).onComplete((Function1)(JProcedure1 & Serializable)result -> this.completeWith$1(onComplete, timeout, (Try)result), ec);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    this.completeWith$1(onComplete, timeout, (Try)Failure$.MODULE$.apply(ex));
                }
                throw throwable;
            }
        });
        return onComplete.future();
    }

    public Function0<BoxedUnit> setTimeout(int ms, Function0<BoxedUnit> body) {
        ScheduledFuture<Object> scheduled = sh.schedule(() -> {
            body.apply$mcV$sp();
            return BoxedUnit.UNIT;
        }, Int$.MODULE$.int2long(ms), TimeUnit.MILLISECONDS);
        return (JFunction0.mcV.sp & Serializable)() -> scheduled.cancel(false);
    }

    public boolean isIgnoreSuite(Class<?> cls) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getAnnotationsByType(IgnoreSuite.class));
        return ArrayOps$.MODULE$.nonEmpty$extension(object);
    }

    public final boolean isJVM() {
        return true;
    }

    public final boolean isJS() {
        return false;
    }

    public final boolean isNative() {
        return false;
    }

    public ClassLoader getThisClassLoader() {
        return this.getClass().getClassLoader();
    }

    private final void completeWith$1(Promise onComplete$2, ScheduledFuture timeout$1, Try result) {
        onComplete$2.tryComplete(result);
        timeout$1.cancel(false);
    }
}

