/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.AfterEach;
import munit.AnyFixture;
import munit.BeforeEach;
import munit.Exceptions$;
import munit.FailSuiteException;
import munit.Fixture;
import munit.FunSuite;
import munit.Location$;
import munit.MUnitRunner;
import munit.MUnitRunner$;
import munit.MUnitRunner$BeforeEachFailure$3$;
import munit.MUnitRunner$TestFailure$3$;
import munit.MUnitRunner$TestSuccess$3$;
import munit.Suite;
import munit.Tag;
import munit.Test;
import munit.TestValues;
import munit.TestValues$;
import munit.internal.PlatformCompat$;
import munit.internal.console.Printers$;
import munit.internal.console.StackTraces$;
import munit.internal.junitinterface.Configurable;
import munit.internal.junitinterface.Settings;
import munit.package$;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.RunNotifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

public class MUnitRunner
extends Runner
implements Filterable,
Configurable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MUnitRunner.class.getDeclaredField("munitFixtures$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MUnitRunner.class.getDeclaredField("munitTests$lzy1"));
    private final Class cls;
    public final Suite munit$MUnitRunner$$suite;
    private final ExecutionContext ec;
    private volatile Settings settings;
    private volatile boolean suiteAborted;
    private final Map<Test, Description> descriptions;
    private final Set<String> testNames;
    private volatile Object munitTests$lzy1;
    private Fixture<BoxedUnit> suiteFixtureBefore;
    private Fixture<BoxedUnit> suiteFixtureAfter;
    private volatile Object munitFixtures$lzy1;

    public MUnitRunner(Class<? extends Suite> cls, Suite suite) {
        this.cls = cls;
        this.munit$MUnitRunner$$suite = suite;
        this.ec = suite.munitExecutionContext();
        this.settings = Settings.defaults();
        this.suiteAborted = false;
        this.descriptions = (Map)Map$.MODULE$.empty();
        this.testNames = (Set)Set$.MODULE$.empty();
        this.suiteFixtureBefore = new Fixture<BoxedUnit>(this){
            private final /* synthetic */ MUnitRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.cls().getName());
            }

            public void apply() {
            }

            public void beforeAll() {
                this.$outer.munit$MUnitRunner$$suite.beforeAll();
            }

            public void beforeEach(BeforeEach context) {
                this.$outer.munit$MUnitRunner$$suite.beforeEach(context);
            }
        };
        this.suiteFixtureAfter = new Fixture<BoxedUnit>(this){
            private final /* synthetic */ MUnitRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.cls().getName());
            }

            public void apply() {
            }

            public void afterEach(AfterEach context) {
                this.$outer.munit$MUnitRunner$$suite.afterEach(context);
            }

            public void afterAll() {
                this.$outer.munit$MUnitRunner$$suite.afterAll();
            }
        };
    }

    public Class<? extends Suite> cls() {
        return this.cls;
    }

    public MUnitRunner(Class<? extends Suite> cls, Function0<Suite> newInstance) {
        this(cls, (Suite)newInstance.apply());
    }

    public MUnitRunner(Class<? extends Suite> cls) {
        this(MUnitRunner$.MODULE$.munit$MUnitRunner$$$ensureEligibleConstructor(cls), cls.newInstance());
    }

    private ArrayBuffer<Test> munitTests() {
        Object object = this.munitTests$lzy1;
        if (object instanceof ArrayBuffer) {
            return (ArrayBuffer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ArrayBuffer)this.munitTests$lzyINIT1();
    }

    private Object munitTests$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.munitTests$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ArrayBuffer arrayBuffer = null;
                    try {
                        arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(this.munit$MUnitRunner$$suite.munitTests());
                        object2 = arrayBuffer == null ? LazyVals.NullValue$.MODULE$ : arrayBuffer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.munitTests$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return arrayBuffer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private List<AnyFixture<?>> munitFixtures() {
        Object object = this.munitFixtures$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.munitFixtures$lzyINIT1();
    }

    private Object munitFixtures$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.munitFixtures$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        List list2 = this.munit$MUnitRunner$$suite.munitFixtures().toList();
                        list = scala.package$.MODULE$.Nil().$colon$colon(this.suiteFixtureAfter).$colon$colon$colon(list2).$colon$colon(this.suiteFixtureBefore);
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                        this.suiteFixtureAfter = null;
                        this.suiteFixtureBefore = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.munitFixtures$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.munitFixtures$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void filter(Filter filter) {
        ArrayBuffer newTests = (ArrayBuffer)this.munitTests().filter((Function1 & Serializable)t -> filter.shouldRun(this.createTestDescription((Test)t)));
        this.munitTests().clear();
        this.munitTests().$plus$plus$eq((IterableOnce)newTests);
    }

    public void configure(Settings settings) {
        this.settings = settings;
    }

    private Description createTestDescription(Test test) {
        return (Description)this.descriptions.getOrElseUpdate((Object)test, () -> this.createTestDescription$$anonfun$1(test));
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.cls());
        try {
            ArrayBuffer suiteTests = (ArrayBuffer)StackTraces$.MODULE$.dropOutside(this::$anonfun$4);
            suiteTests.iterator().map((Function1 & Serializable)test -> this.createTestDescription((Test)test)).foreach((Function1)(JProcedure1 & Serializable)x$0 -> description.addChild(x$0));
        }
        catch (Throwable ex) {
            this.trimStackTrace(ex);
            ex.printStackTrace();
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        PlatformCompat$.MODULE$.awaitResult(this.runAsync(notifier));
    }

    public Future<BoxedUnit> runAsync(RunNotifier notifier) {
        Description description = this.getDescription();
        if (PlatformCompat$.MODULE$.isIgnoreSuite(this.cls()) || this.munitTests().isEmpty()) {
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        notifier.fireTestSuiteStarted(description);
        return this.runBeforeAll(notifier).flatMap((Function1 & Serializable)beforeAll -> {
            Future body = !beforeAll.isSuccess() ? Future$.MODULE$.successful((Object)scala.package$.MODULE$.Nil()) : this.sequenceFutures(this.munitTests().iterator().map((Function1 & Serializable)_$1 -> this.runTest(notifier, (Test)_$1)));
            return body.transform((Function1 & Serializable)res -> {
                this.runAfterAll(notifier, (BeforeAllResult)beforeAll);
                res.failed().foreach((Function1)(JProcedure1 & Serializable)ex -> this.fireFailedHiddenTest(notifier, "unexpected error running tests", (Throwable)ex));
                notifier.fireTestSuiteFinished(description);
                return Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
            }, this.ec);
        }, this.ec);
    }

    private <A> Future<List<Try<A>>> sequenceFutures(Iterator<Future<A>> futures) {
        ListBuffer acc = ListBuffer$.MODULE$.empty();
        return this.loop$1(futures, acc);
    }

    private Future<BeforeAllResult> runBeforeAll(RunNotifier notifier) {
        Future result = this.sequenceFutures(this.munitFixtures().iterator().map((Function1 & Serializable)f -> this.runHiddenTest(notifier, new StringBuilder(11).append("beforeAll(").append(f.fixtureName()).append(")").toString(), (Function0<Object>)(Function0 & Serializable)() -> f.beforeAll()).map((Function1 & Serializable)isSuccess -> MUnitRunner.$anonfun$6$$anonfun$2(f, BoxesRunTime.unboxToBoolean((Object)isSuccess)), this.ec)));
        return result.map((Function1 & Serializable)results -> {
            Builder loadedFixtures = scala.package$.MODULE$.List().newBuilder();
            Builder errors = scala.package$.MODULE$.List().newBuilder();
            BooleanRef isSuccess = BooleanRef.create((boolean)true);
            results.foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Try try_ = x$1;
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    errors.$plus$eq((Object)ex);
                    isSuccess$1.elem = false;
                    return BoxedUnit.UNIT;
                }
                if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                    AnyFixture fixture = (AnyFixture)tuple2._1();
                    boolean success = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                    if (success) {
                        return loadedFixtures.$plus$eq((Object)fixture);
                    }
                    isSuccess$1.elem = false;
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)try_);
            });
            return new BeforeAllResult(this, isSuccess.elem, (List)loadedFixtures.result(), (List<Throwable>)((List)errors.result()));
        }, this.ec);
    }

    private Future<List<Try<Object>>> runAfterAll(RunNotifier notifier, BeforeAllResult beforeAll) {
        return this.sequenceFutures(beforeAll.loadedFixtures().iterator().map((Function1 & Serializable)f -> this.runHiddenTest(notifier, new StringBuilder(10).append("afterAll(").append(f.fixtureName()).append(")").toString(), (Function0<Object>)(Function0 & Serializable)() -> f.afterAll())));
    }

    private Future<BeforeAllResult> runBeforeEach(Test test) {
        BeforeEach context = new BeforeEach(test);
        return this.sequenceFutures(this.munitFixtures().iterator().map((Function1 & Serializable)f -> this.valueTransform((Function0<Object>)(Function0 & Serializable)() -> f.beforeEach(context)).map((Function1 & Serializable)_$2 -> f, this.ec))).map((Function1 & Serializable)results -> {
            Builder loadedFixtures = scala.package$.MODULE$.List().newBuilder();
            Builder errors = scala.package$.MODULE$.List().newBuilder();
            results.foreach((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    return (Builder)errors.$plus$eq((Object)ex);
                }
                if (try_ instanceof Success) {
                    AnyFixture fixture = (AnyFixture)((Success)try_).value();
                    return (Builder)loadedFixtures.$plus$eq((Object)fixture);
                }
                throw new MatchError((Object)try_);
            });
            List errorList = (List)errors.result();
            return new BeforeAllResult(this, errorList.isEmpty(), (List)loadedFixtures.result(), (List<Throwable>)errorList);
        }, this.ec);
    }

    private Future<List<Try<?>>> runAfterEach(Test test, List<AnyFixture<?>> fixtures) {
        AfterEach context = new AfterEach(test);
        return this.sequenceFutures(fixtures.iterator().map((Function1 & Serializable)f -> this.valueTransform((Function0<Object>)(Function0 & Serializable)() -> f.afterEach(context))));
    }

    private Future<Object> runTest(RunNotifier notifier, Test test) {
        Future future;
        Description description = this.createTestDescription(test);
        if (this.suiteAborted) {
            notifier.fireTestAssumptionFailed(new org.junit.runner.notification.Failure(description, (Throwable)((Object)new FailSuiteException("Suite has been aborted", test.location()))));
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (test.tags().apply((Object)package$.MODULE$.Ignore())) {
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        notifier.fireTestStarted(description);
        try {
            future = this.runTestBody(notifier, description, test).transformWith((Function1 & Serializable)res -> this.onResult$1(notifier, description, test, (Try)res), this.ec);
        }
        catch (Throwable ex) {
            future = this.onResult$1(notifier, description, test, (Try)Failure$.MODULE$.apply(ex));
        }
        return future;
    }

    private Future<Object> futureFromAny(Object any) {
        Object object = any;
        if (object instanceof Future) {
            Future f = (Future)object;
            return f;
        }
        return Future$.MODULE$.successful(any);
    }

    private Future<BoxedUnit> runTestBody(RunNotifier notifier, Description description, Test test) {
        return this.runBeforeEach(test).flatMap((Function1 & Serializable)beforeEach -> {
            public class Munit_MUnitRunner$BeforeEachFailure$1
            implements Munit_MUnitRunner$Outcome$1,
            Product,
            Serializable {
                private final List exceptions;
                private final /* synthetic */ MUnitRunner $outer;

                public Munit_MUnitRunner$BeforeEachFailure$1(MUnitRunner $outer, List exceptions) {
                    this.exceptions = exceptions;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int hashCode() {
                    return MurmurHash3$.MODULE$.productHash((Product)this, 1348179921, true);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$0) {
                    if (this == x$0) return true;
                    Object object = x$0;
                    if (!(object instanceof Munit_MUnitRunner$BeforeEachFailure$1)) return false;
                    Munit_MUnitRunner$BeforeEachFailure$1 var3_3 = (Munit_MUnitRunner$BeforeEachFailure$1)object;
                    List list = this.exceptions();
                    List list2 = var3_3.exceptions();
                    if (list == null) {
                        if (list2 != null) {
                            return false;
                        }
                    } else if (!list.equals(list2)) return false;
                    if (!var3_3.canEqual(this)) return false;
                    return true;
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                public boolean canEqual(Object that) {
                    return that instanceof Munit_MUnitRunner$BeforeEachFailure$1;
                }

                public int productArity() {
                    return 1;
                }

                public String productPrefix() {
                    return "BeforeEachFailure";
                }

                public Object productElement(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return this._1();
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public String productElementName(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return "exceptions";
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public List exceptions() {
                    return this.exceptions;
                }

                public Munit_MUnitRunner$BeforeEachFailure$1 copy(List exceptions) {
                    return new Munit_MUnitRunner$BeforeEachFailure$1(this.$outer, exceptions);
                }

                public List copy$default$1() {
                    return this.exceptions();
                }

                public List _1() {
                    return this.exceptions();
                }

                public final /* synthetic */ MUnitRunner munit$MUnitRunner$_$_$BeforeEachFailure$$$outer() {
                    return this.$outer;
                }
            }
            public class Munit_MUnitRunner$TestFailure$1
            implements Munit_MUnitRunner$Outcome$1,
            Product,
            Serializable {
                private final Throwable exception;
                private final /* synthetic */ MUnitRunner $outer;

                public Munit_MUnitRunner$TestFailure$1(MUnitRunner $outer, Throwable exception) {
                    this.exception = exception;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int hashCode() {
                    return MurmurHash3$.MODULE$.productHash((Product)this, 71633222, true);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$0) {
                    if (this == x$0) return true;
                    Object object = x$0;
                    if (!(object instanceof Munit_MUnitRunner$TestFailure$1)) return false;
                    Munit_MUnitRunner$TestFailure$1 var3_3 = (Munit_MUnitRunner$TestFailure$1)object;
                    Throwable throwable = this.exception();
                    Throwable throwable2 = var3_3.exception();
                    if (throwable == null) {
                        if (throwable2 != null) {
                            return false;
                        }
                    } else if (!throwable.equals(throwable2)) return false;
                    if (!var3_3.canEqual(this)) return false;
                    return true;
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                public boolean canEqual(Object that) {
                    return that instanceof Munit_MUnitRunner$TestFailure$1;
                }

                public int productArity() {
                    return 1;
                }

                public String productPrefix() {
                    return "TestFailure";
                }

                public Object productElement(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return this._1();
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public String productElementName(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return "exception";
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public Throwable exception() {
                    return this.exception;
                }

                public Munit_MUnitRunner$TestFailure$1 copy(Throwable exception) {
                    return new Munit_MUnitRunner$TestFailure$1(this.$outer, exception);
                }

                public Throwable copy$default$1() {
                    return this.exception();
                }

                public Throwable _1() {
                    return this.exception();
                }

                public final /* synthetic */ MUnitRunner munit$MUnitRunner$_$_$TestFailure$$$outer() {
                    return this.$outer;
                }
            }
            public class Munit_MUnitRunner$TestSuccess$1
            implements Munit_MUnitRunner$Outcome$1,
            Product,
            Serializable {
                private final Object testResult;
                private final /* synthetic */ MUnitRunner $outer;

                public Munit_MUnitRunner$TestSuccess$1(MUnitRunner $outer, Object testResult) {
                    this.testResult = testResult;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int hashCode() {
                    return MurmurHash3$.MODULE$.productHash((Product)this, 2146280331, true);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$0) {
                    if (this == x$0) return true;
                    Object object = x$0;
                    if (!(object instanceof Munit_MUnitRunner$TestSuccess$1)) return false;
                    Munit_MUnitRunner$TestSuccess$1 var3_3 = (Munit_MUnitRunner$TestSuccess$1)object;
                    if (!BoxesRunTime.equals((Object)this.testResult(), (Object)var3_3.testResult())) return false;
                    if (!var3_3.canEqual(this)) return false;
                    return true;
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                public boolean canEqual(Object that) {
                    return that instanceof Munit_MUnitRunner$TestSuccess$1;
                }

                public int productArity() {
                    return 1;
                }

                public String productPrefix() {
                    return "TestSuccess";
                }

                public Object productElement(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return this._1();
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public String productElementName(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return "testResult";
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public Object testResult() {
                    return this.testResult;
                }

                public Munit_MUnitRunner$TestSuccess$1 copy(Object testResult) {
                    return new Munit_MUnitRunner$TestSuccess$1(this.$outer, testResult);
                }

                public Object copy$default$1() {
                    return this.testResult();
                }

                public Object _1() {
                    return this.testResult();
                }

                public final /* synthetic */ MUnitRunner munit$MUnitRunner$_$_$TestSuccess$$$outer() {
                    return this.$outer;
                }
            }
            Future future;
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            LazyRef lazyRef3 = new LazyRef();
            List<Throwable> list = beforeEach.errors();
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List<Throwable> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                future = ((Future)StackTraces$.MODULE$.dropOutside(() -> MUnitRunner.runTestBody$$anonfun$1$$anonfun$1(test))).transform((Function1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        Object testResult = ((Success)try_).value();
                        return Success$.MODULE$.apply((Object)this.TestSuccess$2(lazyRef3).apply(testResult));
                    }
                    if (try_ instanceof Failure) {
                        Throwable testException = ((Failure)try_).exception();
                        return Success$.MODULE$.apply((Object)this.TestFailure$2(lazyRef2).apply(testException));
                    }
                    throw new MatchError((Object)try_);
                }, this.ec);
            } else {
                List<Throwable> errors = list;
                future = Future$.MODULE$.successful((Object)this.BeforeEachFailure$2(lazyRef).apply(errors));
            }
            return future.flatMap((Function1 & Serializable)outcome -> this.runAfterEach(test, beforeEach.loadedFixtures()).transform((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Failure) {
                    Throwable afterEachException = ((Failure)try_).exception();
                    return Success$.MODULE$.apply((Object)new .colon.colon((Object)afterEachException, (List)Nil$.MODULE$));
                }
                if (try_ instanceof Success) {
                    List afterEachExceptions = (List)((Success)try_).value();
                    return Success$.MODULE$.apply((Object)afterEachExceptions.collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Try x) {
                            Try try_ = x;
                            if (try_ instanceof Failure) {
                                Throwable e = ((Failure)try_).exception();
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(Try x, Function1 function1) {
                            Try try_ = x;
                            if (try_ instanceof Failure) {
                                Throwable e = ((Failure)try_).exception();
                                return e;
                            }
                            return function1.apply((Object)x);
                        }
                    }));
                }
                throw new MatchError((Object)try_);
            }, this.ec).flatMap((Function1 & Serializable)afterEachErrors -> {
                public static interface Munit_MUnitRunner$Outcome$1 {
                }
                Munit_MUnitRunner$Outcome$1 var6_6 = outcome;
                if (var6_6 instanceof Munit_MUnitRunner$BeforeEachFailure$1) {
                    List list;
                    Munit_MUnitRunner$BeforeEachFailure$1 var7_7 = this.BeforeEachFailure$2(lazyRef).unapply((Munit_MUnitRunner$BeforeEachFailure$1)var6_6);
                    List beforeEachErrors = list = var7_7._1();
                    return Future$.MODULE$.failed(MUnitRunner.addSuppressed$1((Throwable)beforeEachErrors.head(), (Seq)((IterableOps)beforeEachErrors.tail()).$plus$plus((IterableOnce)afterEachErrors)));
                }
                if (var6_6 instanceof Munit_MUnitRunner$TestFailure$1) {
                    Throwable throwable;
                    Munit_MUnitRunner$TestFailure$1 var10_10 = this.TestFailure$2(lazyRef2).unapply((Munit_MUnitRunner$TestFailure$1)var6_6);
                    Throwable testException = throwable = var10_10._1();
                    return Future$.MODULE$.failed(MUnitRunner.addSuppressed$1(testException, (Seq)afterEachErrors));
                }
                if (var6_6 instanceof Munit_MUnitRunner$TestSuccess$1) {
                    Object object;
                    Munit_MUnitRunner$TestSuccess$1 var13_13 = this.TestSuccess$2(lazyRef3).unapply((Munit_MUnitRunner$TestSuccess$1)var6_6);
                    Object testResult = object = var13_13._1();
                    if (afterEachErrors.isEmpty()) {
                        return Future$.MODULE$.successful(testResult);
                    }
                    return Future$.MODULE$.failed(MUnitRunner.addSuppressed$1(new TestTeardownException((Throwable)afterEachErrors.head()), (Seq)afterEachErrors.tail()));
                }
                throw new MatchError((Object)var6_6);
            }, this.ec), this.ec);
        }, this.ec).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof TestValues.FlakyFailure) {
                TestValues.FlakyFailure f = (TestValues.FlakyFailure)object;
                this.trimStackTrace((Throwable)((Object)f));
                notifier.fireTestAssumptionFailed(new org.junit.runner.notification.Failure(description, (Throwable)((Object)f)));
                return;
            }
            Tag tag = TestValues$.MODULE$.Ignore();
            Object object2 = object;
            if (!(tag != null ? !((Object)tag).equals(object2) : object2 != null)) {
                notifier.fireTestIgnored(description);
                return;
            }
            if (test.tags().apply((Object)package$.MODULE$.Pending())) {
                notifier.fireTestIgnored(description);
                return;
            }
        }, this.ec);
    }

    private Future<Object> runHiddenTest(RunNotifier notifier, String name, Function0<Object> thunk) {
        Future future;
        try {
            future = (Future)StackTraces$.MODULE$.dropOutside(() -> this.runHiddenTest$$anonfun$1(thunk, notifier, name));
        }
        catch (Throwable ex) {
            this.fireFailedHiddenTest(notifier, name, ex);
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return future;
    }

    private void fireFailedHiddenTest(RunNotifier notifier, String name, Throwable ex) {
        Test test = new Test(name, (Function0<Future<Object>>)(Function0 & Serializable)() -> {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }, (scala.collection.immutable.Set<Tag>)Predef$.MODULE$.Set().empty(), Location$.MODULE$.empty());
        Description description = this.createTestDescription(test);
        notifier.fireTestStarted(description);
        this.trimStackTrace(ex);
        notifier.fireTestFailure(new org.junit.runner.notification.Failure(description, Exceptions$.MODULE$.rootCause(ex)));
        notifier.fireTestFinished(description);
    }

    private void trimStackTrace(Throwable ex) {
        if (this.settings.trimStackTraces()) {
            StackTraces$.MODULE$.trimStackTrace(ex);
            return;
        }
    }

    private Future<Object> valueTransform(Function0<Object> thunk) {
        Suite suite = this.munit$MUnitRunner$$suite;
        if (suite instanceof FunSuite) {
            FunSuite funSuite = (FunSuite)suite;
            return funSuite.munitValueTransform((Function0)thunk);
        }
        return this.futureFromAny(thunk.apply());
    }

    private static final /* synthetic */ String $anonfun$2(String escapedName$1, int x$1) {
        int n = x$1;
        if (0 == n) {
            return escapedName$1;
        }
        int n2 = n;
        return new StringBuilder(1).append(escapedName$1).append("-").append(n2).toString();
    }

    private final Description createTestDescription$$anonfun$1(Test test$1) {
        String escapedName = Printers$.MODULE$.escapeNonVisible(test$1.name());
        String testName = (String)Option$.MODULE$.option2Iterable(scala.package$.MODULE$.Iterator().from(0).map((Function1 & Serializable)x$1 -> MUnitRunner.$anonfun$2(escapedName, BoxesRunTime.unboxToInt((Object)x$1))).find((Function1 & Serializable)candidate -> !this.testNames.contains(candidate))).head();
        this.testNames.$plus$eq((Object)testName);
        Description desc = Description.createTestDescription(this.cls(), (String)testName, (Annotation[])test$1.annotations());
        return desc;
    }

    private final ArrayBuffer $anonfun$4() {
        return this.munitTests();
    }

    private final Future loop$1(Iterator futures$1, ListBuffer acc$1) {
        Option option;
        Future future;
        while (true) {
            if (!futures$1.hasNext()) {
                return Future$.MODULE$.successful((Object)acc$1.toList());
            }
            future = (Future)futures$1.next();
            option = future.value();
            if (!(option instanceof Some)) break;
            Try t2 = (Try)((Some)option).value();
            acc$1.$plus$eq((Object)t2);
        }
        if (None$.MODULE$.equals(option)) {
            return future.transformWith((Function1 & Serializable)t -> {
                acc$1.$plus$eq(t);
                return this.loop$1(futures$1, acc$1);
            }, this.ec);
        }
        throw new MatchError((Object)option);
    }

    private static final /* synthetic */ Tuple2 $anonfun$6$$anonfun$2(AnyFixture f$2, boolean isSuccess) {
        AnyFixture anyFixture = (AnyFixture)Predef$.MODULE$.ArrowAssoc((Object)f$2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)anyFixture, (Object)BoxesRunTime.boxToBoolean((boolean)isSuccess));
    }

    private final void handleNonFatalOrStackOverflow$1(Description description$4, RunNotifier notifier$7, Throwable ex) {
        this.trimStackTrace(ex);
        Throwable cause = Exceptions$.MODULE$.rootCause(ex);
        org.junit.runner.notification.Failure failure = new org.junit.runner.notification.Failure(description$4, cause);
        Throwable throwable = cause;
        if (throwable instanceof AssumptionViolatedException) {
            notifier$7.fireTestAssumptionFailed(failure);
            return;
        }
        if (throwable instanceof FailSuiteException) {
            this.suiteAborted = true;
            notifier$7.fireTestFailure(failure);
            return;
        }
        notifier$7.fireTestFailure(failure);
    }

    private final void onError$1(RunNotifier notifier$8, Description description$5, Throwable ex) {
        Option option;
        Throwable throwable = ex;
        if (throwable instanceof AssumptionViolatedException) {
            AssumptionViolatedException ex2 = (AssumptionViolatedException)throwable;
            this.trimStackTrace((Throwable)ex2);
            notifier$8.fireTestAssumptionFailed(new org.junit.runner.notification.Failure(description$5, (Throwable)ex2));
            return;
        }
        if (throwable instanceof TestTeardownException) {
            TestTeardownException ex3 = (TestTeardownException)throwable;
            this.suiteAborted = true;
            this.trimStackTrace(ex3);
            notifier$8.fireTestFailure(new org.junit.runner.notification.Failure(description$5, (Throwable)ex3));
            return;
        }
        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
            Throwable throwable2;
            Throwable ex4 = throwable2 = (Throwable)option.get();
            this.handleNonFatalOrStackOverflow$1(description$5, notifier$8, ex4);
            return;
        }
        if (throwable instanceof StackOverflowError) {
            StackOverflowError ex5 = (StackOverflowError)throwable;
            this.handleNonFatalOrStackOverflow$1(description$5, notifier$8, ex5);
            return;
        }
        Throwable ex6 = throwable;
        this.suiteAborted = true;
        notifier$8.fireTestFailure(new org.junit.runner.notification.Failure(description$5, ex6));
    }

    private final Future onResult$1(RunNotifier notifier$9, Description description$6, Test test$2, Try res) {
        res.failed().foreach((Function1)(JProcedure1 & Serializable)ex -> this.onError$1(notifier$9, description$6, (Throwable)ex));
        notifier$9.fireTestFinished(description$6);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((!test$2.tags().apply((Object)package$.MODULE$.Pending()) ? 1 : 0) != 0));
    }

    private static final Throwable addSuppressed$1(Throwable firstError, Seq otherErrors) {
        otherErrors.foreach((Function1)(JProcedure1 & Serializable)err -> firstError.addSuppressed((Throwable)err));
        return firstError;
    }

    private final MUnitRunner$BeforeEachFailure$3$ BeforeEachFailure$lzyINIT1$1(LazyRef BeforeEachFailure$lzy1$1) {
        MUnitRunner$BeforeEachFailure$3$ mUnitRunner$BeforeEachFailure$3$;
        LazyRef lazyRef = BeforeEachFailure$lzy1$1;
        synchronized (lazyRef) {
            mUnitRunner$BeforeEachFailure$3$ = (MUnitRunner$BeforeEachFailure$3$)(BeforeEachFailure$lzy1$1.initialized() ? BeforeEachFailure$lzy1$1.value() : BeforeEachFailure$lzy1$1.initialize((Object)new MUnitRunner$BeforeEachFailure$3$(this)));
        }
        return mUnitRunner$BeforeEachFailure$3$;
    }

    private final MUnitRunner$BeforeEachFailure$3$ BeforeEachFailure$2(LazyRef BeforeEachFailure$lzy1$2) {
        return (MUnitRunner$BeforeEachFailure$3$)(BeforeEachFailure$lzy1$2.initialized() ? BeforeEachFailure$lzy1$2.value() : this.BeforeEachFailure$lzyINIT1$1(BeforeEachFailure$lzy1$2));
    }

    private final MUnitRunner$TestFailure$3$ TestFailure$lzyINIT1$1(LazyRef TestFailure$lzy1$1) {
        MUnitRunner$TestFailure$3$ mUnitRunner$TestFailure$3$;
        LazyRef lazyRef = TestFailure$lzy1$1;
        synchronized (lazyRef) {
            mUnitRunner$TestFailure$3$ = (MUnitRunner$TestFailure$3$)(TestFailure$lzy1$1.initialized() ? TestFailure$lzy1$1.value() : TestFailure$lzy1$1.initialize((Object)new MUnitRunner$TestFailure$3$(this)));
        }
        return mUnitRunner$TestFailure$3$;
    }

    private final MUnitRunner$TestFailure$3$ TestFailure$2(LazyRef TestFailure$lzy1$2) {
        return (MUnitRunner$TestFailure$3$)(TestFailure$lzy1$2.initialized() ? TestFailure$lzy1$2.value() : this.TestFailure$lzyINIT1$1(TestFailure$lzy1$2));
    }

    private final MUnitRunner$TestSuccess$3$ TestSuccess$lzyINIT1$1(LazyRef TestSuccess$lzy1$1) {
        MUnitRunner$TestSuccess$3$ mUnitRunner$TestSuccess$3$;
        LazyRef lazyRef = TestSuccess$lzy1$1;
        synchronized (lazyRef) {
            mUnitRunner$TestSuccess$3$ = (MUnitRunner$TestSuccess$3$)(TestSuccess$lzy1$1.initialized() ? TestSuccess$lzy1$1.value() : TestSuccess$lzy1$1.initialize((Object)new MUnitRunner$TestSuccess$3$(this)));
        }
        return mUnitRunner$TestSuccess$3$;
    }

    private final MUnitRunner$TestSuccess$3$ TestSuccess$2(LazyRef TestSuccess$lzy1$2) {
        return (MUnitRunner$TestSuccess$3$)(TestSuccess$lzy1$2.initialized() ? TestSuccess$lzy1$2.value() : this.TestSuccess$lzyINIT1$1(TestSuccess$lzy1$2));
    }

    private static final Future runTestBody$$anonfun$1$$anonfun$1(Test test$4) {
        return (Future)test$4.body().apply();
    }

    private final Future runHiddenTest$$anonfun$1(Function0 thunk$1, RunNotifier notifier$11, String name$1) {
        return this.valueTransform((Function0<Object>)thunk$1).transform((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.fireFailedHiddenTest(notifier$11, name$1, exception);
                return Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, this.ec);
    }

    public class BeforeAllResult {
        private final boolean isSuccess;
        private final List loadedFixtures;
        private final List errors;
        private final /* synthetic */ MUnitRunner $outer;

        public BeforeAllResult(MUnitRunner $outer, boolean isSuccess, List<AnyFixture<?>> loadedFixtures, List<Throwable> errors) {
            this.isSuccess = isSuccess;
            this.loadedFixtures = loadedFixtures;
            this.errors = errors;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public List<AnyFixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        public List<Throwable> errors() {
            return this.errors;
        }

        public final /* synthetic */ MUnitRunner munit$MUnitRunner$BeforeAllResult$$$outer() {
            return this.$outer;
        }
    }

    public static class TestTeardownException
    extends RuntimeException {
        public TestTeardownException(Throwable cause) {
            super("Teardown of test failed", cause);
        }
    }
}

