/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyField;
import com.google.protobuf.MessageLite;
import com.google.protobuf.SmallSortedMap;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<FieldDescriptorType extends FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField = false;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(other.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<FieldDescriptorType> clone() {
        FieldDescriptorLite descriptor;
        FieldSet clone = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            descriptor = (FieldDescriptorLite)entry.getKey();
            clone.setField(descriptor, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            descriptor = (FieldDescriptorLite)entry.getKey();
            clone.setField(descriptor, entry.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return clone;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<FieldDescriptorType, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap result2 = SmallSortedMap.newFieldMap(16);
            for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
                this.cloneFieldEntry(result2, this.fields.getArrayEntryAt(i));
            }
            for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
                this.cloneFieldEntry(result2, entry);
            }
            if (this.fields.isImmutable()) {
                result2.makeImmutable();
            }
            return result2;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private void cloneFieldEntry(Map<FieldDescriptorType, Object> map, Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite key2 = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (value2 instanceof LazyField) {
            map.put(key2, ((LazyField)value2).getValue());
        } else {
            map.put(key2, value2);
        }
    }

    public Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(FieldDescriptorType descriptor) {
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor) != null;
    }

    public Object getField(FieldDescriptorType descriptor) {
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return o;
    }

    public void setField(FieldDescriptorType descriptor, Object value2) {
        if (descriptor.isRepeated()) {
            if (!(value2 instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll(value2);
            for (Object element : newList) {
                FieldSet.verifyType(descriptor.getLiteType(), element);
            }
            value2 = newList;
        } else {
            FieldSet.verifyType(descriptor.getLiteType(), value2);
        }
        if (value2 instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor, (Object)value2);
    }

    public void clearField(FieldDescriptorType descriptor) {
        this.fields.remove(descriptor);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(FieldDescriptorType descriptor) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value2 = this.getField(descriptor);
        if (value2 == null) {
            return 0;
        }
        return ((List)value2).size();
    }

    public Object getRepeatedField(FieldDescriptorType descriptor, int index) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value2 = this.getField(descriptor);
        if (value2 == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)value2).get(index);
    }

    public void setRepeatedField(FieldDescriptorType descriptor, int index, Object value2) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object list = this.getField(descriptor);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        FieldSet.verifyType(descriptor.getLiteType(), value2);
        ((List)list).set(index, value2);
    }

    public void addRepeatedField(FieldDescriptorType descriptor, Object value2) {
        ArrayList<Object> list;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(descriptor.getLiteType(), value2);
        Object existingValue = this.getField(descriptor);
        if (existingValue == null) {
            list = new ArrayList<Object>();
            this.fields.put(descriptor, (Object)list);
        } else {
            list = (ArrayList<Object>)existingValue;
        }
        list.add(value2);
    }

    private static void verifyType(WireFormat.FieldType type2, Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        boolean isValid = false;
        switch (type2.getJavaType()) {
            case INT: {
                isValid = value2 instanceof Integer;
                break;
            }
            case LONG: {
                isValid = value2 instanceof Long;
                break;
            }
            case FLOAT: {
                isValid = value2 instanceof Float;
                break;
            }
            case DOUBLE: {
                isValid = value2 instanceof Double;
                break;
            }
            case BOOLEAN: {
                isValid = value2 instanceof Boolean;
                break;
            }
            case STRING: {
                isValid = value2 instanceof String;
                break;
            }
            case BYTE_STRING: {
                isValid = value2 instanceof ByteString || value2 instanceof byte[];
                break;
            }
            case ENUM: {
                isValid = value2 instanceof Integer || value2 instanceof Internal.EnumLite;
                break;
            }
            case MESSAGE: {
                boolean bl = isValid = value2 instanceof MessageLite || value2 instanceof LazyField;
            }
        }
        if (!isValid) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    public boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (this.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            if (this.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (descriptor.isRepeated()) {
                for (MessageLite element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
            } else {
                Object value2 = entry.getValue();
                if (value2 instanceof MessageLite) {
                    if (!((MessageLite)value2).isInitialized()) {
                        return false;
                    }
                } else {
                    if (value2 instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type2, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type2.getWireType();
    }

    public void mergeFrom(FieldSet<FieldDescriptorType> other) {
        for (int i = 0; i < other.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(other.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private Object cloneIfMutable(Object value2) {
        if (value2 instanceof byte[]) {
            byte[] bytes = (byte[])value2;
            byte[] copy = new byte[bytes.length];
            System.arraycopy(bytes, 0, copy, 0, bytes.length);
            return copy;
        }
        return value2;
    }

    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            otherValue = ((LazyField)otherValue).getValue();
        }
        if (descriptor.isRepeated()) {
            ArrayList value2 = this.getField(descriptor);
            if (value2 == null) {
                value2 = new ArrayList();
            }
            for (Object element : (List)otherValue) {
                ((List)value2).add(this.cloneIfMutable(element));
            }
            this.fields.put((FieldDescriptorType)descriptor, (Object)value2);
        } else if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object value3 = this.getField(descriptor);
            if (value3 == null) {
                this.fields.put((FieldDescriptorType)descriptor, this.cloneIfMutable(otherValue));
            } else {
                value3 = descriptor.internalMergeFrom(((MessageLite)value3).toBuilder(), (MessageLite)otherValue).build();
                this.fields.put((FieldDescriptorType)descriptor, value3);
            }
        } else {
            this.fields.put((FieldDescriptorType)descriptor, this.cloneIfMutable(otherValue));
        }
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type2, boolean checkUtf8) throws IOException {
        if (checkUtf8) {
            return WireFormat.readPrimitiveField(input, type2, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(input, type2, WireFormat.Utf8Validation.LOOSE);
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
    }

    public void writeMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i), output);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output);
        }
    }

    private void writeMessageSetTo(Map.Entry<FieldDescriptorType, Object> entry, CodedOutputStream output) throws IOException {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Object value2 = entry.getValue();
            if (value2 instanceof LazyField) {
                value2 = ((LazyField)value2).getValue();
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        } else {
            FieldSet.writeField(descriptor, entry.getValue(), output);
        }
    }

    static void writeElement(CodedOutputStream output, WireFormat.FieldType type2, int number2, Object value2) throws IOException {
        if (type2 == WireFormat.FieldType.GROUP) {
            output.writeGroup(number2, (MessageLite)value2);
        } else {
            output.writeTag(number2, FieldSet.getWireFormatForFieldType(type2, false));
            FieldSet.writeElementNoTag(output, type2, value2);
        }
    }

    static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type2, Object value2) throws IOException {
        switch (type2) {
            case DOUBLE: {
                output.writeDoubleNoTag((Double)value2);
                break;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value2).floatValue());
                break;
            }
            case INT64: {
                output.writeInt64NoTag((Long)value2);
                break;
            }
            case UINT64: {
                output.writeUInt64NoTag((Long)value2);
                break;
            }
            case INT32: {
                output.writeInt32NoTag((Integer)value2);
                break;
            }
            case FIXED64: {
                output.writeFixed64NoTag((Long)value2);
                break;
            }
            case FIXED32: {
                output.writeFixed32NoTag((Integer)value2);
                break;
            }
            case BOOL: {
                output.writeBoolNoTag((Boolean)value2);
                break;
            }
            case GROUP: {
                output.writeGroupNoTag((MessageLite)value2);
                break;
            }
            case MESSAGE: {
                output.writeMessageNoTag((MessageLite)value2);
                break;
            }
            case STRING: {
                if (value2 instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output.writeStringNoTag((String)value2);
                break;
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output.writeByteArrayNoTag((byte[])value2);
                break;
            }
            case UINT32: {
                output.writeUInt32NoTag((Integer)value2);
                break;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag((Integer)value2);
                break;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag((Long)value2);
                break;
            }
            case SINT32: {
                output.writeSInt32NoTag((Integer)value2);
                break;
            }
            case SINT64: {
                output.writeSInt64NoTag((Long)value2);
                break;
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value2).getNumber());
                    break;
                }
                output.writeEnumNoTag((Integer)value2);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> descriptor, Object value2, CodedOutputStream output) throws IOException {
        WireFormat.FieldType type2 = descriptor.getLiteType();
        int number2 = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value2;
            if (descriptor.isPacked()) {
                output.writeTag(number2, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                output.writeRawVarint32(dataSize);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output, type2, element);
                }
            } else {
                for (Object element : valueList) {
                    FieldSet.writeElement(output, type2, number2, element);
                }
            }
        } else if (value2 instanceof LazyField) {
            FieldSet.writeElement(output, type2, number2, ((LazyField)value2).getValue());
        } else {
            FieldSet.writeElement(output, type2, number2, value2);
        }
    }

    public int getSerializedSize() {
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return size;
    }

    public int getMessageSetSerializedSize() {
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            size += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            size += this.getMessageSetSerializedSize(entry);
        }
        return size;
    }

    private int getMessageSetSerializedSize(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            if (value2 instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value2);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        }
        return FieldSet.computeFieldSize(descriptor, value2);
    }

    static int computeElementSize(WireFormat.FieldType type2, int number2, Object value2) {
        int tagSize = CodedOutputStream.computeTagSize(number2);
        if (type2 == WireFormat.FieldType.GROUP) {
            tagSize *= 2;
        }
        return tagSize + FieldSet.computeElementSizeNoTag(type2, value2);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType type2, Object value2) {
        switch (type2) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value2);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value2).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value2);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value2);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value2);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value2);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value2);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value2);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value2);
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value2);
            }
            case STRING: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value2);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value2);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value2);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value2);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value2);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value2);
            }
            case MESSAGE: {
                if (value2 instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value2);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value2);
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value2).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value2);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value2) {
        WireFormat.FieldType type2 = descriptor.getLiteType();
        int number2 = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            if (descriptor.isPacked()) {
                int dataSize = 0;
                for (Object element : (List)value2) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number2) + CodedOutputStream.computeRawVarint32Size(dataSize);
            }
            int size = 0;
            for (Object element : (List)value2) {
                size += FieldSet.computeElementSize(type2, number2, element);
            }
            return size;
        }
        return FieldSet.computeElementSize(type2, number2, value2);
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

