/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.sbt;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import org.scalafmt.interfaces.ScalafmtSession;
import org.scalafmt.interfaces.ScalafmtSessionFactory;
import org.scalafmt.sbt.CompatibilityScalafmtSession;
import org.scalafmt.sbt.ScalafmtPlugin;
import org.scalafmt.sbt.ScalafmtPlugin$ScalafmtAnalysis$;
import org.scalafmt.sbt.ScalafmtPlugin$autoImport$;
import org.scalafmt.sbt.ScalafmtSbtReporter;
import sbt.AutoPlugin;
import sbt.BuildPaths$;
import sbt.ConfigKey$;
import sbt.Def$;
import sbt.InputTask$;
import sbt.Keys$;
import sbt.LocalRootProject$;
import sbt.PluginTrigger;
import sbt.Reference;
import sbt.ResolvedProject;
import sbt.Scope;
import sbt.ScopeFilter;
import sbt.ScopeFilter$;
import sbt.Scoped;
import sbt.Task;
import sbt.TaskKey;
import sbt.TaskKey$;
import sbt.ThisBuild$;
import sbt.internal.util.AList$;
import sbt.internal.util.Init;
import sbt.internal.util.LinePosition;
import sbt.internal.util.MessageOnlyException;
import sbt.internal.util.SourcePosition;
import sbt.io.FileFilter;
import sbt.io.RichFile$;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.MavenRepository;
import sbt.librarymanagement.Resolver;
import sbt.package$;
import sbt.std.FullInstance$;
import sbt.std.InitializeInstance$;
import sbt.std.ParserInstance$;
import sbt.std.TaskInstance$;
import sbt.std.TaskStreams;
import sbt.util.CacheImplicits$;
import sbt.util.CacheStoreFactory;
import sbt.util.ChangeReport;
import sbt.util.FileInfo;
import sbt.util.HashFileInfo;
import sbt.util.HashFileInfo$;
import sbt.util.Logger;
import sbt.util.SingletonCache$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ScalafmtPlugin$
extends AutoPlugin {
    public static ScalafmtPlugin$ MODULE$;
    private Init.Initialize<Task<Seq<File>>> sbtSources;
    private Init.Initialize<Task<Seq<File>>> metabuildSources;
    private Seq<Init.Setting<?>> scalafmtConfigSettings;
    private final TaskKey<BoxedUnit> scalafmtDoFormatOnCompile;
    private final Init.Initialize<Task<Path>> scalaConfig;
    private final Init.Initialize<Task<Path>> sbtConfig;
    private final Scalafmt globalInstance;
    private final ScopeFilter.Base<Scope> anyConfigsInThisProject;
    private volatile byte bitmap$0;

    static {
        new ScalafmtPlugin$();
    }

    public PluginTrigger trigger() {
        return this.allRequirements();
    }

    private TaskKey<BoxedUnit> scalafmtDoFormatOnCompile() {
        return this.scalafmtDoFormatOnCompile;
    }

    private Init.Initialize<Task<Path>> scalaConfig() {
        return this.scalaConfig;
    }

    private Init.Initialize<Task<Path>> sbtConfig() {
        return this.sbtConfig;
    }

    public Scalafmt globalInstance() {
        return this.globalInstance;
    }

    private <T> Seq<Option<T>> withFormattedSources(Seq<File> sources, Path config, Logger log, OutputStreamWriter writer, Seq<Resolver> resolvers, Function3<File, String, String, T> onFormat) {
        CompatibilityScalafmtSession compatibilityScalafmtSession;
        ScalafmtSbtReporter reporter = new ScalafmtSbtReporter(log, writer);
        Seq repositories = (Seq)resolvers.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Resolver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof MavenRepository) {
                    MavenRepository mavenRepository = (MavenRepository)A1;
                    object = mavenRepository.root();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Resolver x1) {
                Resolver resolver = x1;
                boolean bl = resolver instanceof MavenRepository;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Scalafmt scalafmt = this.globalInstance().withReporter((ScalafmtReporter)reporter).withMavenRepositories((String[])repositories.toArray(ClassTag$.MODULE$.apply(String.class))).withRespectProjectFilters(true);
        if (scalafmt instanceof ScalafmtSessionFactory) {
            Scalafmt scalafmt2 = scalafmt;
            ScalafmtSession session = ((ScalafmtSessionFactory)scalafmt2).createSession(config.toAbsolutePath());
            if (session == null) {
                throw new MessageOnlyException("failed to create formatting session. Please report bug to https://github.com/scalameta/sbt-scalafmt");
            }
            compatibilityScalafmtSession = session;
        } else {
            compatibilityScalafmtSession = new CompatibilityScalafmtSession(config.toAbsolutePath(), scalafmt);
        }
        CompatibilityScalafmtSession scalafmtSession = compatibilityScalafmtSession;
        log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Adding repositories ").append(repositories.mkString("[", ",", "]")).toString());
        return (Seq)sources.map((Function1 & Serializable & scala.Serializable)file -> {
            String input = package$.MODULE$.IO().read(file, package$.MODULE$.IO().read$default$2());
            String output = scalafmtSession.format(file.toPath().toAbsolutePath(), input);
            return new Some(onFormat.apply(file, (Object)input, (Object)output));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void formatSources(CacheStoreFactory cacheStoreFactory, Seq<File> sources, Path config, Logger log, OutputStreamWriter writer, Seq<Resolver> resolvers) {
        this.trackSourcesAndConfig(cacheStoreFactory, sources, config, (Function3<ChangeReport<File>, Object, ScalafmtPlugin.ScalafmtAnalysis, ScalafmtPlugin.ScalafmtAnalysis>)(Function3 & Serializable & scala.Serializable)(outDiff, configChanged, prev) -> ScalafmtPlugin$.$anonfun$formatSources$1(log, sources, config, writer, resolvers, outDiff, BoxesRunTime.unboxToBoolean((Object)configChanged), prev));
    }

    private void formatSources(Set<File> sources, Path config, Logger log, OutputStreamWriter writer, Seq<Resolver> resolvers) {
        block0: {
            int cnt = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.withFormattedSources((Seq<File>)sources.toSeq(), config, log, writer, resolvers, (Function3 & Serializable & scala.Serializable)(file, input, output) -> BoxesRunTime.boxToInteger((int)ScalafmtPlugin$.$anonfun$formatSources$4(file, input, output))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (cnt <= 1) break block0;
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Reformatted ").append(cnt).append(" Scala sources").toString());
        }
    }

    private ScalafmtPlugin.ScalafmtAnalysis checkSources(CacheStoreFactory cacheStoreFactory, Seq<File> sources, Path config, Logger log, OutputStreamWriter writer, Seq<Resolver> resolvers) {
        return this.trackSourcesAndConfig(cacheStoreFactory, sources, config, (Function3<ChangeReport<File>, Object, ScalafmtPlugin.ScalafmtAnalysis, ScalafmtPlugin.ScalafmtAnalysis>)(Function3 & Serializable & scala.Serializable)(outDiff, configChanged, prev) -> ScalafmtPlugin$.$anonfun$checkSources$1(log, sources, config, writer, resolvers, outDiff, BoxesRunTime.unboxToBoolean((Object)configChanged), prev));
    }

    private boolean trueOrBoom(ScalafmtPlugin.ScalafmtAnalysis analysis) {
        int failureCount = analysis.failedScalafmtCheck().size();
        if (failureCount > 0) {
            throw new MessageOnlyException(new StringBuilder(24).append(failureCount).append(" files must be formatted").toString());
        }
        return true;
    }

    private void warnBadFormat(File file, Logger log) {
        log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(file.toString()).append(" isn't formatted properly!").toString());
    }

    private ScalafmtPlugin.ScalafmtAnalysis checkSources(Seq<File> sources, Path config, Logger log, OutputStreamWriter writer, Seq<Resolver> resolvers) {
        if (sources.nonEmpty()) {
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking ").append(sources.size()).append(" Scala sources...").toString());
        }
        Set unformatted = ((TraversableOnce)this.withFormattedSources(sources, config, log, writer, resolvers, (Function3 & Serializable & scala.Serializable)(file, input, output) -> {
            None$ none$;
            boolean diff;
            String string = input;
            String string2 = output;
            boolean bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (diff = false);
            if (diff) {
                MODULE$.warnBadFormat((File)file, log);
                none$ = new Some(file);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toSet();
        return new ScalafmtPlugin.ScalafmtAnalysis((Set<File>)unformatted);
    }

    private ScalafmtPlugin.ScalafmtAnalysis trackSourcesAndConfig(CacheStoreFactory cacheStoreFactory, Seq<File> sources, Path config, Function3<ChangeReport<File>, Object, ScalafmtPlugin.ScalafmtAnalysis, ScalafmtPlugin.ScalafmtAnalysis> f) {
        Function1 prevTracker = package$.MODULE$.Tracked().lastOutput(cacheStoreFactory.make("last"), (Function2 & Serializable & scala.Serializable)(x$3, prev0) -> {
            ScalafmtPlugin.ScalafmtAnalysis prev = (ScalafmtPlugin.ScalafmtAnalysis)prev0.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ScalafmtPlugin.ScalafmtAnalysis((Set<File>)Predef$.MODULE$.Set().empty()));
            Function1 tracker = package$.MODULE$.Tracked().inputChanged(cacheStoreFactory.make("config"), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> ScalafmtPlugin$.$anonfun$trackSourcesAndConfig$3(cacheStoreFactory, sources, f, prev, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1), HashFileInfo$.MODULE$.format(), SingletonCache$.MODULE$.basicSingletonCache(HashFileInfo$.MODULE$.format()));
            return (ScalafmtPlugin.ScalafmtAnalysis)tracker.apply((Object)FileInfo.hash$.MODULE$.apply(config.toFile()));
        }, CacheImplicits$.MODULE$.isolistFormat(ScalafmtPlugin$ScalafmtAnalysis$.MODULE$.analysisIso()));
        return (ScalafmtPlugin.ScalafmtAnalysis)prevTracker.apply((Object)BoxedUnit.UNIT);
    }

    private Init.Initialize<Task<Seq<File>>> sbtSources$lzycompute() {
        ScalafmtPlugin$ scalafmtPlugin$ = this;
        synchronized (scalafmtPlugin$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sbtSources = (Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple2((Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.thisProject()), (Object)Def$.MODULE$.toITask((Init.Initialize)package$.MODULE$.sbtSlashSyntaxRichReference((Reference)LocalRootProject$.MODULE$).$div((Scoped.ScopingSetting)Keys$.MODULE$.baseDirectory()))), (Function1 & Serializable & scala.Serializable)$p$macro$3 -> {
                    File file;
                    ResolvedProject resolvedProject = (ResolvedProject)$p$macro$3._1();
                    File rootBase = file = (File)$p$macro$3._2();
                    File thisBase = resolvedProject.base();
                    Seq rootSbt = (Seq)BuildPaths$.MODULE$.configurationSources(thisBase).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isHidden()));
                    File file2 = rootBase;
                    File file3 = thisBase;
                    Nil$ metabuildSbt = !(file2 != null ? !((Object)file2).equals(file3) : file3 != null) ? package$.MODULE$.singleFileFinder(BuildPaths$.MODULE$.projectStandard(thisBase)).$times$times((FileFilter)package$.MODULE$.GlobFilter().apply("*.sbt")).get() : Nil$.MODULE$;
                    return (Seq)rootSbt.$plus$plus((GenTraversableOnce)metabuildSbt, Seq$.MODULE$.canBuildFrom());
                }, AList$.MODULE$.tuple2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sbtSources;
    }

    private Init.Initialize<Task<Seq<File>>> sbtSources() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sbtSources$lzycompute() : this.sbtSources;
    }

    private Init.Initialize<Task<Seq<File>>> metabuildSources$lzycompute() {
        ScalafmtPlugin$ scalafmtPlugin$ = this;
        synchronized (scalafmtPlugin$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metabuildSources = (Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple2((Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.thisProject()), (Object)Def$.MODULE$.toITask((Init.Initialize)package$.MODULE$.sbtSlashSyntaxRichReference((Reference)LocalRootProject$.MODULE$).$div((Scoped.ScopingSetting)Keys$.MODULE$.baseDirectory()))), (Function1 & Serializable & scala.Serializable)$p$macro$3 -> {
                    Nil$ nil$;
                    File file;
                    ResolvedProject resolvedProject = (ResolvedProject)$p$macro$3._1();
                    File rootBase = file = (File)$p$macro$3._2();
                    File thisBase = resolvedProject.base();
                    File file2 = rootBase;
                    File file3 = thisBase;
                    if (!(file2 != null ? !((Object)file2).equals(file3) : file3 != null)) {
                        File projectDirectory = BuildPaths$.MODULE$.projectStandard(thisBase);
                        String targetDirectory = BuildPaths$.MODULE$.outputDirectory(projectDirectory).getAbsolutePath();
                        nil$ = package$.MODULE$.singleFileFinder(projectDirectory).descendantsExcept((FileFilter)package$.MODULE$.globFilter("*.scala"), new FileFilter(targetDirectory){
                            private final String targetDirectory$1;

                            public FileFilter $bar$bar(FileFilter filter) {
                                return FileFilter.$bar$bar$((FileFilter)this, (FileFilter)filter);
                            }

                            public FileFilter $amp$amp(FileFilter filter) {
                                return FileFilter.$amp$amp$((FileFilter)this, (FileFilter)filter);
                            }

                            public FileFilter $minus$minus(FileFilter filter) {
                                return FileFilter.$minus$minus$((FileFilter)this, (FileFilter)filter);
                            }

                            public FileFilter unary_$minus() {
                                return FileFilter.unary_$minus$((FileFilter)this);
                            }

                            public final boolean accept(File x$1) {
                                return ScalafmtPlugin$.org$scalafmt$sbt$ScalafmtPlugin$$$anonfun$metabuildSources$2(x$1, this.targetDirectory$1);
                            }
                            {
                                this.targetDirectory$1 = targetDirectory$1;
                                FileFilter.$init$((FileFilter)this);
                            }
                        }).get();
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    return nil$;
                }, AList$.MODULE$.tuple2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metabuildSources;
    }

    private Init.Initialize<Task<Seq<File>>> metabuildSources() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metabuildSources$lzycompute() : this.metabuildSources;
    }

    private Init.Initialize<Task<BoxedUnit>> scalafmtTask() {
        return package$.MODULE$.richInitializeTask((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple6((Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.scalaConfig(), Keys$.MODULE$.unmanagedSources().in(ScalafmtPlugin$autoImport$.MODULE$.scalafmt()), (Object)Keys$.MODULE$.streams()), (Function1 & Serializable & scala.Serializable)$p$macro$7 -> {
            ScalafmtPlugin$.$anonfun$scalafmtTask$1($p$macro$7);
            return BoxedUnit.UNIT;
        }, AList$.MODULE$.tuple6())).tag(ScalafmtPlugin$autoImport$.MODULE$.ScalafmtTagPack());
    }

    private Init.Initialize<Task<BoxedUnit>> scalafmtSbtTask() {
        return package$.MODULE$.richInitializeTask((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple10((Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.scalaConfig(), this.metabuildSources(), (Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.sbtConfig(), this.sbtSources()), (Function1 & Serializable & scala.Serializable)$p$macro$11 -> {
            ScalafmtPlugin$.$anonfun$scalafmtSbtTask$1($p$macro$11);
            return BoxedUnit.UNIT;
        }, AList$.MODULE$.tuple10())).tag(ScalafmtPlugin$autoImport$.MODULE$.ScalafmtTagPack());
    }

    private Init.Initialize<Task<Object>> scalafmtCheckTask() {
        return package$.MODULE$.richInitializeTask((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple6((Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.scalaConfig(), Keys$.MODULE$.unmanagedSources().in(ScalafmtPlugin$autoImport$.MODULE$.scalafmt()), package$.MODULE$.sbtSlashSyntaxRichScopeFromScoped(ScalafmtPlugin$autoImport$.MODULE$.scalafmt()).$div((Scoped.ScopingSetting)Keys$.MODULE$.streams())), (Function1 & Serializable & scala.Serializable)$p$macro$7 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtPlugin$.$anonfun$scalafmtCheckTask$1($p$macro$7)), AList$.MODULE$.tuple6())).tag(ScalafmtPlugin$autoImport$.MODULE$.ScalafmtTagPack());
    }

    private Init.Initialize<Task<Object>> scalafmtSbtCheckTask() {
        return package$.MODULE$.richInitializeTask((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple10((Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.scalaConfig(), this.metabuildSources(), (Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.sbtConfig(), this.sbtSources()), (Function1 & Serializable & scala.Serializable)$p$macro$11 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtPlugin$.$anonfun$scalafmtSbtCheckTask$1($p$macro$11)), AList$.MODULE$.tuple10())).tag(ScalafmtPlugin$autoImport$.MODULE$.ScalafmtTagPack());
    }

    private Seq<Init.Setting<?>> scalafmtConfigSettings$lzycompute() {
        ScalafmtPlugin$ scalafmtPlugin$ = this;
        synchronized (scalafmtPlugin$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.scalafmtConfigSettings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Init.Setting[]{ScalafmtPlugin$autoImport$.MODULE$.scalafmt().set((Init.Initialize)FullInstance$.MODULE$.map(this.scalafmtTask(), (Function1 & Serializable & scala.Serializable)$q$macro$1 -> {
                    ScalafmtPlugin$.$anonfun$scalafmtConfigSettings$1($q$macro$1);
                    return BoxedUnit.UNIT;
                }), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 390)), ScalafmtPlugin$autoImport$.MODULE$.scalafmtIncremental().set((Init.Initialize)FullInstance$.MODULE$.map(ScalafmtPlugin$autoImport$.MODULE$.scalafmt(), (Function1 & Serializable & scala.Serializable)$q$macro$2 -> {
                    ScalafmtPlugin$.$anonfun$scalafmtConfigSettings$2($q$macro$2);
                    return BoxedUnit.UNIT;
                }), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 391)), ScalafmtPlugin$autoImport$.MODULE$.scalafmtSbt().set((Init.Initialize)FullInstance$.MODULE$.map(this.scalafmtSbtTask(), (Function1 & Serializable & scala.Serializable)$q$macro$3 -> {
                    ScalafmtPlugin$.$anonfun$scalafmtConfigSettings$3($q$macro$3);
                    return BoxedUnit.UNIT;
                }), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 392)), ScalafmtPlugin$autoImport$.MODULE$.scalafmtCheck().set((Init.Initialize)FullInstance$.MODULE$.map(this.scalafmtCheckTask(), (Function1 & Serializable & scala.Serializable)$q$macro$4 -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)$q$macro$4))), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 393)), ScalafmtPlugin$autoImport$.MODULE$.scalafmtSbtCheck().set((Init.Initialize)FullInstance$.MODULE$.map(this.scalafmtSbtCheckTask(), (Function1 & Serializable & scala.Serializable)$q$macro$5 -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)$q$macro$5))), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 394)), this.scalafmtDoFormatOnCompile().set((Init.Initialize)FullInstance$.MODULE$.map((Object)InitializeInstance$.MODULE$.flatten(InitializeInstance$.MODULE$.app((Object)new Tuple2((Object)Keys$.MODULE$.resolvedScoped(), ScalafmtPlugin$autoImport$.MODULE$.scalafmtOnCompile()), (Function1 & Serializable & scala.Serializable)$p$macro$8 -> {
                    Init.ScopedKey scopedKey = (Init.ScopedKey)$p$macro$8._1();
                    boolean bl = $p$macro$8._2$mcZ$sp();
                    return bl ? ScalafmtPlugin$autoImport$.MODULE$.scalafmt().in((Scope)scopedKey.scope()) : (Init.Initialize)FullInstance$.MODULE$.pure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
                }, AList$.MODULE$.tuple2())), (Function1 & Serializable & scala.Serializable)$q$macro$9 -> {
                    ScalafmtPlugin$.$anonfun$scalafmtConfigSettings$8($q$macro$9);
                    return BoxedUnit.UNIT;
                }), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 395)), ((Scoped.DefinableTask)Keys$.MODULE$.sources().in(ConfigKey$.MODULE$.configurationToKey(package$.MODULE$.Compile()))).set((Init.Initialize)FullInstance$.MODULE$.map((Object)package$.MODULE$.richInitializeTask((Init.Initialize)Keys$.MODULE$.sources().in(ConfigKey$.MODULE$.configurationToKey(package$.MODULE$.Compile()))).dependsOn((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Init.Initialize[]{this.scalafmtDoFormatOnCompile()})), (Function1 & Serializable & scala.Serializable)$q$macro$10 -> $q$macro$10), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 402)), ScalafmtPlugin$autoImport$.MODULE$.scalafmtOnly().set(InitializeInstance$.MODULE$.app((Object)new Tuple6((Object)Keys$.MODULE$.fullResolvers(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.streams(), this.scalaConfig(), (Object)Keys$.MODULE$.streams(), (Object)Keys$.MODULE$.baseDirectory()), (Function1 & Serializable & scala.Serializable)$p$macro$24 -> {
                    Task task = (Task)$p$macro$24._1();
                    Task task2 = (Task)$p$macro$24._2();
                    Task task3 = (Task)$p$macro$24._3();
                    Task task4 = (Task)$p$macro$24._4();
                    Task task5 = (Task)$p$macro$24._5();
                    File file = (File)$p$macro$24._6();
                    return InputTask$.MODULE$.make(ParserInstance$.MODULE$.map(Def$.MODULE$.toSParser(package$.MODULE$.complete().DefaultParsers().spaceDelimited("<files>")), (Function1 & Serializable & scala.Serializable)$q$macro$17 -> TaskInstance$.MODULE$.app((Object)new Tuple5((Object)task, (Object)task2, (Object)task3, (Object)task4, (Object)task5), (Function1 & Serializable & scala.Serializable)$p$macro$23 -> {
                        ScalafmtPlugin$.$anonfun$scalafmtConfigSettings$12($q$macro$17, file, $p$macro$23);
                        return BoxedUnit.UNIT;
                    }, AList$.MODULE$.tuple5())));
                }, AList$.MODULE$.tuple6()), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.scalafmtConfigSettings) ScalafmtPlugin.scala", 405))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scalafmtConfigSettings;
    }

    public Seq<Init.Setting<?>> scalafmtConfigSettings() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scalafmtConfigSettings$lzycompute() : this.scalafmtConfigSettings;
    }

    private OutputStreamWriter outputStreamWriter(TaskStreams<Init.ScopedKey<?>> streams) {
        return new OutputStreamWriter(streams.binary(streams.binary$default$1()));
    }

    private ScopeFilter.Base<Scope> anyConfigsInThisProject() {
        return this.anyConfigsInThisProject;
    }

    public Seq<Init.Setting<?>> projectSettings() {
        return (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Configuration[]{package$.MODULE$.Compile(), package$.MODULE$.Test()}))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> package$.MODULE$.inConfig(x$5, MODULE$.scalafmtConfigSettings()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Init.Setting[]{ScalafmtPlugin$autoImport$.MODULE$.scalafmtAll().set((Init.Initialize)FullInstance$.MODULE$.map((Object)package$.MODULE$.taskKeyAll(ScalafmtPlugin$autoImport$.MODULE$.scalafmt().$qmark()).all((Function0 & Serializable & scala.Serializable)() -> MODULE$.anyConfigsInThisProject()), (Function1 & Serializable & scala.Serializable)$q$macro$1 -> {
            ScalafmtPlugin$.$anonfun$projectSettings$3($q$macro$1);
            return BoxedUnit.UNIT;
        }), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.projectSettings) ScalafmtPlugin.scala", 436)), ScalafmtPlugin$autoImport$.MODULE$.scalafmtCheckAll().set((Init.Initialize)FullInstance$.MODULE$.map((Object)package$.MODULE$.taskKeyAll(ScalafmtPlugin$autoImport$.MODULE$.scalafmtCheck().$qmark()).all((Function0 & Serializable & scala.Serializable)() -> MODULE$.anyConfigsInThisProject()), (Function1 & Serializable & scala.Serializable)$q$macro$2 -> {
            ScalafmtPlugin$.$anonfun$projectSettings$5($q$macro$2);
            return BoxedUnit.UNIT;
        }), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.projectSettings) ScalafmtPlugin.scala", 437))})), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Init.Setting<?>> buildSettings() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Init.Setting[]{ScalafmtPlugin$autoImport$.MODULE$.scalafmtConfig().set((Init.Initialize)FullInstance$.MODULE$.map((Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.baseDirectory().in((Reference)ThisBuild$.MODULE$)), (Function1 & Serializable & scala.Serializable)$q$macro$1 -> RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile($q$macro$1), ".scalafmt.conf")), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.buildSettings) ScalafmtPlugin.scala", 441))}));
    }

    public Seq<Init.Setting<?>> globalSettings() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Init.Setting[]{ScalafmtPlugin$autoImport$.MODULE$.scalafmtOnCompile().set(InitializeInstance$.MODULE$.pure((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false), (SourcePosition)new LinePosition("(org.scalafmt.sbt.ScalafmtPlugin.globalSettings) ScalafmtPlugin.scala", 448))}));
    }

    public static final /* synthetic */ ScalafmtPlugin.ScalafmtAnalysis $anonfun$formatSources$1(Logger log$1, Seq sources$1, Path config$1, OutputStreamWriter writer$1, Seq resolvers$1, ChangeReport outDiff, boolean configChanged, ScalafmtPlugin.ScalafmtAnalysis prev) {
        Set filesToFormat;
        log$1.debug((Function0 & Serializable & scala.Serializable)() -> outDiff.toString());
        Set updatedOrAdded = (Set)outDiff.modified().$amp((GenSet)outDiff.checked());
        Set set = filesToFormat = configChanged ? sources$1.toSet() : (Set)updatedOrAdded.$bar(prev.failedScalafmtCheck());
        if (filesToFormat.nonEmpty()) {
            log$1.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Formatting ").append(filesToFormat.size()).append(" Scala sources...").toString());
            MODULE$.formatSources((Set<File>)filesToFormat, config$1, log$1, writer$1, (Seq<Resolver>)resolvers$1);
        }
        return new ScalafmtPlugin.ScalafmtAnalysis((Set<File>)Predef$.MODULE$.Set().empty());
    }

    public static final /* synthetic */ int $anonfun$formatSources$4(File file, String input, String output) {
        int n;
        String string = input;
        String string2 = output;
        if (string == null ? string2 != null : !string.equals(string2)) {
            package$.MODULE$.IO().write(file, output, package$.MODULE$.IO().write$default$3(), package$.MODULE$.IO().write$default$4());
            n = 1;
        } else {
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ ScalafmtPlugin.ScalafmtAnalysis $anonfun$checkSources$1(Logger log$2, Seq sources$2, Path config$2, OutputStreamWriter writer$2, Seq resolvers$2, ChangeReport outDiff, boolean configChanged, ScalafmtPlugin.ScalafmtAnalysis prev) {
        log$2.debug((Function0 & Serializable & scala.Serializable)() -> outDiff.toString());
        Set updatedOrAdded = (Set)outDiff.modified().$amp((GenSet)outDiff.checked());
        Set filesToCheck = configChanged ? sources$2.toSet() : updatedOrAdded;
        Set prevFailed = configChanged ? Predef$.MODULE$.Set().empty() : (Set)prev.failedScalafmtCheck().$amp((GenSet)outDiff.unmodified());
        prevFailed.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ScalafmtPlugin$.MODULE$.warnBadFormat(x$2, log$2);
            return BoxedUnit.UNIT;
        });
        ScalafmtPlugin.ScalafmtAnalysis result = MODULE$.checkSources((Seq<File>)filesToCheck.toSeq(), config$2, log$2, writer$2, (Seq<Resolver>)resolvers$2);
        return prev.copy((Set<File>)((Set)result.failedScalafmtCheck().$bar((GenSet)prevFailed)));
    }

    public static final /* synthetic */ ScalafmtPlugin.ScalafmtAnalysis $anonfun$trackSourcesAndConfig$3(CacheStoreFactory cacheStoreFactory$1, Seq sources$4, Function3 f$1, ScalafmtPlugin.ScalafmtAnalysis prev$1, boolean x0$1, HashFileInfo x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean configChanged = tuple2._1$mcZ$sp();
        ScalafmtPlugin.ScalafmtAnalysis scalafmtAnalysis = (ScalafmtPlugin.ScalafmtAnalysis)package$.MODULE$.Tracked().diffOutputs(cacheStoreFactory$1.make("output-diff"), (FileInfo.Style)FileInfo.lastModified$.MODULE$).apply(sources$4.toSet(), (Function1 & Serializable & scala.Serializable)outDiff -> (ScalafmtPlugin.ScalafmtAnalysis)f$1.apply(outDiff, (Object)BoxesRunTime.boxToBoolean((boolean)configChanged), (Object)prev$1));
        return scalafmtAnalysis;
    }

    public static final /* synthetic */ boolean org$scalafmt$sbt$ScalafmtPlugin$$$anonfun$metabuildSources$2(File pathname, String targetDirectory$1) {
        return pathname.getAbsolutePath().startsWith(targetDirectory$1);
    }

    public static final /* synthetic */ void $anonfun$scalafmtTask$1(Tuple6 $p$macro$7) {
        Seq seq = (Seq)$p$macro$7._1();
        TaskStreams taskStreams = (TaskStreams)$p$macro$7._2();
        TaskStreams taskStreams2 = (TaskStreams)$p$macro$7._3();
        Path path = (Path)$p$macro$7._4();
        Seq seq2 = (Seq)$p$macro$7._5();
        TaskStreams taskStreams3 = (TaskStreams)$p$macro$7._6();
        MODULE$.formatSources(taskStreams3.cacheStoreFactory(), (Seq<File>)seq2, path, (Logger)taskStreams2.log(), MODULE$.outputStreamWriter(taskStreams), (Seq<Resolver>)seq);
    }

    public static final /* synthetic */ void $anonfun$scalafmtSbtTask$1(Tuple10 $p$macro$11) {
        Seq seq = (Seq)$p$macro$11._1();
        TaskStreams taskStreams = (TaskStreams)$p$macro$11._2();
        TaskStreams taskStreams2 = (TaskStreams)$p$macro$11._3();
        Path path = (Path)$p$macro$11._4();
        Seq seq2 = (Seq)$p$macro$11._5();
        Seq seq3 = (Seq)$p$macro$11._6();
        TaskStreams taskStreams3 = (TaskStreams)$p$macro$11._7();
        TaskStreams taskStreams4 = (TaskStreams)$p$macro$11._8();
        Path path2 = (Path)$p$macro$11._9();
        Seq seq4 = (Seq)$p$macro$11._10();
        MODULE$.formatSources((Set<File>)seq4.toSet(), path2, (Logger)taskStreams4.log(), MODULE$.outputStreamWriter(taskStreams3), (Seq<Resolver>)seq3);
        MODULE$.formatSources((Set<File>)seq2.toSet(), path, (Logger)taskStreams2.log(), MODULE$.outputStreamWriter(taskStreams), (Seq<Resolver>)seq);
    }

    public static final /* synthetic */ boolean $anonfun$scalafmtCheckTask$1(Tuple6 $p$macro$7) {
        Seq seq = (Seq)$p$macro$7._1();
        TaskStreams taskStreams = (TaskStreams)$p$macro$7._2();
        TaskStreams taskStreams2 = (TaskStreams)$p$macro$7._3();
        Path path = (Path)$p$macro$7._4();
        Seq seq2 = (Seq)$p$macro$7._5();
        TaskStreams taskStreams3 = (TaskStreams)$p$macro$7._6();
        ScalafmtPlugin.ScalafmtAnalysis analysis = MODULE$.checkSources(taskStreams3.cacheStoreFactory(), (Seq<File>)seq2, path, (Logger)taskStreams2.log(), MODULE$.outputStreamWriter(taskStreams), (Seq<Resolver>)seq);
        return MODULE$.trueOrBoom(analysis);
    }

    public static final /* synthetic */ boolean $anonfun$scalafmtSbtCheckTask$1(Tuple10 $p$macro$11) {
        Seq seq = (Seq)$p$macro$11._1();
        TaskStreams taskStreams = (TaskStreams)$p$macro$11._2();
        TaskStreams taskStreams2 = (TaskStreams)$p$macro$11._3();
        Path path = (Path)$p$macro$11._4();
        Seq seq2 = (Seq)$p$macro$11._5();
        Seq seq3 = (Seq)$p$macro$11._6();
        TaskStreams taskStreams3 = (TaskStreams)$p$macro$11._7();
        TaskStreams taskStreams4 = (TaskStreams)$p$macro$11._8();
        Path path2 = (Path)$p$macro$11._9();
        Seq seq4 = (Seq)$p$macro$11._10();
        MODULE$.trueOrBoom(MODULE$.checkSources((Seq<File>)seq4, path2, (Logger)taskStreams4.log(), MODULE$.outputStreamWriter(taskStreams3), (Seq<Resolver>)seq3));
        return MODULE$.trueOrBoom(MODULE$.checkSources((Seq<File>)seq2, path, (Logger)taskStreams2.log(), MODULE$.outputStreamWriter(taskStreams), (Seq<Resolver>)seq));
    }

    public static final /* synthetic */ void $anonfun$scalafmtConfigSettings$1(BoxedUnit $q$macro$1) {
    }

    public static final /* synthetic */ void $anonfun$scalafmtConfigSettings$2(BoxedUnit $q$macro$2) {
    }

    public static final /* synthetic */ void $anonfun$scalafmtConfigSettings$3(BoxedUnit $q$macro$3) {
    }

    public static final /* synthetic */ void $anonfun$scalafmtConfigSettings$8(BoxedUnit $q$macro$9) {
    }

    public static final /* synthetic */ void $anonfun$scalafmtConfigSettings$12(Seq $q$macro$17$1, File $q$macro$11$1, Tuple5 $p$macro$23) {
        Seq seq = (Seq)$p$macro$23._1();
        TaskStreams taskStreams = (TaskStreams)$p$macro$23._2();
        TaskStreams taskStreams2 = (TaskStreams)$p$macro$23._3();
        Path path = (Path)$p$macro$23._4();
        TaskStreams taskStreams3 = (TaskStreams)$p$macro$23._5();
        Seq files = $q$macro$17$1;
        Seq absFiles = (Seq)files.flatMap((Function1 & Serializable & scala.Serializable)fileS -> {
            Iterable iterable;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.IO().resolve($q$macro$11$1, new File((String)fileS)));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                taskStreams3.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Error with ").append((String)fileS).append(" file: ").append(e).toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                File file = (File)success.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)file));
            } else {
                throw new MatchError((Object)try_);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        MODULE$.formatSources((Set<File>)absFiles.toSet(), path, (Logger)taskStreams2.log(), MODULE$.outputStreamWriter(taskStreams), (Seq<Resolver>)seq);
    }

    public static final /* synthetic */ void $anonfun$projectSettings$3(Seq $q$macro$1) {
    }

    public static final /* synthetic */ void $anonfun$projectSettings$5(Seq $q$macro$2) {
    }

    private ScalafmtPlugin$() {
        MODULE$ = this;
        this.scalafmtDoFormatOnCompile = TaskKey$.MODULE$.apply("scalafmtDoFormatOnCompile", "Format Scala source files if scalafmtOnCompile is on.", TaskKey$.MODULE$.apply$default$3(), (Manifest)ManifestFactory$.MODULE$.Unit());
        this.scalaConfig = package$.MODULE$.richInitializeTask(ScalafmtPlugin$autoImport$.MODULE$.scalafmtConfig()).map((Function1 & Serializable & scala.Serializable)f -> {
            if (!f.exists()) {
                throw new MessageOnlyException(new StringBuilder(17).append("File not exists: ").append(f.toPath()).toString());
            }
            return f.toPath();
        });
        this.sbtConfig = this.scalaConfig();
        this.globalInstance = Scalafmt.create((ClassLoader)this.getClass().getClassLoader());
        ScopeFilter.Base x$1 = package$.MODULE$.inAnyConfiguration();
        ScopeFilter.Base x$2 = ScopeFilter$.MODULE$.apply$default$1();
        ScopeFilter.Base x$3 = ScopeFilter$.MODULE$.apply$default$3();
        this.anyConfigsInThisProject = ScopeFilter$.MODULE$.apply(x$2, x$1, x$3);
    }
}

