/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.scalafmt.Error;
import org.scalafmt.cli.ChangedFiles$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.DiffFiles;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.GitFiles$;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.InputMethod$StdinCode$;
import org.scalafmt.cli.RecursiveSearch$;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.cli.TermDisplay$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.cli.WriteMode$Stdout$;
import org.scalafmt.sysops.AbsoluteFile;
import org.scalafmt.sysops.AbsoluteFile$;
import org.scalafmt.sysops.BatchPathFinder;
import org.scalafmt.sysops.GitOps;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005%4qAB\u0004\u0011\u0002\u0007\u0005a\u0002C\u0003\u0016\u0001\u0011\u0005a\u0003\u0003\u0004\u001b\u0001\u0019\u0005qa\u0007\u0005\u0006e\u0001!\tb\r\u0005\u0006\u0011\u0002!\t\"\u0013\u0005\u0007;\u0002\u0001K\u0011\u00020\u0003\u001dM\u001b\u0017\r\\1g[R\u0014VO\u001c8fe*\u0011\u0001\"C\u0001\u0004G2L'B\u0001\u0006\f\u0003!\u00198-\u00197bM6$(\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002/A\u0011\u0001\u0003G\u0005\u00033E\u0011A!\u00168ji\u0006\u0019!/\u001e8\u0015\u0007q\u0001S\u0005\u0005\u0002\u001e=5\tq!\u0003\u0002 \u000f\tAQ\t_5u\u0007>$W\rC\u0003\"\u0005\u0001\u0007!%A\u0004paRLwN\\:\u0011\u0005u\u0019\u0013B\u0001\u0013\b\u0005)\u0019E.[(qi&|gn\u001d\u0005\u0006M\t\u0001\raJ\u0001\u0013i\u0016\u0014X\u000eR5ta2\f\u00170T3tg\u0006<W\r\u0005\u0002)_9\u0011\u0011&\f\t\u0003UEi\u0011a\u000b\u0006\u0003Y5\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\n\u0012A\u00048foR+'/\u001c#jgBd\u0017-\u001f\u000b\u0005i]Bd\t\u0005\u0002\u001ek%\u0011ag\u0002\u0002\f)\u0016\u0014X\u000eR5ta2\f\u0017\u0010C\u0003\"\u0007\u0001\u0007!\u0005C\u0003:\u0007\u0001\u0007!(\u0001\u0007j]B,H/T3uQ>$7\u000fE\u0002<\u0001\u000es!\u0001\u0010 \u000f\u0005)j\u0014\"\u0001\n\n\u0005}\n\u0012a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u00131aU3r\u0015\ty\u0014\u0003\u0005\u0002\u001e\t&\u0011Qi\u0002\u0002\f\u0013:\u0004X\u000f^'fi\"|G\rC\u0003H\u0007\u0001\u0007q%A\u0002ng\u001e\fqbZ3u\u0013:\u0004X\u000f^'fi\"|Gm\u001d\u000b\u0004u)[\u0005\"B\u0011\u0005\u0001\u0004\u0011\u0003\"\u0002'\u0005\u0001\u0004i\u0015A\u00024jYR,'\u000f\u0005\u0003\u0011\u001dBS\u0016BA(\u0012\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002R16\t!K\u0003\u0002T)\u0006!a-\u001b7f\u0015\t)f+A\u0002oS>T\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z%\n!\u0001+\u0019;i!\t\u00012,\u0003\u0002]#\t9!i\\8mK\u0006t\u0017AF4fi\u001aKG.Z:Ge>l7\t\\5PaRLwN\\:\u0015\u0007}3w\rE\u0002<\u0001\u0002\u0004\"!\u00193\u000e\u0003\tT!aY\u0005\u0002\rML8o\u001c9t\u0013\t)'M\u0001\u0007BEN|G.\u001e;f\r&dW\rC\u0003\"\u000b\u0001\u0007!\u0005C\u0003i\u000b\u0001\u0007Q*A\u0005dC:4uN]7bi\u0002")
public interface ScalafmtRunner {
    public ExitCode run(CliOptions var1, String var2);

    public static /* synthetic */ TermDisplay newTermDisplay$(ScalafmtRunner $this, CliOptions options, Seq inputMethods, String msg) {
        return $this.newTermDisplay(options, (Seq<InputMethod>)inputMethods, msg);
    }

    default public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        TermDisplay termDisplay;
        block0: {
            termDisplay = new TermDisplay(new OutputStreamWriter(options.common().info()), options.nonInteractive() || TermDisplay$.MODULE$.defaultFallbackMode());
            WriteMode writeMode = options.writeMode();
            WriteMode$Stdout$ writeMode$Stdout$ = WriteMode$Stdout$.MODULE$;
            if (!(writeMode == null ? writeMode$Stdout$ != null : !writeMode.equals(writeMode$Stdout$)) || inputMethods.lengthCompare(5) <= 0) break block0;
            termDisplay.init();
            termDisplay.startTask(msg, AbsoluteFile$.MODULE$.jfile$extension(options.cwd()));
            termDisplay.taskLength(msg, inputMethods.length(), 0L);
        }
        return termDisplay;
    }

    public static /* synthetic */ Seq getInputMethods$(ScalafmtRunner $this, CliOptions options, Function1 filter) {
        return $this.getInputMethods(options, (Function1<Path, Object>)filter);
    }

    default public Seq<InputMethod> getInputMethods(CliOptions options, Function1<Path, Object> filter) {
        Seq seq;
        if (options.stdIn()) {
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InputMethod.StdinCode[]{InputMethod$StdinCode$.MODULE$.apply(options.assumeFilename(), options.common().in())}));
        } else {
            Seq<AbsoluteFile> projectFiles = this.getFilesFromCliOptions(options, filter);
            if (projectFiles.isEmpty() && options.mode().isEmpty()) {
                throw Error.NoMatchingFiles$.MODULE$;
            }
            options.common().debug().print(new StringBuilder(24).append("Files to be formatted:\n").append(projectFiles.mkString("\n")).append("\n").toString());
            seq = (Seq)projectFiles.map((Function1 & Serializable)file -> ScalafmtRunner.$anonfun$getInputMethods$1(((AbsoluteFile)file).path()));
        }
        return seq;
    }

    private Seq<AbsoluteFile> getFilesFromCliOptions(CliOptions options, Function1<Path, Object> canFormat) {
        BatchPathFinder.GitFiles gitFiles;
        GitOps gitOps = options.gitOps();
        FileFetchMode fileFetchMode = options.fileFetchMode();
        if (GitFiles$.MODULE$.equals(fileFetchMode)) {
            gitFiles = new BatchPathFinder.GitFiles(gitOps, canFormat);
        } else if (RecursiveSearch$.MODULE$.equals(fileFetchMode)) {
            gitFiles = new BatchPathFinder.DirFiles(options.cwd(), canFormat);
        } else if (fileFetchMode instanceof DiffFiles) {
            DiffFiles diffFiles = (DiffFiles)fileFetchMode;
            String branch = diffFiles.branch();
            gitFiles = new BatchPathFinder.GitBranchFiles(gitOps, branch, canFormat);
        } else if (ChangedFiles$.MODULE$.equals(fileFetchMode)) {
            gitFiles = new BatchPathFinder.GitDirtyFiles(gitOps, canFormat);
        } else {
            throw new MatchError((Object)fileFetchMode);
        }
        BatchPathFinder.GitFiles finder = gitFiles;
        Seq files = finder.findMatchingFiles(options.respectProjectFilters(), (Seq)options.customFilesOpt().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()));
        Regex excludeRegexp = options.excludeFilterRegexp();
        return (Seq)files.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ScalafmtRunner.$anonfun$getFilesFromCliOptions$2(excludeRegexp, ((AbsoluteFile)f).path())));
    }

    public static /* synthetic */ InputMethod.FileContents $anonfun$getInputMethods$1(Path file) {
        return new InputMethod.FileContents(file);
    }

    public static /* synthetic */ boolean $anonfun$getFilesFromCliOptions$2(Regex excludeRegexp$1, Path f) {
        return excludeRegexp$1.findFirstIn((CharSequence)AbsoluteFile$.MODULE$.toString$extension(f)).isEmpty();
    }

    public static void $init$(ScalafmtRunner $this) {
    }
}

