/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.dynamic;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import coursierapi.MavenRepository;
import coursierapi.Repository;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.scalafmt.dynamic.BuildInfo$;
import org.scalafmt.dynamic.ConsoleScalafmtReporter$;
import org.scalafmt.dynamic.ScalafmtDynamic$;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader$;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.dynamic.ScalafmtDynamicError$CannotDownload$;
import org.scalafmt.dynamic.ScalafmtReflect;
import org.scalafmt.dynamic.ScalafmtReflectConfig;
import org.scalafmt.dynamic.ScalafmtVersion;
import org.scalafmt.dynamic.ScalafmtVersion$;
import org.scalafmt.dynamic.exceptions.ReflectionException$;
import org.scalafmt.dynamic.utils.ReentrantCache;
import org.scalafmt.dynamic.utils.ReentrantCache$;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import org.scalafmt.interfaces.ScalafmtSession;
import org.scalafmt.interfaces.ScalafmtSessionFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\rud\u0001\u0002#F\u00052C\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005S\"AQ\u000e\u0001BK\u0002\u0013\u0005a\u000eC\u0005\u0002\u0004\u0001\u0011\t\u0012)A\u0005_\"Q\u0011Q\u0001\u0001\u0003\u0016\u0004%\t!a\u0002\t\u0015\u0005=\u0001A!E!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u001a!C\u0001\u0003\u000fA!\"a\u0005\u0001\u0005#\u0005\u000b\u0011BA\u0005\u0011)\t)\u0002\u0001BK\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003S\u0001!\u0011#Q\u0001\n\u0005e\u0001BCA\u0016\u0001\tU\r\u0011\"\u0001\u0002.!Q\u0011q\u001f\u0001\u0003\u0012\u0003\u0006I!a\f\t\u0015\u00055\u0006A!f\u0001\n\u0003\t9\u0001\u0003\u0006\u0002z\u0002\u0011\t\u0012)A\u0005\u0003\u0013A!\"!-\u0001\u0005+\u0007I\u0011AA~\u0011)\u0011\t\u0001\u0001B\tB\u0003%\u0011Q \u0005\b\u0003?\u0002A\u0011\u0001B\u0002\u0011\u001d\ty\u0006\u0001C\u0001\u0005+AqAa\u0006\u0001\t\u0003\u0012I\u0002C\u0004\u0003\"\u0001!\tEa\t\t\u000f\t\u001d\u0002\u0001\"\u0011\u0003*!9!Q\u0006\u0001\u0005B\t=\u0002b\u0002B\u001a\u0001\u0011\u0005#Q\u0007\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqA!\u0014\u0001\t\u0013\u0011y\u0005C\u0004\u0003X\u0001!\tA!\u0017\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!9!Q\u000e\u0001\u0005\n\t=\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003.\u0002!IAa,\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bf\u0001\u0011\u0005#Q\u001a\u0004\u0007\u0005/\u0004AA!7\t\u0015\tmgE!A!\u0002\u0013\ti\rC\u0004\u0002`\u0019\"\tA!8\t\u000f\t}b\u0005\"\u0011\u0003f\"9!1\u001e\u0014\u0005B\t5\b\"\u0003By\u0001\u0005\u0005I\u0011\u0001Bz\u0011%\u0019)\u0001AI\u0001\n\u0003\u00199\u0001C\u0005\u0004\u001e\u0001\t\n\u0011\"\u0001\u0004 !I11\u0005\u0001\u0012\u0002\u0013\u00051Q\u0005\u0005\n\u0007S\u0001\u0011\u0013!C\u0001\u0007KA\u0011ba\u000b\u0001#\u0003%\ta!\f\t\u0013\rE\u0002!%A\u0005\u0002\rM\u0002\"CB\u001c\u0001E\u0005I\u0011AB\u0013\u0011%\u0019I\u0004AI\u0001\n\u0003\u0019Y\u0004C\u0005\u0004@\u0001\t\t\u0011\"\u0011\u0004B!I1q\t\u0001\u0002\u0002\u0013\u00051\u0011\n\u0005\n\u0007#\u0002\u0011\u0011!C\u0001\u0007'B\u0011b!\u0017\u0001\u0003\u0003%\tea\u0017\t\u0013\r%\u0004!!A\u0005\u0002\r-\u0004\"CB8\u0001\u0005\u0005I\u0011IB9\u0011%\u0019\u0019\bAA\u0001\n\u0003\u001a)\bC\u0005\u0004x\u0001\t\t\u0011\"\u0011\u0004z\u001d9\u00111K#\t\u0002\u0005UcA\u0002#F\u0011\u0003\t9\u0006C\u0004\u0002`u\"\t!!\u0019\u0006\r\u0005\rT\bAA3\u000b\u0019\t\t(\u0010\u0003\u0002t!I\u0011QR\u001f\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003?l\u0014\u0011!CA\u0003CD\u0011\"a=>\u0003\u0003%I!!>\u0003\u001fM\u001b\u0017\r\\1g[R$\u0015P\\1nS\u000eT!AR$\u0002\u000f\u0011Lh.Y7jG*\u0011\u0001*S\u0001\tg\u000e\fG.\u00194ni*\t!*A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001\u001bV[f\f\u001a\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019y%M[3diB\u0011a+W\u0007\u0002/*\u0011\u0001lR\u0001\u000bS:$XM\u001d4bG\u0016\u001c\u0018B\u0001.X\u0005!\u00196-\u00197bM6$\bC\u0001,]\u0013\tivK\u0001\fTG\u0006d\u0017MZ7u'\u0016\u001c8/[8o\r\u0006\u001cGo\u001c:z!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u001d\u0001&o\u001c3vGR\u0004\"aX3\n\u0005\u0019\u0004'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003%\u0004\"A\u00166\n\u0005-<&\u0001E*dC2\fg-\u001c;SKB|'\u000f^3s\u0003%\u0011X\r]8si\u0016\u0014\b%\u0001\u0007sKB|7/\u001b;pe&,7/F\u0001p!\r\u0001\bp\u001f\b\u0003cZt!A];\u000e\u0003MT!\u0001^&\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0017BA<a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\t1K7\u000f\u001e\u0006\u0003o\u0002\u0004\"\u0001`@\u000e\u0003uT\u0011A`\u0001\fG>,(o]5fe\u0006\u0004\u0018.C\u0002\u0002\u0002u\u0014!BU3q_NLGo\u001c:z\u00035\u0011X\r]8tSR|'/[3tA\u0005q!/Z:qK\u000e$h+\u001a:tS>tWCAA\u0005!\ry\u00161B\u0005\u0004\u0003\u001b\u0001'a\u0002\"p_2,\u0017M\\\u0001\u0010e\u0016\u001c\b/Z2u-\u0016\u00148/[8oA\u0005)\"/Z:qK\u000e$X\t_2mk\u0012,g)\u001b7uKJ\u001c\u0018A\u0006:fgB,7\r^#yG2,H-\u001a$jYR,'o\u001d\u0011\u0002\u001d\u0011,g-Y;miZ+'o]5p]V\u0011\u0011\u0011\u0004\t\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005}\u0001C\u0001:a\u0013\r\t\t\u0003Y\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0002-A\beK\u001a\fW\u000f\u001c;WKJ\u001c\u0018n\u001c8!\u0003-1wN]7bi\u000e\u000b7\r[3\u0016\u0005\u0005=\u0002\u0003CA\u0019\u0003o\tY$a\u0011\u000e\u0005\u0005M\"bAA\u001b\u000b\u0006)Q\u000f^5mg&!\u0011\u0011HA\u001a\u00059\u0011V-\u001a8ue\u0006tGoQ1dQ\u0016\u0004B!!\u0010\u0002@5\tQ)C\u0002\u0002B\u0015\u0013qbU2bY\u00064W\u000e\u001e,feNLwN\u001c\t\u0006\u0003\u000b\u0002\u0015Q\u0015\b\u0004\u0003\u000fbd\u0002BA%\u0003#rA!a\u0013\u0002P9\u0019!/!\u0014\n\u0003)K!\u0001S%\n\u0005\u0019;\u0015aD*dC2\fg-\u001c;Es:\fW.[2\u0011\u0007\u0005uRh\u0005\u0003>\u00033\"\u0007cA0\u0002\\%\u0019\u0011Q\f1\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011Q\u000b\u0002\r\r>\u0014X.\u0019;SKN,H\u000e\u001e\t\ba\u0006\u001d\u00141NA\r\u0013\r\tIG\u001f\u0002\u0007\u000b&$\b.\u001a:\u0011\t\u0005u\u0012QN\u0005\u0004\u0003_*%\u0001F*dC2\fg-\u001c;Es:\fW.[2FeJ|'O\u0001\u0006G_Jl\u0017\r^#wC2,B!!\u001e\u0002|A9\u0001/a\u001a\u0002l\u0005]\u0004\u0003BA=\u0003wb\u0001\u0001B\u0004\u0002~\u0001\u0013\r!a \u0003\u0003Q\u000bB!!!\u0002\bB\u0019q,a!\n\u0007\u0005\u0015\u0005MA\u0004O_RD\u0017N\\4\u0011\u0007}\u000bI)C\u0002\u0002\f\u0002\u00141!\u00118z\u0003\u0015\t\u0007\u000f\u001d7z)I\t\t*a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u000bY+a,\u0011\u0007\u0005u\u0002\u0001C\u0003h\u0003\u0002\u0007\u0011\u000eC\u0003n\u0003\u0002\u0007q\u000eC\u0004\u0002\u0006\u0005\u0003\r!!\u0003\t\u000f\u0005E\u0011\t1\u0001\u0002\n!9\u0011QC!A\u0002\u0005e\u0001bBA\u0016\u0003\u0002\u0007\u0011q\u0014\t\t\u0003c\t9$a\u000f\u0002\"B)\u00111\u0015!\u0002&6\tQ\b\u0005\u0003\u0002>\u0005\u001d\u0016bAAU\u000b\ny1kY1mC\u001alGOU3gY\u0016\u001cG\u000fC\u0004\u0002.\u0006\u0003\r!!\u0003\u0002\u0019\r\f7\r[3D_:4\u0017nZ:\t\u000f\u0005E\u0016\t1\u0001\u00024\u0006a1m\u001c8gS\u001e\u001c8)Y2iKBA\u0011\u0011GA\u001c\u0003k\u000b)\r\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\t\u0019LG.\u001a\u0006\u0004\u0003\u007f\u000b\u0016a\u00018j_&!\u00111YA]\u0005\u0011\u0001\u0016\r\u001e5\u0011\u000b\u0005\r\u0006)a2\u0011\u000f}\u000bI-!4\u0002T&\u0019\u00111\u001a1\u0003\rQ+\b\u000f\\33!\u0011\ti$a4\n\u0007\u0005EWIA\u000bTG\u0006d\u0017MZ7u%\u00164G.Z2u\u0007>tg-[4\u0011\t\u0005U\u00171\\\u0007\u0003\u0003/TA!!7\u0002:\u0006I\u0011\r\u001e;sS\n,H/Z\u0005\u0005\u0003;\f9N\u0001\u0005GS2,G+[7f\u0003\u001d)h.\u00199qYf$B!a9\u0002pB)q,!:\u0002j&\u0019\u0011q\u001d1\u0003\r=\u0003H/[8o!Ey\u00161^5p\u0003\u0013\tI!!\u0007\u0002 \u0006%\u00111W\u0005\u0004\u0003[\u0004'A\u0002+va2,\u0007\bC\u0005\u0002r\n\u000b\t\u00111\u0001\u0002\u0012\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002\u001b\u0006aam\u001c:nCR\u001c\u0015m\u00195fA\u0005i1-Y2iK\u000e{gNZ5hg\u0002*\"!!@\u0011\u0011\u0005E\u0012qGA[\u0003\u007f\u0004R!!\u0012A\u0003\u000f\fQbY8oM&<7oQ1dQ\u0016\u0004CCEAI\u0005\u000b\u00119A!\u0003\u0003\f\t5!q\u0002B\t\u0005'AQaZ\tA\u0002%DQ!\\\tA\u0002=Dq!!\u0002\u0012\u0001\u0004\tI\u0001C\u0004\u0002\u0012E\u0001\r!!\u0003\t\u000f\u0005U\u0011\u00031\u0001\u0002\u001a!9\u00111F\tA\u0002\u0005=\u0002bBAW#\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003c\u000b\u0002\u0019AA\u007f)\t\t\t*A\u0003dY\u0016\f'\u000f\u0006\u0002\u0003\u001cA\u0019qL!\b\n\u0007\t}\u0001M\u0001\u0003V]&$\u0018\u0001D<ji\"\u0014V\r]8si\u0016\u0014H\u0003BAI\u0005KAQa\u001a\u000bA\u0002%\f\u0011d^5uQJ+7\u000f]3diB\u0013xN[3di\u001aKG\u000e^3sgR!\u0011\u0011\u0013B\u0016\u0011\u001d\t\t\"\u0006a\u0001\u0003\u0013\t!c^5uQJ+7\u000f]3diZ+'o]5p]R!\u0011\u0011\u0013B\u0019\u0011\u001d\t)A\u0006a\u0001\u0003\u0013\t!c^5uQ\u0012+g-Y;miZ+'o]5p]R!\u0011\u0011\u0013B\u001c\u0011\u001d\t)b\u0006a\u0001\u00033\t\u0011c^5uQ\u000e{gNZ5h\u0007\u0006\u001c\u0007.\u001b8h)\u0011\t\tJ!\u0010\t\u000f\u00055\u0006\u00041\u0001\u0002\n\u00051am\u001c:nCR$\u0002\"!\u0007\u0003D\t\u001d#\u0011\n\u0005\b\u0005\u000bJ\u0002\u0019AA[\u0003\u0019\u0019wN\u001c4jO\"9\u00111X\rA\u0002\u0005U\u0006b\u0002B&3\u0001\u0007\u0011\u0011D\u0001\u0005G>$W-A\u0006sKB|'\u000f^#se>\u0014HC\u0002B\u000e\u0005#\u0012\u0019\u0006C\u0004\u0002<j\u0001\r!!.\t\u000f\tU#\u00041\u0001\u0002l\u0005)QM\u001d:pe\u0006qam\u001c:nCR$U\r^1jY\u0016$G\u0003\u0003B.\u0005;\u0012\tGa\u0019\u0011\u0007\u0005\u0015s\bC\u0004\u0003`m\u0001\r!!.\u0002\u0015\r|gNZ5h!\u0006$\b\u000eC\u0004\u0002<n\u0001\r!!.\t\u000f\t-3\u00041\u0001\u0002\u001a\u0005i!/Z:pYZ,7i\u001c8gS\u001e$BA!\u001b\u0003lA9\u0001/a\u001a\u0002l\u00055\u0007b\u0002B09\u0001\u0007\u0011QW\u0001\u001ae\u0016\u001cx\u000e\u001c<f\u0007>tg-[4XSRD7kY1mC\u001alG\u000f\u0006\u0003\u0003r\tM\u0004#BA#\u0001\u00065\u0007b\u0002B0;\u0001\u0007\u0011QW\u0001\fa\u0006\u00148/Z\"p]\u001aLw\r\u0006\u0004\u0003r\te$1\u0010\u0005\b\u0005?r\u0002\u0019AA[\u0011\u001d\u0011iH\ba\u0001\u0003K\u000b!BZ7u%\u00164G.Z2u\u0003A\u0011Xm]8mm\u00164uN]7biR,'\u000f\u0006\u0004\u0002D\t\r%Q\u0011\u0005\b\u0005?z\u0002\u0019AA[\u0011\u001d\u00119i\ba\u0001\u0003w\tqA^3sg&|g.\u0001\tsKN|GN^3DY\u0006\u001c8\u000fU1uQR!!Q\u0012BQ)\u0011\t\u0019Ea$\t\u000f\tE\u0005\u00051\u0001\u0003\u0014\u0006yAm\\<oY>\fGmU;dG\u0016\u001c8\u000f\u0005\u0003\u0003\u0016\nme\u0002BA$\u0005/K1A!'F\u0003e\u00196-\u00197bM6$H)\u001f8b[&\u001cGi\\<oY>\fG-\u001a:\n\t\tu%q\u0014\u0002\u0010\t><h\u000e\\8bIN+8mY3tg*\u0019!\u0011T#\t\u000f\t}\u0003\u00051\u0001\u00026\u0006IAO]=G_Jl\u0017\r\u001e\u000b\t\u00057\u00129K!+\u0003,\"9\u00111X\u0011A\u0002\u0005U\u0006b\u0002B&C\u0001\u0007\u0011\u0011\u0004\u0005\b\u0005\u000b\n\u0003\u0019AAg\u00035I7/S4o_J,GMR5mKR1\u0011\u0011\u0002BY\u0005kCqAa-#\u0001\u0004\tI\"\u0001\u0005gS2,g.Y7f\u0011\u001d\u0011)E\ta\u0001\u0003\u001b\f1B]3bIZ+'o]5p]R!!1\u0018B_!\u0015\t)\u0005QA\u001e\u0011\u001d\u0011)e\ta\u0001\u0003k\u000bQc^5uQ6\u000bg/\u001a8SKB|7/\u001b;pe&,7\u000fF\u0002V\u0005\u0007Da!\u001c\u0013A\u0002\t\u0015\u0007#B0\u0003H\u0006e\u0011b\u0001BeA\nQAH]3qK\u0006$X\r\u001a \u0002\u001b\r\u0014X-\u0019;f'\u0016\u001c8/[8o)\u0011\u0011yM!6\u0011\u0007Y\u0013\t.C\u0002\u0003T^\u0013qbU2bY\u00064W\u000e^*fgNLwN\u001c\u0005\b\u0005\u000b*\u0003\u0019AA[\u0005%i\u0015pU3tg&|gn\u0005\u0003'\u001b\n=\u0017aA2gOR!!q\u001cBr!\r\u0011\tOJ\u0007\u0002\u0001!9!1\u001c\u0015A\u0002\u00055GCBA\r\u0005O\u0014I\u000fC\u0004\u0002<&\u0002\r!!.\t\u000f\t-\u0013\u00061\u0001\u0002\u001a\u0005)R.\u0019;dQ\u0016\u001c\bK]8kK\u000e$h)\u001b7uKJ\u001cH\u0003BA\u0005\u0005_Dq!a/+\u0001\u0004\t),\u0001\u0003d_BLHCEAI\u0005k\u00149P!?\u0003|\nu(q`B\u0001\u0007\u0007AqaZ\u0016\u0011\u0002\u0003\u0007\u0011\u000eC\u0004nWA\u0005\t\u0019A8\t\u0013\u0005\u00151\u0006%AA\u0002\u0005%\u0001\"CA\tWA\u0005\t\u0019AA\u0005\u0011%\t)b\u000bI\u0001\u0002\u0004\tI\u0002C\u0005\u0002,-\u0002\n\u00111\u0001\u00020!I\u0011QV\u0016\u0011\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003c[\u0003\u0013!a\u0001\u0003{\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\n)\u001a\u0011na\u0003,\u0005\r5\u0001\u0003BB\b\u00073i!a!\u0005\u000b\t\rM1QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u0006a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00077\u0019\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\")\u001aqna\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\u0005\u0016\u0005\u0003\u0013\u0019Y!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u00111q\u0006\u0016\u0005\u00033\u0019Y!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rU\"\u0006BA\u0018\u0007\u0017\tabY8qs\u0012\"WMZ1vYR$s'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\ru\"\u0006BA\u007f\u0007\u0017\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\"!\rq5QI\u0005\u0004\u0003Ky\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAB&!\ry6QJ\u0005\u0004\u0007\u001f\u0002'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAD\u0007+B\u0011ba\u00167\u0003\u0003\u0005\raa\u0013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019i\u0006\u0005\u0004\u0004`\r\u0015\u0014qQ\u0007\u0003\u0007CR1aa\u0019a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007O\u001a\tG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0005\u0007[B\u0011ba\u00169\u0003\u0003\u0005\r!a\"\u0002\u0011!\f7\u000f[\"pI\u0016$\"aa\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0011\u0002\r\u0015\fX/\u00197t)\u0011\tIaa\u001f\t\u0013\r]3(!AA\u0002\u0005\u001d\u0005")
public final class ScalafmtDynamic
implements Scalafmt,
ScalafmtSessionFactory,
Product,
scala.Serializable {
    private final ScalafmtReporter reporter;
    private final List<Repository> repositories;
    private final boolean respectVersion;
    private final boolean respectExcludeFilters;
    private final String defaultVersion;
    private final ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache;
    private final boolean cacheConfigs;
    private final ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache;

    public static Option<Tuple8<ScalafmtReporter, List<Repository>, Object, Object, String, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>>, Object, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>>> unapply(ScalafmtDynamic scalafmtDynamic) {
        return ScalafmtDynamic$.MODULE$.unapply(scalafmtDynamic);
    }

    public static ScalafmtDynamic apply(ScalafmtReporter scalafmtReporter, List<Repository> list, boolean bl, boolean bl2, String string, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache, boolean bl3, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache2) {
        return ScalafmtDynamic$.MODULE$.apply(scalafmtReporter, list, bl, bl2, string, reentrantCache, bl3, reentrantCache2);
    }

    public ScalafmtReporter reporter() {
        return this.reporter;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public boolean respectVersion() {
        return this.respectVersion;
    }

    public boolean respectExcludeFilters() {
        return this.respectExcludeFilters;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache() {
        return this.formatCache;
    }

    public boolean cacheConfigs() {
        return this.cacheConfigs;
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache() {
        return this.configsCache;
    }

    public void clear() {
        this.formatCache().clear().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ScalafmtDynamic.$anonfun$clear$2(x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
    }

    public ScalafmtDynamic withReporter(ScalafmtReporter reporter) {
        return this.copy(reporter, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public ScalafmtDynamic withRespectProjectFilters(boolean respectExcludeFilters) {
        boolean x$1 = respectExcludeFilters;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        String x$5 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withRespectVersion(boolean respectVersion) {
        boolean x$1 = respectVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withDefaultVersion(String defaultVersion) {
        String x$1 = defaultVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withConfigCaching(boolean cacheConfigs) {
        boolean x$1 = cacheConfigs;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        String x$6 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$7 = this.copy$default$6();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public String format(Path config, Path file, String code) {
        String string;
        Either<ScalafmtDynamicError, String> either = this.formatDetailed(config, file, code);
        if (either instanceof Right) {
            String codeFormatted;
            Right right = (Right)either;
            string = codeFormatted = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ScalafmtDynamicError error = (ScalafmtDynamicError)left.value();
            this.org$scalafmt$dynamic$ScalafmtDynamic$$reportError(file, error);
            if (error instanceof ScalafmtDynamicError.ConfigError) {
                throw error;
            }
            string = code;
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    public void org$scalafmt$dynamic$ScalafmtDynamic$$reportError(Path file, ScalafmtDynamicError error) {
        ScalafmtDynamicError scalafmtDynamicError = error;
        if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigMissingVersion) {
            ScalafmtDynamicError.ConfigMissingVersion configMissingVersion = (ScalafmtDynamicError.ConfigMissingVersion)scalafmtDynamicError;
            this.reporter().missingVersion(configMissingVersion.configPath(), this.defaultVersion());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigError) {
            ScalafmtDynamicError.ConfigError configError = (ScalafmtDynamicError.ConfigError)scalafmtDynamicError;
            Option option = Option$.MODULE$.apply((Object)configError.getCause());
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable cause = (Throwable)some.value();
                this.reporter().error(configError.configPath(), configError.getMessage(), cause);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.reporter().error(configError.configPath(), configError.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.UnknownError) {
            ScalafmtDynamicError.UnknownError unknownError = (ScalafmtDynamicError.UnknownError)scalafmtDynamicError;
            Throwable cause = unknownError.cause();
            this.reporter().error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafmtDynamicError);
        }
    }

    public Either<ScalafmtDynamicError, String> formatDetailed(Path configPath, Path file, String code) {
        return this.resolveConfig(configPath).flatMap((Function1 & Serializable & scala.Serializable)config -> this.org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(file, code, (ScalafmtReflectConfig)config).map((Function1 & Serializable & scala.Serializable)codeFormatted -> codeFormatted));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfig(Path configPath) {
        Left left;
        if (!Files.exists(configPath, new LinkOption[0])) {
            left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigDoesNotExist(configPath));
        } else if (this.cacheConfigs()) {
            FileTime currentTimestamp = Files.getLastModifiedTime(configPath, new LinkOption[0]);
            left = this.configsCache().getOrAddToCache(configPath, (Function1<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$1(currentTimestamp, x$4)), (Function0<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>)(Function0 & Serializable & scala.Serializable)() -> this.resolveConfigWithScalafmt(configPath).map((Function1 & Serializable & scala.Serializable)config -> {
                this.reporter().parsedConfig(configPath, config.version());
                return new Tuple2(config, (Object)currentTimestamp);
            })).map((Function1 & Serializable & scala.Serializable)x$7 -> (ScalafmtReflectConfig)x$7._1());
        } else {
            left = this.resolveConfigWithScalafmt(configPath);
        }
        return left;
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfigWithScalafmt(Path configPath) {
        return this.readVersion(configPath).flatMap((Function1 & Serializable & scala.Serializable)version -> this.resolveFormatter(configPath, (ScalafmtVersion)version).flatMap((Function1 & Serializable & scala.Serializable)fmtReflect -> this.parseConfig(configPath, (ScalafmtReflect)fmtReflect).map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> parseConfig(Path configPath, ScalafmtReflect fmtReflect) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fmtReflect.parseConfig(configPath)).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScalafmtDynamicError scalafmtDynamicError;
            Throwable throwable = x0$1;
            ScalafmtDynamicError scalafmtDynamicError2 = throwable instanceof ScalafmtDynamicError ? (scalafmtDynamicError = (ScalafmtDynamicError)throwable) : new ScalafmtDynamicError.UnknownError(throwable);
            return scalafmtDynamicError2;
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveFormatter(Path configPath, ScalafmtVersion version) {
        return this.formatCache().getOrAddToCache(version, this.formatCache().getOrAddToCache$default$2(), (Function0<Either<ScalafmtDynamicError, ScalafmtReflect>>)(Function0 & Serializable & scala.Serializable)() -> {
            OutputStreamWriter writer = this.reporter().downloadOutputStreamWriter();
            return new ScalafmtDynamicDownloader(writer, this.repositories(), ScalafmtDynamicDownloader$.MODULE$.$lessinit$greater$default$3()).download(version).left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ScalafmtDynamicError.CannotDownload cannotDownload;
                ScalafmtDynamicDownloader.DownloadFailure downloadFailure = x0$1;
                if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadResolutionError) {
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, version, ScalafmtDynamicError$CannotDownload$.MODULE$.$lessinit$greater$default$3());
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadUnknownError) {
                    ScalafmtDynamicDownloader.DownloadUnknownError downloadUnknownError = (ScalafmtDynamicDownloader.DownloadUnknownError)downloadFailure;
                    Throwable cause = downloadUnknownError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, version, cause);
                } else {
                    throw new MatchError((Object)downloadFailure);
                }
                return cannotDownload;
            }).flatMap((Function1 & Serializable & scala.Serializable)downloadSuccess -> this.resolveClassPath(configPath, (ScalafmtDynamicDownloader.DownloadSuccess)downloadSuccess));
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveClassPath(Path configPath, ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess) {
        ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess2 = downloadSuccess;
        if (downloadSuccess2 == null) {
            throw new MatchError((Object)downloadSuccess2);
        }
        ScalafmtVersion version = downloadSuccess2.version();
        Seq<URL> urls = downloadSuccess2.jarUrls();
        Tuple2 tuple2 = new Tuple2((Object)version, urls);
        Tuple2 tuple22 = tuple2;
        ScalafmtVersion version2 = (ScalafmtVersion)tuple22._1();
        Seq urls2 = (Seq)tuple22._2();
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader classloader = new URLClassLoader((URL[])urls2.toArray(ClassTag$.MODULE$.apply(URL.class)), null);
            return new ScalafmtReflect(classloader, version2, this.respectVersion());
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScalafmtDynamicError scalafmtDynamicError;
            Throwable throwable = x0$1;
            if (throwable instanceof ReflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)throwable;
                scalafmtDynamicError = new ScalafmtDynamicError.CorruptedClassPath(configPath, version2, (Seq<URL>)urls2, reflectiveOperationException);
            } else {
                scalafmtDynamicError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return scalafmtDynamicError;
        });
    }

    public Either<ScalafmtDynamicError, String> org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(Path file, String code, ScalafmtReflectConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            ScalafmtReflectConfig configWithDialect;
            String filename = ((Object)file).toString();
            ScalafmtReflectConfig scalafmtReflectConfig = configWithDialect = config.fmtReflect().version().$less(new ScalafmtVersion(2, 6, 3, ScalafmtVersion$.MODULE$.apply$default$4(), ScalafmtVersion$.MODULE$.apply$default$5())) && (filename.endsWith(".sbt") || filename.endsWith(".sc")) ? config.withSbtDialect() : config;
            if (this.isIgnoredFile(filename, configWithDialect)) {
                this.reporter().excluded(file);
                string = code;
            } else {
                string = configWithDialect.format(code, (Option<Path>)new Some((Object)file));
            }
            return string;
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScalafmtDynamicError.UnknownError unknownError;
            Throwable throwable = x0$1;
            Option<Throwable> option = ReflectionException$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                unknownError = new ScalafmtDynamicError.UnknownError(e);
            } else {
                unknownError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return unknownError;
        });
    }

    private boolean isIgnoredFile(String filename, ScalafmtReflectConfig config) {
        return this.respectExcludeFilters() && !config.isIncludedInProject(filename);
    }

    private Either<ScalafmtDynamicError, ScalafmtVersion> readVersion(Path config) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)config.toFile()).getString("version")).toEither().left().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            Throwable throwable = x0$1;
            if (throwable instanceof ConfigException.Parse) {
                ConfigException.Parse parse = (ConfigException.Parse)throwable;
                left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigParseError(config, parse.getMessage()));
            } else if (throwable instanceof ConfigException.Missing) {
                left = this.respectVersion() ? package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigMissingVersion(config)) : package$.MODULE$.Right().apply((Object)this.defaultVersion());
            } else {
                throw new MatchError((Object)throwable);
            }
            return left;
        }).flatMap((Function1 & Serializable & scala.Serializable)v -> ScalafmtVersion$.MODULE$.parse((String)v).toRight((Function0 & Serializable & scala.Serializable)() -> new ScalafmtDynamicError.ConfigInvalidVersion(config, (String)v)));
    }

    public Scalafmt withMavenRepositories(Seq<String> repositories) {
        List x$12 = ((TraversableOnce)repositories.map((Function1 & Serializable & scala.Serializable)x$1 -> MavenRepository.of((String)x$1), Seq$.MODULE$.canBuildFrom())).toList();
        ScalafmtReporter x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, (List<Repository>)x$12, x$3, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtSession createSession(Path config2) {
        return (ScalafmtSession)this.resolveConfig(config2).fold((Function1 & Serializable & scala.Serializable)error -> {
            this.org$scalafmt$dynamic$ScalafmtDynamic$$reportError(config2, (ScalafmtDynamicError)error);
            throw error;
        }, (Function1 & Serializable & scala.Serializable)config -> new MySession(this, (ScalafmtReflectConfig)config));
    }

    public ScalafmtDynamic copy(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        return new ScalafmtDynamic(reporter, repositories, respectVersion, respectExcludeFilters, defaultVersion, formatCache, cacheConfigs, configsCache);
    }

    public ScalafmtReporter copy$default$1() {
        return this.reporter();
    }

    public List<Repository> copy$default$2() {
        return this.repositories();
    }

    public boolean copy$default$3() {
        return this.respectVersion();
    }

    public boolean copy$default$4() {
        return this.respectExcludeFilters();
    }

    public String copy$default$5() {
        return this.defaultVersion();
    }

    public ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> copy$default$6() {
        return this.formatCache();
    }

    public boolean copy$default$7() {
        return this.cacheConfigs();
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> copy$default$8() {
        return this.configsCache();
    }

    public String productPrefix() {
        return "ScalafmtDynamic";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.reporter();
                break;
            }
            case 1: {
                object = this.repositories();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectVersion());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectExcludeFilters());
                break;
            }
            case 4: {
                object = this.defaultVersion();
                break;
            }
            case 5: {
                object = this.formatCache();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.cacheConfigs());
                break;
            }
            case 7: {
                object = this.configsCache();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalafmtDynamic;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reporter()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.repositories()));
        n = Statics.mix((int)n, (int)(this.respectVersion() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.respectExcludeFilters() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultVersion()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.formatCache()));
        n = Statics.mix((int)n, (int)(this.cacheConfigs() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.configsCache()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalafmtDynamic)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalafmtDynamic scalafmtDynamic = (ScalafmtDynamic)x$1;
        ScalafmtReporter scalafmtReporter = this.reporter();
        ScalafmtReporter scalafmtReporter2 = scalafmtDynamic.reporter();
        if (scalafmtReporter == null) {
            if (scalafmtReporter2 != null) {
                return false;
            }
        } else if (!scalafmtReporter.equals(scalafmtReporter2)) return false;
        List<Repository> list = this.repositories();
        List<Repository> list2 = scalafmtDynamic.repositories();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (this.respectVersion() != scalafmtDynamic.respectVersion()) return false;
        if (this.respectExcludeFilters() != scalafmtDynamic.respectExcludeFilters()) return false;
        String string = this.defaultVersion();
        String string2 = scalafmtDynamic.defaultVersion();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache = this.formatCache();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache2 = scalafmtDynamic.formatCache();
        if (reentrantCache == null) {
            if (reentrantCache2 != null) {
                return false;
            }
        } else if (!reentrantCache.equals(reentrantCache2)) return false;
        if (this.cacheConfigs() != scalafmtDynamic.cacheConfigs()) return false;
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache3 = this.configsCache();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache4 = scalafmtDynamic.configsCache();
        if (reentrantCache3 == null) {
            if (reentrantCache4 == null) return true;
            return false;
        } else {
            if (!reentrantCache3.equals(reentrantCache4)) return false;
            return true;
        }
    }

    public Scalafmt withMavenRepositories(String[] repositories) {
        return this.withMavenRepositories((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])repositories));
    }

    public static final /* synthetic */ void $anonfun$clear$3(ScalafmtReflect x$3) {
        x$3.classLoader().close();
    }

    public static final /* synthetic */ void $anonfun$clear$2(Either x$2) {
        x$2.right().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ScalafmtDynamic.$anonfun$clear$3(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$2(ScalafmtDynamicError x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$3(FileTime currentTimestamp$1, Tuple2 x$6) {
        return ((FileTime)x$6._2()).compareTo(currentTimestamp$1) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$1(FileTime currentTimestamp$1, Either x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.fold((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$2(x$5)), (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$3(currentTimestamp$1, x$6))));
    }

    public ScalafmtDynamic(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        this.reporter = reporter;
        this.repositories = repositories;
        this.respectVersion = respectVersion;
        this.respectExcludeFilters = respectExcludeFilters;
        this.defaultVersion = defaultVersion;
        this.formatCache = formatCache;
        this.cacheConfigs = cacheConfigs;
        this.configsCache = configsCache;
        Product.$init$((Product)this);
    }

    public ScalafmtDynamic() {
        this(ConsoleScalafmtReporter$.MODULE$, (List<Repository>)Nil$.MODULE$, true, true, BuildInfo$.MODULE$.stable(), ReentrantCache$.MODULE$.apply(), true, ReentrantCache$.MODULE$.apply());
    }

    public class MySession
    implements ScalafmtSession {
        private final ScalafmtReflectConfig cfg;
        public final /* synthetic */ ScalafmtDynamic $outer;

        public String format(Path file, String code) {
            return (String)this.org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer().org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(file, code, this.cfg).fold((Function1 & Serializable & scala.Serializable)error -> {
                this.org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer().org$scalafmt$dynamic$ScalafmtDynamic$$reportError(file, (ScalafmtDynamicError)error);
                return code;
            }, (Function1 & Serializable & scala.Serializable)formatted -> formatted);
        }

        public boolean matchesProjectFilters(Path file) {
            return this.cfg.isIncludedInProject(((Object)file).toString());
        }

        public /* synthetic */ ScalafmtDynamic org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer() {
            return this.$outer;
        }

        public MySession(ScalafmtDynamic $outer, ScalafmtReflectConfig cfg) {
            this.cfg = cfg;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

