/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.dynamic;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import coursierapi.MavenRepository;
import coursierapi.Repository;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.scalafmt.dynamic.BuildInfo$;
import org.scalafmt.dynamic.ConsoleScalafmtReporter$;
import org.scalafmt.dynamic.ScalafmtDynamic$;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader$;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.dynamic.ScalafmtDynamicError$CannotDownload$;
import org.scalafmt.dynamic.ScalafmtReflect;
import org.scalafmt.dynamic.ScalafmtReflectConfig;
import org.scalafmt.dynamic.ScalafmtVersion;
import org.scalafmt.dynamic.ScalafmtVersion$;
import org.scalafmt.dynamic.exceptions.ReflectionException$;
import org.scalafmt.dynamic.utils.ReentrantCache;
import org.scalafmt.dynamic.utils.ReentrantCache$;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import org.scalafmt.interfaces.ScalafmtSession;
import org.scalafmt.interfaces.ScalafmtSessionFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r=e\u0001B#G\u00056C\u0001\"\u001d\u0001\u0003\u0016\u0004%\tA\u001d\u0005\tm\u0002\u0011\t\u0012)A\u0005g\"Aq\u000f\u0001BK\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0012)A\u0005s\"Q\u0011q\u0001\u0001\u0003\u0016\u0004%\t!!\u0003\t\u0015\u0005E\u0001A!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014\u0001\u0011)\u001a!C\u0001\u0003\u0013A!\"!\u0006\u0001\u0005#\u0005\u000b\u0011BA\u0006\u0011)\t9\u0002\u0001BK\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003W\u0001!\u0011#Q\u0001\n\u0005m\u0001BCA\u0017\u0001\tU\r\u0011\"\u0001\u00020!Q!1\u0001\u0001\u0003\u0012\u0003\u0006I!!\r\t\u0015\u0005e\u0006A!f\u0001\n\u0003\tI\u0001\u0003\u0006\u0003\u0006\u0001\u0011\t\u0012)A\u0005\u0003\u0017A!\"!0\u0001\u0005+\u0007I\u0011\u0001B\u0004\u0011)\u0011i\u0001\u0001B\tB\u0003%!\u0011\u0002\u0005\b\u0003W\u0002A\u0011\u0001B\b\u0011\u001d\tY\u0007\u0001C\u0001\u0005CAqAa\t\u0001\t\u0003\u0012)\u0003C\u0004\u0003.\u0001!\tEa\f\t\u000f\tM\u0002\u0001\"\u0011\u00036!9!\u0011\b\u0001\u0005B\tm\u0002b\u0002B \u0001\u0011\u0005#\u0011\t\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001bBqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003d\u0001!\tA!\u001a\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0011\u001d\u0011)\n\u0001C\u0005\u0005/CqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003:\u0002!IAa/\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!1\u001a\u0001\u0005B\t5\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0004\u0007\u0005G\u0004AA!:\t\u0015\t\u001dhE!A!\u0002\u0013\tI\u000eC\u0004\u0002l\u0019\"\tA!;\t\u000f\t-c\u0005\"\u0011\u0003r\"9!q\u001f\u0014\u0005B\te\b\"\u0003B\u007f\u0001\u0005\u0005I\u0011\u0001B\u0000\u0011%\u0019\t\u0002AI\u0001\n\u0003\u0019\u0019\u0002C\u0005\u0004*\u0001\t\n\u0011\"\u0001\u0004,!I1q\u0006\u0001\u0012\u0002\u0013\u00051\u0011\u0007\u0005\n\u0007k\u0001\u0011\u0013!C\u0001\u0007cA\u0011ba\u000e\u0001#\u0003%\ta!\u000f\t\u0013\ru\u0002!%A\u0005\u0002\r}\u0002\"CB\"\u0001E\u0005I\u0011AB\u0019\u0011%\u0019)\u0005AI\u0001\n\u0003\u00199\u0005C\u0005\u0004L\u0001\t\t\u0011\"\u0011\u0004N!I11\u000b\u0001\u0002\u0002\u0013\u00051Q\u000b\u0005\n\u0007;\u0002\u0011\u0011!C\u0001\u0007?B\u0011b!\u001a\u0001\u0003\u0003%\tea\u001a\t\u0013\rU\u0004!!A\u0005\u0002\r]\u0004\"CB>\u0001\u0005\u0005I\u0011IB?\u0011%\u0019\t\tAA\u0001\n\u0003\u001a\u0019\tC\u0005\u0004\u0006\u0002\t\t\u0011\"\u0011\u0004\b\"I1\u0011\u0012\u0001\u0002\u0002\u0013\u000531R\u0004\b\u0003+2\u0005\u0012AA,\r\u0019)e\t#\u0001\u0002Z!9\u00111\u000e \u0005\u0002\u00055TABA8}\u0001\t\t(\u0002\u0004\u0002~y\"\u0011q\u0010\u0005\n\u00033s\u0014\u0011!CA\u00037C\u0011\"a;?\u0003\u0003%\t)!<\t\u0013\u0005}h(!A\u0005\n\t\u0005!aD*dC2\fg-\u001c;Es:\fW.[2\u000b\u0005\u001dC\u0015a\u00023z]\u0006l\u0017n\u0019\u0006\u0003\u0013*\u000b\u0001b]2bY\u00064W\u000e\u001e\u0006\u0002\u0017\u0006\u0019qN]4\u0004\u0001M1\u0001A\u0014,]?\u0016\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0004PE*,7\r\u001e\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\"\u000b!\"\u001b8uKJ4\u0017mY3t\u0013\tY\u0006L\u0001\u0005TG\u0006d\u0017MZ7u!\t9V,\u0003\u0002_1\n12kY1mC\u001alGoU3tg&|gNR1di>\u0014\u0018\u0010\u0005\u0002aG6\t\u0011MC\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!\u0017MA\u0004Qe>$Wo\u0019;\u0011\u0005\u0019tgBA4m\u001d\tA7.D\u0001j\u0015\tQG*\u0001\u0004=e>|GOP\u0005\u0002E&\u0011Q.Y\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0007O\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002nC\u0006A!/\u001a9peR,'/F\u0001t!\t9F/\u0003\u0002v1\n\u00012kY1mC\u001alGOU3q_J$XM]\u0001\ne\u0016\u0004xN\u001d;fe\u0002\nAB]3q_NLGo\u001c:jKN,\u0012!\u001f\t\u0004Mjd\u0018BA>q\u0005\u0011a\u0015n\u001d;\u0011\u0007u\f\t!D\u0001\u007f\u0015\u0005y\u0018aC2pkJ\u001c\u0018.\u001a:ba&L1!a\u0001\u007f\u0005)\u0011V\r]8tSR|'/_\u0001\u000ee\u0016\u0004xn]5u_JLWm\u001d\u0011\u0002\u001dI,7\u000f]3diZ+'o]5p]V\u0011\u00111\u0002\t\u0004A\u00065\u0011bAA\bC\n9!i\\8mK\u0006t\u0017a\u0004:fgB,7\r\u001e,feNLwN\u001c\u0011\u0002+I,7\u000f]3di\u0016C8\r\\;eK\u001aKG\u000e^3sg\u00061\"/Z:qK\u000e$X\t_2mk\u0012,g)\u001b7uKJ\u001c\b%\u0001\beK\u001a\fW\u000f\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003KqA!a\b\u0002\"A\u0011\u0001.Y\u0005\u0004\u0003G\t\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005%\"AB*ue&twMC\u0002\u0002$\u0005\fq\u0002Z3gCVdGOV3sg&|g\u000eI\u0001\fM>\u0014X.\u0019;DC\u000eDW-\u0006\u0002\u00022AA\u00111GA\u001d\u0003{\t)%\u0004\u0002\u00026)\u0019\u0011q\u0007$\u0002\u000bU$\u0018\u000e\\:\n\t\u0005m\u0012Q\u0007\u0002\u000f%\u0016,g\u000e\u001e:b]R\u001c\u0015m\u00195f!\u0011\ty$!\u0011\u000e\u0003\u0019K1!a\u0011G\u0005=\u00196-\u00197bM6$h+\u001a:tS>t\u0007#BA$\u0003\u0006EfbAA%{9!\u00111JA*\u001d\u0011\ti%!\u0015\u000f\u0007!\fy%C\u0001L\u0013\tI%*\u0003\u0002H\u0011\u0006y1kY1mC\u001alG\u000fR=oC6L7\rE\u0002\u0002@y\u001aRAPA.\u0003C\u00022\u0001YA/\u0013\r\ty&\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001aS\u0003\tIw.C\u0002p\u0003K\na\u0001P5oSRtDCAA,\u000511uN]7biJ+7/\u001e7u!\u001d1\u00171OA<\u00037I1!!\u001eq\u0005\u0019)\u0015\u000e\u001e5feB!\u0011qHA=\u0013\r\tYH\u0012\u0002\u0015'\u000e\fG.\u00194ni\u0012Kh.Y7jG\u0016\u0013(o\u001c:\u0003\u0015\u0019{'/\\1u\u000bZ\fG.\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u00024\u0002t\u0005]\u00141\u0011\t\u0005\u0003\u000b\u000b9\t\u0004\u0001\u0005\u000f\u0005%\u0015I1\u0001\u0002\f\n\tA+\u0005\u0003\u0002\u000e\u0006M\u0005c\u00011\u0002\u0010&\u0019\u0011\u0011S1\u0003\u000f9{G\u000f[5oOB\u0019\u0001-!&\n\u0007\u0005]\u0015MA\u0002B]f\fQ!\u00199qYf$\"#!(\u0002 \u0006\u0005\u00161UAS\u0003O\u000bI+a.\u0002<B\u0019\u0011q\b\u0001\t\u000bE\u0014\u0005\u0019A:\t\u000b]\u0014\u0005\u0019A=\t\u000f\u0005\u001d!\t1\u0001\u0002\f!9\u00111\u0003\"A\u0002\u0005-\u0001bBA\f\u0005\u0002\u0007\u00111\u0004\u0005\b\u0003[\u0011\u0005\u0019AAV!!\t\u0019$!\u000f\u0002>\u00055\u0006#BAX\u0003\u0006EV\"\u0001 \u0011\t\u0005}\u00121W\u0005\u0004\u0003k3%aD*dC2\fg-\u001c;SK\u001adWm\u0019;\t\u000f\u0005e&\t1\u0001\u0002\f\u0005a1-Y2iK\u000e{gNZ5hg\"9\u0011Q\u0018\"A\u0002\u0005}\u0016\u0001D2p]\u001aLwm]\"bG\",\u0007\u0003CA\u001a\u0003s\t\t-!5\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006!a-\u001b7f\u0015\r\tYMU\u0001\u0004]&|\u0017\u0002BAh\u0003\u000b\u0014A\u0001U1uQB)\u0011qV!\u0002TB9\u0001-!6\u0002Z\u0006}\u0017bAAlC\n1A+\u001e9mKJ\u0002B!a\u0010\u0002\\&\u0019\u0011Q\u001c$\u0003+M\u001b\u0017\r\\1g[R\u0014VM\u001a7fGR\u001cuN\u001c4jOB!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u0015\u0017!C1uiJL'-\u001e;f\u0013\u0011\tI/a9\u0003\u0011\u0019KG.\u001a+j[\u0016\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002p\u0006m\b#\u00021\u0002r\u0006U\u0018bAAzC\n1q\n\u001d;j_:\u0004\u0012\u0003YA|gf\fY!a\u0003\u0002\u001c\u0005-\u00161BA`\u0013\r\tI0\u0019\u0002\u0007)V\u0004H.\u001a\u001d\t\u0013\u0005u8)!AA\u0002\u0005u\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\ta*\u0001\u0007g_Jl\u0017\r^\"bG\",\u0007%A\u0007dC\u000eDWmQ8oM&<7\u000fI\u000b\u0003\u0005\u0013\u0001\u0002\"a\r\u0002:\u0005\u0005'1\u0002\t\u0006\u0003\u000f\n\u00151[\u0001\u000eG>tg-[4t\u0007\u0006\u001c\u0007.\u001a\u0011\u0015%\u0005u%\u0011\u0003B\n\u0005+\u00119B!\u0007\u0003\u001c\tu!q\u0004\u0005\u0006cF\u0001\ra\u001d\u0005\u0006oF\u0001\r!\u001f\u0005\b\u0003\u000f\t\u0002\u0019AA\u0006\u0011\u001d\t\u0019\"\u0005a\u0001\u0003\u0017Aq!a\u0006\u0012\u0001\u0004\tY\u0002C\u0004\u0002.E\u0001\r!!\r\t\u000f\u0005e\u0016\u00031\u0001\u0002\f!9\u0011QX\tA\u0002\t%ACAAO\u0003\u0015\u0019G.Z1s)\t\u00119\u0003E\u0002a\u0005SI1Aa\u000bb\u0005\u0011)f.\u001b;\u0002\u0019]LG\u000f\u001b*fa>\u0014H/\u001a:\u0015\t\u0005u%\u0011\u0007\u0005\u0006cR\u0001\ra]\u0001\u001ao&$\bNU3ta\u0016\u001cG\u000f\u0015:pU\u0016\u001cGOR5mi\u0016\u00148\u000f\u0006\u0003\u0002\u001e\n]\u0002bBA\n+\u0001\u0007\u00111B\u0001\u0013o&$\bNU3ta\u0016\u001cGOV3sg&|g\u000e\u0006\u0003\u0002\u001e\nu\u0002bBA\u0004-\u0001\u0007\u00111B\u0001\u0013o&$\b\u000eR3gCVdGOV3sg&|g\u000e\u0006\u0003\u0002\u001e\n\r\u0003bBA\f/\u0001\u0007\u00111D\u0001\u0012o&$\bnQ8oM&<7)Y2iS:<G\u0003BAO\u0005\u0013Bq!!/\u0019\u0001\u0004\tY!\u0001\u0004g_Jl\u0017\r\u001e\u000b\t\u00037\u0011yEa\u0015\u0003V!9!\u0011K\rA\u0002\u0005\u0005\u0017AB2p]\u001aLw\rC\u0004\u0002Hf\u0001\r!!1\t\u000f\t]\u0013\u00041\u0001\u0002\u001c\u0005!1m\u001c3f\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\r\t\u001d\"Q\fB0\u0011\u001d\t9M\u0007a\u0001\u0003\u0003DqA!\u0019\u001b\u0001\u0004\t9(A\u0003feJ|'/\u0001\bg_Jl\u0017\r\u001e#fi\u0006LG.\u001a3\u0015\u0011\t\u001d$\u0011\u000eB7\u0005_\u00022!a\u0012A\u0011\u001d\u0011Yg\u0007a\u0001\u0003\u0003\f!bY8oM&<\u0007+\u0019;i\u0011\u001d\t9m\u0007a\u0001\u0003\u0003DqAa\u0016\u001c\u0001\u0004\tY\"A\u0007sKN|GN^3D_:4\u0017n\u001a\u000b\u0005\u0005k\u00129\bE\u0004g\u0003g\n9(!7\t\u000f\t-D\u00041\u0001\u0002B\u0006I\"/Z:pYZ,7i\u001c8gS\u001e<\u0016\u000e\u001e5TG\u0006d\u0017MZ7u)\u0011\u0011iHa \u0011\u000b\u0005\u001d\u0013)!7\t\u000f\t-T\u00041\u0001\u0002B\u0006Y\u0001/\u0019:tK\u000e{gNZ5h)\u0019\u0011iH!\"\u0003\b\"9!1\u000e\u0010A\u0002\u0005\u0005\u0007b\u0002BE=\u0001\u0007\u0011\u0011W\u0001\u000bM6$(+\u001a4mK\u000e$\u0018\u0001\u0005:fg>dg/\u001a$pe6\fG\u000f^3s)\u0019\t)Ea$\u0003\u0012\"9!1N\u0010A\u0002\u0005\u0005\u0007b\u0002BJ?\u0001\u0007\u0011QH\u0001\bm\u0016\u00148/[8o\u0003A\u0011Xm]8mm\u0016\u001cE.Y:t!\u0006$\b\u000e\u0006\u0003\u0003\u001a\n5F\u0003BA#\u00057CqA!(!\u0001\u0004\u0011y*A\be_^tGn\\1e'V\u001c7-Z:t!\u0011\u0011\tKa*\u000f\t\u0005%#1U\u0005\u0004\u0005K3\u0015!G*dC2\fg-\u001c;Es:\fW.[2E_^tGn\\1eKJLAA!+\u0003,\nyAi\\<oY>\fGmU;dG\u0016\u001c8OC\u0002\u0003&\u001aCqAa\u001b!\u0001\u0004\t\t-A\u0005uef4uN]7biRA!q\rBZ\u0005k\u00139\fC\u0004\u0002H\u0006\u0002\r!!1\t\u000f\t]\u0013\u00051\u0001\u0002\u001c!9!\u0011K\u0011A\u0002\u0005e\u0017!D5t\u0013\u001etwN]3e\r&dW\r\u0006\u0004\u0002\f\tu&\u0011\u0019\u0005\b\u0005\u007f\u0013\u0003\u0019AA\u000e\u0003!1\u0017\u000e\\3oC6,\u0007b\u0002B)E\u0001\u0007\u0011\u0011\\\u0001\fe\u0016\fGMV3sg&|g\u000e\u0006\u0003\u0003H\n%\u0007#BA$\u0003\u0006u\u0002b\u0002B)G\u0001\u0007\u0011\u0011Y\u0001\u0016o&$\b.T1wK:\u0014V\r]8tSR|'/[3t)\r1&q\u001a\u0005\u0007o\u0012\u0002\rA!5\u0011\u000b\u0001\u0014\u0019.a\u0007\n\u0007\tU\u0017M\u0001\u0006=e\u0016\u0004X-\u0019;fIz\nQb\u0019:fCR,7+Z:tS>tG\u0003\u0002Bn\u0005C\u00042a\u0016Bo\u0013\r\u0011y\u000e\u0017\u0002\u0010'\u000e\fG.\u00194niN+7o]5p]\"9!\u0011K\u0013A\u0002\u0005\u0005'!C'z'\u0016\u001c8/[8o'\u00111cJa7\u0002\u0007\r4w\r\u0006\u0003\u0003l\n=\bc\u0001BwM5\t\u0001\u0001C\u0004\u0003h\"\u0002\r!!7\u0015\r\u0005m!1\u001fB{\u0011\u001d\t9-\u000ba\u0001\u0003\u0003DqAa\u0016*\u0001\u0004\tY\"A\u000bnCR\u001c\u0007.Z:Qe>TWm\u0019;GS2$XM]:\u0015\t\u0005-!1 \u0005\b\u0003\u000fT\u0003\u0019AAa\u0003\u0011\u0019w\u000e]=\u0015%\u0005u5\u0011AB\u0002\u0007\u000b\u00199a!\u0003\u0004\f\r51q\u0002\u0005\bc.\u0002\n\u00111\u0001t\u0011\u001d98\u0006%AA\u0002eD\u0011\"a\u0002,!\u0003\u0005\r!a\u0003\t\u0013\u0005M1\u0006%AA\u0002\u0005-\u0001\"CA\fWA\u0005\t\u0019AA\u000e\u0011%\tic\u000bI\u0001\u0002\u0004\t\t\u0004C\u0005\u0002:.\u0002\n\u00111\u0001\u0002\f!I\u0011QX\u0016\u0011\u0002\u0003\u0007!\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019)BK\u0002t\u0007/Y#a!\u0007\u0011\t\rm1QE\u0007\u0003\u0007;QAaa\b\u0004\"\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007G\t\u0017AC1o]>$\u0018\r^5p]&!1qEB\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iCK\u0002z\u0007/\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00044)\"\u00111BB\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0004<)\"\u00111DB\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"a!\u0011+\t\u0005E2qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"a!\u0013+\t\t%1qC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r=\u0003cA(\u0004R%\u0019\u0011q\u0005)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\r]\u0003c\u00011\u0004Z%\u001911L1\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M5\u0011\r\u0005\n\u0007G2\u0014\u0011!a\u0001\u0007/\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB5!\u0019\u0019Yg!\u001d\u0002\u00146\u00111Q\u000e\u0006\u0004\u0007_\n\u0017AC2pY2,7\r^5p]&!11OB7\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-1\u0011\u0010\u0005\n\u0007GB\u0014\u0011!a\u0001\u0003'\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!1qJB@\u0011%\u0019\u0019'OA\u0001\u0002\u0004\u00199&\u0001\u0005iCND7i\u001c3f)\t\u00199&\u0001\u0005u_N#(/\u001b8h)\t\u0019y%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\u0019i\tC\u0005\u0004dq\n\t\u00111\u0001\u0002\u0014\u0002")
public final class ScalafmtDynamic
implements Scalafmt,
ScalafmtSessionFactory,
Product,
Serializable {
    private final ScalafmtReporter reporter;
    private final List<Repository> repositories;
    private final boolean respectVersion;
    private final boolean respectExcludeFilters;
    private final String defaultVersion;
    private final ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache;
    private final boolean cacheConfigs;
    private final ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache;

    public static Option<Tuple8<ScalafmtReporter, List<Repository>, Object, Object, String, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>>, Object, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>>> unapply(ScalafmtDynamic scalafmtDynamic) {
        return ScalafmtDynamic$.MODULE$.unapply(scalafmtDynamic);
    }

    public static ScalafmtDynamic apply(ScalafmtReporter scalafmtReporter, List<Repository> list, boolean bl, boolean bl2, String string, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache, boolean bl3, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache2) {
        return ScalafmtDynamic$.MODULE$.apply(scalafmtReporter, list, bl, bl2, string, reentrantCache, bl3, reentrantCache2);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ScalafmtReporter reporter() {
        return this.reporter;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public boolean respectVersion() {
        return this.respectVersion;
    }

    public boolean respectExcludeFilters() {
        return this.respectExcludeFilters;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache() {
        return this.formatCache;
    }

    public boolean cacheConfigs() {
        return this.cacheConfigs;
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache() {
        return this.configsCache;
    }

    public void clear() {
        this.formatCache().clear().foreach((Function1 & Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable)x$2 -> {
                ScalafmtDynamic.$anonfun$clear$2(x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
    }

    public ScalafmtDynamic withReporter(ScalafmtReporter reporter) {
        return this.copy(reporter, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public ScalafmtDynamic withRespectProjectFilters(boolean respectExcludeFilters) {
        boolean x$1 = respectExcludeFilters;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        String x$5 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withRespectVersion(boolean respectVersion) {
        boolean x$1 = respectVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withDefaultVersion(String defaultVersion) {
        String x$1 = defaultVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withConfigCaching(boolean cacheConfigs) {
        boolean x$1 = cacheConfigs;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        String x$6 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$7 = this.copy$default$6();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public String format(Path config, Path file, String code) {
        String string;
        Either<ScalafmtDynamicError, String> either = this.formatDetailed(config, file, code);
        if (either instanceof Right) {
            String codeFormatted;
            Right right = (Right)either;
            string = codeFormatted = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ScalafmtDynamicError error = (ScalafmtDynamicError)left.value();
            this.org$scalafmt$dynamic$ScalafmtDynamic$$reportError(file, error);
            if (error instanceof ScalafmtDynamicError.ConfigError) {
                throw error;
            }
            string = code;
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    public void org$scalafmt$dynamic$ScalafmtDynamic$$reportError(Path file, ScalafmtDynamicError error) {
        ScalafmtDynamicError scalafmtDynamicError = error;
        if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigMissingVersion) {
            ScalafmtDynamicError.ConfigMissingVersion configMissingVersion = (ScalafmtDynamicError.ConfigMissingVersion)scalafmtDynamicError;
            this.reporter().missingVersion(configMissingVersion.configPath(), this.defaultVersion());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigError) {
            ScalafmtDynamicError.ConfigError configError = (ScalafmtDynamicError.ConfigError)scalafmtDynamicError;
            Option option = Option$.MODULE$.apply((Object)configError.getCause());
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable cause = (Throwable)some.value();
                this.reporter().error(configError.configPath(), configError.getMessage(), cause);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.reporter().error(configError.configPath(), configError.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.UnknownError) {
            ScalafmtDynamicError.UnknownError unknownError = (ScalafmtDynamicError.UnknownError)scalafmtDynamicError;
            Throwable cause = unknownError.cause();
            this.reporter().error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafmtDynamicError);
        }
    }

    public Either<ScalafmtDynamicError, String> formatDetailed(Path configPath, Path file, String code) {
        return this.resolveConfig(configPath).flatMap((Function1 & Serializable)config -> this.org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(file, code, (ScalafmtReflectConfig)config).map((Function1 & Serializable)codeFormatted -> codeFormatted));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfig(Path configPath) {
        Left left;
        if (!Files.exists(configPath, new LinkOption[0])) {
            left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigDoesNotExist(configPath));
        } else if (this.cacheConfigs()) {
            FileTime currentTimestamp = Files.getLastModifiedTime(configPath, new LinkOption[0]);
            left = this.configsCache().getOrAddToCache(configPath, (Function1<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$1(currentTimestamp, x$4)), (Function0<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>)(Function0 & Serializable)() -> this.resolveConfigWithScalafmt(configPath).map((Function1 & Serializable)config -> {
                this.reporter().parsedConfig(configPath, config.version());
                return new Tuple2(config, (Object)currentTimestamp);
            })).map((Function1 & Serializable)x$7 -> (ScalafmtReflectConfig)x$7._1());
        } else {
            left = this.resolveConfigWithScalafmt(configPath);
        }
        return left;
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfigWithScalafmt(Path configPath) {
        return this.readVersion(configPath).flatMap((Function1 & Serializable)version -> this.resolveFormatter(configPath, (ScalafmtVersion)version).flatMap((Function1 & Serializable)fmtReflect -> this.parseConfig(configPath, (ScalafmtReflect)fmtReflect).map((Function1 & Serializable)config -> config)));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> parseConfig(Path configPath, ScalafmtReflect fmtReflect) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> fmtReflect.parseConfig(configPath)).toEither().left().map((Function1 & Serializable)x0$1 -> {
            ScalafmtDynamicError scalafmtDynamicError;
            Throwable throwable = x0$1;
            ScalafmtDynamicError scalafmtDynamicError2 = throwable instanceof ScalafmtDynamicError ? (scalafmtDynamicError = (ScalafmtDynamicError)throwable) : new ScalafmtDynamicError.UnknownError(throwable);
            return scalafmtDynamicError2;
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveFormatter(Path configPath, ScalafmtVersion version) {
        return this.formatCache().getOrAddToCache(version, this.formatCache().getOrAddToCache$default$2(), (Function0<Either<ScalafmtDynamicError, ScalafmtReflect>>)(Function0 & Serializable)() -> {
            OutputStreamWriter writer = this.reporter().downloadOutputStreamWriter();
            return new ScalafmtDynamicDownloader(writer, this.repositories(), ScalafmtDynamicDownloader$.MODULE$.$lessinit$greater$default$3()).download(version).left().map((Function1 & Serializable)x0$1 -> {
                ScalafmtDynamicError.CannotDownload cannotDownload;
                ScalafmtDynamicDownloader.DownloadFailure downloadFailure = x0$1;
                if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadResolutionError) {
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, version, ScalafmtDynamicError$CannotDownload$.MODULE$.$lessinit$greater$default$3());
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadUnknownError) {
                    ScalafmtDynamicDownloader.DownloadUnknownError downloadUnknownError = (ScalafmtDynamicDownloader.DownloadUnknownError)downloadFailure;
                    Throwable cause = downloadUnknownError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, version, cause);
                } else {
                    throw new MatchError((Object)downloadFailure);
                }
                return cannotDownload;
            }).flatMap((Function1 & Serializable)downloadSuccess -> this.resolveClassPath(configPath, (ScalafmtDynamicDownloader.DownloadSuccess)downloadSuccess));
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveClassPath(Path configPath, ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess) {
        ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess2 = downloadSuccess;
        if (downloadSuccess2 == null) {
            throw new MatchError((Object)downloadSuccess2);
        }
        ScalafmtVersion version = downloadSuccess2.version();
        Seq<URL> urls = downloadSuccess2.jarUrls();
        Tuple2 tuple2 = new Tuple2((Object)version, urls);
        Tuple2 tuple22 = tuple2;
        ScalafmtVersion version2 = (ScalafmtVersion)tuple22._1();
        Seq urls2 = (Seq)tuple22._2();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            URLClassLoader classloader = new URLClassLoader((URL[])urls2.toArray(ClassTag$.MODULE$.apply(URL.class)), null);
            return new ScalafmtReflect(classloader, version2, this.respectVersion());
        }).toEither().left().map((Function1 & Serializable)x0$1 -> {
            ScalafmtDynamicError scalafmtDynamicError;
            Throwable throwable = x0$1;
            if (throwable instanceof ReflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)throwable;
                scalafmtDynamicError = new ScalafmtDynamicError.CorruptedClassPath(configPath, version2, (Seq<URL>)urls2, reflectiveOperationException);
            } else {
                scalafmtDynamicError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return scalafmtDynamicError;
        });
    }

    public Either<ScalafmtDynamicError, String> org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(Path file, String code, ScalafmtReflectConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String string;
            ScalafmtReflectConfig configWithDialect;
            String filename = ((Object)file).toString();
            ScalafmtReflectConfig scalafmtReflectConfig = configWithDialect = config.fmtReflect().version().$less(new ScalafmtVersion(2, 6, 3, ScalafmtVersion$.MODULE$.apply$default$4(), ScalafmtVersion$.MODULE$.apply$default$5())) && (filename.endsWith(".sbt") || filename.endsWith(".sc")) ? config.withSbtDialect() : config;
            if (this.isIgnoredFile(filename, configWithDialect)) {
                this.reporter().excluded(file);
                string = code;
            } else {
                string = configWithDialect.format(code, (Option<Path>)new Some((Object)file));
            }
            return string;
        }).toEither().left().map((Function1 & Serializable)x0$1 -> {
            ScalafmtDynamicError.UnknownError unknownError;
            Option<Throwable> option;
            Throwable throwable = x0$1;
            if (throwable != null && !(option = ReflectionException$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                unknownError = new ScalafmtDynamicError.UnknownError(e);
            } else {
                unknownError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return unknownError;
        });
    }

    private boolean isIgnoredFile(String filename, ScalafmtReflectConfig config) {
        return this.respectExcludeFilters() && !config.isIncludedInProject(filename);
    }

    private Either<ScalafmtDynamicError, ScalafmtVersion> readVersion(Path config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> ConfigFactory.parseFile((File)config.toFile()).getString("version")).toEither().left().flatMap((Function1 & Serializable)x0$1 -> {
            Left left;
            Throwable throwable = x0$1;
            if (throwable instanceof ConfigException.Parse) {
                ConfigException.Parse parse = (ConfigException.Parse)throwable;
                left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigParseError(config, parse.getMessage()));
            } else if (throwable instanceof ConfigException.Missing) {
                left = this.respectVersion() ? package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigMissingVersion(config)) : package$.MODULE$.Right().apply((Object)this.defaultVersion());
            } else {
                throw new MatchError((Object)throwable);
            }
            return left;
        }).flatMap((Function1 & Serializable)v -> ScalafmtVersion$.MODULE$.parse((String)v).toRight((Function0 & Serializable)() -> new ScalafmtDynamicError.ConfigInvalidVersion(config, (String)v)));
    }

    public Scalafmt withMavenRepositories(Seq<String> repositories) {
        List x$12 = ((IterableOnceOps)repositories.map((Function1 & Serializable)x$1 -> MavenRepository.of((String)x$1))).toList();
        ScalafmtReporter x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, (List<Repository>)x$12, x$3, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtSession createSession(Path config2) {
        return (ScalafmtSession)this.resolveConfig(config2).fold((Function1 & Serializable)error -> {
            this.org$scalafmt$dynamic$ScalafmtDynamic$$reportError(config2, (ScalafmtDynamicError)error);
            throw error;
        }, (Function1 & Serializable)config -> new MySession(this, (ScalafmtReflectConfig)config));
    }

    public ScalafmtDynamic copy(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        return new ScalafmtDynamic(reporter, repositories, respectVersion, respectExcludeFilters, defaultVersion, formatCache, cacheConfigs, configsCache);
    }

    public ScalafmtReporter copy$default$1() {
        return this.reporter();
    }

    public List<Repository> copy$default$2() {
        return this.repositories();
    }

    public boolean copy$default$3() {
        return this.respectVersion();
    }

    public boolean copy$default$4() {
        return this.respectExcludeFilters();
    }

    public String copy$default$5() {
        return this.defaultVersion();
    }

    public ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> copy$default$6() {
        return this.formatCache();
    }

    public boolean copy$default$7() {
        return this.cacheConfigs();
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> copy$default$8() {
        return this.configsCache();
    }

    public String productPrefix() {
        return "ScalafmtDynamic";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.reporter();
                break;
            }
            case 1: {
                object = this.repositories();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectVersion());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectExcludeFilters());
                break;
            }
            case 4: {
                object = this.defaultVersion();
                break;
            }
            case 5: {
                object = this.formatCache();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.cacheConfigs());
                break;
            }
            case 7: {
                object = this.configsCache();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalafmtDynamic;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "reporter";
                break;
            }
            case 1: {
                string = "repositories";
                break;
            }
            case 2: {
                string = "respectVersion";
                break;
            }
            case 3: {
                string = "respectExcludeFilters";
                break;
            }
            case 4: {
                string = "defaultVersion";
                break;
            }
            case 5: {
                string = "formatCache";
                break;
            }
            case 6: {
                string = "cacheConfigs";
                break;
            }
            case 7: {
                string = "configsCache";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reporter()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.repositories()));
        n = Statics.mix((int)n, (int)(this.respectVersion() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.respectExcludeFilters() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultVersion()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.formatCache()));
        n = Statics.mix((int)n, (int)(this.cacheConfigs() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.configsCache()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalafmtDynamic)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalafmtDynamic scalafmtDynamic = (ScalafmtDynamic)x$1;
        if (this.respectVersion() != scalafmtDynamic.respectVersion()) return false;
        if (this.respectExcludeFilters() != scalafmtDynamic.respectExcludeFilters()) return false;
        if (this.cacheConfigs() != scalafmtDynamic.cacheConfigs()) return false;
        ScalafmtReporter scalafmtReporter = this.reporter();
        ScalafmtReporter scalafmtReporter2 = scalafmtDynamic.reporter();
        if (scalafmtReporter == null) {
            if (scalafmtReporter2 != null) {
                return false;
            }
        } else if (!scalafmtReporter.equals(scalafmtReporter2)) return false;
        List<Repository> list = this.repositories();
        List<Repository> list2 = scalafmtDynamic.repositories();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        String string = this.defaultVersion();
        String string2 = scalafmtDynamic.defaultVersion();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache = this.formatCache();
        ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache2 = scalafmtDynamic.formatCache();
        if (reentrantCache == null) {
            if (reentrantCache2 != null) {
                return false;
            }
        } else if (!reentrantCache.equals(reentrantCache2)) return false;
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache3 = this.configsCache();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache4 = scalafmtDynamic.configsCache();
        if (reentrantCache3 == null) {
            if (reentrantCache4 == null) return true;
            return false;
        } else {
            if (!reentrantCache3.equals(reentrantCache4)) return false;
            return true;
        }
    }

    public Scalafmt withMavenRepositories(String[] repositories) {
        return this.withMavenRepositories((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])repositories));
    }

    public static final /* synthetic */ void $anonfun$clear$3(ScalafmtReflect x$3) {
        x$3.classLoader().close();
    }

    public static final /* synthetic */ void $anonfun$clear$2(Either x$2) {
        x$2.right().foreach((Function1 & Serializable)x$3 -> {
            ScalafmtDynamic.$anonfun$clear$3(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$2(ScalafmtDynamicError x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$3(FileTime currentTimestamp$1, Tuple2 x$6) {
        return ((FileTime)x$6._2()).compareTo(currentTimestamp$1) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$1(FileTime currentTimestamp$1, Either x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.fold((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$2(x$5)), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$3(currentTimestamp$1, x$6))));
    }

    public ScalafmtDynamic(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<ScalafmtVersion, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        this.reporter = reporter;
        this.repositories = repositories;
        this.respectVersion = respectVersion;
        this.respectExcludeFilters = respectExcludeFilters;
        this.defaultVersion = defaultVersion;
        this.formatCache = formatCache;
        this.cacheConfigs = cacheConfigs;
        this.configsCache = configsCache;
        Product.$init$((Product)this);
    }

    public ScalafmtDynamic() {
        this(ConsoleScalafmtReporter$.MODULE$, (List<Repository>)Nil$.MODULE$, true, true, BuildInfo$.MODULE$.stable(), ReentrantCache$.MODULE$.apply(), true, ReentrantCache$.MODULE$.apply());
    }

    public class MySession
    implements ScalafmtSession {
        private final ScalafmtReflectConfig cfg;
        public final /* synthetic */ ScalafmtDynamic $outer;

        public String format(Path file, String code) {
            return (String)this.org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer().org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(file, code, this.cfg).fold((Function1 & Serializable)error -> {
                this.org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer().org$scalafmt$dynamic$ScalafmtDynamic$$reportError(file, (ScalafmtDynamicError)error);
                return code;
            }, (Function1 & Serializable)formatted -> formatted);
        }

        public boolean matchesProjectFilters(Path file) {
            return this.cfg.isIncludedInProject(((Object)file).toString());
        }

        public /* synthetic */ ScalafmtDynamic org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer() {
            return this.$outer;
        }

        public MySession(ScalafmtDynamic $outer, ScalafmtReflectConfig cfg) {
            this.cfg = cfg;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

