/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.sysops;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.scalafmt.sysops.AbsoluteFile;
import org.scalafmt.sysops.AbsoluteFile$;
import org.scalafmt.sysops.FileOps;
import org.scalafmt.sysops.FileStat;
import org.scalafmt.sysops.PlatformFileOps$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class FileOps$ {
    public static FileOps$ MODULE$;
    private final String defaultConfigFileName;

    static {
        new FileOps$();
    }

    public String defaultConfigFileName() {
        return this.defaultConfigFileName;
    }

    public Seq<Path> listFiles(String path) {
        return this.listFiles(this.getPath(path, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
    }

    public Seq<Path> listFiles(Path file) {
        return this.listFiles((Function2<Path, FileStat, Object>)(Function2 & Serializable & scala.Serializable)(x$1, a) -> BoxesRunTime.boxToBoolean((boolean)a.isRegularFile()), file);
    }

    public Seq<Path> listFiles(Function2<Path, FileStat, Object> matches, Path file) {
        return PlatformFileOps$.MODULE$.listFiles(file, matches);
    }

    public Seq<Path> walkFiles(FileOps.WalkVisitor visitor, Path file) {
        return PlatformFileOps$.MODULE$.walkFiles(visitor, file);
    }

    public Path getFile(Seq<String> path) {
        return this.getPath((String)path.head(), (Seq<String>)((Seq)path.tail()));
    }

    public Path getPath(String head, Seq<String> tail) {
        return Paths.get(head, (String[])tail.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean isMarkdown(String filename) {
        return filename.endsWith(".md");
    }

    public boolean isAmmonite(String filename) {
        return filename.endsWith(".sc");
    }

    public boolean isSbt(String filename) {
        return filename.endsWith(".sbt");
    }

    public Option<Try<Path>> getCanonicalConfigFile(Path workingDirectory, Option<Path> config) {
        return (Option)config.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.tryGetConfigInDir(workingDirectory), (Function1 & Serializable & scala.Serializable)x -> {
            Path file = AbsoluteFile$.MODULE$.join$extension0(workingDirectory, (Path)x);
            return MODULE$.tryCheckConfigFile(file).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)new Failure((Throwable)new RuntimeException(new StringBuilder(16).append("Config missing: ").append(new AbsoluteFile(file)).toString()))));
        });
    }

    public Option<Path> getCanonicalConfigFile$default$2() {
        return None$.MODULE$;
    }

    public Option<Try<Path>> tryGetConfigInDir(Path dir) {
        return this.tryCheckConfigFile(AbsoluteFile$.MODULE$.$div$extension1(dir, this.defaultConfigFileName()));
    }

    private Option<Try<Path>> tryCheckConfigFile(Path file) {
        if (!AbsoluteFile$.MODULE$.exists$extension(file)) {
            return None$.MODULE$;
        }
        if (AbsoluteFile$.MODULE$.isRegularFile$extension(file)) {
            return new Some((Object)new Success((Object)file));
        }
        return new Some((Object)new Failure((Throwable)new RuntimeException(new StringBuilder(19).append("Config not a file: ").append(new AbsoluteFile(file)).toString())));
    }

    public String readInputStream(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int cnt = 0;
        while ((cnt = is.read(buf)) >= 0) {
            baos.write(buf, 0, cnt);
        }
        return baos.toString("utf-8");
    }

    private FileOps$() {
        MODULE$ = this;
        this.defaultConfigFileName = ".scalafmt.conf";
    }
}

