/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.sysops;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.io.Codec;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class GranularPlatformAsyncOps$ {
    public static GranularPlatformAsyncOps$ MODULE$;
    private final ExecutionContext ioExecutionContext;

    static {
        new GranularPlatformAsyncOps$();
    }

    public ExecutionContext ioExecutionContext() {
        return this.ioExecutionContext;
    }

    public Future<String> readFileAsync(Path path, Codec codec) {
        Promise promise = Promise$.MODULE$.apply();
        byte[] buf = new byte[1024];
        ByteBuffer bbuf = ByteBuffer.wrap(buf);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AsynchronousFileChannel channel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);
            CompletionHandler<Integer, Object> handler = new CompletionHandler<Integer, Object>(promise, os, codec, channel, buf, bbuf){
                private final Promise promise$1;
                private final ByteArrayOutputStream os$1;
                private final Codec codec$1;
                private final AsynchronousFileChannel channel$1;
                private final byte[] buf$1;
                private final ByteBuffer bbuf$1;

                public void completed(Integer result, Object unused) {
                    Object object;
                    int count = result;
                    if (count < 0) {
                        this.promise$1.trySuccess((Object)this.os$1.toString(this.codec$1.charSet().name()));
                        this.channel$1.close();
                        return;
                    }
                    if (count > 0) {
                        this.os$1.write(this.buf$1, 0, count);
                        object = this.bbuf$1.clear();
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.channel$1.read(this.bbuf$1, this.os$1.size(), null, this);
                }

                public void failed(Throwable exc, Object unused) {
                    this.promise$1.tryFailure(exc);
                    this.channel$1.close();
                }
                {
                    this.promise$1 = promise$1;
                    this.os$1 = os$1;
                    this.codec$1 = codec$1;
                    this.channel$1 = channel$1;
                    this.buf$1 = buf$1;
                    this.bbuf$1 = bbuf$1;
                }
            };
            channel.read(bbuf, 0L, null, handler);
        }).failed().foreach((Function1 & Serializable & scala.Serializable)cause -> BoxesRunTime.boxToBoolean((boolean)promise.tryFailure(cause)));
        return promise.future();
    }

    public Future<BoxedUnit> writeFileAsync(Path path, String content, Codec codec) {
        Promise promise = Promise$.MODULE$.apply();
        ByteBuffer buf = ByteBuffer.wrap(content.getBytes(codec.charSet()));
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AsynchronousFileChannel channel = AsynchronousFileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            CompletionHandler<Integer, Object> handler = new CompletionHandler<Integer, Object>(buf, channel, promise){
                private final ByteBuffer buf$2;
                private final AsynchronousFileChannel channel$2;
                private final Promise promise$2;

                public void completed(Integer result, Object attachment) {
                    if (this.buf$2.hasRemaining()) {
                        this.channel$2.write(this.buf$2, this.buf$2.position(), null, this);
                        return;
                    }
                    this.promise$2.trySuccess((Object)BoxedUnit.UNIT);
                    this.channel$2.close();
                }

                public void failed(Throwable exc, Object attachment) {
                    this.promise$2.tryFailure(exc);
                    this.channel$2.close();
                }
                {
                    this.buf$2 = buf$2;
                    this.channel$2 = channel$2;
                    this.promise$2 = promise$2;
                }
            };
            channel.write(buf, 0L, null, handler);
        }).failed().foreach((Function1 & Serializable & scala.Serializable)cause -> BoxesRunTime.boxToBoolean((boolean)promise.tryFailure(cause)));
        return promise.future();
    }

    private GranularPlatformAsyncOps$() {
        MODULE$ = this;
        this.ioExecutionContext = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newCachedThreadPool());
    }
}

