/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.sysops;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.scalafmt.sysops.AbsoluteFile;
import org.scalafmt.sysops.AbsoluteFile$;
import org.scalafmt.sysops.FileOps$;
import org.scalafmt.sysops.GitOps;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%da\u0002\u0013&!\u0003\r\t\u0001\f\u0005\u0006g\u0001!\t\u0001\u000e\u0005\bq\u0001\u0011\rQ\"\u0001:\u0011\u0015Q\u0005A\"\u0001L\u0011\u0015\t\u0007\u0001\"\u0002c\u0011\u0015)\u0007\u0001\"\u0002g\u000f\u0015YW\u0005#\u0001m\r\u0015!S\u0005#\u0001n\u0011\u0015qw\u0001\"\u0001p\r\u0011\u0001xAA9\t\u0011ML!Q1A\u0005\u0002QD\u0001\"^\u0005\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tq%\u0011)\u0019!C\u0001s!Aa/\u0003B\u0001B\u0003%!\bC\u0003o\u0013\u0011\u0005q\u000fC\u0003~\u0013\u0011%a\u0010\u0003\u0004K\u0013\u0011\u0015\u00131\u0003\u0004\u0007\u0003/9!!!\u0007\t\u0015\u0005m\u0011C!A!\u0002\u0013\ti\u0002\u0003\u00059#\t\u0015\r\u0011\"\u0001:\u0011!1\u0018C!A!\u0002\u0013Q\u0004B\u00028\u0012\t\u0003\t\u0019\u0003\u0003\u0004K#\u0011\u0015\u0013Q\u0006\u0004\u0007\u0003c9!!a\r\t\u0015\u0005mqC!A!\u0002\u0013\ti\u0002\u0003\u0006\u00026]\u0011\t\u0011)A\u0005\u0003oA\u0001\u0002O\f\u0003\u0006\u0004%\t!\u000f\u0005\tm^\u0011\t\u0011)A\u0005u!1an\u0006C\u0001\u0003\u000fBaAS\f\u0005F\u0005McABA,\u000f\t\tI\u0006\u0003\u0006\u0002\u001cy\u0011\t\u0011)A\u0005\u0003;A\u0001\u0002\u000f\u0010\u0003\u0006\u0004%\t!\u000f\u0005\tmz\u0011\t\u0011)A\u0005u!1aN\bC\u0001\u00037BaA\u0013\u0010\u0005F\u0005\u0015$a\u0004\"bi\u000eD\u0007+\u0019;i\r&tG-\u001a:\u000b\u0005\u0019:\u0013AB:zg>\u00048O\u0003\u0002)S\u0005A1oY1mC\u001alGOC\u0001+\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003U\u0002\"A\f\u001c\n\u0005]z#\u0001B+oSR\fq!\\1uG\",7/F\u0001;!\u0011q3(P$\n\u0005qz#!\u0003$v]\u000e$\u0018n\u001c82!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003gS2,'B\u0001\"D\u0003\rq\u0017n\u001c\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1uH\u0001\u0003QCRD\u0007C\u0001\u0018I\u0013\tIuFA\u0004C_>dW-\u00198\u0002\u0013\u0019Lg\u000e\u001a$jY\u0016\u001cHC\u0001']!\riU\u000b\u0017\b\u0003\u001dNs!a\u0014*\u000e\u0003AS!!U\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001+0\u0003\u001d\u0001\u0018mY6bO\u0016L!AV,\u0003\u0007M+\u0017O\u0003\u0002U_A\u0011\u0011LW\u0007\u0002K%\u00111,\n\u0002\r\u0003\n\u001cx\u000e\\;uK\u001aKG.\u001a\u0005\u0006;\u000e\u0001\rAX\u0001\u0004I&\u0014\bc\u0001\u0018`1&\u0011\u0001m\f\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!\u00054j]\u00124\u0015\u000e\\3t\u000bb\u0004H.[2jiR\u0011Aj\u0019\u0005\u0006I\u0012\u0001\r\u0001T\u0001\u0005I&\u00148/A\tgS:$W*\u0019;dQ&twMR5mKN$2\u0001T4j\u0011\u0015AW\u00011\u0001H\u000391\u0017\u000e\u001c;fe\u001aKG.Z:U_>DQA[\u0003A\u0002y\u000bQ\u0001]1uQN\fqBQ1uG\"\u0004\u0016\r\u001e5GS:$WM\u001d\t\u00033\u001e\u0019\"aB\u0017\u0002\rqJg.\u001b;?)\u0005a'\u0001\u0003#je\u001aKG.Z:\u0014\u0007%i#\u000f\u0005\u0002Z\u0001\u0005\u00191m\u001e3\u0016\u0003a\u000bAaY<eA\u0005AQ.\u0019;dQ\u0016\u001c\b\u0005\u0006\u0002yyR\u0011\u0011p\u001f\t\u0003u&i\u0011a\u0002\u0005\u0006q9\u0001\rA\u000f\u0005\u0006g:\u0001\r\u0001W\u0001\u0007M&dG/\u001a:\u0015\t\u001d{\u00181\u0001\u0005\u0007\u0003\u0003y\u0001\u0019A\u001f\u0002\tA\fG\u000f\u001b\u0005\b\u0003\u000by\u0001\u0019AA\u0004\u0003\u0015\tG\u000f\u001e:t!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\u007f\u0005I\u0011\r\u001e;sS\n,H/Z\u0005\u0005\u0003#\tYAA\nCCNL7MR5mK\u0006#HO]5ckR,7\u000fF\u0002M\u0003+AQ!\u0018\tA\u0002y\u0013\u0001bR5u\r&dWm]\n\u0004#5\u0012\u0018aA4jiB\u0019\u0011,a\b\n\u0007\u0005\u0005RE\u0001\u0004HSR|\u0005o\u001d\u000b\u0005\u0003K\tY\u0003\u0006\u0003\u0002(\u0005%\u0002C\u0001>\u0012\u0011\u0015AT\u00031\u0001;\u0011\u001d\tY\"\u0006a\u0001\u0003;!2\u0001TA\u0018\u0011\u0015if\u00031\u0001_\u000599\u0015\u000e\u001e\"sC:\u001c\u0007NR5mKN\u001c2aF\u0017s\u0003\u0019\u0011'/\u00198dQB!\u0011\u0011HA!\u001d\u0011\tY$!\u0010\u0011\u0005={\u0013bAA _\u00051\u0001K]3eK\u001aLA!a\u0011\u0002F\t11\u000b\u001e:j]\u001eT1!a\u00100)\u0019\tI%a\u0014\u0002RQ!\u00111JA'!\tQx\u0003C\u000399\u0001\u0007!\bC\u0004\u0002\u001cq\u0001\r!!\b\t\u000f\u0005UB\u00041\u0001\u00028Q\u0019A*!\u0016\t\u000buk\u0002\u0019\u00010\u0003\u001b\u001dKG\u000fR5sif4\u0015\u000e\\3t'\rqRF\u001d\u000b\u0005\u0003;\n\u0019\u0007\u0006\u0003\u0002`\u0005\u0005\u0004C\u0001>\u001f\u0011\u0015A$\u00051\u0001;\u0011\u001d\tYB\ta\u0001\u0003;!2\u0001TA4\u0011\u0015i6\u00051\u0001_\u0001")
public interface BatchPathFinder {
    public Function1<Path, Object> matches();

    public Seq<AbsoluteFile> findFiles(Seq<AbsoluteFile> var1);

    default public Seq<AbsoluteFile> findFilesExplicit(Seq<AbsoluteFile> dirs) {
        return dirs.isEmpty() ? (Seq)package$.MODULE$.Seq().empty() : this.findFiles(dirs);
    }

    default public Seq<AbsoluteFile> findMatchingFiles(boolean filterFilesToo, Seq<AbsoluteFile> paths) {
        Seq seq;
        if (paths.isEmpty()) {
            seq = this.findFiles((Seq<AbsoluteFile>)Nil$.MODULE$);
        } else {
            Builder files = package$.MODULE$.Seq().newBuilder();
            Builder dirs = package$.MODULE$.Seq().newBuilder();
            paths.foreach((Function1 & Serializable)x -> BatchPathFinder.$anonfun$findMatchingFiles$1(this, dirs, filterFilesToo, files, ((AbsoluteFile)x).path()));
            seq = (Seq)((IterableOps)files.result()).$plus$plus(this.findFilesExplicit((Seq<AbsoluteFile>)((Seq)dirs.result())));
        }
        return seq;
    }

    public static /* synthetic */ Object $anonfun$findMatchingFiles$1(BatchPathFinder $this, Builder dirs$1, boolean filterFilesToo$1, Builder files$1, Path x) {
        return !AbsoluteFile$.MODULE$.isRegularFile$extension(x) ? dirs$1.$plus$eq((Object)new AbsoluteFile(x)) : (!filterFilesToo$1 || BoxesRunTime.unboxToBoolean((Object)$this.matches().apply((Object)x)) ? files$1.$plus$eq((Object)new AbsoluteFile(x)) : BoxedUnit.UNIT);
    }

    public static void $init$(BatchPathFinder $this) {
    }

    public static final class DirFiles
    implements BatchPathFinder {
        private final Path cwd;
        private final Function1<Path, Object> matches;

        @Override
        public final Seq<AbsoluteFile> findFilesExplicit(Seq<AbsoluteFile> dirs) {
            return ((BatchPathFinder)this).findFilesExplicit((Seq<AbsoluteFile>)dirs);
        }

        @Override
        public final Seq<AbsoluteFile> findMatchingFiles(boolean filterFilesToo, Seq<AbsoluteFile> paths) {
            return ((BatchPathFinder)this).findMatchingFiles(filterFilesToo, (Seq<AbsoluteFile>)paths);
        }

        public Path cwd() {
            return this.cwd;
        }

        @Override
        public Function1<Path, Object> matches() {
            return this.matches;
        }

        private boolean filter(Path path, BasicFileAttributes attrs) {
            return attrs.isRegularFile() && BoxesRunTime.unboxToBoolean((Object)this.matches().apply((Object)path));
        }

        @Override
        public final Seq<AbsoluteFile> findFiles(Seq<AbsoluteFile> dir) {
            Seq dirs = dir.isEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{this.cwd()})) : (Seq)dir.map((Function1 & Serializable)x$1 -> ((AbsoluteFile)x$1).path());
            return (Seq)((IterableOps)dirs.flatMap((Function1 & Serializable)x$2 -> FileOps$.MODULE$.listFiles((Path)x$2, (Function2<Path, BasicFileAttributes, Object>)(Function2 & Serializable)(path, attrs) -> BoxesRunTime.boxToBoolean((boolean)this.filter(path, attrs))))).map((Function1 & Serializable)x$3 -> new AbsoluteFile(x$3));
        }

        public DirFiles(Path cwd, Function1<Path, Object> matches) {
            this.cwd = cwd;
            this.matches = matches;
            BatchPathFinder.$init$(this);
        }
    }

    public static final class GitBranchFiles
    implements BatchPathFinder {
        private final GitOps git;
        private final String branch;
        private final Function1<Path, Object> matches;

        @Override
        public final Seq<AbsoluteFile> findFilesExplicit(Seq<AbsoluteFile> dirs) {
            return ((BatchPathFinder)this).findFilesExplicit((Seq<AbsoluteFile>)dirs);
        }

        @Override
        public final Seq<AbsoluteFile> findMatchingFiles(boolean filterFilesToo, Seq<AbsoluteFile> paths) {
            return ((BatchPathFinder)this).findMatchingFiles(filterFilesToo, (Seq<AbsoluteFile>)paths);
        }

        @Override
        public Function1<Path, Object> matches() {
            return this.matches;
        }

        @Override
        public final Seq<AbsoluteFile> findFiles(Seq<AbsoluteFile> dir) {
            return (Seq)this.git.diff(this.branch, dir).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GitBranchFiles.$anonfun$findFiles$6(this, ((AbsoluteFile)x).path())));
        }

        public static final /* synthetic */ boolean $anonfun$findFiles$6(GitBranchFiles $this, Path x) {
            return BoxesRunTime.unboxToBoolean((Object)$this.matches().apply((Object)x));
        }

        public GitBranchFiles(GitOps git, String branch, Function1<Path, Object> matches) {
            this.git = git;
            this.branch = branch;
            this.matches = matches;
            BatchPathFinder.$init$(this);
        }
    }

    public static final class GitDirtyFiles
    implements BatchPathFinder {
        private final GitOps git;
        private final Function1<Path, Object> matches;

        @Override
        public final Seq<AbsoluteFile> findFilesExplicit(Seq<AbsoluteFile> dirs) {
            return ((BatchPathFinder)this).findFilesExplicit((Seq<AbsoluteFile>)dirs);
        }

        @Override
        public final Seq<AbsoluteFile> findMatchingFiles(boolean filterFilesToo, Seq<AbsoluteFile> paths) {
            return ((BatchPathFinder)this).findMatchingFiles(filterFilesToo, (Seq<AbsoluteFile>)paths);
        }

        @Override
        public Function1<Path, Object> matches() {
            return this.matches;
        }

        @Override
        public final Seq<AbsoluteFile> findFiles(Seq<AbsoluteFile> dir) {
            return (Seq)this.git.status(dir).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GitDirtyFiles.$anonfun$findFiles$7(this, ((AbsoluteFile)x).path())));
        }

        public static final /* synthetic */ boolean $anonfun$findFiles$7(GitDirtyFiles $this, Path x) {
            return BoxesRunTime.unboxToBoolean((Object)$this.matches().apply((Object)x));
        }

        public GitDirtyFiles(GitOps git, Function1<Path, Object> matches) {
            this.git = git;
            this.matches = matches;
            BatchPathFinder.$init$(this);
        }
    }

    public static final class GitFiles
    implements BatchPathFinder {
        private final GitOps git;
        private final Function1<Path, Object> matches;

        @Override
        public final Seq<AbsoluteFile> findFilesExplicit(Seq<AbsoluteFile> dirs) {
            return ((BatchPathFinder)this).findFilesExplicit((Seq<AbsoluteFile>)dirs);
        }

        @Override
        public final Seq<AbsoluteFile> findMatchingFiles(boolean filterFilesToo, Seq<AbsoluteFile> paths) {
            return ((BatchPathFinder)this).findMatchingFiles(filterFilesToo, (Seq<AbsoluteFile>)paths);
        }

        @Override
        public Function1<Path, Object> matches() {
            return this.matches;
        }

        @Override
        public final Seq<AbsoluteFile> findFiles(Seq<AbsoluteFile> dir) {
            return (Seq)this.git.lsTree(dir).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GitFiles.$anonfun$findFiles$5(this, ((AbsoluteFile)x).path())));
        }

        public static final /* synthetic */ boolean $anonfun$findFiles$5(GitFiles $this, Path x) {
            return BoxesRunTime.unboxToBoolean((Object)$this.matches().apply((Object)x));
        }

        public GitFiles(GitOps git, Function1<Path, Object> matches) {
            this.git = git;
            this.matches = matches;
            BatchPathFinder.$init$(this);
        }
    }
}

