/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.sysops;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import org.scalafmt.CompatCollections$;
import org.scalafmt.sysops.AbsoluteFile;
import org.scalafmt.sysops.AbsoluteFile$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.io.Codec;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class FileOps$ {
    public static final FileOps$ MODULE$ = new FileOps$();

    /*
     * WARNING - void declaration
     */
    public long getLastModifiedMsec(Path file) {
        void var3_3;
        BasicFileAttributes attributes = this.getAttributesNoLinks(file);
        long mtime = attributes.lastModifiedTime().toMillis();
        return attributes.isSymbolicLink() ? package$.MODULE$.max(mtime, Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()) : var3_3;
    }

    public long getLastModifiedMsecNoLinks(Path file) {
        return Files.getLastModifiedTime(file, LinkOption.NOFOLLOW_LINKS).toMillis();
    }

    public boolean isDirectory(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    public boolean isDirectoryNoLinks(Path file) {
        return Files.isDirectory(file, LinkOption.NOFOLLOW_LINKS);
    }

    public boolean isRegularFile(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    public boolean isRegularFileNoLinks(Path file) {
        return Files.isRegularFile(file, LinkOption.NOFOLLOW_LINKS);
    }

    public BasicFileAttributes getAttributes(Path file) {
        return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
    }

    public BasicFileAttributes getAttributesNoLinks(Path file) {
        return Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    public Seq<Path> listFiles(String path) {
        return this.listFiles(this.getFile(path));
    }

    public Seq<Path> listFiles(Path file) {
        return this.listFiles(file, (Function2<Path, BasicFileAttributes, Object>)(Function2 & Serializable)(x$1, a) -> BoxesRunTime.boxToBoolean((boolean)a.isRegularFile()));
    }

    public Seq<Path> listFiles(Path file, Function2<Path, BasicFileAttributes, Object> matches) {
        List list;
        try (Stream<Path> iter = Files.find(file, Integer.MAX_VALUE, (p, a) -> BoxesRunTime.unboxToBoolean((Object)matches.apply(p, a)), new FileVisitOption[0]);){
            list = CompatCollections$.MODULE$.JavaConverters().IteratorHasAsScala(iter.iterator()).asScala().toList();
        }
        return list;
    }

    public String readFile(String filename, Codec codec) {
        String string;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new URL(filename));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            URL url = (URL)success.value();
            string = this.readFile(url, codec);
        } else {
            string = this.readFile(this.getFile(filename), codec);
        }
        return string;
    }

    public String readFile(URL url, Codec codec) {
        boolean isFile = Option$.MODULE$.apply((Object)url.getProtocol()).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileOps$.$anonfun$readFile$2(x$1)));
        return isFile ? this.readAsURI(url.toURI(), codec) : this.readAsURL(url, codec);
    }

    public String readAsURL(URL url, Codec codec) {
        return (String)Using$.MODULE$.resource((Object)Source$.MODULE$.fromURL(url, codec), (Function1 & Serializable)x$2 -> x$2.getLines().mkString("", "\n", "\n"), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String readAsURI(URI uri, Codec codec) {
        return this.readFile(Paths.get(uri), codec);
    }

    public String readFile(Path file, Codec codec) {
        return new String(Files.readAllBytes(file), codec.charSet());
    }

    public Path getFile(String path) {
        return this.getPath(path, (Seq<String>)Nil$.MODULE$);
    }

    public Path getFile(Seq<String> path) {
        return this.getPath((String)path.head(), (Seq<String>)((Seq)path.tail()));
    }

    public Path getPath(String head, Seq<String> tail) {
        return Paths.get(head, (String[])tail.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void writeFile(Path path, String content, Codec codec) {
        byte[] bytes = content.getBytes(codec.charSet());
        Files.write(path, bytes, new OpenOption[0]);
    }

    public void writeFile(String filename, String content, Codec codec) {
        this.writeFile(this.getFile(filename), content, codec);
    }

    public boolean isMarkdown(String filename) {
        return filename.endsWith(".md");
    }

    public boolean isAmmonite(String filename) {
        return filename.endsWith(".sc");
    }

    public boolean isSbt(String filename) {
        return filename.endsWith(".sbt");
    }

    public Option<Try<Path>> getCanonicalConfigFile(Path workingDirectory, Option<Path> config) {
        return (Option)config.fold((Function0 & Serializable)() -> MODULE$.tryGetConfigInDir(workingDirectory), (Function1 & Serializable)x -> {
            Path file = AbsoluteFile$.MODULE$.join$extension(workingDirectory, (Path)x);
            return MODULE$.tryCheckConfigFile(file).orElse((Function0 & Serializable)() -> new Some((Object)new Failure((Throwable)new NoSuchFileException(new StringBuilder(16).append("Config missing: ").append(new AbsoluteFile(file)).toString()))));
        });
    }

    public Option<Path> getCanonicalConfigFile$default$2() {
        return None$.MODULE$;
    }

    public Option<Try<Path>> tryGetConfigInDir(Path dir) {
        return this.tryCheckConfigFile(AbsoluteFile$.MODULE$.$div$extension(dir, ".scalafmt.conf"));
    }

    private Option<Try<Path>> tryCheckConfigFile(Path file) {
        return !AbsoluteFile$.MODULE$.exists$extension(file) ? None$.MODULE$ : (AbsoluteFile$.MODULE$.isRegularFile$extension(file) ? new Some((Object)new Success((Object)file)) : new Some((Object)new Failure((Throwable)new AccessDeniedException(new StringBuilder(19).append("Config not a file: ").append(new AbsoluteFile(file)).toString()))));
    }

    public Function1<Path, Object> getFileMatcher(Seq<Path> paths) {
        Builder dirBuilder = scala.package$.MODULE$.Seq().newBuilder();
        Builder fileBuilder = Predef$.MODULE$.Set().newBuilder();
        paths.foreach((Function1 & Serializable)path -> MODULE$.isRegularFile((Path)path) ? (Builder)fileBuilder.$plus$eq(path) : (Builder)dirBuilder.$plus$eq(path));
        Seq dirs = (Seq)dirBuilder.result();
        Set files = (Set)fileBuilder.result();
        return (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FileOps$.$anonfun$getFileMatcher$2(files, dirs, x));
    }

    public static final /* synthetic */ boolean $anonfun$readFile$2(String x$1) {
        return "file".equalsIgnoreCase(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getFileMatcher$3(String filename$2, String sep$1, Path dir) {
        String dirname = ((Object)dir).toString();
        return filename$2.startsWith(dirname) && (filename$2.length() == dirname.length() || filename$2.startsWith(sep$1, dirname.length()));
    }

    public static final /* synthetic */ boolean $anonfun$getFileMatcher$2(Set files$1, Seq dirs$1, Path x) {
        String sep;
        String filename;
        return files$1.apply((Object)x) || dirs$1.exists(arg_0 -> FileOps$.$anonfun$getFileMatcher$3$adapted(filename = ((Object)x).toString(), sep = x.getFileSystem().getSeparator(), arg_0));
    }

    private FileOps$() {
    }

    public static final /* synthetic */ Object $anonfun$getFileMatcher$3$adapted(String filename$2, String sep$1, Path dir) {
        return BoxesRunTime.boxToBoolean((boolean)FileOps$.$anonfun$getFileMatcher$3(filename$2, sep$1, dir));
    }
}

