/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.sysops;

import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.scalafmt.CompatCollections$;
import org.scalafmt.sysops.FileOps$;
import org.scalafmt.sysops.FileStat;
import org.scalafmt.sysops.GranularPlatformAsyncOps$;
import org.scalafmt.sysops.PlatformFileOps;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.Codec;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class PlatformFileOps$ {
    public static final PlatformFileOps$ MODULE$ = new PlatformFileOps$();

    public boolean exists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    public void symlink(Path link, Path file) {
        Files.createSymbolicLink(link, file, new FileAttribute[0]);
    }

    public void mkdir(Path file) {
        Files.createDirectory(file, new FileAttribute[0]);
    }

    public void mkdirs(Path file) {
        Files.createDirectories(file, new FileAttribute[0]);
    }

    public Path mkdtemp(String prefix) {
        return Files.createTempDirectory(prefix, new FileAttribute[0]);
    }

    public void move(Path src, Path dst) {
        Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING);
    }

    public void delete(Path file) {
        Files.delete(file);
    }

    public boolean isDirectory(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    public boolean isRegularFile(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    public boolean isRegularFileNoLinks(Path file) {
        return Files.isRegularFile(file, LinkOption.NOFOLLOW_LINKS);
    }

    public Option<FileStat> getFileStat(Path file, boolean followLinks) {
        Nil$ linkOpts = followLinks ? Nil$.MODULE$ : new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$);
        return Try$.MODULE$.apply(() -> PlatformFileOps$.$anonfun$getFileStat$1(file, (Seq)linkOpts)).toOption().map((Function1 & Serializable)x$1 -> new PlatformFileOps.NioFileStat((BasicFileAttributes)x$1));
    }

    public Seq<Path> listFiles(Path file, Function2<Path, FileStat, Object> matches) {
        List list;
        try (Stream<Path> iter = Files.find(file, Integer.MAX_VALUE, (p, a) -> BoxesRunTime.unboxToBoolean((Object)matches.apply(p, (Object)new PlatformFileOps.NioFileStat((BasicFileAttributes)a))), new FileVisitOption[0]);){
            list = CompatCollections$.MODULE$.JavaConverters().IteratorHasAsScala(iter.iterator()).asScala().toList();
        }
        return list;
    }

    public String readFile(Path file, Codec codec) {
        return new String(Files.readAllBytes(file), codec.charSet());
    }

    public Future<String> readFileAsync(Path file, Codec codec) {
        return GranularPlatformAsyncOps$.MODULE$.readFileAsync(file, codec);
    }

    public Future<String> readStdinAsync() {
        return Future$.MODULE$.successful((Object)FileOps$.MODULE$.readInputStream(System.in));
    }

    public void writeFile(Path path, String content, Codec codec) {
        byte[] bytes = content.getBytes(codec.charSet());
        Files.write(path, bytes, new OpenOption[0]);
    }

    public Future<BoxedUnit> writeFileAsync(Path path, String content, Codec codec) {
        return GranularPlatformAsyncOps$.MODULE$.writeFileAsync(path, content, codec);
    }

    public String cwd() {
        return System.getProperty("user.dir");
    }

    public static final /* synthetic */ BasicFileAttributes $anonfun$getFileStat$1(Path file$1, Seq linkOpts$1) {
        return Files.readAttributes(file$1, BasicFileAttributes.class, (LinkOption[])linkOpts$1.toArray(ClassTag$.MODULE$.apply(LinkOption.class)));
    }

    private PlatformFileOps$() {
    }
}

