/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.classpath;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.scalameta.collections.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.meta.internal.classpath.Classdir;
import scala.meta.internal.classpath.Classfile;
import scala.meta.internal.classpath.ClasspathElement;
import scala.meta.internal.classpath.ClasspathIndex$;
import scala.meta.internal.classpath.ClasspathIndex$Builder$;
import scala.meta.internal.classpath.CompressedClassfile;
import scala.meta.internal.classpath.UncompressedClassfile;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.Classpath;
import scala.meta.io.Classpath$;
import scala.meta.io.RelativePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\u000f\u001e\u0005\u0019B\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011)\u0019!C\u0001e!A\u0001\n\u0001B\u0001B\u0003%1\u0007C\u0003J\u0001\u0011%!\nC\u0003O\u0001\u0011\u0005q\nC\u0003O\u0001\u0011\u0005\u0001\fC\u0003^\u0001\u0011\u0005a\fC\u0003d\u0001\u0011\u0005CmB\u0003f;!\u0005aMB\u0003\u001d;!\u0005q\rC\u0003J\u0015\u0011\u0005\u0001\u000eC\u0003j\u0015\u0011\u0005!\u000eC\u0003j\u0015\u0011\u0005AN\u0002\u0003q\u0015\u0019\t\b\u0002\u0003\u0010\u000f\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0011=t!\u0011!Q\u0001\n}CQ!\u0013\b\u0005\u0002IDq!\r\bC\u0002\u0013%q\u000f\u0003\u0004I\u001d\u0001\u0006I\u0001\u001f\u0005\u0006{:!\tA \u0005\u0007\u007f:!\t!!\u0001\t\u000f\u0005%a\u0002\"\u0003\u0002\u0002!9\u00111\u0002\b\u0005\n\u00055\u0001bBA\f\u001d\u0011%\u0011\u0011\u0004\u0005\b\u0003[qA\u0011BA\u0018\u0011\u001d\t)D\u0004C\u0005\u0003oAq!!\u0010\u000f\t\u0013\tyD\u0001\bDY\u0006\u001c8\u000f]1uQ&sG-\u001a=\u000b\u0005yy\u0012!C2mCN\u001c\b/\u0019;i\u0015\t\u0001\u0013%\u0001\u0005j]R,'O\\1m\u0015\t\u00113%\u0001\u0003nKR\f'\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001a\n\t\u0003Q%j\u0011aI\u0005\u0003U\r\u0012a!\u00118z%\u00164\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\"\u0003\tIw.\u0003\u00021[\tI1\t\\1tgB\fG\u000f[\u0001\u0005I&\u00148/F\u00014!\u0011!t'\u000f#\u000e\u0003UR!AN\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00029k\t\u0019Q*\u00199\u0011\u0005i\neBA\u001e@!\ta4%D\u0001>\u0015\tqT%\u0001\u0004=e>|GOP\u0005\u0003\u0001\u000e\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001i\t\t\u0003\u000b\u001ak\u0011!H\u0005\u0003\u000fv\u0011\u0001b\u00117bgN$\u0017N]\u0001\u0006I&\u00148\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-cU\n\u0005\u0002F\u0001!)a\u0004\u0002a\u0001W!)\u0011\u0007\u0002a\u0001g\u0005aq-\u001a;DY\u0006\u001c8OZ5mKR\u0011\u0001K\u0016\t\u0004QE\u001b\u0016B\u0001*$\u0005\u0019y\u0005\u000f^5p]B\u0011Q\tV\u0005\u0003+v\u0011\u0011b\u00117bgN4\u0017\u000e\\3\t\u000b]+\u0001\u0019A\u001d\u0002\tA\fG\u000f\u001b\u000b\u0004!f[\u0006\"\u0002.\u0007\u0001\u0004I\u0014!\u00033je\u0016\u001cGo\u001c:z\u0011\u0015af\u00011\u0001:\u0003!1\u0017\u000e\\3oC6,\u0017AC5t\u00072\f7o\u001d3jeR\u0011qL\u0019\t\u0003Q\u0001L!!Y\u0012\u0003\u000f\t{w\u000e\\3b]\")qk\u0002a\u0001s\u0005AAo\\*ue&tw\rF\u0001:\u00039\u0019E.Y:ta\u0006$\b.\u00138eKb\u0004\"!\u0012\u0006\u0014\u0005)9C#\u00014\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005-[\u0007\"\u0002\u0010\r\u0001\u0004YCcA&n]\")a$\u0004a\u0001W!)q.\u0004a\u0001?\u0006Q\u0011N\\2mk\u0012,'\nZ6\u0003\u000f\t+\u0018\u000e\u001c3feN\u0011ab\n\u000b\u0004gV4\bC\u0001;\u000f\u001b\u0005Q\u0001\"\u0002\u0010\u0012\u0001\u0004Y\u0003\"B8\u0012\u0001\u0004yV#\u0001=\u0011\ted\u0018\bR\u0007\u0002u*\u001110N\u0001\b[V$\u0018M\u00197f\u0013\tA$0\u0001\u0004sKN,H\u000e\u001e\u000b\u0002\u0017\u0006\u0011R\r\u001f9b]\u0012TEm[\"mCN\u001c\b/\u0019;i)\t\t\u0019\u0001E\u0002)\u0003\u000bI1!a\u0002$\u0005\u0011)f.\u001b;\u0002%\u0015D\b/\u00198e\u0015J$8\t\\1tgB\fG\u000f[\u0001\fKb\u0004\u0018M\u001c3F]R\u0014\u0018\u0010\u0006\u0003\u0002\u0004\u0005=\u0001BB,\u0018\u0001\u0004\t\t\u0002E\u0002-\u0003'I1!!\u0006.\u00051\t%m]8mkR,\u0007+\u0019;i\u0003%\tG\rZ'f[\n,'\u000f\u0006\u0005\u0002\u0004\u0005m\u0011qDA\u0012\u0011\u0019\ti\u0002\u0007a\u0001\t\u00061\u0001/\u0019:f]RDa!!\t\u0019\u0001\u0004I\u0014\u0001\u00032bg\u0016t\u0017-\\3\t\u000f\u0005\u0015\u0002\u00041\u0001\u0002(\u00059Q\r\\3nK:$\bcA#\u0002*%\u0019\u00111F\u000f\u0003!\rc\u0017m]:qCRDW\t\\3nK:$\u0018aC4fi\u000ec\u0017m]:eSJ$2\u0001RA\u0019\u0011\u0019\t\u0019$\u0007a\u0001s\u0005!a.Y7f\u00039)\u0007\u0010]1oI*\u000b'/\u00128uef$B!a\u0001\u0002:!9\u00111\b\u000eA\u0002\u0005E\u0011a\u00026beB\fG\u000f[\u0001\u000fKb\u0004\u0018M\u001c3ESJ,e\u000e\u001e:z)\u0011\t\u0019!!\u0011\t\u000f\u0005\r3\u00041\u0001\u0002\u0012\u0005!!o\\8u\u0001")
public final class ClasspathIndex {
    private final Classpath classpath;
    private final Map<String, Classdir> dirs;

    public static ClasspathIndex apply(Classpath classpath, boolean bl) {
        return ClasspathIndex$.MODULE$.apply(classpath, bl);
    }

    public static ClasspathIndex apply(Classpath classpath) {
        return ClasspathIndex$.MODULE$.apply(classpath);
    }

    public Map<String, Classdir> dirs() {
        return this.dirs;
    }

    public Option<Classfile> getClassfile(String path) {
        return this.getClassfile(PathIO$.MODULE$.dirname(path), PathIO$.MODULE$.basename(path));
    }

    public Option<Classfile> getClassfile(String directory, String filename) {
        Option option = this.dirs().get((Object)directory);
        if (option instanceof Some) {
            Some some = (Some)option;
            Classdir pkg = (Classdir)some.value();
            return pkg.resolve(filename).collect((PartialFunction)new Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends ClasspathElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Classfile) {
                        Classfile classfile = (Classfile)A1;
                        return (B1)classfile;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(ClasspathElement x1) {
                    ClasspathElement classpathElement = x1;
                    return classpathElement instanceof Classfile;
                }
            });
        }
        return None$.MODULE$;
    }

    public boolean isClassdir(String path) {
        return this.dirs().contains((Object)path);
    }

    public String toString() {
        return new StringBuilder(16).append("ClasspathIndex(").append(this.classpath).append(")").toString();
    }

    public ClasspathIndex(Classpath classpath, Map<String, Classdir> dirs) {
        this.classpath = classpath;
        this.dirs = dirs;
    }

    private static final class Builder {
        private final Classpath classpath;
        private final boolean includeJdk;
        private final scala.collection.mutable.Map<String, Classdir> dirs;

        private scala.collection.mutable.Map<String, Classdir> dirs() {
            return this.dirs;
        }

        public ClasspathIndex result() {
            Classdir root = new Classdir("/");
            this.dirs().update((Object)root.relativeUri(), (Object)root);
            if (this.includeJdk) {
                this.expandJdkClasspath();
            }
            this.classpath.entries().foreach((Function1 & java.io.Serializable & Serializable)path -> {
                this.expandEntry(path);
                return BoxedUnit.UNIT;
            });
            return new ClasspathIndex(this.classpath, (Map<String, Classdir>)this.dirs());
        }

        public void expandJdkClasspath() {
            if (Properties$.MODULE$.isJavaAtLeast("9")) {
                this.expandJrtClasspath();
                return;
            }
            scala.sys.package$.MODULE$.props().collectFirst((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Builder $outer;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String k = (String)A1._1();
                        String v = (String)A1._2();
                        if (k.endsWith(".boot.class.path")) {
                            ((List)Classpath$.MODULE$.apply(v).entries().filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Builder$$anonfun$expandJdkClasspath$1.$anonfun$applyOrElse$1(x$1)))).foreach((Function1 & java.io.Serializable & Serializable)jarpath -> {
                                Builder$$anonfun$expandJdkClasspath$1.$anonfun$applyOrElse$2(this, jarpath);
                                return BoxedUnit.UNIT;
                            });
                            return (B1)BoxedUnit.UNIT;
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    String k;
                    Tuple2<String, String> tuple2 = x1;
                    return tuple2 != null && (k = (String)tuple2._1()).endsWith(".boot.class.path");
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AbsolutePath x$1) {
                    return x$1.isFile();
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$2(Builder$$anonfun$expandJdkClasspath$1 $this, AbsolutePath jarpath) {
                    $this.$outer.scala$meta$internal$classpath$ClasspathIndex$Builder$$expandJarEntry(jarpath);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(scala.meta.io.AbsolutePath ), $anonfun$applyOrElse$2$adapted(scala.meta.internal.classpath.ClasspathIndex$Builder$$anonfun$expandJdkClasspath$1 scala.meta.io.AbsolutePath )}, serializedLambda);
                }
            }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
                throw new IllegalStateException("Unable to detect bootclasspath");
            });
        }

        private void expandJrtClasspath() {
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            Path dir = fs.getPath("/packages", new String[0]);
            package$.MODULE$.XtensionJavaIterator(Files.newDirectoryStream(dir).iterator()).toScala().map((Function1 & java.io.Serializable & Serializable)pkg -> {
                String symbol = new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(((Object)pkg).toString())).stripPrefix("/packages/").replace('.', '/')).append("/").toString();
                Classdir classdir = this.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(symbol);
                return new Tuple3(pkg, (Object)symbol, (Object)classdir);
            }).foreach((Function1 & java.io.Serializable & Serializable)x$2 -> {
                Builder.$anonfun$expandJrtClasspath$2(x$2);
                return BoxedUnit.UNIT;
            });
        }

        private void expandEntry(AbsolutePath path) {
            if (path.isFile()) {
                this.scala$meta$internal$classpath$ClasspathIndex$Builder$$expandJarEntry(path);
                return;
            }
            if (path.isDirectory()) {
                this.expandDirEntry(path);
                return;
            }
        }

        public void scala$meta$internal$classpath$ClasspathIndex$Builder$$addMember(Classdir parent, String basename, ClasspathElement element) {
            if (!parent.members().contains((Object)basename)) {
                parent.members().update((Object)basename, (Object)element);
                return;
            }
        }

        public Classdir scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(String name) {
            Option option = this.dirs().get((Object)name);
            if (option instanceof Some) {
                Some some = (Some)option;
                Classdir dir = (Classdir)some.value();
                return dir;
            }
            Classdir parent = this.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(PathIO$.MODULE$.dirname(name));
            Classdir element = new Classdir(name);
            parent.members().update((Object)PathIO$.MODULE$.basename(name), (Object)element);
            this.dirs().update((Object)name, (Object)element);
            return element;
        }

        public void scala$meta$internal$classpath$ClasspathIndex$Builder$$expandJarEntry(AbsolutePath jarpath) {
            JarFile jarFile;
            File file = jarpath.toFile();
            try {
                jarFile = new JarFile(file);
            }
            catch (ZipException zex) {
                return;
            }
            try (JarFile jar = jarFile;){
                String classpathAttr;
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry element = entries.nextElement();
                    if (element.getName().startsWith("META-INF")) continue;
                    Classdir parent = this.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(element.isDirectory() ? element.getName() : PathIO$.MODULE$.dirname(element.getName()));
                    CompressedClassfile inJar = new CompressedClassfile(element, file);
                    this.scala$meta$internal$classpath$ClasspathIndex$Builder$$addMember(parent, PathIO$.MODULE$.basename(element.getName()), inJar);
                }
                Manifest manifest = jar.getManifest();
                if (manifest != null && (classpathAttr = manifest.getMainAttributes().getValue("Class-Path")) != null) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classpathAttr.split(" "))).foreach((Function1 & java.io.Serializable & Serializable)relpath -> {
                        Builder.$anonfun$expandJarEntry$1(this, jarpath, relpath);
                        return BoxedUnit.UNIT;
                    });
                }
            }
        }

        private void expandDirEntry(AbsolutePath root) {
            Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, root){
                private final /* synthetic */ Builder $outer;
                private final AbsolutePath root$1;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    block0: {
                        String name = ((Object)file.getFileName()).toString();
                        if (!name.endsWith(".class")) break block0;
                        RelativePath relpath = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()).toRelative(this.root$1);
                        String reluri = relpath.toURI(false).toString();
                        String basename = PathIO$.MODULE$.basename(reluri);
                        String dirname = PathIO$.MODULE$.dirname(reluri);
                        Classdir classdir = this.$outer.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(dirname);
                        UncompressedClassfile element = new UncompressedClassfile(reluri, AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()));
                        this.$outer.scala$meta$internal$classpath$ClasspathIndex$Builder$$addMember(classdir, basename, element);
                    }
                    return super.visitFile(file, attrs);
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (dir.endsWith("META-INF")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.root$1 = root$1;
                }
            });
        }

        public static final /* synthetic */ void $anonfun$expandJrtClasspath$3(Classdir classdir$1, Path moduleLink) {
            Path module = !Files.isSymbolicLink(moduleLink) ? moduleLink : Files.readSymbolicLink(moduleLink);
            classdir$1.modules_$eq((List<Path>)classdir$1.modules().$colon$colon((Object)module));
        }

        public static final /* synthetic */ void $anonfun$expandJrtClasspath$2(Tuple3 x$2) {
            Tuple3 tuple3 = x$2;
            if (tuple3 != null) {
                Path pkg = (Path)tuple3._1();
                Classdir classdir = (Classdir)tuple3._3();
                package$.MODULE$.XtensionJavaIterator(Files.list(pkg).iterator()).toScala().foreach((Function1 & java.io.Serializable & Serializable)moduleLink -> {
                    Builder.$anonfun$expandJrtClasspath$3(classdir, moduleLink);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError((Object)tuple3);
        }

        public static final /* synthetic */ void $anonfun$expandJarEntry$1(Builder $this, AbsolutePath jarpath$1, String relpath) {
            AbsolutePath abspath = AbsolutePath$.MODULE$.apply(jarpath$1.toNIO().getParent(), AbsolutePath$.MODULE$.workingDirectory()).resolve(relpath);
            if (abspath.isFile() || abspath.isDirectory()) {
                $this.expandEntry(abspath);
                return;
            }
        }

        public Builder(Classpath classpath, boolean includeJdk) {
            this.classpath = classpath;
            this.includeJdk = includeJdk;
            this.dirs = Map$.MODULE$.empty();
        }
    }
}

