/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.LongArrayList;
import com.google.protobuf.MapFieldSchema;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Schema;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLiteSchema;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> PROTO2_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(false);
    private static final UnknownFieldSchema<?, ?> PROTO3_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(true);
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();
    private static final int DEFAULT_LOOK_UP_START_NUMBER = 40;

    private SchemaUtil() {
    }

    public static void requireGeneratedMessage(Class<?> messageType2) {
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType2) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom(messageType2)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessage or GeneratedMessageLite");
        }
    }

    public static void writeDouble(int fieldNumber, double value2, Writer writer) throws IOException {
        if (Double.compare(value2, 0.0) != 0) {
            writer.writeDouble(fieldNumber, value2);
        }
    }

    public static void writeFloat(int fieldNumber, float value2, Writer writer) throws IOException {
        if (Float.compare(value2, 0.0f) != 0) {
            writer.writeFloat(fieldNumber, value2);
        }
    }

    public static void writeInt64(int fieldNumber, long value2, Writer writer) throws IOException {
        if (value2 != 0L) {
            writer.writeInt64(fieldNumber, value2);
        }
    }

    public static void writeUInt64(int fieldNumber, long value2, Writer writer) throws IOException {
        if (value2 != 0L) {
            writer.writeUInt64(fieldNumber, value2);
        }
    }

    public static void writeSInt64(int fieldNumber, long value2, Writer writer) throws IOException {
        if (value2 != 0L) {
            writer.writeSInt64(fieldNumber, value2);
        }
    }

    public static void writeFixed64(int fieldNumber, long value2, Writer writer) throws IOException {
        if (value2 != 0L) {
            writer.writeFixed64(fieldNumber, value2);
        }
    }

    public static void writeSFixed64(int fieldNumber, long value2, Writer writer) throws IOException {
        if (value2 != 0L) {
            writer.writeSFixed64(fieldNumber, value2);
        }
    }

    public static void writeInt32(int fieldNumber, int value2, Writer writer) throws IOException {
        if (value2 != 0) {
            writer.writeInt32(fieldNumber, value2);
        }
    }

    public static void writeUInt32(int fieldNumber, int value2, Writer writer) throws IOException {
        if (value2 != 0) {
            writer.writeUInt32(fieldNumber, value2);
        }
    }

    public static void writeSInt32(int fieldNumber, int value2, Writer writer) throws IOException {
        if (value2 != 0) {
            writer.writeSInt32(fieldNumber, value2);
        }
    }

    public static void writeFixed32(int fieldNumber, int value2, Writer writer) throws IOException {
        if (value2 != 0) {
            writer.writeFixed32(fieldNumber, value2);
        }
    }

    public static void writeSFixed32(int fieldNumber, int value2, Writer writer) throws IOException {
        if (value2 != 0) {
            writer.writeSFixed32(fieldNumber, value2);
        }
    }

    public static void writeEnum(int fieldNumber, int value2, Writer writer) throws IOException {
        if (value2 != 0) {
            writer.writeEnum(fieldNumber, value2);
        }
    }

    public static void writeBool(int fieldNumber, boolean value2, Writer writer) throws IOException {
        if (value2) {
            writer.writeBool(fieldNumber, true);
        }
    }

    public static void writeString(int fieldNumber, Object value2, Writer writer) throws IOException {
        if (value2 instanceof String) {
            SchemaUtil.writeStringInternal(fieldNumber, (String)value2, writer);
        } else {
            SchemaUtil.writeBytes(fieldNumber, (ByteString)value2, writer);
        }
    }

    private static void writeStringInternal(int fieldNumber, String value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeString(fieldNumber, value2);
        }
    }

    public static void writeBytes(int fieldNumber, ByteString value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeBytes(fieldNumber, value2);
        }
    }

    public static void writeMessage(int fieldNumber, Object value2, Writer writer) throws IOException {
        if (value2 != null) {
            writer.writeMessage(fieldNumber, value2);
        }
    }

    public static void writeDoubleList(int fieldNumber, List<Double> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeDoubleList(fieldNumber, value2, packed2);
        }
    }

    public static void writeFloatList(int fieldNumber, List<Float> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeFloatList(fieldNumber, value2, packed2);
        }
    }

    public static void writeInt64List(int fieldNumber, List<Long> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeInt64List(fieldNumber, value2, packed2);
        }
    }

    public static void writeUInt64List(int fieldNumber, List<Long> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeUInt64List(fieldNumber, value2, packed2);
        }
    }

    public static void writeSInt64List(int fieldNumber, List<Long> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeSInt64List(fieldNumber, value2, packed2);
        }
    }

    public static void writeFixed64List(int fieldNumber, List<Long> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeFixed64List(fieldNumber, value2, packed2);
        }
    }

    public static void writeSFixed64List(int fieldNumber, List<Long> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeSFixed64List(fieldNumber, value2, packed2);
        }
    }

    public static void writeInt32List(int fieldNumber, List<Integer> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeInt32List(fieldNumber, value2, packed2);
        }
    }

    public static void writeUInt32List(int fieldNumber, List<Integer> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeUInt32List(fieldNumber, value2, packed2);
        }
    }

    public static void writeSInt32List(int fieldNumber, List<Integer> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeSInt32List(fieldNumber, value2, packed2);
        }
    }

    public static void writeFixed32List(int fieldNumber, List<Integer> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeFixed32List(fieldNumber, value2, packed2);
        }
    }

    public static void writeSFixed32List(int fieldNumber, List<Integer> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeSFixed32List(fieldNumber, value2, packed2);
        }
    }

    public static void writeEnumList(int fieldNumber, List<Integer> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeEnumList(fieldNumber, value2, packed2);
        }
    }

    public static void writeBoolList(int fieldNumber, List<Boolean> value2, Writer writer, boolean packed2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeBoolList(fieldNumber, value2, packed2);
        }
    }

    public static void writeStringList(int fieldNumber, List<String> value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeStringList(fieldNumber, value2);
        }
    }

    public static void writeBytesList(int fieldNumber, List<ByteString> value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeBytesList(fieldNumber, value2);
        }
    }

    public static void writeMessageList(int fieldNumber, List<?> value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeMessageList(fieldNumber, value2);
        }
    }

    public static void writeMessageList(int fieldNumber, List<?> value2, Writer writer, Schema schema2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeMessageList(fieldNumber, value2, schema2);
        }
    }

    public static void writeLazyFieldList(int fieldNumber, List<?> value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            for (Object item : value2) {
                ((LazyFieldLite)item).writeTo(writer, fieldNumber);
            }
        }
    }

    public static void writeGroupList(int fieldNumber, List<?> value2, Writer writer) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeGroupList(fieldNumber, value2);
        }
    }

    public static void writeGroupList(int fieldNumber, List<?> value2, Writer writer, Schema schema2) throws IOException {
        if (value2 != null && !value2.isEmpty()) {
            writer.writeGroupList(fieldNumber, value2, schema2);
        }
    }

    static int computeSizeInt64ListNoTag(List<Long> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt64SizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeInt64List(int fieldNumber, List<Long> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeInt64ListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + list.size() * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeUInt64ListNoTag(List<Long> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt64SizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeUInt64List(int fieldNumber, List<Long> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeUInt64ListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + length * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeSInt64ListNoTag(List<Long> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt64SizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeSInt64List(int fieldNumber, List<Long> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeSInt64ListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + length * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeEnumListNoTag(List<Integer> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeEnumSizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeEnumSizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeEnumList(int fieldNumber, List<Integer> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeEnumListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + length * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeInt32ListNoTag(List<Integer> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt32SizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeInt32List(int fieldNumber, List<Integer> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeInt32ListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + length * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeUInt32ListNoTag(List<Integer> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt32SizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeUInt32List(int fieldNumber, List<Integer> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeUInt32ListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + length * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeSInt32ListNoTag(List<Integer> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt32SizeNoTag(list.get(i));
            }
        }
        return size;
    }

    static int computeSizeSInt32List(int fieldNumber, List<Integer> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeSInt32ListNoTag(list);
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return size + length * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeFixed32ListNoTag(List<?> list) {
        return list.size() * 4;
    }

    static int computeSizeFixed32List(int fieldNumber, List<?> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        if (packed2) {
            int dataSize = length * 4;
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(dataSize);
        }
        return length * CodedOutputStream.computeFixed32Size(fieldNumber, 0);
    }

    static int computeSizeFixed64ListNoTag(List<?> list) {
        return list.size() * 8;
    }

    static int computeSizeFixed64List(int fieldNumber, List<?> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        if (packed2) {
            int dataSize = length * 8;
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(dataSize);
        }
        return length * CodedOutputStream.computeFixed64Size(fieldNumber, 0L);
    }

    static int computeSizeBoolListNoTag(List<?> list) {
        return list.size();
    }

    static int computeSizeBoolList(int fieldNumber, List<?> list, boolean packed2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        if (packed2) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(length);
        }
        return length * CodedOutputStream.computeBoolSize(fieldNumber, true);
    }

    static int computeSizeStringList(int fieldNumber, List<?> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        if (list instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)list;
            for (int i = 0; i < length; ++i) {
                Object value2 = lazyList.getRaw(i);
                if (value2 instanceof ByteString) {
                    size += CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                    continue;
                }
                size += CodedOutputStream.computeStringSizeNoTag((String)value2);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object value3 = list.get(i);
                if (value3 instanceof ByteString) {
                    size += CodedOutputStream.computeBytesSizeNoTag((ByteString)value3);
                    continue;
                }
                size += CodedOutputStream.computeStringSizeNoTag((String)value3);
            }
        }
        return size;
    }

    static int computeSizeMessage(int fieldNumber, Object value2, Schema schema2) {
        if (value2 instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(fieldNumber, (LazyFieldLite)value2);
        }
        return CodedOutputStream.computeMessageSize(fieldNumber, (MessageLite)value2, schema2);
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < length; ++i) {
            Object value2 = list.get(i);
            if (value2 instanceof LazyFieldLite) {
                size += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)value2);
                continue;
            }
            size += CodedOutputStream.computeMessageSizeNoTag((MessageLite)value2);
        }
        return size;
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list, Schema schema2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < length; ++i) {
            Object value2 = list.get(i);
            if (value2 instanceof LazyFieldLite) {
                size += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)value2);
                continue;
            }
            size += CodedOutputStream.computeMessageSizeNoTag((MessageLite)value2, schema2);
        }
        return size;
    }

    static int computeSizeByteStringList(int fieldNumber, List<ByteString> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < list.size(); ++i) {
            size += CodedOutputStream.computeBytesSizeNoTag(list.get(i));
        }
        return size;
    }

    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < length; ++i) {
            size += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i));
        }
        return size;
    }

    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list, Schema schema2) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < length; ++i) {
            size += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i), schema2);
        }
        return size;
    }

    public static boolean shouldUseTableSwitch(FieldInfo[] fields2) {
        if (fields2.length == 0) {
            return false;
        }
        int lo2 = fields2[0].getFieldNumber();
        int hi2 = fields2[fields2.length - 1].getFieldNumber();
        return SchemaUtil.shouldUseTableSwitch(lo2, hi2, fields2.length);
    }

    public static boolean shouldUseTableSwitch(int lo2, int hi2, int numFields) {
        if (hi2 < 40) {
            return true;
        }
        long tableSpaceCost = (long)hi2 - (long)lo2 + 1L;
        long tableTimeCost = 3L;
        long lookupSpaceCost = 3L + 2L * (long)numFields;
        long lookupTimeCost = 3L + (long)numFields;
        return tableSpaceCost + 3L * tableTimeCost <= lookupSpaceCost + 3L * lookupTimeCost;
    }

    public static UnknownFieldSchema<?, ?> proto2UnknownFieldSetSchema() {
        return PROTO2_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> proto3UnknownFieldSetSchema() {
        return PROTO3_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema(boolean proto3) {
        try {
            Class<?> clz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clz == null) {
                return null;
            }
            return (UnknownFieldSchema)clz.getConstructor(Boolean.TYPE).newInstance(proto3);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        try {
            return Class.forName("com.google.protobuf.GeneratedMessageV3");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        try {
            return Class.forName("com.google.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable e) {
            return null;
        }
    }

    static Object getMapDefaultEntry(Class<?> clazz, String name2) {
        try {
            Class<?> holder = Class.forName(clazz.getName() + "$" + SchemaUtil.toCamelCase(name2, true) + "DefaultEntryHolder");
            Field[] fields2 = holder.getDeclaredFields();
            if (fields2.length != 1) {
                throw new IllegalStateException("Unable to look up map field default entry holder class for " + name2 + " in " + clazz.getName());
            }
            return UnsafeUtil.getStaticObject(fields2[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static String toCamelCase(String name2, boolean capNext) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if ('a' <= c && c <= 'z') {
                if (capNext) {
                    sb.append((char)(c + -32));
                } else {
                    sb.append(c);
                }
                capNext = false;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                if (i == 0 && !capNext) {
                    sb.append((char)(c - -32));
                } else {
                    sb.append(c);
                }
                capNext = false;
                continue;
            }
            if ('0' <= c && c <= '9') {
                sb.append(c);
                capNext = true;
                continue;
            }
            capNext = true;
        }
        return sb.toString();
    }

    static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T message2, T o, long offset) {
        Object merged = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(o, offset));
        UnsafeUtil.putObject(message2, offset, merged);
    }

    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> schema2, T message2, T other) {
        FieldSet<FT> otherExtensions = schema2.getExtensions(other);
        if (!otherExtensions.isEmpty()) {
            FieldSet<FT> messageExtensions = schema2.getMutableExtensions(message2);
            messageExtensions.mergeFrom(otherExtensions);
        }
    }

    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> schema2, T message2, T other) {
        UT messageUnknowns = schema2.getFromMessage(message2);
        UT otherUnknowns = schema2.getFromMessage(other);
        UT merged = schema2.merge(messageUnknowns, otherUnknowns);
        schema2.setToMessage(message2, merged);
    }

    static <UT, UB> UB filterUnknownEnumList(int number2, List<Integer> enumList2, Internal.EnumLiteMap<?> enumMap, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumMap == null) {
            return unknownFields;
        }
        if (enumList2 instanceof RandomAccess) {
            int writePos = 0;
            int size = enumList2.size();
            for (int readPos = 0; readPos < size; ++readPos) {
                int enumValue = enumList2.get(readPos);
                if (enumMap.findValueByNumber(enumValue) != null) {
                    if (readPos != writePos) {
                        enumList2.set(writePos, enumValue);
                    }
                    ++writePos;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(number2, enumValue, unknownFields, unknownFieldSchema);
            }
            if (writePos != size) {
                enumList2.subList(writePos, size).clear();
            }
        } else {
            Iterator<Integer> it = enumList2.iterator();
            while (it.hasNext()) {
                int enumValue = it.next();
                if (enumMap.findValueByNumber(enumValue) != null) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(number2, enumValue, unknownFields, unknownFieldSchema);
                it.remove();
            }
        }
        return unknownFields;
    }

    static <UT, UB> UB filterUnknownEnumList(int number2, List<Integer> enumList2, Internal.EnumVerifier enumVerifier, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumVerifier == null) {
            return unknownFields;
        }
        if (enumList2 instanceof RandomAccess) {
            int writePos = 0;
            int size = enumList2.size();
            for (int readPos = 0; readPos < size; ++readPos) {
                int enumValue = enumList2.get(readPos);
                if (enumVerifier.isInRange(enumValue)) {
                    if (readPos != writePos) {
                        enumList2.set(writePos, enumValue);
                    }
                    ++writePos;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(number2, enumValue, unknownFields, unknownFieldSchema);
            }
            if (writePos != size) {
                enumList2.subList(writePos, size).clear();
            }
        } else {
            Iterator<Integer> it = enumList2.iterator();
            while (it.hasNext()) {
                int enumValue = it.next();
                if (enumVerifier.isInRange(enumValue)) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(number2, enumValue, unknownFields, unknownFieldSchema);
                it.remove();
            }
        }
        return unknownFields;
    }

    static <UT, UB> UB storeUnknownEnum(int number2, int enumValue, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (unknownFields == null) {
            unknownFields = unknownFieldSchema.newBuilder();
        }
        unknownFieldSchema.addVarint(unknownFields, number2, enumValue);
        return unknownFields;
    }
}

