/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.prettyprinters;

import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.meta.Dialect;
import scala.meta.internal.tokens.Chars$;
import scala.meta.prettyprinters.Show;
import scala.meta.prettyprinters.Show$;
import scala.meta.prettyprinters.Structure;
import scala.meta.prettyprinters.Structure$;
import scala.meta.tokens.Token;
import scala.runtime.BoxesRunTime;

public final class TokenStructure$ {
    public static final TokenStructure$ MODULE$;

    static {
        new TokenStructure$();
    }

    public <T extends Token> Structure<T> apply() {
        return Structure$.MODULE$.apply(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Show.Result apply(Token x) {
                String string;
                Dialect dialect = x.dialect();
                Token token = x;
                if (token instanceof Token.Ident) {
                    Token.Ident ident = (Token.Ident)token;
                    string = ident.value();
                } else if (token instanceof Token.Constant.Char) {
                    Token.Constant.Char char_ = (Token.Constant.Char)token;
                    string = Chars$.MODULE$.escape(char_.value());
                } else if (token instanceof Token.Constant.String) {
                    Token.Constant.String string2 = (Token.Constant.String)token;
                    string = Chars$.MODULE$.escape(string2.value());
                } else if (token instanceof Token.Constant.Symbol) {
                    Token.Constant.Symbol symbol2 = (Token.Constant.Symbol)token;
                    string = Chars$.MODULE$.escape(symbol2.value().name());
                } else if (token instanceof Token.NumericConstant) {
                    Token.NumericConstant numericConstant = (Token.NumericConstant)token;
                    string = numericConstant.value().toString();
                } else if (token instanceof Token.Interpolation.Id) {
                    Token.Interpolation.Id id2 = (Token.Interpolation.Id)token;
                    string = Chars$.MODULE$.escape(id2.value());
                } else if (token instanceof Token.Interpolation.Start) {
                    Token.Interpolation.Start start2 = (Token.Interpolation.Start)token;
                    string = start2.text();
                } else if (token instanceof Token.Interpolation.Part) {
                    Token.Interpolation.Part part2 = (Token.Interpolation.Part)token;
                    string = Chars$.MODULE$.escape(part2.value());
                } else if (token instanceof Token.Interpolation.End) {
                    Token.Interpolation.End end2 = (Token.Interpolation.End)token;
                    string = end2.text();
                } else if (token instanceof Token.Xml.Part) {
                    Token.Xml.Part part3 = (Token.Xml.Part)token;
                    string = Chars$.MODULE$.escape(part3.value());
                } else if (token instanceof Token.Comment) {
                    Token.Comment comment = (Token.Comment)token;
                    string = Chars$.MODULE$.escape(comment.value());
                } else if (token instanceof Token.Ellipsis) {
                    Token.Ellipsis ellipsis2 = (Token.Ellipsis)token;
                    string = ((Object)BoxesRunTime.boxToInteger((int)ellipsis2.rank())).toString();
                } else if (token instanceof Token.Unquote) {
                    Token.Unquote unquote2 = (Token.Unquote)token;
                    string = unquote2.text();
                } else if (token instanceof Token.MultiHS) {
                    Token.MultiHS multiHS = (Token.MultiHS)token;
                    string = ((Object)BoxesRunTime.boxToInteger((int)multiHS.len())).toString();
                } else if (token instanceof Token.MultiNL) {
                    Token.MultiNL multiNL = (Token.MultiNL)token;
                    string = ((Object)BoxesRunTime.boxToInteger((int)multiNL.tokens().length())).toString();
                } else if (token instanceof Token.Invalid) {
                    Token.Invalid invalid = (Token.Invalid)token;
                    string = invalid.error();
                } else {
                    string = null;
                }
                String text2 = string;
                String name2 = x.getClass().getName();
                int idx = name2.lastIndexOf(".Token$");
                String label2 = idx < 0 ? x.name() : name2.substring(idx + 7).replace("$", ".");
                Show.Result syntax2 = text2 == null ? Show$.MODULE$.mkseq((Seq<Show.Result>)Nil$.MODULE$) : Show$.MODULE$.mkseq((Seq<Show.Result>)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply("("), Show$.MODULE$.printString().apply(text2), Show$.MODULE$.printString().apply(")")}));
                return Show$.MODULE$.mkseq((Seq<Show.Result>)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply(label2), syntax2, Show$.MODULE$.printString().apply(" ["), Show$.MODULE$.printString().apply(((Object)BoxesRunTime.boxToInteger((int)x.start())).toString()), Show$.MODULE$.printString().apply(".."), Show$.MODULE$.printString().apply(((Object)BoxesRunTime.boxToInteger((int)x.end())).toString()), Show$.MODULE$.printString().apply(")")}));
            }
        });
    }

    private TokenStructure$() {
        MODULE$ = this;
    }
}

