/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.BinaryReader;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Protobuf;
import com.google.protobuf.Reader;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class ExtensionSchemaLite
extends ExtensionSchema<GeneratedMessageLite.ExtensionDescriptor> {
    ExtensionSchemaLite() {
    }

    @Override
    boolean hasExtensions(MessageLite prototype) {
        return prototype instanceof GeneratedMessageLite.ExtendableMessage;
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getExtensions(Object message2) {
        return ((GeneratedMessageLite.ExtendableMessage)message2).extensions;
    }

    @Override
    void setExtensions(Object message2, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) {
        ((GeneratedMessageLite.ExtendableMessage)message2).extensions = extensions;
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getMutableExtensions(Object message2) {
        return ((GeneratedMessageLite.ExtendableMessage)message2).ensureExtensionsAreMutable();
    }

    @Override
    void makeImmutable(Object message2) {
        this.getExtensions(message2).makeImmutable();
    }

    @Override
    <UT, UB> UB parseExtension(Reader reader, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension2 = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        int fieldNumber = extension2.getNumber();
        if (extension2.descriptor.isRepeated() && extension2.descriptor.isPacked()) {
            ArrayList<Constable> value2 = null;
            switch (extension2.getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> list = new ArrayList<Double>();
                    reader.readDoubleList(list);
                    value2 = list;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> list = new ArrayList<Float>();
                    reader.readFloatList(list);
                    value2 = list;
                    break;
                }
                case INT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readInt64List(list);
                    value2 = list;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readUInt64List(list);
                    value2 = list;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readInt32List(list);
                    value2 = list;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readFixed64List(list);
                    value2 = list;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readFixed32List(list);
                    value2 = list;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    reader.readBoolList(list);
                    value2 = list;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readUInt32List(list);
                    value2 = list;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSFixed32List(list);
                    value2 = list;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSFixed64List(list);
                    value2 = list;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSInt32List(list);
                    value2 = list;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSInt64List(list);
                    value2 = list;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readEnumList(list);
                    unknownFields = SchemaUtil.filterUnknownEnumList(fieldNumber, list, extension2.descriptor.getEnumType(), unknownFields, unknownFieldSchema);
                    value2 = list;
                    break;
                }
                default: {
                    throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension2.descriptor.getLiteType()));
                }
            }
            extensions.setField(extension2.descriptor, value2);
        } else {
            Object value3 = null;
            if (extension2.getLiteType() == WireFormat.FieldType.ENUM) {
                int number2 = reader.readInt32();
                Object enumValue = extension2.descriptor.getEnumType().findValueByNumber(number2);
                if (enumValue == null) {
                    return SchemaUtil.storeUnknownEnum(fieldNumber, number2, unknownFields, unknownFieldSchema);
                }
                value3 = number2;
            } else {
                switch (extension2.getLiteType()) {
                    case DOUBLE: {
                        value3 = reader.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value3 = Float.valueOf(reader.readFloat());
                        break;
                    }
                    case INT64: {
                        value3 = reader.readInt64();
                        break;
                    }
                    case UINT64: {
                        value3 = reader.readUInt64();
                        break;
                    }
                    case INT32: {
                        value3 = reader.readInt32();
                        break;
                    }
                    case FIXED64: {
                        value3 = reader.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        value3 = reader.readFixed32();
                        break;
                    }
                    case BOOL: {
                        value3 = reader.readBool();
                        break;
                    }
                    case BYTES: {
                        value3 = reader.readBytes();
                        break;
                    }
                    case UINT32: {
                        value3 = reader.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value3 = reader.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        value3 = reader.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        value3 = reader.readSInt32();
                        break;
                    }
                    case SINT64: {
                        value3 = reader.readSInt64();
                        break;
                    }
                    case STRING: {
                        value3 = reader.readString();
                        break;
                    }
                    case GROUP: {
                        value3 = reader.readGroup(extension2.getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case MESSAGE: {
                        value3 = reader.readMessage(extension2.getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension2.isRepeated()) {
                extensions.addRepeatedField(extension2.descriptor, value3);
            } else {
                switch (extension2.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object oldValue = extensions.getField(extension2.descriptor);
                        if (oldValue == null) break;
                        value3 = Internal.mergeMessage(oldValue, value3);
                        break;
                    }
                }
                extensions.setField(extension2.descriptor, value3);
            }
        }
        return unknownFields;
    }

    @Override
    int extensionNumber(Map.Entry<?, ?> extension2) {
        GeneratedMessageLite.ExtensionDescriptor descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension2.getKey();
        return descriptor.getNumber();
    }

    @Override
    void serializeExtension(Writer writer, Map.Entry<?, ?> extension2) throws IOException {
        block42: {
            GeneratedMessageLite.ExtensionDescriptor descriptor;
            block41: {
                descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension2.getKey();
                if (!descriptor.isRepeated()) break block41;
                switch (descriptor.getLiteType()) {
                    case DOUBLE: {
                        SchemaUtil.writeDoubleList(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case FLOAT: {
                        SchemaUtil.writeFloatList(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case INT64: {
                        SchemaUtil.writeInt64List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case UINT64: {
                        SchemaUtil.writeUInt64List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case INT32: {
                        SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case FIXED64: {
                        SchemaUtil.writeFixed64List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case FIXED32: {
                        SchemaUtil.writeFixed32List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case BOOL: {
                        SchemaUtil.writeBoolList(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case BYTES: {
                        SchemaUtil.writeBytesList(descriptor.getNumber(), (List)extension2.getValue(), writer);
                        break;
                    }
                    case UINT32: {
                        SchemaUtil.writeUInt32List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case SFIXED32: {
                        SchemaUtil.writeSFixed32List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case SFIXED64: {
                        SchemaUtil.writeSFixed64List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case SINT32: {
                        SchemaUtil.writeSInt32List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case SINT64: {
                        SchemaUtil.writeSInt64List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case ENUM: {
                        SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension2.getValue(), writer, descriptor.isPacked());
                        break;
                    }
                    case STRING: {
                        SchemaUtil.writeStringList(descriptor.getNumber(), (List)extension2.getValue(), writer);
                        break;
                    }
                    case GROUP: {
                        List data2 = (List)extension2.getValue();
                        if (data2 != null && !data2.isEmpty()) {
                            SchemaUtil.writeGroupList(descriptor.getNumber(), (List)extension2.getValue(), writer, Protobuf.getInstance().schemaFor(data2.get(0).getClass()));
                            break;
                        }
                        break block42;
                    }
                    case MESSAGE: {
                        List data3 = (List)extension2.getValue();
                        if (data3 == null || data3.isEmpty()) break;
                        SchemaUtil.writeMessageList(descriptor.getNumber(), (List)extension2.getValue(), writer, Protobuf.getInstance().schemaFor(data3.get(0).getClass()));
                    }
                }
                break block42;
            }
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    writer.writeDouble(descriptor.getNumber(), (Double)extension2.getValue());
                    break;
                }
                case FLOAT: {
                    writer.writeFloat(descriptor.getNumber(), ((Float)extension2.getValue()).floatValue());
                    break;
                }
                case INT64: {
                    writer.writeInt64(descriptor.getNumber(), (Long)extension2.getValue());
                    break;
                }
                case UINT64: {
                    writer.writeUInt64(descriptor.getNumber(), (Long)extension2.getValue());
                    break;
                }
                case INT32: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension2.getValue());
                    break;
                }
                case FIXED64: {
                    writer.writeFixed64(descriptor.getNumber(), (Long)extension2.getValue());
                    break;
                }
                case FIXED32: {
                    writer.writeFixed32(descriptor.getNumber(), (Integer)extension2.getValue());
                    break;
                }
                case BOOL: {
                    writer.writeBool(descriptor.getNumber(), (Boolean)extension2.getValue());
                    break;
                }
                case BYTES: {
                    writer.writeBytes(descriptor.getNumber(), (ByteString)extension2.getValue());
                    break;
                }
                case UINT32: {
                    writer.writeUInt32(descriptor.getNumber(), (Integer)extension2.getValue());
                    break;
                }
                case SFIXED32: {
                    writer.writeSFixed32(descriptor.getNumber(), (Integer)extension2.getValue());
                    break;
                }
                case SFIXED64: {
                    writer.writeSFixed64(descriptor.getNumber(), (Long)extension2.getValue());
                    break;
                }
                case SINT32: {
                    writer.writeSInt32(descriptor.getNumber(), (Integer)extension2.getValue());
                    break;
                }
                case SINT64: {
                    writer.writeSInt64(descriptor.getNumber(), (Long)extension2.getValue());
                    break;
                }
                case ENUM: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension2.getValue());
                    break;
                }
                case STRING: {
                    writer.writeString(descriptor.getNumber(), (String)extension2.getValue());
                    break;
                }
                case GROUP: {
                    writer.writeGroup(descriptor.getNumber(), extension2.getValue(), Protobuf.getInstance().schemaFor(extension2.getValue().getClass()));
                    break;
                }
                case MESSAGE: {
                    writer.writeMessage(descriptor.getNumber(), extension2.getValue(), Protobuf.getInstance().schemaFor(extension2.getValue().getClass()));
                }
            }
        }
    }

    @Override
    Object findExtensionByNumber(ExtensionRegistryLite extensionRegistry, MessageLite defaultInstance, int number2) {
        return extensionRegistry.findLiteExtensionByNumber(defaultInstance, number2);
    }

    @Override
    void parseLengthPrefixedMessageSetItem(Reader reader, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension2 = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        Object value2 = reader.readMessage(extension2.getMessageDefaultInstance().getClass(), extensionRegistry);
        extensions.setField(extension2.descriptor, value2);
    }

    @Override
    void parseMessageSetItem(ByteString data2, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension2 = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        MessageLite value2 = extension2.getMessageDefaultInstance().newBuilderForType().buildPartial();
        BinaryReader reader = BinaryReader.newInstance(ByteBuffer.wrap(data2.toByteArray()), true);
        Protobuf.getInstance().mergeFrom(value2, reader, extensionRegistry);
        extensions.setField(extension2.descriptor, value2);
        if (reader.getFieldNumber() != Integer.MAX_VALUE) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }
}

