/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";

    MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String commentString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("# ").append(commentString);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, buffer, 0);
        return buffer.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder buffer, int indent) {
        HashMap<String, Method> nameToNoArgMethod = new HashMap<String, Method>();
        HashMap<String, Method> nameToMethod = new HashMap<String, Method>();
        TreeSet<String> getters = new TreeSet<String>();
        for (Method method2 : messageLite.getClass().getDeclaredMethods()) {
            nameToMethod.put(method2.getName(), method2);
            if (method2.getParameterTypes().length != 0) continue;
            nameToNoArgMethod.put(method2.getName(), method2);
            if (!method2.getName().startsWith("get")) continue;
            getters.add(method2.getName());
        }
        for (String getter : getters) {
            Method setter;
            String camelCase;
            String suffix2 = getter.replaceFirst("get", "");
            if (suffix2.endsWith(LIST_SUFFIX) && !suffix2.endsWith(BUILDER_LIST_SUFFIX) && !suffix2.equals(LIST_SUFFIX)) {
                camelCase = suffix2.substring(0, 1).toLowerCase() + suffix2.substring(1, suffix2.length() - LIST_SUFFIX.length());
                Method listMethod = (Method)nameToNoArgMethod.get(getter);
                if (listMethod != null && listMethod.getReturnType().equals(List.class)) {
                    MessageLiteToString.printField(buffer, indent, MessageLiteToString.camelCaseToSnakeCase(camelCase), GeneratedMessageLite.invokeOrDie(listMethod, messageLite, new Object[0]));
                    continue;
                }
            }
            if (suffix2.endsWith(MAP_SUFFIX) && !suffix2.equals(MAP_SUFFIX)) {
                camelCase = suffix2.substring(0, 1).toLowerCase() + suffix2.substring(1, suffix2.length() - MAP_SUFFIX.length());
                Method mapMethod = (Method)nameToNoArgMethod.get(getter);
                if (mapMethod != null && mapMethod.getReturnType().equals(Map.class) && !mapMethod.isAnnotationPresent(Deprecated.class) && Modifier.isPublic(mapMethod.getModifiers())) {
                    MessageLiteToString.printField(buffer, indent, MessageLiteToString.camelCaseToSnakeCase(camelCase), GeneratedMessageLite.invokeOrDie(mapMethod, messageLite, new Object[0]));
                    continue;
                }
            }
            if ((setter = (Method)nameToMethod.get("set" + suffix2)) == null || suffix2.endsWith(BYTES_SUFFIX) && nameToNoArgMethod.containsKey("get" + suffix2.substring(0, suffix2.length() - BYTES_SUFFIX.length()))) continue;
            String camelCase2 = suffix2.substring(0, 1).toLowerCase() + suffix2.substring(1);
            Method getMethod = (Method)nameToNoArgMethod.get("get" + suffix2);
            Method hasMethod2 = (Method)nameToNoArgMethod.get("has" + suffix2);
            if (getMethod == null) continue;
            Object value2 = GeneratedMessageLite.invokeOrDie(getMethod, messageLite, new Object[0]);
            boolean bl = hasMethod2 == null ? !MessageLiteToString.isDefaultValue(value2) : (Boolean)GeneratedMessageLite.invokeOrDie(hasMethod2, messageLite, new Object[0]);
            boolean hasValue = bl;
            if (!hasValue) continue;
            MessageLiteToString.printField(buffer, indent, MessageLiteToString.camelCaseToSnakeCase(camelCase2), value2);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iter2 = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iter2.hasNext()) {
                Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object> entry2 = iter2.next();
                MessageLiteToString.printField(buffer, indent, "[" + entry2.getKey().getNumber() + "]", entry2.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(buffer, indent);
        }
    }

    private static boolean isDefaultValue(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o == false;
        }
        if (o instanceof Integer) {
            return (Integer)o == 0;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() == 0.0f;
        }
        if (o instanceof Double) {
            return (Double)o == 0.0;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        if (o instanceof ByteString) {
            return o.equals(ByteString.EMPTY);
        }
        if (o instanceof MessageLite) {
            return o == ((MessageLite)o).getDefaultInstanceForType();
        }
        if (o instanceof Enum) {
            return ((Enum)o).ordinal() == 0;
        }
        return false;
    }

    static final void printField(StringBuilder buffer, int indent, String name2, Object object) {
        int i;
        if (object instanceof List) {
            List list = (List)object;
            for (Object entry2 : list) {
                MessageLiteToString.printField(buffer, indent, name2, entry2);
            }
            return;
        }
        if (object instanceof Map) {
            Map map3 = (Map)object;
            for (Map.Entry entry3 : map3.entrySet()) {
                MessageLiteToString.printField(buffer, indent, name2, entry3);
            }
            return;
        }
        buffer.append('\n');
        for (i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        buffer.append(name2);
        if (object instanceof String) {
            buffer.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
        } else if (object instanceof ByteString) {
            buffer.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
        } else if (object instanceof GeneratedMessageLite) {
            buffer.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, buffer, indent + 2);
            buffer.append("\n");
            for (i = 0; i < indent; ++i) {
                buffer.append(' ');
            }
            buffer.append("}");
        } else if (object instanceof Map.Entry) {
            buffer.append(" {");
            Map.Entry entry4 = (Map.Entry)object;
            MessageLiteToString.printField(buffer, indent + 2, "key", entry4.getKey());
            MessageLiteToString.printField(buffer, indent + 2, "value", entry4.getValue());
            buffer.append("\n");
            for (int i2 = 0; i2 < indent; ++i2) {
                buffer.append(' ');
            }
            buffer.append("}");
        } else {
            buffer.append(": ").append(object.toString());
        }
    }

    private static final String camelCaseToSnakeCase(String camelCase) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char ch = camelCase.charAt(i);
            if (Character.isUpperCase(ch)) {
                builder.append("_");
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }
}

