/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ArrayDecoders;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyField;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Protobuf;
import com.google.protobuf.Reader;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLite;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

final class MessageSetSchema<T>
implements Schema<T> {
    private final MessageLite defaultInstance;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final boolean hasExtensions;
    private final ExtensionSchema<?> extensionSchema;

    private MessageSetSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        this.unknownFieldSchema = unknownFieldSchema;
        this.hasExtensions = extensionSchema.hasExtensions(defaultInstance);
        this.extensionSchema = extensionSchema;
        this.defaultInstance = defaultInstance;
    }

    static <T> MessageSetSchema<T> newSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        return new MessageSetSchema<T>(unknownFieldSchema, extensionSchema, defaultInstance);
    }

    @Override
    public T newInstance() {
        return (T)this.defaultInstance.newBuilderForType().buildPartial();
    }

    @Override
    public boolean equals(T message2, T other) {
        Object otherUnknown;
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message2);
        if (!messageUnknown.equals(otherUnknown = this.unknownFieldSchema.getFromMessage(other))) {
            return false;
        }
        if (this.hasExtensions) {
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message2);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return messageExtensions.equals(otherExtensions);
        }
        return true;
    }

    @Override
    public int hashCode(T message2) {
        int hashCode = this.unknownFieldSchema.getFromMessage(message2).hashCode();
        if (this.hasExtensions) {
            FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
            hashCode = hashCode * 53 + extensions.hashCode();
        }
        return hashCode;
    }

    @Override
    public void mergeFrom(T message2, T other) {
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message2, other);
        if (this.hasExtensions) {
            SchemaUtil.mergeExtensions(this.extensionSchema, message2, other);
        }
    }

    @Override
    public void writeTo(T message2, Writer writer) throws IOException {
        FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
        Iterator<Map.Entry<?, Object>> iterator2 = extensions.iterator();
        while (iterator2.hasNext()) {
            Map.Entry<?, Object> extension2 = iterator2.next();
            FieldSet.FieldDescriptorLite fd = (FieldSet.FieldDescriptorLite)extension2.getKey();
            if (fd.getLiteJavaType() != WireFormat.JavaType.MESSAGE || fd.isRepeated() || fd.isPacked()) {
                throw new IllegalStateException("Found invalid MessageSet item.");
            }
            if (extension2 instanceof LazyField.LazyEntry) {
                writer.writeMessageSetItem(fd.getNumber(), ((LazyField.LazyEntry)extension2).getField().toByteString());
                continue;
            }
            writer.writeMessageSetItem(fd.getNumber(), extension2.getValue());
        }
        this.writeUnknownFieldsHelper(this.unknownFieldSchema, message2, writer);
    }

    private <UT, UB> void writeUnknownFieldsHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, T message2, Writer writer) throws IOException {
        unknownFieldSchema.writeAsMessageSetTo(unknownFieldSchema.getFromMessage(message2), writer);
    }

    @Override
    public void mergeFrom(T message2, byte[] data2, int position, int limit, ArrayDecoders.Registers registers) throws IOException {
        UnknownFieldSetLite unknownFields = ((GeneratedMessageLite)message2).unknownFields;
        if (unknownFields == UnknownFieldSetLite.getDefaultInstance()) {
            ((GeneratedMessageLite)message2).unknownFields = unknownFields = UnknownFieldSetLite.newInstance();
        }
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions = ((GeneratedMessageLite.ExtendableMessage)message2).ensureExtensionsAreMutable();
        GeneratedMessageLite.GeneratedExtension extension2 = null;
        while (position < limit) {
            position = ArrayDecoders.decodeVarint32(data2, position, registers);
            int startTag = registers.int1;
            if (startTag != WireFormat.MESSAGE_SET_ITEM_TAG) {
                if (WireFormat.getTagWireType(startTag) == 2) {
                    extension2 = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(startTag));
                    if (extension2 != null) {
                        position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(extension2.getMessageDefaultInstance().getClass()), data2, position, limit, registers);
                        extensions.setField(extension2.descriptor, registers.object1);
                        continue;
                    }
                    position = ArrayDecoders.decodeUnknownField(startTag, data2, position, limit, unknownFields, registers);
                    continue;
                }
                position = ArrayDecoders.skipField(startTag, data2, position, limit, registers);
                continue;
            }
            int typeId = 0;
            ByteString rawBytes = null;
            block5: while (position < limit) {
                position = ArrayDecoders.decodeVarint32(data2, position, registers);
                int tag2 = registers.int1;
                int number2 = WireFormat.getTagFieldNumber(tag2);
                int wireType = WireFormat.getTagWireType(tag2);
                switch (number2) {
                    case 2: {
                        if (wireType != 0) break;
                        position = ArrayDecoders.decodeVarint32(data2, position, registers);
                        typeId = registers.int1;
                        extension2 = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, typeId);
                        continue block5;
                    }
                    case 3: {
                        if (extension2 != null) {
                            position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(extension2.getMessageDefaultInstance().getClass()), data2, position, limit, registers);
                            extensions.setField(extension2.descriptor, registers.object1);
                            continue block5;
                        }
                        if (wireType != 2) break;
                        position = ArrayDecoders.decodeBytes(data2, position, registers);
                        rawBytes = (ByteString)registers.object1;
                        continue block5;
                    }
                }
                if (tag2 == WireFormat.MESSAGE_SET_ITEM_END_TAG) break;
                position = ArrayDecoders.skipField(tag2, data2, position, limit, registers);
            }
            if (rawBytes == null) continue;
            unknownFields.storeField(WireFormat.makeTag(typeId, 2), rawBytes);
        }
        if (position != limit) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    @Override
    public void mergeFrom(T message2, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.mergeFromHelper(this.unknownFieldSchema, this.extensionSchema, message2, reader, extensionRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> void mergeFromHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, ExtensionSchema<ET> extensionSchema, T message2, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        UB unknownFields = unknownFieldSchema.getBuilderFromMessage(message2);
        FieldSet<ET> extensions = extensionSchema.getMutableExtensions(message2);
        try {
            do {
                int number2;
                if ((number2 = reader.getFieldNumber()) != Integer.MAX_VALUE) continue;
                return;
            } while (this.parseMessageSetItemOrUnknownField(reader, extensionRegistry, extensionSchema, extensions, unknownFieldSchema, unknownFields));
            return;
        }
        finally {
            unknownFieldSchema.setBuilderToMessage(message2, unknownFields);
        }
    }

    @Override
    public void makeImmutable(T message2) {
        this.unknownFieldSchema.makeImmutable(message2);
        this.extensionSchema.makeImmutable(message2);
    }

    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> boolean parseMessageSetItemOrUnknownField(Reader reader, ExtensionRegistryLite extensionRegistry, ExtensionSchema<ET> extensionSchema, FieldSet<ET> extensions, UnknownFieldSchema<UT, UB> unknownFieldSchema, UB unknownFields) throws IOException {
        int number2;
        int startTag = reader.getTag();
        if (startTag != WireFormat.MESSAGE_SET_ITEM_TAG) {
            if (WireFormat.getTagWireType(startTag) == 2) {
                Object extension2 = extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(startTag));
                if (extension2 != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, extension2, extensionRegistry, extensions);
                    return true;
                }
                return unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader);
            }
            return reader.skipField();
        }
        int typeId = 0;
        ByteString rawBytes = null;
        Object extension3 = null;
        while ((number2 = reader.getFieldNumber()) != Integer.MAX_VALUE) {
            int tag2 = reader.getTag();
            if (tag2 == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                typeId = reader.readUInt32();
                extension3 = extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, typeId);
                continue;
            }
            if (tag2 == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (extension3 != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, extension3, extensionRegistry, extensions);
                    continue;
                }
                rawBytes = reader.readBytes();
                continue;
            }
            if (reader.skipField()) continue;
            break;
        }
        if (reader.getTag() != WireFormat.MESSAGE_SET_ITEM_END_TAG) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
        if (rawBytes != null) {
            if (extension3 != null) {
                extensionSchema.parseMessageSetItem(rawBytes, extension3, extensionRegistry, extensions);
            } else {
                unknownFieldSchema.addLengthDelimited(unknownFields, typeId, rawBytes);
            }
        }
        return true;
    }

    @Override
    public final boolean isInitialized(T message2) {
        FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
        return extensions.isInitialized();
    }

    @Override
    public int getSerializedSize(T message2) {
        int size = 0;
        size += this.getUnknownFieldsSerializedSize(this.unknownFieldSchema, message2);
        if (this.hasExtensions) {
            size += this.extensionSchema.getExtensions(message2).getMessageSetSerializedSize();
        }
        return size;
    }

    private <UT, UB> int getUnknownFieldsSerializedSize(UnknownFieldSchema<UT, UB> schema2, T message2) {
        UT unknowns = schema2.getFromMessage(message2);
        return schema2.getSerializedSizeAsMessageSet(unknowns);
    }
}

