/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.meta.internal.io.InputStreamIO;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.internal.io.OutputStreamIO;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class PlatformFileIO$ {
    public static final PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readAllBytes(URI uri2) {
        byte[] byArray;
        InputStream is2 = uri2.toURL().openStream();
        try {
            byArray = InputStreamIO$.MODULE$.readBytes(is2);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        is2.close();
        return byArray;
    }

    public byte[] readAllBytes(AbsolutePath path2) {
        return Files.readAllBytes(path2.toNIO());
    }

    /*
     * WARNING - void declaration
     */
    public <A> A read(AbsolutePath path2, InputStreamIO<A> isio) {
        A a;
        InputStream stream = Files.newInputStream(path2.toNIO(), new OpenOption[0]);
        try {
            a = isio.read(stream);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public <A> void write(AbsolutePath path2, A msg, Seq<OpenOption> openOptions, OutputStreamIO<A> osio) {
        Files.createDirectories(path2.toNIO().getParent(), new FileAttribute[0]);
        OutputStream os = Files.newOutputStream(path2.toNIO(), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)));
        try {
            osio.write(msg, os);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        os.close();
    }

    public String slurp(AbsolutePath path2, Charset charset) {
        return new String(Files.readAllBytes(path2.toNIO()), charset);
    }

    public ListFiles listFiles(AbsolutePath path2) {
        return new ListFiles(path2, (List<RelativePath>)((List)((List)Option$.MODULE$.apply((Object)path2.toFile().list()).toList().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RelativePath apply(String path2) {
                return RelativePath$.MODULE$.apply(path2);
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public boolean isFile(AbsolutePath path2) {
        return Files.isRegularFile(path2.toNIO(), new LinkOption[0]);
    }

    public boolean isDirectory(AbsolutePath path2) {
        return Files.isDirectory(path2.toNIO(), new LinkOption[0]);
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root2) {
        Builder relativeFiles = List$.MODULE$.newBuilder();
        Iterator iter2 = Files.walk(root2.toNIO(), new FileVisitOption[0]).iterator();
        while (iter2.hasNext()) {
            Path path2 = (Path)iter2.next();
            Object object = Files.isRegularFile(path2, new LinkOption[0]) ? relativeFiles.$plus$eq((Object)RelativePath$.MODULE$.apply(root2.toNIO().relativize(path2))) : BoxedUnit.UNIT;
        }
        return new ListFiles(root2, (List<RelativePath>)((List)relativeFiles.result()));
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile, boolean create) {
        FileSystem fs = this.newJarFileSystem(jarFile, create);
        return AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public boolean jarRootPath$default$2() {
        return false;
    }

    public <T> T withJarFileSystem(AbsolutePath path2, boolean create, boolean close, Function1<AbsolutePath, T> f) {
        Object object;
        FileSystem fs = this.newJarFileSystem(path2, create);
        AbsolutePath root2 = AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        if (create || close) {
            object = f.apply((Object)root2);
        } else {
            object = f.apply((Object)root2);
        }
        return (T)object;
        finally {
            fs.close();
        }
    }

    public <T> boolean withJarFileSystem$default$3() {
        return false;
    }

    public FileSystem newJarFileSystem(AbsolutePath path2, boolean create) {
        Object object = create && !Files.exists(path2.toNIO().getParent(), new LinkOption[0]) ? Files.createDirectories(path2.toNIO().getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        HashMap<String, String> map3 = new HashMap<String, String>();
        Object object2 = create ? map3.put("create", "true") : BoxedUnit.UNIT;
        URI uri2 = URI.create(new StringBuilder().append((Object)"jar:").append((Object)path2.toNIO().toUri().toString()).toString());
        return this.newFileSystem(uri2, map3);
    }

    public FileSystem newFileSystem(URI uri2, Map<String, ?> map3) {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.newFileSystem(uri2, map3);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            fileSystem = FileSystems.getFileSystem(uri2);
        }
        return fileSystem;
    }

    public Map<String, ?> newFileSystem$default$2() {
        return new HashMap();
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

