/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldType;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageInfoFactory;
import com.google.protobuf.OneofInfo;
import com.google.protobuf.ProtoSyntax;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.StructuralMessageInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

final class DescriptorMessageInfoFactory
implements MessageInfoFactory {
    private static final String GET_DEFAULT_INSTANCE_METHOD_NAME = "getDefaultInstance";
    private static final DescriptorMessageInfoFactory instance = new DescriptorMessageInfoFactory();
    private static final Set<String> specialFieldNames = new HashSet<String>(Arrays.asList("cached_size", "serialized_size", "class"));
    private static IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = new IsInitializedCheckAnalyzer();

    private DescriptorMessageInfoFactory() {
    }

    public static DescriptorMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> messageType2) {
        return GeneratedMessageV3.class.isAssignableFrom(messageType2);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> messageType2) {
        if (!GeneratedMessageV3.class.isAssignableFrom(messageType2)) {
            throw new IllegalArgumentException("Unsupported message type: " + messageType2.getName());
        }
        return DescriptorMessageInfoFactory.convert(messageType2, DescriptorMessageInfoFactory.descriptorForType(messageType2));
    }

    private static Message getDefaultInstance(Class<?> messageType2) {
        try {
            Method method2 = messageType2.getDeclaredMethod(GET_DEFAULT_INSTANCE_METHOD_NAME, new Class[0]);
            return (Message)method2.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get default instance for message class " + messageType2.getName(), e);
        }
    }

    private static Descriptors.Descriptor descriptorForType(Class<?> messageType2) {
        return DescriptorMessageInfoFactory.getDefaultInstance(messageType2).getDescriptorForType();
    }

    private static MessageInfo convert(Class<?> messageType2, Descriptors.Descriptor messageDescriptor) {
        switch (messageDescriptor.getFile().getSyntax()) {
            case PROTO2: {
                return DescriptorMessageInfoFactory.convertProto2(messageType2, messageDescriptor);
            }
            case PROTO3: {
                return DescriptorMessageInfoFactory.convertProto3(messageType2, messageDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported syntax: " + (Object)((Object)messageDescriptor.getFile().getSyntax()));
    }

    private static boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
        return isInitializedCheckAnalyzer.needsIsInitializedCheck(descriptor);
    }

    private static StructuralMessageInfo convertProto2(Class<?> messageType2, Descriptors.Descriptor messageDescriptor) {
        List<Descriptors.FieldDescriptor> fieldDescriptors = messageDescriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(fieldDescriptors.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(messageType2));
        builder.withSyntax(ProtoSyntax.PROTO2);
        builder.withMessageSetWireFormat(messageDescriptor.getOptions().getMessageSetWireFormat());
        OneofState oneofState = new OneofState();
        int bitFieldIndex = 0;
        int presenceMask = 1;
        Field bitField = null;
        for (int i = 0; i < fieldDescriptors.size(); ++i) {
            final Descriptors.FieldDescriptor fd = fieldDescriptors.get(i);
            boolean enforceUtf8 = fd.getFile().getOptions().getJavaStringCheckUtf8();
            Internal.EnumVerifier enumVerifier = null;
            if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                enumVerifier = new Internal.EnumVerifier(){

                    @Override
                    public boolean isInRange(int number2) {
                        return fd.getEnumType().findValueByNumber(number2) != null;
                    }
                };
            }
            if (fd.getContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(messageType2, fd, oneofState, enforceUtf8, enumVerifier));
            } else {
                Field field2 = DescriptorMessageInfoFactory.field(messageType2, fd);
                int number2 = fd.getNumber();
                FieldType type2 = DescriptorMessageInfoFactory.getFieldType(fd);
                if (fd.isMapField()) {
                    final Descriptors.FieldDescriptor valueField = fd.getMessageType().findFieldByNumber(2);
                    if (valueField.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        enumVerifier = new Internal.EnumVerifier(){

                            @Override
                            public boolean isInRange(int number2) {
                                return valueField.getEnumType().findValueByNumber(number2) != null;
                            }
                        };
                    }
                    builder.withField(FieldInfo.forMapField(field2, number2, SchemaUtil.getMapDefaultEntry(messageType2, fd.getName()), enumVerifier));
                    continue;
                }
                if (fd.isRepeated()) {
                    if (enumVerifier != null) {
                        if (fd.isPacked()) {
                            builder.withField(FieldInfo.forPackedFieldWithEnumVerifier(field2, number2, type2, enumVerifier, DescriptorMessageInfoFactory.cachedSizeField(messageType2, fd)));
                            continue;
                        }
                        builder.withField(FieldInfo.forFieldWithEnumVerifier(field2, number2, type2, enumVerifier));
                        continue;
                    }
                    if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        builder.withField(FieldInfo.forRepeatedMessageField(field2, number2, type2, DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(messageType2, fd)));
                        continue;
                    }
                    if (fd.isPacked()) {
                        builder.withField(FieldInfo.forPackedField(field2, number2, type2, DescriptorMessageInfoFactory.cachedSizeField(messageType2, fd)));
                        continue;
                    }
                    builder.withField(FieldInfo.forField(field2, number2, type2, enforceUtf8));
                    continue;
                }
                if (bitField == null) {
                    bitField = DescriptorMessageInfoFactory.bitField(messageType2, bitFieldIndex);
                }
                if (fd.isRequired()) {
                    builder.withField(FieldInfo.forProto2RequiredField(field2, number2, type2, bitField, presenceMask, enforceUtf8, enumVerifier));
                } else {
                    builder.withField(FieldInfo.forProto2OptionalField(field2, number2, type2, bitField, presenceMask, enforceUtf8, enumVerifier));
                }
            }
            if ((presenceMask <<= 1) != 0) continue;
            bitField = null;
            presenceMask = 1;
            ++bitFieldIndex;
        }
        ArrayList<Integer> fieldsToCheckIsInitialized = new ArrayList<Integer>();
        for (int i = 0; i < fieldDescriptors.size(); ++i) {
            Descriptors.FieldDescriptor fd = fieldDescriptors.get(i);
            if (!fd.isRequired() && (fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !DescriptorMessageInfoFactory.needsIsInitializedCheck(fd.getMessageType()))) continue;
            fieldsToCheckIsInitialized.add(fd.getNumber());
        }
        int[] numbers = new int[fieldsToCheckIsInitialized.size()];
        for (int i = 0; i < fieldsToCheckIsInitialized.size(); ++i) {
            numbers[i] = (Integer)fieldsToCheckIsInitialized.get(i);
        }
        builder.withCheckInitialized(numbers);
        return builder.build();
    }

    private static StructuralMessageInfo convertProto3(Class<?> messageType2, Descriptors.Descriptor messageDescriptor) {
        List<Descriptors.FieldDescriptor> fieldDescriptors = messageDescriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(fieldDescriptors.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(messageType2));
        builder.withSyntax(ProtoSyntax.PROTO3);
        OneofState oneofState = new OneofState();
        boolean enforceUtf8 = true;
        for (int i = 0; i < fieldDescriptors.size(); ++i) {
            Descriptors.FieldDescriptor fd = fieldDescriptors.get(i);
            if (fd.getContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(messageType2, fd, oneofState, enforceUtf8, null));
                continue;
            }
            if (fd.isMapField()) {
                builder.withField(FieldInfo.forMapField(DescriptorMessageInfoFactory.field(messageType2, fd), fd.getNumber(), SchemaUtil.getMapDefaultEntry(messageType2, fd.getName()), null));
                continue;
            }
            if (fd.isRepeated() && fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                builder.withField(FieldInfo.forRepeatedMessageField(DescriptorMessageInfoFactory.field(messageType2, fd), fd.getNumber(), DescriptorMessageInfoFactory.getFieldType(fd), DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(messageType2, fd)));
                continue;
            }
            if (fd.isPacked()) {
                builder.withField(FieldInfo.forPackedField(DescriptorMessageInfoFactory.field(messageType2, fd), fd.getNumber(), DescriptorMessageInfoFactory.getFieldType(fd), DescriptorMessageInfoFactory.cachedSizeField(messageType2, fd)));
                continue;
            }
            builder.withField(FieldInfo.forField(DescriptorMessageInfoFactory.field(messageType2, fd), fd.getNumber(), DescriptorMessageInfoFactory.getFieldType(fd), enforceUtf8));
        }
        return builder.build();
    }

    private static FieldInfo buildOneofMember(Class<?> messageType2, Descriptors.FieldDescriptor fd, OneofState oneofState, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        OneofInfo oneof = oneofState.getOneof(messageType2, fd.getContainingOneof());
        FieldType type2 = DescriptorMessageInfoFactory.getFieldType(fd);
        Class<?> oneofStoredType = DescriptorMessageInfoFactory.getOneofStoredType(messageType2, fd, type2);
        return FieldInfo.forOneofMemberField(fd.getNumber(), type2, oneof, oneofStoredType, enforceUtf8, enumVerifier);
    }

    private static Class<?> getOneofStoredType(Class<?> messageType2, Descriptors.FieldDescriptor fd, FieldType type2) {
        switch (type2.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case ENUM: 
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case MESSAGE: {
                return DescriptorMessageInfoFactory.getOneofStoredTypeForMessage(messageType2, fd);
            }
        }
        throw new IllegalArgumentException("Invalid type for oneof: " + (Object)((Object)type2));
    }

    private static FieldType getFieldType(Descriptors.FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOL: {
                if (!fd.isRepeated()) {
                    return FieldType.BOOL;
                }
                return fd.isPacked() ? FieldType.BOOL_LIST_PACKED : FieldType.BOOL_LIST;
            }
            case BYTES: {
                return fd.isRepeated() ? FieldType.BYTES_LIST : FieldType.BYTES;
            }
            case DOUBLE: {
                if (!fd.isRepeated()) {
                    return FieldType.DOUBLE;
                }
                return fd.isPacked() ? FieldType.DOUBLE_LIST_PACKED : FieldType.DOUBLE_LIST;
            }
            case ENUM: {
                if (!fd.isRepeated()) {
                    return FieldType.ENUM;
                }
                return fd.isPacked() ? FieldType.ENUM_LIST_PACKED : FieldType.ENUM_LIST;
            }
            case FIXED32: {
                if (!fd.isRepeated()) {
                    return FieldType.FIXED32;
                }
                return fd.isPacked() ? FieldType.FIXED32_LIST_PACKED : FieldType.FIXED32_LIST;
            }
            case FIXED64: {
                if (!fd.isRepeated()) {
                    return FieldType.FIXED64;
                }
                return fd.isPacked() ? FieldType.FIXED64_LIST_PACKED : FieldType.FIXED64_LIST;
            }
            case FLOAT: {
                if (!fd.isRepeated()) {
                    return FieldType.FLOAT;
                }
                return fd.isPacked() ? FieldType.FLOAT_LIST_PACKED : FieldType.FLOAT_LIST;
            }
            case GROUP: {
                return fd.isRepeated() ? FieldType.GROUP_LIST : FieldType.GROUP;
            }
            case INT32: {
                if (!fd.isRepeated()) {
                    return FieldType.INT32;
                }
                return fd.isPacked() ? FieldType.INT32_LIST_PACKED : FieldType.INT32_LIST;
            }
            case INT64: {
                if (!fd.isRepeated()) {
                    return FieldType.INT64;
                }
                return fd.isPacked() ? FieldType.INT64_LIST_PACKED : FieldType.INT64_LIST;
            }
            case MESSAGE: {
                if (fd.isMapField()) {
                    return FieldType.MAP;
                }
                return fd.isRepeated() ? FieldType.MESSAGE_LIST : FieldType.MESSAGE;
            }
            case SFIXED32: {
                if (!fd.isRepeated()) {
                    return FieldType.SFIXED32;
                }
                return fd.isPacked() ? FieldType.SFIXED32_LIST_PACKED : FieldType.SFIXED32_LIST;
            }
            case SFIXED64: {
                if (!fd.isRepeated()) {
                    return FieldType.SFIXED64;
                }
                return fd.isPacked() ? FieldType.SFIXED64_LIST_PACKED : FieldType.SFIXED64_LIST;
            }
            case SINT32: {
                if (!fd.isRepeated()) {
                    return FieldType.SINT32;
                }
                return fd.isPacked() ? FieldType.SINT32_LIST_PACKED : FieldType.SINT32_LIST;
            }
            case SINT64: {
                if (!fd.isRepeated()) {
                    return FieldType.SINT64;
                }
                return fd.isPacked() ? FieldType.SINT64_LIST_PACKED : FieldType.SINT64_LIST;
            }
            case STRING: {
                return fd.isRepeated() ? FieldType.STRING_LIST : FieldType.STRING;
            }
            case UINT32: {
                if (!fd.isRepeated()) {
                    return FieldType.UINT32;
                }
                return fd.isPacked() ? FieldType.UINT32_LIST_PACKED : FieldType.UINT32_LIST;
            }
            case UINT64: {
                if (!fd.isRepeated()) {
                    return FieldType.UINT64;
                }
                return fd.isPacked() ? FieldType.UINT64_LIST_PACKED : FieldType.UINT64_LIST;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fd.getType()));
    }

    private static Field bitField(Class<?> messageType2, int index) {
        return DescriptorMessageInfoFactory.field(messageType2, "bitField" + index + "_");
    }

    private static Field field(Class<?> messageType2, Descriptors.FieldDescriptor fd) {
        return DescriptorMessageInfoFactory.field(messageType2, DescriptorMessageInfoFactory.getFieldName(fd));
    }

    private static Field cachedSizeField(Class<?> messageType2, Descriptors.FieldDescriptor fd) {
        return DescriptorMessageInfoFactory.field(messageType2, DescriptorMessageInfoFactory.getCachedSizeFieldName(fd));
    }

    private static Field field(Class<?> messageType2, String fieldName) {
        try {
            return messageType2.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find field " + fieldName + " in message class " + messageType2.getName());
        }
    }

    static String getFieldName(Descriptors.FieldDescriptor fd) {
        String name2 = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd.getMessageType().getName() : fd.getName();
        String suffix2 = specialFieldNames.contains(name2) ? "__" : "_";
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(name2) + suffix2;
    }

    private static String getCachedSizeFieldName(Descriptors.FieldDescriptor fd) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(fd.getName()) + "MemoizedSerializedSize";
    }

    private static String snakeCaseToCamelCase(String snakeCase) {
        StringBuilder sb = new StringBuilder(snakeCase.length() + 1);
        boolean capNext = false;
        for (int ctr = 0; ctr < snakeCase.length(); ++ctr) {
            char next = snakeCase.charAt(ctr);
            if (next == '_') {
                capNext = true;
                continue;
            }
            if (Character.isDigit(next)) {
                sb.append(next);
                capNext = true;
                continue;
            }
            if (capNext) {
                sb.append(Character.toUpperCase(next));
                capNext = false;
                continue;
            }
            if (ctr == 0) {
                sb.append(Character.toLowerCase(next));
                continue;
            }
            sb.append(next);
        }
        return sb.toString();
    }

    private static Class<?> getOneofStoredTypeForMessage(Class<?> messageType2, Descriptors.FieldDescriptor fd) {
        try {
            String name2 = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd.getMessageType().getName() : fd.getName();
            Method getter = messageType2.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(name2), new Class[0]);
            return getter.getReturnType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getTypeForRepeatedMessageField(Class<?> messageType2, Descriptors.FieldDescriptor fd) {
        try {
            String name2 = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd.getMessageType().getName() : fd.getName();
            Method getter = messageType2.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(name2), Integer.TYPE);
            return getter.getReturnType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getterForField(String snakeCase) {
        String camelCase = DescriptorMessageInfoFactory.snakeCaseToCamelCase(snakeCase);
        StringBuilder builder = new StringBuilder("get");
        builder.append(Character.toUpperCase(camelCase.charAt(0)));
        builder.append(camelCase.substring(1, camelCase.length()));
        return builder.toString();
    }

    private static final class OneofState {
        private OneofInfo[] oneofs = new OneofInfo[2];

        private OneofState() {
        }

        OneofInfo getOneof(Class<?> messageType2, Descriptors.OneofDescriptor desc) {
            OneofInfo info2;
            int index = desc.getIndex();
            if (index >= this.oneofs.length) {
                this.oneofs = Arrays.copyOf(this.oneofs, index * 2);
            }
            if ((info2 = this.oneofs[index]) == null) {
                this.oneofs[index] = info2 = OneofState.newInfo(messageType2, desc);
            }
            return info2;
        }

        private static OneofInfo newInfo(Class<?> messageType2, Descriptors.OneofDescriptor desc) {
            String camelCase = DescriptorMessageInfoFactory.snakeCaseToCamelCase(desc.getName());
            String valueFieldName = camelCase + "_";
            String caseFieldName = camelCase + "Case_";
            return new OneofInfo(desc.getIndex(), DescriptorMessageInfoFactory.field(messageType2, caseFieldName), DescriptorMessageInfoFactory.field(messageType2, valueFieldName));
        }
    }

    static class IsInitializedCheckAnalyzer {
        private final Map<Descriptors.Descriptor, Boolean> resultCache = new ConcurrentHashMap<Descriptors.Descriptor, Boolean>();
        private int index = 0;
        private final Stack<Node> stack = new Stack();
        private final Map<Descriptors.Descriptor, Node> nodeCache = new HashMap<Descriptors.Descriptor, Node>();

        IsInitializedCheckAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
            Boolean cachedValue = this.resultCache.get(descriptor);
            if (cachedValue != null) {
                return cachedValue;
            }
            IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = this;
            synchronized (isInitializedCheckAnalyzer) {
                cachedValue = this.resultCache.get(descriptor);
                if (cachedValue != null) {
                    return cachedValue;
                }
                return this.dfs((Descriptors.Descriptor)descriptor).component.needsIsInitializedCheck;
            }
        }

        private Node dfs(Descriptors.Descriptor descriptor) {
            Node result2 = new Node(descriptor, this.index++);
            this.stack.push(result2);
            this.nodeCache.put(descriptor, result2);
            for (Descriptors.FieldDescriptor field2 : descriptor.getFields()) {
                if (field2.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                Node child = this.nodeCache.get(field2.getMessageType());
                if (child == null) {
                    child = this.dfs(field2.getMessageType());
                    result2.lowLink = Math.min(result2.lowLink, child.lowLink);
                    continue;
                }
                if (child.component != null) continue;
                result2.lowLink = Math.min(result2.lowLink, child.lowLink);
            }
            if (result2.index == result2.lowLink) {
                Node node;
                StronglyConnectedComponent component = new StronglyConnectedComponent();
                do {
                    node = this.stack.pop();
                    node.component = component;
                    component.messages.add(node.descriptor);
                } while (node != result2);
                this.analyze(component);
            }
            return result2;
        }

        private void analyze(StronglyConnectedComponent component) {
            boolean needsIsInitializedCheck = false;
            block0: for (Descriptors.Descriptor descriptor : component.messages) {
                if (descriptor.isExtendable()) {
                    needsIsInitializedCheck = true;
                    break;
                }
                for (Descriptors.FieldDescriptor field2 : descriptor.getFields()) {
                    if (field2.isRequired()) {
                        needsIsInitializedCheck = true;
                        break block0;
                    }
                    if (field2.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                    Node node = this.nodeCache.get(field2.getMessageType());
                    if (node.component == component || !node.component.needsIsInitializedCheck) continue;
                    needsIsInitializedCheck = true;
                    break block0;
                }
            }
            component.needsIsInitializedCheck = needsIsInitializedCheck;
            for (Descriptors.Descriptor descriptor : component.messages) {
                this.resultCache.put(descriptor, component.needsIsInitializedCheck);
            }
        }

        private static class StronglyConnectedComponent {
            final List<Descriptors.Descriptor> messages = new ArrayList<Descriptors.Descriptor>();
            boolean needsIsInitializedCheck = false;

            private StronglyConnectedComponent() {
            }
        }

        private static class Node {
            final Descriptors.Descriptor descriptor;
            final int index;
            int lowLink;
            StronglyConnectedComponent component;

            Node(Descriptors.Descriptor descriptor, int index) {
                this.descriptor = descriptor;
                this.index = index;
                this.lowLink = index;
                this.component = null;
            }
        }
    }
}

