/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import scala.Option;
import scala.Predef$;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.internal.tokenizers.CharArrayReaderData;
import scala.meta.internal.tokenizers.Chars$;
import scala.meta.internal.tokenizers.Reporter;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0006\f\u0001?!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!!\u0004A!A!\u0002\u0013)\u0004\"\u0002\u001d\u0001\t\u0003I\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002!\t\u000f\u001d\u0003\u0001\u0019!C\u0001\u0011\"9A\n\u0001a\u0001\n\u0003i\u0005BB*\u0001A\u0003&\u0011\nC\u0003U\u0001\u0011\u0015Q\u000bC\u0003W\u0001\u0011\u0015Q\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003Z\u0001\u0011%Q\u000bC\u0003[\u0001\u0011%Q\u000bC\u0003\\\u0001\u0011%Q\u000bC\u0003]\u0001\u0011\u0005QL\u0002\u0003a\u0001\u0001\t\u0007\"\u0002\u001d\u0012\t\u0003\u0011\u0007\"B2\u0012\t\u0003!\u0007\"B3\u0012\t\u0003!'aD\"iCJ\f%O]1z%\u0016\fG-\u001a:\u000b\u0005]A\u0012A\u0003;pW\u0016t\u0017N_3sg*\u0011\u0011DG\u0001\tS:$XM\u001d8bY*\u00111\u0004H\u0001\u0005[\u0016$\u0018MC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0007\u0001\u00192\u0001\u0001\u0011%!\t\t#%D\u0001\u001d\u0013\t\u0019CD\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011AF\u0005\u0003OY\u00111c\u00115be\u0006\u0013(/Y=SK\u0006$WM\u001d#bi\u0006\fQ!\u001b8qkR\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\u000e\u0002\r%t\u0007/\u001e;t\u0013\tq3FA\u0003J]B,H/A\u0004eS\u0006dWm\u0019;\u0011\u0005E\u0012T\"\u0001\u000e\n\u0005MR\"a\u0002#jC2,7\r^\u0001\te\u0016\u0004xN\u001d;feB\u0011QEN\u0005\u0003oY\u0011\u0001BU3q_J$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiZD(\u0010\t\u0003K\u0001AQ\u0001\u000b\u0003A\u0002%BQa\f\u0003A\u0002ABQ\u0001\u000e\u0003A\u0002U\n1AY;g+\u0005\u0001\u0005cA\u0011B\u0007&\u0011!\t\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003C\u0011K!!\u0012\u000f\u0003\t\rC\u0017M]\u0001\u0005EV4\u0007%A\bjgVs\u0017nY8eK\u0016\u001b8-\u00199f+\u0005I\u0005CA\u0011K\u0013\tYEDA\u0004C_>dW-\u00198\u0002'%\u001cXK\\5d_\u0012,Wi]2ba\u0016|F%Z9\u0015\u00059\u000b\u0006CA\u0011P\u0013\t\u0001FD\u0001\u0003V]&$\bb\u0002*\t\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\n\u0014\u0001E5t+:L7m\u001c3f\u000bN\u001c\u0017\r]3!\u0003!qW\r\u001f;DQ\u0006\u0014H#\u0001(\u0002\u00179,\u0007\u0010\u001e*bo\u000eC\u0017M]\u0001\u0012]\u0016DHOT8o/\"LG/Z:qC\u000e,W#A\"\u0002!A|G/\u001a8uS\u0006dWK\\5d_\u0012,\u0017AB:lSB\u001c%+\u0001\tq_R,g\u000e^5bY2Kg.Z#oI\u0006yAn\\8lC\",\u0017\r\u001a*fC\u0012,'/F\u0001_!\ty\u0016#D\u0001\u0001\u0005a\u0019\u0005.\u0019:BeJ\f\u0017\u0010T8pW\u0006DW-\u00193SK\u0006$WM]\n\u0003#i\"\u0012AX\u0001\u0005O\u0016$8\rF\u0001D\u0003\u00119W\r^;")
public class CharArrayReader
implements CharArrayReaderData {
    public final Input scala$meta$internal$tokenizers$CharArrayReader$$input;
    public final Dialect scala$meta$internal$tokenizers$CharArrayReader$$dialect;
    public final Reporter scala$meta$internal$tokenizers$CharArrayReader$$reporter;
    private final char[] buf;
    private boolean isUnicodeEscape;
    private char ch;
    private int charOffset;
    private int lineStartOffset;
    private int lastLineStartOffset;
    private int lastUnicodeOffset;

    @Override
    public char ch() {
        return this.ch;
    }

    @Override
    public void ch_$eq(char x$1) {
        this.ch = x$1;
    }

    @Override
    public int charOffset() {
        return this.charOffset;
    }

    @Override
    public void charOffset_$eq(int x$1) {
        this.charOffset = x$1;
    }

    @Override
    public int lineStartOffset() {
        return this.lineStartOffset;
    }

    @Override
    public void lineStartOffset_$eq(int x$1) {
        this.lineStartOffset = x$1;
    }

    @Override
    public int lastLineStartOffset() {
        return this.lastLineStartOffset;
    }

    @Override
    public void lastLineStartOffset_$eq(int x$1) {
        this.lastLineStartOffset = x$1;
    }

    @Override
    public int lastUnicodeOffset() {
        return this.lastUnicodeOffset;
    }

    @Override
    public void lastUnicodeOffset_$eq(int x$1) {
        this.lastUnicodeOffset = x$1;
    }

    public char[] buf() {
        return this.buf;
    }

    public boolean isUnicodeEscape() {
        return this.isUnicodeEscape;
    }

    public void isUnicodeEscape_$eq(boolean x$1) {
        this.isUnicodeEscape = x$1;
    }

    public final void nextChar() {
        if (this.isUnicodeEscape()) {
            this.charOffset_$eq(this.lastUnicodeOffset());
        }
        this.isUnicodeEscape_$eq(false);
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[this.charOffset()];
            this.ch_$eq(c);
            this.charOffset_$eq(this.charOffset() + 1);
            if (c == '\\') {
                this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            }
            if (this.ch() < ' ') {
                this.skipCR();
                this.potentialLineEnd();
            }
            if (this.ch() == '\"' && !this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
                throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("double quotes are not allowed in single-line quasiquotes", this.charOffset() - 1);
            }
        }
    }

    public final void nextRawChar() {
        block2: {
            block1: {
                if (this.isUnicodeEscape()) {
                    this.charOffset_$eq(this.lastUnicodeOffset());
                }
                this.isUnicodeEscape_$eq(false);
                if (this.charOffset() < this.buf().length) break block1;
                this.ch_$eq('\u001a');
                break block2;
            }
            char c = this.buf()[this.charOffset()];
            this.ch_$eq(c);
            this.charOffset_$eq(this.charOffset() + 1);
            if (c != '\\') break block2;
            this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
        }
    }

    public char nextNonWhitespace() {
        while (this.ch() == ' ' || this.ch() == '\t') {
            this.nextRawChar();
        }
        return this.ch();
    }

    public void scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode() {
        block5: {
            int end = this.charOffset();
            if (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u' && this.evenSlashPrefix$1()) {
                do {
                    this.charOffset_$eq(this.charOffset() + 1);
                } while (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u');
                try {
                    int code = this.udigit$1() << 12 | this.udigit$1() << 8 | this.udigit$1() << 4 | this.udigit$1();
                    this.lastUnicodeOffset_$eq(this.charOffset());
                    this.isUnicodeEscape_$eq(true);
                    this.ch_$eq((char)code);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }
            if (end >= this.buf().length) break block5;
            this.charOffset_$eq(end);
        }
    }

    private void skipCR() {
        block4: {
            if (this.ch() != '\r' || this.charOffset() >= this.buf().length) break block4;
            char c = this.buf()[this.charOffset()];
            switch (c) {
                case '\\': {
                    if (this.lookaheadReader().getu() == '\n') {
                        this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
                        break;
                    } else {
                        break;
                    }
                }
            }
        }
    }

    private void potentialLineEnd() {
        block1: {
            if (this.ch() != '\n' && this.ch() != '\f') break block1;
            if (!this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
                throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("line breaks are not allowed in single-line quasiquotes", this.charOffset() - 1);
            }
            this.lastLineStartOffset_$eq(this.lineStartOffset());
            this.lineStartOffset_$eq(this.charOffset());
        }
    }

    public CharArrayLookaheadReader lookaheadReader() {
        return new CharArrayLookaheadReader();
    }

    private final boolean evenSlashPrefix$1() {
        int p;
        for (p = this.charOffset() - 2; p >= 0 && this.buf()[p] == '\\'; --p) {
        }
        return (this.charOffset() - p) % 2 == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int udigit$1() {
        void var1_1;
        if (this.charOffset() >= this.buf().length) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("incomplete unicode escape", this.charOffset() - 1);
        }
        int d = Chars$.MODULE$.digit2int(this.buf()[this.charOffset()], 16);
        if (d < 0) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("error in unicode escape", this.charOffset());
        }
        this.charOffset_$eq(this.charOffset() + 1);
        return (int)var1_1;
    }

    public CharArrayReader(Input input, Dialect dialect, Reporter reporter) {
        this.scala$meta$internal$tokenizers$CharArrayReader$$input = input;
        this.scala$meta$internal$tokenizers$CharArrayReader$$dialect = dialect;
        this.scala$meta$internal$tokenizers$CharArrayReader$$reporter = reporter;
        CharArrayReaderData.$init$(this);
        this.buf = input.chars();
        this.isUnicodeEscape = false;
    }

    public class CharArrayLookaheadReader
    extends CharArrayReader {
        public char getc() {
            this.nextChar();
            return this.ch();
        }

        public char getu() {
            Predef$.MODULE$.require(this.buf()[this.charOffset()] == '\\');
            this.ch_$eq('\\');
            this.charOffset_$eq(this.charOffset() + 1);
            this.scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer().scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            return this.ch();
        }

        public /* synthetic */ CharArrayReader scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer() {
            return CharArrayReader.this;
        }

        public CharArrayLookaheadReader() {
            if (CharArrayReader.this == null) {
                throw null;
            }
            super(CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$input, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$dialect, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$reporter);
            this.charOffset_$eq(CharArrayReader.this.charOffset());
            this.ch_$eq(CharArrayReader.this.ch());
        }
    }
}

