/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.scalameta.collections.package$;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.meta.internal.io.InputStreamIO;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.internal.io.OutputStreamIO;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class PlatformFileIO$ {
    public static PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    public byte[] readAllBytes(URI uri) {
        byte[] byArray;
        try (InputStream is = uri.toURL().openStream();){
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        return byArray;
    }

    public byte[] readAllBytes(AbsolutePath path2) {
        return Files.readAllBytes(path2.toNIO());
    }

    public <A> A read(AbsolutePath path2, InputStreamIO<A> isio) {
        A a;
        try (InputStream stream = Files.newInputStream(path2.toNIO(), new OpenOption[0]);){
            a = isio.read(stream);
        }
        return a;
    }

    public <A> void write(AbsolutePath path2, A msg, Seq<OpenOption> openOptions, OutputStreamIO<A> osio) {
        Files.createDirectories(path2.toNIO().getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path2.toNIO(), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)));){
            osio.write(msg, os);
        }
    }

    public String slurp(AbsolutePath path2, Charset charset) {
        return new String(Files.readAllBytes(path2.toNIO()), charset);
    }

    public ListFiles listFiles(AbsolutePath path3) {
        return new ListFiles(path3, (List<RelativePath>)((List)((List)Option$.MODULE$.apply((Object)path3.toFile().list()).toList().flatten((Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).map((Function1 & java.io.Serializable & Serializable)path2 -> RelativePath$.MODULE$.apply((String)path2), List$.MODULE$.canBuildFrom())));
    }

    public boolean isFile(AbsolutePath path2) {
        return Files.isRegularFile(path2.toNIO(), new LinkOption[0]);
    }

    public boolean isDirectory(AbsolutePath path2) {
        return Files.isDirectory(path2.toNIO(), new LinkOption[0]);
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root2) {
        List relativeFiles = (List)package$.MODULE$.XtensionJavaList(Files.walk(root2.toNIO(), new FileVisitOption[0]).collect(Collectors.toList())).toScala().collect((PartialFunction)new Serializable(root2){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath root$1;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (Files.isRegularFile(A1, new LinkOption[0])) {
                    return (B1)RelativePath$.MODULE$.apply(this.root$1.toNIO().relativize(A1));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Path x1) {
                Path path2 = x1;
                return Files.isRegularFile(path2, new LinkOption[0]);
            }
            {
                this.root$1 = root$1;
            }
        }, List$.MODULE$.canBuildFrom());
        return new ListFiles(root2, (List<RelativePath>)relativeFiles);
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile, boolean create) {
        FileSystem fs = this.newJarFileSystem(jarFile, create);
        return AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public boolean jarRootPath$default$2() {
        return false;
    }

    public <T> T withJarFileSystem(AbsolutePath path2, boolean create, boolean close, Function1<AbsolutePath, T> f) {
        FileSystem fs = this.newJarFileSystem(path2, create);
        AbsolutePath root2 = AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        if (create || close) {
            Object object;
            try {
                object = f.apply((Object)root2);
            }
            finally {
                fs.close();
            }
            return (T)object;
        }
        return (T)f.apply((Object)root2);
    }

    public <T> boolean withJarFileSystem$default$3() {
        return false;
    }

    public FileSystem newJarFileSystem(AbsolutePath path2, boolean create) {
        Object object = create && !Files.exists(path2.toNIO().getParent(), new LinkOption[0]) ? Files.createDirectories(path2.toNIO().getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        HashMap<String, String> map = new HashMap<String, String>();
        Object object2 = create ? map.put("create", "true") : BoxedUnit.UNIT;
        URI uri = URI.create(new StringBuilder(4).append("jar:").append(path2.toNIO().toUri().toString()).toString());
        return this.newFileSystem(uri, map);
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> map) {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.newFileSystem(uri, map);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    public Map<String, ?> newFileSystem$default$2() {
        return new HashMap();
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

