/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.descriptor.FieldDescriptorProto;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BOOL$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BYTES$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_DOUBLE$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_ENUM$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FLOAT$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_GROUP$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_STRING$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT64$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scalapb.GeneratedMessage;
import scalapb.GeneratedMessageCompanion;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PString;
import scalapb.descriptors.PValue;
import scalapb.textformat.AstUtils;
import scalapb.textformat.Position;
import scalapb.textformat.TArray;
import scalapb.textformat.TBytes;
import scalapb.textformat.TField;
import scalapb.textformat.TIntLiteral;
import scalapb.textformat.TLiteral;
import scalapb.textformat.TMessage;
import scalapb.textformat.TPrimitive;
import scalapb.textformat.TValue;
import scalapb.textformat.TextFormatUtils$;

public final class AstUtils$ {
    public static AstUtils$ MODULE$;

    static {
        new AstUtils$();
    }

    private <T> Either<AstUtils.AstError, Vector<T>> flatten(Seq<Either<AstUtils.AstError, T>> s) {
        return (Either)s.foldLeft((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().empty()), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Either either;
            Either either2;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                Left left = (Left)either2;
                AstUtils.AstError l = (AstUtils.AstError)left.value();
                return package$.MODULE$.Left().apply((Object)l);
            }
            if (tuple2 != null && (either = (Either)tuple2._2()) instanceof Left) {
                Left left = (Left)either;
                AstUtils.AstError l = (AstUtils.AstError)left.value();
                return package$.MODULE$.Left().apply((Object)l);
            }
            if (tuple2 != null) {
                Either either3 = (Either)tuple2._1();
                Either either4 = (Either)tuple2._2();
                if (either3 instanceof Right) {
                    Right right = (Right)either3;
                    Vector xs = (Vector)right.value();
                    if (either4 instanceof Right) {
                        Right right2 = (Right)either4;
                        Object x = right2.value();
                        return package$.MODULE$.Right().apply(xs.$colon$plus(x, Vector$.MODULE$.canBuildFrom()));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <T extends GeneratedMessage> Either<AstUtils.AstError, T> parseMessage(GeneratedMessageCompanion<T> v, TMessage ast2) {
        return this.parseUnsafe(v, ast2).map(v.messageReads().read());
    }

    public Either<AstUtils.AstError, BigInt> checkBigInt(TPrimitive p, boolean isSigned, boolean isLong) {
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            int maxBits;
            boolean negative;
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            Position index = tIntLiteral.position();
            BigInt v = tIntLiteral.value();
            boolean bl = negative = v.signum() == -1;
            int n = isLong ? (isSigned ? 63 : 64) : (maxBits = isSigned ? 31 : 32);
            if (!isSigned && negative) {
                return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, new StringBuilder(25).append("Number must be positive: ").append(v).toString()));
            }
            if (v.bitLength() > maxBits) {
                return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, new StringBuilder(39).append("Number out of range for ").append(isLong ? BoxesRunTime.boxToInteger((int)64) : BoxesRunTime.boxToInteger((int)32)).append("-bit ").append((Object)(isSigned ? "signed" : "unsigned")).append(" integer: ").append(v).toString()));
            }
            return package$.MODULE$.Right().apply((Object)v);
        }
        return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.position(), new StringBuilder(16).append("Invalid input '").append(tPrimitive.asString()).append("'").toString()));
    }

    public boolean checkBigInt$default$2() {
        return true;
    }

    public Either<AstUtils.AstError, PInt> parseInt32(TPrimitive p) {
        return this.checkBigInt(p, true, false).map((Function1 & java.io.Serializable & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PInt> parseUint32(TPrimitive p) {
        return this.checkBigInt(p, false, false).map((Function1 & java.io.Serializable & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PLong> parseInt64(TPrimitive p) {
        return this.checkBigInt(p, true, true).map((Function1 & java.io.Serializable & Serializable)t -> new PLong(t.longValue()));
    }

    public Either<AstUtils.AstError, PLong> parseUint64(TPrimitive p) {
        return this.checkBigInt(p, false, true).map((Function1 & java.io.Serializable & Serializable)t -> new PLong(t.longValue()));
    }

    private Either<AstUtils.AstError, PMessage> parseUnsafe(GeneratedMessageCompanion<?> v, TMessage ast2) {
        Left left;
        Map fieldMap = ((TraversableOnce)v.scalaDescriptor().fields().map((Function1 & java.io.Serializable & Serializable)f -> new Tuple2((Object)f.name(), f), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map fields = ast2.fields().groupBy((Function1 & java.io.Serializable & Serializable)x$11 -> x$11.name());
        Option option = ast2.fields().find((Function1 & java.io.Serializable & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$26(fieldMap, f)));
        if (option instanceof Some) {
            Some some = (Some)option;
            TField f2 = (TField)some.value();
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(f2.position(), new StringBuilder(21).append("Unknown field name '").append(f2.name()).append("'").toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = this.flatten((Seq)((TraversableOnce)fields.map(((Function2 & java.io.Serializable & Serializable)(Function2 & java.io.Serializable & Serializable)(name, group) -> this.fieldGroupToValue$1((String)name, (Seq)group, fieldMap, v)).tupled(), Iterable$.MODULE$.canBuildFrom())).toVector());
        } else {
            throw new MatchError((Object)option);
        }
        Left maybeMap = left;
        return maybeMap.map((Function1 & java.io.Serializable & Serializable)t -> new PMessage((Map<FieldDescriptor, PValue>)t.toMap(Predef$.MODULE$.$conforms())));
    }

    public static final /* synthetic */ double $anonfun$parseUnsafe$1(String value$1) {
        return new StringOps(Predef$.MODULE$.augmentString(value$1)).toDouble();
    }

    private static final Either parseDouble$1(TPrimitive p) {
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TLiteral) {
            TLiteral tLiteral = (TLiteral)tPrimitive;
            String value = tLiteral.value();
            String low = value.toLowerCase();
            String string = low;
            if ("inf".equals(string) ? true : "infinity".equals(string)) {
                return package$.MODULE$.Right().apply((Object)new PDouble(Double.POSITIVE_INFINITY));
            }
            if ("-inf".equals(string) ? true : "-infinity".equals(string)) {
                return package$.MODULE$.Right().apply((Object)new PDouble(Double.NEGATIVE_INFINITY));
            }
            if ("nan".equals(string)) {
                return package$.MODULE$.Right().apply((Object)new PDouble(Double.NaN));
            }
            return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new PDouble(AstUtils$.$anonfun$parseUnsafe$1(value))).toOption().toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(p.position(), new StringBuilder(28).append("Invalid value for double: '").append(value).append("'").toString()));
        }
        if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            BigInt value = tIntLiteral.value();
            return package$.MODULE$.Right().apply((Object)new PDouble(value.toDouble()));
        }
        return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.position(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
    }

    public static final /* synthetic */ float $anonfun$parseUnsafe$3(String value$2) {
        return new StringOps(Predef$.MODULE$.augmentString(value$2)).toFloat();
    }

    private static final Either parseFloat$1(TPrimitive p) {
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TLiteral) {
            TLiteral tLiteral = (TLiteral)tPrimitive;
            String value = tLiteral.value();
            String low = value.toLowerCase();
            String string = low;
            if ("inf".equals(string) ? true : ("inff".equals(string) ? true : ("infinity".equals(string) ? true : "infinityf".equals(string)))) {
                return package$.MODULE$.Right().apply((Object)new PFloat(Float.POSITIVE_INFINITY));
            }
            if ("-inf".equals(string) ? true : ("-inff".equals(string) ? true : ("-infinity".equals(string) ? true : "-infinityf".equals(string)))) {
                return package$.MODULE$.Right().apply((Object)new PFloat(Float.NEGATIVE_INFINITY));
            }
            if ("nan".equals(string) ? true : "nanf".equals(string)) {
                return package$.MODULE$.Right().apply((Object)new PFloat(Float.NaN));
            }
            return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new PFloat(AstUtils$.$anonfun$parseUnsafe$3(value))).toOption().toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(p.position(), new StringBuilder(27).append("Invalid value for float: '").append(value).append("'").toString()));
        }
        if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            BigInt value = tIntLiteral.value();
            return package$.MODULE$.Right().apply((Object)new PFloat(value.toFloat()));
        }
        return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.position(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
    }

    private static final String invalidInput$1(String v) {
        return new StringBuilder(44).append("Invalid input '").append(v).append("', expected 'true' or 'false'").toString();
    }

    private static final Either parseBoolean$1(TPrimitive p) {
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            Position index = tIntLiteral.position();
            BigInt v = tIntLiteral.value();
            if (BoxesRunTime.equalsNumObject((Number)v, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return package$.MODULE$.Right().apply((Object)new PBoolean(false));
            }
            if (BoxesRunTime.equalsNumObject((Number)v, (Object)BoxesRunTime.boxToInteger((int)1))) {
                return package$.MODULE$.Right().apply((Object)new PBoolean(true));
            }
            return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString())));
        }
        if (tPrimitive instanceof TLiteral) {
            TLiteral tLiteral = (TLiteral)tPrimitive;
            Position index = tLiteral.position();
            String v = tLiteral.value();
            String string = v.toLowerCase();
            if ("t".equals(string) ? true : "true".equals(string)) {
                return package$.MODULE$.Right().apply((Object)new PBoolean(true));
            }
            if ("f".equals(string) ? true : "false".equals(string)) {
                return package$.MODULE$.Right().apply((Object)new PBoolean(false));
            }
            return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString())));
        }
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String v = tBytes.value();
            return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.position(), AstUtils$.invalidInput$1(v)));
        }
        throw new MatchError((Object)tPrimitive);
    }

    private static final Either parseString$1(TPrimitive p) {
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            return TextFormatUtils$.MODULE$.unescapeText(value).map((Function1 & java.io.Serializable & Serializable)x$1 -> new PString(x$1)).left().map((Function1 & java.io.Serializable & Serializable)error -> new AstUtils.AstError(p.position(), error.msg()));
        }
        return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.position(), new StringBuilder(33).append("Invalid input '").append(tPrimitive.asString()).append("', expected string").toString()));
    }

    private static final Either parseBytes$1(TPrimitive p) {
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            return TextFormatUtils$.MODULE$.unescapeBytes(value).map((Function1 & java.io.Serializable & Serializable)x$2 -> new PByteString(x$2)).left().map((Function1 & java.io.Serializable & Serializable)error -> new AstUtils.AstError(p.position(), error.msg()));
        }
        return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.position(), "Unexpected input"));
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$9(BigInt num$1, EnumValueDescriptor x$3) {
        return x$3.number() == num$1.toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$12(String name$1, EnumValueDescriptor x$5) {
        String string = x$5.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Either parsePrimitive$1(FieldDescriptor field, TPrimitive p, GeneratedMessageCompanion v$1) {
        FieldDescriptorProto.Type type = field.protoType();
        if (FieldDescriptorProto$Type$TYPE_DOUBLE$.MODULE$.equals(type)) {
            return AstUtils$.parseDouble$1(p);
        }
        if (FieldDescriptorProto$Type$TYPE_FLOAT$.MODULE$.equals(type)) {
            return AstUtils$.parseFloat$1(p);
        }
        if (FieldDescriptorProto$Type$TYPE_INT64$.MODULE$.equals(type)) {
            return this.parseInt64(p);
        }
        if (FieldDescriptorProto$Type$TYPE_UINT64$.MODULE$.equals(type)) {
            return this.parseUint64(p);
        }
        if (FieldDescriptorProto$Type$TYPE_INT32$.MODULE$.equals(type)) {
            return this.parseInt32(p);
        }
        if (FieldDescriptorProto$Type$TYPE_FIXED64$.MODULE$.equals(type)) {
            return this.parseUint64(p);
        }
        if (FieldDescriptorProto$Type$TYPE_FIXED32$.MODULE$.equals(type)) {
            return this.parseUint32(p);
        }
        if (FieldDescriptorProto$Type$TYPE_BOOL$.MODULE$.equals(type)) {
            return AstUtils$.parseBoolean$1(p);
        }
        if (FieldDescriptorProto$Type$TYPE_STRING$.MODULE$.equals(type)) {
            return AstUtils$.parseString$1(p);
        }
        if (FieldDescriptorProto$Type$TYPE_BYTES$.MODULE$.equals(type)) {
            return AstUtils$.parseBytes$1(p);
        }
        if (FieldDescriptorProto$Type$TYPE_UINT32$.MODULE$.equals(type)) {
            return this.parseUint32(p);
        }
        if (FieldDescriptorProto$Type$TYPE_SFIXED32$.MODULE$.equals(type)) {
            return this.parseInt32(p);
        }
        if (FieldDescriptorProto$Type$TYPE_SFIXED64$.MODULE$.equals(type)) {
            return this.parseInt64(p);
        }
        if (FieldDescriptorProto$Type$TYPE_SINT32$.MODULE$.equals(type)) {
            return this.parseInt32(p);
        }
        if (FieldDescriptorProto$Type$TYPE_SINT64$.MODULE$.equals(type)) {
            return this.parseInt64(p);
        }
        if (FieldDescriptorProto$Type$TYPE_GROUP$.MODULE$.equals(type)) {
            return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.position(), "groups are not supported"));
        }
        if (FieldDescriptorProto$Type$TYPE_ENUM$.MODULE$.equals(type)) {
            EnumDescriptor enumDesc = v$1.enumCompanionForFieldNumber(field.number()).scalaDescriptor();
            TPrimitive tPrimitive = p;
            if (tPrimitive instanceof TIntLiteral) {
                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                Position index = tIntLiteral.position();
                BigInt num = tIntLiteral.value();
                return enumDesc.values().find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$9(num, x$3))).map((Function1 & java.io.Serializable & Serializable)x$4 -> new PEnum(x$4)).toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(47).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value with number ").append(num.toString()).toString()));
            }
            if (tPrimitive instanceof TLiteral) {
                TLiteral tLiteral = (TLiteral)tPrimitive;
                Position index = tLiteral.position();
                String name = tLiteral.value();
                return enumDesc.values().find((Function1 & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$12(name, x$5))).map((Function1 & java.io.Serializable & Serializable)x$6 -> new PEnum(x$6)).toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(43).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value named \"").append(name).append("\"").toString()));
            }
            return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.position(), new StringBuilder(38).append("Invalid value '").append(tPrimitive.asString()).append(", expected Enum type \"").append(enumDesc.asProto().getName()).append("\"").toString()));
        }
        return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.position(), "This should not happen."));
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$15(TValue x$7) {
        return !(x$7 instanceof TMessage);
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$18(TValue x$9) {
        return !(x$9 instanceof TPrimitive);
    }

    private final Either pfieldToValue$1(FieldDescriptor fd, TField pfield, GeneratedMessageCompanion v$1) {
        TValue tValue = pfield.value();
        if (tValue instanceof TArray) {
            TArray tArray = (TArray)tValue;
            if (!fd.isRepeated()) {
                return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.position(), new StringBuilder(28).append("Invalid input '[', expected ").append(fd.protoType().toString().toLowerCase()).toString()));
            }
            if (fd.protoType().isTypeMessage()) {
                int idx = tArray.values().indexWhere((Function1 & java.io.Serializable & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$15(x$7)));
                if (idx != -1) {
                    return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.position(), new StringBuilder(43).append("Array contain a non-message value at index ").append(idx).toString()));
                }
                return this.flatten((Seq)((TraversableOnce)tArray.values().map((Function1 & java.io.Serializable & Serializable)t -> MODULE$.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), (TMessage)t), Seq$.MODULE$.canBuildFrom())).toVector()).map((Function1 & java.io.Serializable & Serializable)x$8 -> new PRepeated((Vector<PValue>)x$8));
            }
            int idx = tArray.values().indexWhere((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$18(x$9)));
            if (idx != -1) {
                return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.position(), new StringBuilder(26).append("Unexpected value at index ").append(idx).toString()));
            }
            return this.flatten((Seq)((TraversableOnce)tArray.values().map((Function1 & java.io.Serializable & Serializable)t -> this.parsePrimitive$1(fd, (TPrimitive)t, v$1), Seq$.MODULE$.canBuildFrom())).toVector()).map((Function1 & java.io.Serializable & Serializable)x$10 -> new PRepeated((Vector<PValue>)x$10));
        }
        if (tValue instanceof TPrimitive) {
            TPrimitive tPrimitive = (TPrimitive)tValue;
            if (fd.protoType().isTypeMessage()) {
                return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.position(), "invalid value for message"));
            }
            return this.parsePrimitive$1(fd, tPrimitive, v$1);
        }
        if (tValue instanceof TMessage) {
            TMessage tMessage = (TMessage)tValue;
            if (!fd.protoType().isTypeMessage()) {
                return package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tMessage.position(), "invalid value for message"));
            }
            return this.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), tMessage);
        }
        throw new MatchError((Object)tValue);
    }

    private final Either fieldGroupToValue$1(String name, Seq group, Map fieldMap$1, GeneratedMessageCompanion v$1) {
        FieldDescriptor fd = (FieldDescriptor)fieldMap$1.apply((Object)name);
        Either values = this.flatten((Seq)group.map((Function1 & java.io.Serializable & Serializable)x$12 -> this.pfieldToValue$1(fd, (TField)x$12, v$1), Seq$.MODULE$.canBuildFrom()));
        return values.map((Function1 & java.io.Serializable & Serializable)t -> {
            if (!fd.isRepeated()) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fd), t.last());
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fd), (Object)new PRepeated((Vector<PValue>)((Vector)t.foldLeft((Object)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Vector xs = (Vector)tuple2._1();
                    PValue pValue = (PValue)tuple2._2();
                    if (pValue instanceof PRepeated) {
                        Vector<PValue> vector;
                        Vector<PValue> ys = vector = pValue == null ? null : ((PRepeated)pValue).value();
                        return (Vector)xs.$plus$plus(ys, Vector$.MODULE$.canBuildFrom());
                    }
                }
                if (tuple2 != null) {
                    Vector xs = (Vector)tuple2._1();
                    PValue t = (PValue)tuple2._2();
                    if (t instanceof PValue) {
                        PValue pValue = t;
                        return (Vector)xs.$colon$plus((Object)pValue, Vector$.MODULE$.canBuildFrom());
                    }
                }
                throw new MatchError((Object)tuple2);
            }))));
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$26(Map fieldMap$1, TField f) {
        return !fieldMap$1.contains((Object)f.name());
    }

    private AstUtils$() {
        MODULE$ = this;
    }
}

