/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import java.util.ArrayList;
import org.scalameta.UnreachableError$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.internal.tokenizers.LegacyScanner;
import scala.meta.internal.tokenizers.LegacyTokenData;
import scala.meta.internal.tokenizers.ScalametaTokenizer$;
import scala.meta.internal.tokenizers.WhitespaceTokenizer;
import scala.meta.internal.tokenizers.WhitespaceTokenizer$;
import scala.meta.internal.tokenizers.package;
import scala.meta.tokenizers.Tokenize;
import scala.meta.tokenizers.TokenizerOptions;
import scala.meta.tokens.Token;
import scala.meta.tokens.Token$At$;
import scala.meta.tokens.Token$BOF$;
import scala.meta.tokens.Token$CR$;
import scala.meta.tokens.Token$CRLF$;
import scala.meta.tokens.Token$Colon$;
import scala.meta.tokens.Token$Comma$;
import scala.meta.tokens.Token$Comment$;
import scala.meta.tokens.Token$Constant$Char$;
import scala.meta.tokens.Token$Constant$Double$;
import scala.meta.tokens.Token$Constant$Float$;
import scala.meta.tokens.Token$Constant$Int$;
import scala.meta.tokens.Token$Constant$Long$;
import scala.meta.tokens.Token$Constant$String$;
import scala.meta.tokens.Token$Constant$Symbol$;
import scala.meta.tokens.Token$ContextArrow$;
import scala.meta.tokens.Token$Dot$;
import scala.meta.tokens.Token$EOF$;
import scala.meta.tokens.Token$Ellipsis$;
import scala.meta.tokens.Token$Equals$;
import scala.meta.tokens.Token$FF$;
import scala.meta.tokens.Token$Hash$;
import scala.meta.tokens.Token$Ident$;
import scala.meta.tokens.Token$Interpolation$End$;
import scala.meta.tokens.Token$Interpolation$Id$;
import scala.meta.tokens.Token$Interpolation$Part$;
import scala.meta.tokens.Token$Interpolation$SpliceEnd$;
import scala.meta.tokens.Token$Interpolation$SpliceStart$;
import scala.meta.tokens.Token$Interpolation$Start$;
import scala.meta.tokens.Token$KwAbstract$;
import scala.meta.tokens.Token$KwCase$;
import scala.meta.tokens.Token$KwCatch$;
import scala.meta.tokens.Token$KwClass$;
import scala.meta.tokens.Token$KwDef$;
import scala.meta.tokens.Token$KwDo$;
import scala.meta.tokens.Token$KwElse$;
import scala.meta.tokens.Token$KwEnum$;
import scala.meta.tokens.Token$KwExport$;
import scala.meta.tokens.Token$KwExtends$;
import scala.meta.tokens.Token$KwFalse$;
import scala.meta.tokens.Token$KwFinal$;
import scala.meta.tokens.Token$KwFinally$;
import scala.meta.tokens.Token$KwFor$;
import scala.meta.tokens.Token$KwForsome$;
import scala.meta.tokens.Token$KwGiven$;
import scala.meta.tokens.Token$KwIf$;
import scala.meta.tokens.Token$KwImplicit$;
import scala.meta.tokens.Token$KwImport$;
import scala.meta.tokens.Token$KwLazy$;
import scala.meta.tokens.Token$KwMacro$;
import scala.meta.tokens.Token$KwMatch$;
import scala.meta.tokens.Token$KwNew$;
import scala.meta.tokens.Token$KwNull$;
import scala.meta.tokens.Token$KwObject$;
import scala.meta.tokens.Token$KwOverride$;
import scala.meta.tokens.Token$KwPackage$;
import scala.meta.tokens.Token$KwPrivate$;
import scala.meta.tokens.Token$KwProtected$;
import scala.meta.tokens.Token$KwReturn$;
import scala.meta.tokens.Token$KwSealed$;
import scala.meta.tokens.Token$KwSuper$;
import scala.meta.tokens.Token$KwThen$;
import scala.meta.tokens.Token$KwThis$;
import scala.meta.tokens.Token$KwThrow$;
import scala.meta.tokens.Token$KwTrait$;
import scala.meta.tokens.Token$KwTrue$;
import scala.meta.tokens.Token$KwTry$;
import scala.meta.tokens.Token$KwType$;
import scala.meta.tokens.Token$KwVal$;
import scala.meta.tokens.Token$KwVar$;
import scala.meta.tokens.Token$KwWhile$;
import scala.meta.tokens.Token$KwWith$;
import scala.meta.tokens.Token$KwYield$;
import scala.meta.tokens.Token$LF$;
import scala.meta.tokens.Token$LeftArrow$;
import scala.meta.tokens.Token$LeftBrace$;
import scala.meta.tokens.Token$LeftBracket$;
import scala.meta.tokens.Token$LeftParen$;
import scala.meta.tokens.Token$MacroQuote$;
import scala.meta.tokens.Token$MacroSplice$;
import scala.meta.tokens.Token$RightArrow$;
import scala.meta.tokens.Token$RightBrace$;
import scala.meta.tokens.Token$RightBracket$;
import scala.meta.tokens.Token$RightParen$;
import scala.meta.tokens.Token$Semicolon$;
import scala.meta.tokens.Token$Space$;
import scala.meta.tokens.Token$Subtype$;
import scala.meta.tokens.Token$Supertype$;
import scala.meta.tokens.Token$Tab$;
import scala.meta.tokens.Token$TypeLambdaArrow$;
import scala.meta.tokens.Token$Underscore$;
import scala.meta.tokens.Token$Unquote$;
import scala.meta.tokens.Token$Viewbound$;
import scala.meta.tokens.Token$Xml$End$;
import scala.meta.tokens.Token$Xml$Part$;
import scala.meta.tokens.Token$Xml$SpliceEnd$;
import scala.meta.tokens.Token$Xml$SpliceStart$;
import scala.meta.tokens.Token$Xml$Start$;
import scala.meta.tokens.Tokens;
import scala.meta.tokens.Tokens$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154AAD\b\u00011!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!I\u0003A!A!\u0002\u0017Q\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B\u001c\u0001\t\u0003A\u0004\"B \u0001\t\u0013A\u0004\"\u0002!\u0001\t\u0013\t\u0005\"\u0002&\u0001\t\u0013Y\u0005\"B'\u0001\t\u0013qu!\u00023\u0010\u0011\u0003)g!\u0002\b\u0010\u0011\u00031\u0007\"B\u0018\f\t\u00039\u0007\"\u00025\f\t\u0003I'AE*dC2\fW.\u001a;b)>\\WM\\5{KJT!\u0001E\t\u0002\u0015Q|7.\u001a8ju\u0016\u00148O\u0003\u0002\u0013'\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0015+\u0005!Q.\u001a;b\u0015\u00051\u0012!B:dC2\f7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003UI!\u0001H\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0015Ig\u000e];u!\ty\"%D\u0001!\u0015\t\t3#\u0001\u0004j]B,Ho]\u0005\u0003G\u0001\u0012Q!\u00138qkR\fq\u0001Z5bY\u0016\u001cG\u000f\u0005\u0002'O5\t1#\u0003\u0002)'\t9A)[1mK\u000e$\u0018aB8qi&|gn\u001d\t\u0003W5j\u0011\u0001\f\u0006\u0003!MI!A\f\u0017\u0003!Q{7.\u001a8ju\u0016\u0014x\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\bF\u00022kY\"\"A\r\u001b\u0011\u0005M\u0002Q\"A\b\t\u000b%\"\u00019\u0001\u0016\t\u000bu!\u0001\u0019\u0001\u0010\t\u000b\u0011\"\u0001\u0019A\u0013\u0002\u0011Q|7.\u001a8ju\u0016$\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003yM\ta\u0001^8lK:\u001c\u0018B\u0001 <\u0005\u0019!vn[3og\u0006\u0001RO\\2bG\",G\rV8lK:L'0Z\u0001\u000bO\u0016$\b,\u001c7QCJ$HC\u0001\"F!\tQ4)\u0003\u0002Ew\t)Ak\\6f]\")ai\u0002a\u0001\u000f\u0006!1-\u001e:s!\t\u0019\u0004*\u0003\u0002J\u001f\tyA*Z4bGf$vn[3o\t\u0006$\u0018-\u0001\u0005hKR$vn[3o)\t\u0011E\nC\u0003G\u0011\u0001\u0007q)\u0001\u0006hKRLeN^1mS\u0012$2a\u0014,X!\t\u00016K\u0004\u0002;#&\u0011!kO\u0001\u0006)>\\WM\\\u0005\u0003)V\u0013q!\u00138wC2LGM\u0003\u0002Sw!)a)\u0003a\u0001\u000f\")\u0001,\u0003a\u00013\u0006)QM\u001d:peB\u0011!,\u0019\b\u00037~\u0003\"\u0001X\u000b\u000e\u0003uS!AX\f\u0002\rq\u0012xn\u001c;?\u0013\t\u0001W#\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011\u0016\u0003I\u00196-\u00197b[\u0016$\u0018\rV8lK:L'0\u001a:\u0011\u0005MZ1CA\u0006\u001a)\u0005)\u0017A\u0003;p)>\\WM\\5{KV\t!\u000e\u0005\u0002,W&\u0011A\u000e\f\u0002\t)>\\WM\\5{K\u0002")
public class ScalametaTokenizer {
    private final Input input;
    private final Dialect dialect;
    private final TokenizerOptions options;

    public static Tokenize toTokenize() {
        return ScalametaTokenizer$.MODULE$.toTokenize();
    }

    public Tokens tokenize() {
        return (Tokens)this.input.tokenCache().getOrElseUpdate((Object)this.dialect, (Function0 & java.io.Serializable & Serializable)() -> this.uncachedTokenize());
    }

    private Tokens uncachedTokenize() {
        Object object;
        LegacyScanner scanner = new LegacyScanner(this.input, this.dialect);
        scanner.initialize(true);
        ArrayList<Token> tokens = new ArrayList<Token>();
        WhitespaceTokenizer whitespaceTokenizer = WhitespaceTokenizer$.MODULE$.apply(this.input, this.dialect, this.options, tokens);
        ScalametaTokenizer.pushToken$1(new Token.BOF(this.input, this.dialect), tokens);
        try {
            object = this.loop$1(ScalametaTokenizer.loop$default$1$1(), scanner, tokens, whitespaceTokenizer);
        }
        catch (package.UnexpectedInputEndException unexpectedInputEndException) {
            object = BoxedUnit.UNIT;
        }
        Token[] underlying = new Token[tokens.size()];
        tokens.toArray((Object[])underlying);
        return Tokens$.MODULE$.apply(underlying, 0, underlying.length);
    }

    private Token getXmlPart(LegacyTokenData curr) {
        int beg = curr.offset();
        int end = curr.endOffset();
        String part = new String(this.input.chars(), beg, end - beg);
        return Token$Xml$Part$.MODULE$.apply(this.input, this.dialect, beg, end, part);
    }

    private Token getToken(LegacyTokenData curr) {
        int n = curr.token();
        switch (n) {
            case 10: {
                return Token$Ident$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.strVal());
            }
            case 1002: {
                return (Token)curr.intVal().fold((Function1 & java.io.Serializable & Serializable)x$1 -> this.getInvalid(curr, (String)x$1), (Function1 & java.io.Serializable & Serializable)x$2 -> Token$Constant$Int$.MODULE$.apply($this.input, $this.dialect, curr.offset(), curr.endOffset(), (BigInt)x$2));
            }
            case 1003: {
                return (Token)curr.longVal().fold((Function1 & java.io.Serializable & Serializable)x$3 -> this.getInvalid(curr, (String)x$3), (Function1 & java.io.Serializable & Serializable)x$4 -> Token$Constant$Long$.MODULE$.apply($this.input, $this.dialect, curr.offset(), curr.endOffset(), (BigInt)x$4));
            }
            case 1004: {
                return (Token)curr.floatVal().fold((Function1 & java.io.Serializable & Serializable)x$5 -> this.getInvalid(curr, (String)x$5), (Function1 & java.io.Serializable & Serializable)x$6 -> Token$Constant$Float$.MODULE$.apply($this.input, $this.dialect, curr.offset(), curr.endOffset(), (BigDecimal)x$6));
            }
            case 1005: {
                return (Token)curr.doubleVal().fold((Function1 & java.io.Serializable & Serializable)x$7 -> this.getInvalid(curr, (String)x$7), (Function1 & java.io.Serializable & Serializable)x$8 -> Token$Constant$Double$.MODULE$.apply($this.input, $this.dialect, curr.offset(), curr.endOffset(), (BigDecimal)x$8));
            }
            case 1001: {
                return Token$Constant$Char$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.charVal());
            }
            case 1008: {
                return Token$Constant$Symbol$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), Symbol$.MODULE$.apply(curr.strVal()));
            }
            case 1006: {
                return Token$Constant$String$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.strVal());
            }
            case 25: {
                return Token$KwTrue$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 26: {
                return Token$KwFalse$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 24: {
                return Token$KwNull$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 1009: {
                return Token$Interpolation$Id$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.strVal());
            }
            case 1010: {
                return this.getXmlPart(curr);
            }
            case 20: {
                return Token$KwNew$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 21: {
                return Token$KwThis$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 23: {
                return Token$KwSuper$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 40: {
                return Token$KwImplicit$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 41: {
                return Token$KwOverride$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 43: {
                return Token$KwProtected$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 44: {
                return Token$KwPrivate$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 46: {
                return Token$KwAbstract$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 49: {
                return Token$KwFinal$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 45: {
                return Token$KwSealed$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 55: {
                return Token$KwLazy$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 57: {
                return Token$KwMacro$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 60: {
                return Token$KwPackage$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 61: {
                return Token$KwImport$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 58: {
                return Token$KwExport$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 62: {
                return Token$KwClass$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 64: {
                return Token$KwObject$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 66: {
                return Token$KwTrait$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 68: {
                return Token$KwExtends$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 69: {
                return Token$KwWith$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 70: {
                return Token$KwType$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 71: {
                return Token$KwForsome$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 72: {
                return Token$KwDef$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 73: {
                return Token$KwVal$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 74: {
                return Token$KwVar$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 75: {
                return Token$KwEnum$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 76: {
                return Token$KwGiven$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 80: {
                return Token$KwIf$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 82: {
                return Token$KwElse$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 83: {
                return Token$KwWhile$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 84: {
                return Token$KwDo$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 85: {
                return Token$KwFor$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 86: {
                return Token$KwYield$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 81: {
                return Token$KwThen$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 90: {
                return Token$KwThrow$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 91: {
                return Token$KwTry$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 92: {
                return Token$KwCatch$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 93: {
                return Token$KwFinally$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 96: {
                return Token$KwCase$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 97: {
                return Token$KwReturn$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 95: {
                return Token$KwMatch$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 100: {
                return Token$LeftParen$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 101: {
                return Token$RightParen$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 102: {
                return Token$LeftBracket$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 103: {
                return Token$RightBracket$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 104: {
                return Token$LeftBrace$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 105: {
                return Token$RightBrace$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 120: {
                return Token$Comma$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 121: {
                return Token$Semicolon$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 122: {
                return Token$Dot$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 123: {
                return Token$Colon$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 124: {
                return Token$Equals$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 125: {
                return Token$At$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 130: {
                return Token$Hash$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 131: {
                return Token$Underscore$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 132: {
                return Token$RightArrow$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset());
            }
            case 133: {
                return Token$LeftArrow$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset());
            }
            case 134: {
                return Token$Subtype$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 135: {
                return Token$Supertype$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 136: {
                return Token$Viewbound$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 137: {
                return Token$TypeLambdaArrow$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 138: {
                return Token$ContextArrow$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 402: {
                return Token$MacroQuote$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 403: {
                return Token$MacroSplice$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 201: {
                return Token$Space$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 202: {
                return Token$Tab$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 205: {
                return Token$CR$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 203: {
                return Token$LF$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 206: {
                return Token$CRLF$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 204: {
                return Token$FF$.MODULE$.apply(this.input, this.dialect, curr.offset());
            }
            case 300: {
                String value = new String(this.input.chars(), curr.offset(), curr.endOffset() - curr.offset());
                if (value.startsWith("//")) {
                    value = new StringOps(Predef$.MODULE$.augmentString(value)).stripPrefix("//");
                }
                if (value.startsWith("/*")) {
                    value = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(value)).stripPrefix("/*"))).stripSuffix("*/");
                }
                return Token$Comment$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), value);
            }
            case 401: {
                return Token$Ellipsis$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.base());
            }
            case 400: {
                return Token$Unquote$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset());
            }
            case 0: {
                return new Token.EOF(this.input, this.dialect);
            }
            case 1: {
                return new Token.Shebang(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.strVal());
            }
            case 2: {
                return this.getInvalid(curr, curr.strVal());
            }
        }
        return this.getInvalid(curr, new StringBuilder(32).append("Unexpected token id ").append(curr.token()).append(", contents:\n").append(curr.strVal()).toString());
    }

    private Token.Invalid getInvalid(LegacyTokenData curr, String error) {
        return new Token.Invalid(this.input, this.dialect, curr.offset(), curr.endOffset(), error);
    }

    private static final void pushToken$1(Token token, ArrayList tokens$1) {
        tokens$1.add(token);
    }

    private final LegacyTokenData nextToken$1(LegacyScanner scanner$1, ArrayList tokens$1) {
        LegacyTokenData nt = scanner$1.nextToken();
        if (nt.token() == 2) {
            ScalametaTokenizer.pushToken$1(this.getToken(nt), tokens$1);
            return scanner$1.nextToken();
        }
        return nt;
    }

    private static final Token lastEmittedToken$1(ArrayList tokens$1) {
        return (Token)tokens$1.get(tokens$1.size() - 1);
    }

    private static final boolean isAtLineStart$1(ArrayList tokens$1) {
        return ScalametaTokenizer.lastEmittedToken$1(tokens$1) instanceof Token.AtEOLorF;
    }

    private final Token emitTokenWhitespace$1(Token.Whitespace token, WhitespaceTokenizer whitespaceTokenizer$1, LegacyScanner scanner$1, ArrayList tokens$1) {
        Token token2;
        while (true) {
            Token.Whitespace whitespace;
            LegacyTokenData next = this.nextToken$1(scanner$1, tokens$1);
            Token.Whitespace whitespace2 = token;
            if (whitespace2 instanceof Token.HSpace) {
                Token.HSpace hSpace = (Token.HSpace)whitespace2;
                whitespaceTokenizer$1.pushHS(hSpace);
            } else if (whitespace2 instanceof Token.EOL) {
                Token.EOL eOL = (Token.EOL)whitespace2;
                whitespaceTokenizer$1.pushVS(eOL);
            } else {
                throw UnreachableError$.MODULE$.raise((Map<String, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"t", (Object)whitespace2)}))), "not a whitespace token");
            }
            token2 = this.getToken(next);
            if (!(token2 instanceof Token.Whitespace)) break;
            token = whitespace = (Token.Whitespace)token2;
        }
        whitespaceTokenizer$1.flush();
        return token2;
    }

    private final void pushPart$1(LegacyTokenData curr, ArrayList tokens$1) {
        ScalametaTokenizer.pushToken$1(Token$Interpolation$Part$.MODULE$.apply(this.input, this.dialect, curr.offset(), curr.endOffset(), curr.strVal()), tokens$1);
    }

    private final LegacyTokenData emitContents$1(LegacyTokenData beg, ArrayList tokens$1, LegacyScanner scanner$1, WhitespaceTokenizer whitespaceTokenizer$1) {
        while (beg.token() == 1007) {
            LegacyTokenData legacyTokenData;
            int dollarOffset = beg.endOffset();
            this.pushPart$1(beg, tokens$1);
            ScalametaTokenizer.pushToken$1(Token$Interpolation$SpliceStart$.MODULE$.apply(this.input, this.dialect, dollarOffset, dollarOffset + 1), tokens$1);
            LegacyTokenData splice = this.nextToken$1(scanner$1, tokens$1);
            if (splice.token() == 1007) {
                legacyTokenData = splice;
            } else {
                ScalametaTokenizer.pushToken$1(this.getToken(splice), tokens$1);
                Object object = splice.token() == 104 ? this.loop$1(1, scanner$1, tokens$1, whitespaceTokenizer$1) : BoxedUnit.UNIT;
                legacyTokenData = this.nextToken$1(scanner$1, tokens$1);
            }
            LegacyTokenData end = legacyTokenData;
            ScalametaTokenizer.pushToken$1(Token$Interpolation$SpliceEnd$.MODULE$.apply(this.input, this.dialect, end.offset(), end.offset()), tokens$1);
            beg = end;
        }
        return beg;
    }

    private final Token emitTokenInterpolation$1(Token.Interpolation.Id token, ArrayList tokens$1, LegacyScanner scanner$1, WhitespaceTokenizer whitespaceTokenizer$1) {
        ScalametaTokenizer.pushToken$1(token, tokens$1);
        LegacyTokenData beg = this.nextToken$1(scanner$1, tokens$1);
        ScalametaTokenizer.pushToken$1(Token$Interpolation$Start$.MODULE$.apply(this.input, this.dialect, token.end(), beg.offset()), tokens$1);
        LegacyTokenData end = this.emitContents$1(beg, tokens$1, scanner$1, whitespaceTokenizer$1);
        int endEndPos = end.endOffset();
        this.pushPart$1(end, tokens$1);
        LegacyTokenData next = this.nextToken$1(scanner$1, tokens$1);
        ScalametaTokenizer.pushToken$1(Token$Interpolation$End$.MODULE$.apply(this.input, this.dialect, endEndPos, next.offset()), tokens$1);
        return this.getToken(next);
    }

    private final void emitContents$2(LegacyTokenData beg, ArrayList tokens$1, LegacyScanner scanner$1, WhitespaceTokenizer whitespaceTokenizer$1) {
        block5: while (true) {
            int n = beg.token();
            switch (n) {
                case 1010: {
                    ScalametaTokenizer.pushToken$1(this.getXmlPart(beg), tokens$1);
                    beg = this.nextToken$1(scanner$1, tokens$1);
                    continue block5;
                }
                case 104: {
                    ScalametaTokenizer.pushToken$1(Token$Xml$SpliceStart$.MODULE$.apply(this.input, this.dialect, beg.offset(), beg.offset()), tokens$1);
                    ScalametaTokenizer.pushToken$1(this.getToken(beg), tokens$1);
                    this.loop$1(1, scanner$1, tokens$1, whitespaceTokenizer$1);
                    LegacyTokenData end = this.nextToken$1(scanner$1, tokens$1);
                    ScalametaTokenizer.pushToken$1(Token$Xml$SpliceEnd$.MODULE$.apply(this.input, this.dialect, end.offset(), end.offset()), tokens$1);
                    beg = end;
                    continue block5;
                }
                case 1011: {
                    int xmlEndIndex = beg.endOffset();
                    ScalametaTokenizer.pushToken$1(Token$Xml$End$.MODULE$.apply(this.input, this.dialect, xmlEndIndex, xmlEndIndex), tokens$1);
                    break block5;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            break;
        }
    }

    private final void emitTokenXml$1(Token.Xml.Part token, ArrayList tokens$1, LegacyScanner scanner$1, WhitespaceTokenizer whitespaceTokenizer$1) {
        ScalametaTokenizer.pushToken$1(Token$Xml$Start$.MODULE$.apply(this.input, this.dialect, token.start(), token.start()), tokens$1);
        ScalametaTokenizer.pushToken$1(token, tokens$1);
        this.emitContents$2(this.nextToken$1(scanner$1, tokens$1), tokens$1, scanner$1, whitespaceTokenizer$1);
    }

    private final void emitToken$1(Token token, ArrayList tokens$1, LegacyScanner scanner$1, WhitespaceTokenizer whitespaceTokenizer$1) {
        Token token2;
        while (true) {
            if ((token2 = token) instanceof Token.At && this.input instanceof Input.Ammonite && ScalametaTokenizer.isAtLineStart$1(tokens$1)) {
                Token token3 = this.getToken(this.nextToken$1(scanner$1, tokens$1));
                if (token3 instanceof Token.Whitespace) {
                    Token.Whitespace whitespace = (Token.Whitespace)token3;
                    ScalametaTokenizer.pushToken$1(Token$EOF$.MODULE$.apply(this.input, this.dialect, token.start()), tokens$1);
                    ScalametaTokenizer.pushToken$1(token, tokens$1);
                    ScalametaTokenizer.pushToken$1(Token$BOF$.MODULE$.apply(this.input, this.dialect, token.end()), tokens$1);
                    token = this.emitTokenWhitespace$1(whitespace, whitespaceTokenizer$1, scanner$1, tokens$1);
                    continue;
                }
                ScalametaTokenizer.pushToken$1(token, tokens$1);
                token = token3;
                continue;
            }
            if (token2 instanceof Token.Whitespace) {
                Token.Whitespace whitespace = (Token.Whitespace)token2;
                token = this.emitTokenWhitespace$1(whitespace, whitespaceTokenizer$1, scanner$1, tokens$1);
                continue;
            }
            if (!(token2 instanceof Token.Interpolation.Id)) break;
            Token.Interpolation.Id id = (Token.Interpolation.Id)token2;
            token = this.emitTokenInterpolation$1(id, tokens$1, scanner$1, whitespaceTokenizer$1);
        }
        if (token2 instanceof Token.Xml.Part) {
            Token.Xml.Part part = (Token.Xml.Part)token2;
            this.emitTokenXml$1(part, tokens$1, scanner$1, whitespaceTokenizer$1);
        } else {
            ScalametaTokenizer.pushToken$1(token, tokens$1);
        }
    }

    private final LegacyTokenData loop$1(int braceBalance, LegacyScanner scanner$1, ArrayList tokens$1, WhitespaceTokenizer whitespaceTokenizer$1) {
        LegacyTokenData curr;
        while ((curr = scanner$1.nextTokenOrEof()).ok()) {
            this.emitToken$1(this.getToken(curr), tokens$1, scanner$1, whitespaceTokenizer$1);
            boolean bl = false;
            Token.RightBrace rightBrace = null;
            Token token = ScalametaTokenizer.lastEmittedToken$1(tokens$1);
            if (token instanceof Token.RightBrace) {
                bl = true;
                rightBrace = (Token.RightBrace)token;
                if (braceBalance == 1) {
                    return curr;
                }
            }
            if (bl && braceBalance > 1) {
                --braceBalance;
                continue;
            }
            if (!(token instanceof Token.LeftBrace) || braceBalance <= 0) continue;
            ++braceBalance;
        }
        return curr;
    }

    private static final int loop$default$1$1() {
        return 0;
    }

    public ScalametaTokenizer(Input input, Dialect dialect, TokenizerOptions options) {
        this.input = input;
        this.dialect = dialect;
        this.options = options;
    }
}

