/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import scala.Predef$;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.internal.tokenizers.CharArrayReaderData;
import scala.meta.internal.tokenizers.CharArrayReaderData$class;
import scala.meta.internal.tokenizers.Chars$;
import scala.meta.internal.tokenizers.Reporter;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u0017\ty1\t[1s\u0003J\u0014\u0018-\u001f*fC\u0012,'O\u0003\u0002\u0004\t\u0005QAo\\6f]&TXM]:\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u001dA\u0011\u0001B7fi\u0006T\u0011!C\u0001\u0006g\u000e\fG.Y\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011\u0001C\u0005\u0003\u001f!\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005M\u0019\u0005.\u0019:BeJ\f\u0017PU3bI\u0016\u0014H)\u0019;b\u0011!)\u0002A!A!\u0002\u00131\u0012!B5oaV$\bCA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003\u0019Ig\u000e];ug&\u00111\u0004\u0007\u0002\u0006\u0013:\u0004X\u000f\u001e\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u00059A-[1mK\u000e$\bCA\u0010!\u001b\u00051\u0011BA\u0011\u0007\u0005\u001d!\u0015.\u00197fGRD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\te\u0016\u0004xN\u001d;feB\u0011\u0011#J\u0005\u0003M\t\u0011\u0001BU3q_J$XM\u001d\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)ZC&\f\t\u0003#\u0001AQ!F\u0014A\u0002YAQ!H\u0014A\u0002yAQaI\u0014A\u0002\u0011Bqa\f\u0001C\u0002\u0013\u0005\u0001'A\u0002ck\u001a,\u0012!\r\t\u0004\u001bI\"\u0014BA\u001a\t\u0005\u0015\t%O]1z!\tiQ'\u0003\u00027\u0011\t!1\t[1s\u0011\u0019A\u0004\u0001)A\u0005c\u0005!!-\u001e4!\u0011\u001dQ\u0004\u00011A\u0005\u0002m\nq\"[:V]&\u001cw\u000eZ3Fg\u000e\f\u0007/Z\u000b\u0002yA\u0011Q\"P\u0005\u0003}!\u0011qAQ8pY\u0016\fg\u000eC\u0004A\u0001\u0001\u0007I\u0011A!\u0002'%\u001cXK\\5d_\u0012,Wi]2ba\u0016|F%Z9\u0015\u0005\t+\u0005CA\u0007D\u0013\t!\u0005B\u0001\u0003V]&$\bb\u0002$@\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0004B\u0002%\u0001A\u0003&A(\u0001\tjgVs\u0017nY8eK\u0016\u001b8-\u00199fA!)!\n\u0001C\u0003\u0017\u0006Aa.\u001a=u\u0007\"\f'\u000fF\u0001C\u0011\u0015i\u0005\u0001\"\u0002L\u0003-qW\r\u001f;SC^\u001c\u0005.\u0019:\t\u000b=\u0003A\u0011B&\u0002!A|G/\u001a8uS\u0006dWK\\5d_\u0012,\u0007\"B)\u0001\t\u0013Y\u0015AB:lSB\u001c%\u000bC\u0003T\u0001\u0011%1*\u0001\tq_R,g\u000e^5bY2Kg.Z#oI\")Q\u000b\u0001C\u0001-\u0006yAn\\8lC\",\u0017\r\u001a*fC\u0012,'/F\u0001X!\tA\u0016,D\u0001\u0001\r\u0011Q\u0006\u0001A.\u00031\rC\u0017M]!se\u0006LHj\\8lC\",\u0017\r\u001a*fC\u0012,'o\u0005\u0002ZU!)\u0001&\u0017C\u0001;R\tq\u000bC\u0003`3\u0012\u0005\u0001-\u0001\u0003hKR\u001cG#\u0001\u001b\t\u000b\tLF\u0011\u00011\u0002\t\u001d,G/\u001e")
public class CharArrayReader
implements CharArrayReaderData {
    public final Input scala$meta$internal$tokenizers$CharArrayReader$$input;
    public final Dialect scala$meta$internal$tokenizers$CharArrayReader$$dialect;
    public final Reporter scala$meta$internal$tokenizers$CharArrayReader$$reporter;
    private final char[] buf;
    private boolean isUnicodeEscape;
    private char ch;
    private int charOffset;
    private int lineStartOffset;
    private int lastLineStartOffset;
    private int lastUnicodeOffset;

    @Override
    public char ch() {
        return this.ch;
    }

    @Override
    @TraitSetter
    public void ch_$eq(char x$1) {
        this.ch = x$1;
    }

    @Override
    public int charOffset() {
        return this.charOffset;
    }

    @Override
    @TraitSetter
    public void charOffset_$eq(int x$1) {
        this.charOffset = x$1;
    }

    @Override
    public int lineStartOffset() {
        return this.lineStartOffset;
    }

    @Override
    @TraitSetter
    public void lineStartOffset_$eq(int x$1) {
        this.lineStartOffset = x$1;
    }

    @Override
    public int lastLineStartOffset() {
        return this.lastLineStartOffset;
    }

    @Override
    @TraitSetter
    public void lastLineStartOffset_$eq(int x$1) {
        this.lastLineStartOffset = x$1;
    }

    @Override
    public int lastUnicodeOffset() {
        return this.lastUnicodeOffset;
    }

    @Override
    @TraitSetter
    public void lastUnicodeOffset_$eq(int x$1) {
        this.lastUnicodeOffset = x$1;
    }

    public char[] buf() {
        return this.buf;
    }

    public boolean isUnicodeEscape() {
        return this.isUnicodeEscape;
    }

    public void isUnicodeEscape_$eq(boolean x$1) {
        this.isUnicodeEscape = x$1;
    }

    public final void nextChar() {
        if (this.isUnicodeEscape()) {
            this.charOffset_$eq(this.lastUnicodeOffset());
        }
        this.isUnicodeEscape_$eq(false);
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[this.charOffset()];
            this.ch_$eq(c);
            this.charOffset_$eq(this.charOffset() + 1);
            if (c == '\\') {
                this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            }
            if (this.ch() < ' ') {
                this.skipCR();
                this.potentialLineEnd();
            }
            if (this.ch() == '\"' && !this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
                throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("double quotes are not allowed in single-line quasiquotes", this.charOffset() - 1);
            }
        }
    }

    public final void nextRawChar() {
        if (this.isUnicodeEscape()) {
            this.charOffset_$eq(this.lastUnicodeOffset());
        }
        this.isUnicodeEscape_$eq(false);
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[this.charOffset()];
            this.ch_$eq(c);
            this.charOffset_$eq(this.charOffset() + 1);
            if (c == '\\') {
                this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            }
        }
    }

    public void scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode() {
        int end = this.charOffset();
        if (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u' && this.evenSlashPrefix$1()) {
            do {
                this.charOffset_$eq(this.charOffset() + 1);
            } while (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u');
            int code = this.udigit$1() << 12 | this.udigit$1() << 8 | this.udigit$1() << 4 | this.udigit$1();
            this.lastUnicodeOffset_$eq(this.charOffset());
            this.isUnicodeEscape_$eq(true);
            this.ch_$eq((char)code);
        }
        if (end < this.buf().length) {
            this.charOffset_$eq(end);
        }
    }

    private void skipCR() {
        if (this.ch() == '\r' && this.charOffset() < this.buf().length) {
            char c = this.buf()[this.charOffset()];
            switch (c) {
                case '\\': {
                    if (this.lookaheadReader().getu() != '\n') break;
                    this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
                }
            }
        }
    }

    private void potentialLineEnd() {
        if (this.ch() == '\n' || this.ch() == '\f') {
            if (this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
                this.lastLineStartOffset_$eq(this.lineStartOffset());
                this.lineStartOffset_$eq(this.charOffset());
            } else {
                throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("line breaks are not allowed in single-line quasiquotes", this.charOffset() - 1);
            }
        }
    }

    public CharArrayLookaheadReader lookaheadReader() {
        return new CharArrayLookaheadReader();
    }

    private final boolean evenSlashPrefix$1() {
        int p;
        for (p = this.charOffset() - 2; p >= 0 && this.buf()[p] == '\\'; --p) {
        }
        return (this.charOffset() - p) % 2 == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int udigit$1() {
        if (this.charOffset() >= this.buf().length) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("incomplete unicode escape", this.charOffset() - 1);
        }
        int d = Chars$.MODULE$.digit2int(this.buf()[this.charOffset()], 16);
        if (d >= 0) {
            void var1_1;
            this.charOffset_$eq(this.charOffset() + 1);
            return (int)var1_1;
        }
        throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("error in unicode escape", this.charOffset());
    }

    public CharArrayReader(Input input, Dialect dialect, Reporter reporter) {
        this.scala$meta$internal$tokenizers$CharArrayReader$$input = input;
        this.scala$meta$internal$tokenizers$CharArrayReader$$dialect = dialect;
        this.scala$meta$internal$tokenizers$CharArrayReader$$reporter = reporter;
        CharArrayReaderData$class.$init$(this);
        this.buf = input.chars();
        this.isUnicodeEscape = false;
    }

    public class CharArrayLookaheadReader
    extends CharArrayReader {
        public char getc() {
            this.nextChar();
            return this.ch();
        }

        public char getu() {
            Predef$.MODULE$.require(this.buf()[this.charOffset()] == '\\');
            this.ch_$eq('\\');
            this.charOffset_$eq(this.charOffset() + 1);
            this.scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer().scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            return this.ch();
        }

        public /* synthetic */ CharArrayReader scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer() {
            return CharArrayReader.this;
        }

        public CharArrayLookaheadReader() {
            if (CharArrayReader.this == null) {
                throw null;
            }
            super(CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$input, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$dialect, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$reporter);
            this.charOffset_$eq(CharArrayReader.this.charOffset());
            this.ch_$eq(CharArrayReader.this.ch());
        }
    }
}

