/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.prettyprinters;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.meta.Dialect;
import scala.meta.internal.tokens.Chars$;
import scala.meta.prettyprinters.Show;
import scala.meta.prettyprinters.Show$;
import scala.meta.prettyprinters.Structure;
import scala.meta.prettyprinters.Structure$;
import scala.meta.tokens.Token;

public final class TokenStructure$ {
    public static TokenStructure$ MODULE$;

    static {
        new TokenStructure$();
    }

    public <T extends Token> Structure<T> apply() {
        return Structure$.MODULE$.apply((Function1 & java.io.Serializable & Serializable)x -> {
            String string;
            Dialect dialect = x.dialect();
            Token token = x;
            if (token instanceof Token.Ident) {
                Token.Ident ident = (Token.Ident)token;
                string = ident.value();
            } else if (token instanceof Token.Constant.Char) {
                Token.Constant.Char char_ = (Token.Constant.Char)token;
                string = Chars$.MODULE$.escape(char_.value());
            } else if (token instanceof Token.Constant.String) {
                Token.Constant.String string2 = (Token.Constant.String)token;
                string = Chars$.MODULE$.escape(string2.value());
            } else if (token instanceof Token.Constant.Symbol) {
                Token.Constant.Symbol symbol = (Token.Constant.Symbol)token;
                string = Chars$.MODULE$.escape(symbol.value().name());
            } else if (token instanceof Token.NumericConstant) {
                Token.NumericConstant numericConstant = (Token.NumericConstant)token;
                string = numericConstant.value().toString();
            } else if (token instanceof Token.Interpolation.Id) {
                Token.Interpolation.Id id = (Token.Interpolation.Id)token;
                string = Chars$.MODULE$.escape(id.value());
            } else if (token instanceof Token.Interpolation.Start) {
                Token.Interpolation.Start start = (Token.Interpolation.Start)token;
                string = start.text();
            } else if (token instanceof Token.Interpolation.Part) {
                Token.Interpolation.Part part = (Token.Interpolation.Part)token;
                string = Chars$.MODULE$.escape(part.value());
            } else if (token instanceof Token.Interpolation.End) {
                Token.Interpolation.End end = (Token.Interpolation.End)token;
                string = end.text();
            } else if (token instanceof Token.Xml.Part) {
                Token.Xml.Part part = (Token.Xml.Part)token;
                string = Chars$.MODULE$.escape(part.value());
            } else if (token instanceof Token.Comment) {
                Token.Comment comment = (Token.Comment)token;
                string = Chars$.MODULE$.escape(comment.value());
            } else if (token instanceof Token.Ellipsis) {
                Token.Ellipsis ellipsis = (Token.Ellipsis)token;
                string = Integer.toString(ellipsis.rank());
            } else if (token instanceof Token.Unquote) {
                Token.Unquote unquote = (Token.Unquote)token;
                string = unquote.text();
            } else if (token instanceof Token.MultiHS) {
                Token.MultiHS multiHS = (Token.MultiHS)token;
                string = Integer.toString(multiHS.len());
            } else if (token instanceof Token.MultiNL) {
                Token.MultiNL multiNL = (Token.MultiNL)token;
                string = Integer.toString(multiNL.tokens().length());
            } else if (token instanceof Token.Invalid) {
                Token.Invalid invalid = (Token.Invalid)token;
                string = invalid.error();
            } else {
                string = null;
            }
            String text = string;
            String name = x.getClass().getName();
            int idx = name.lastIndexOf(".Token$");
            String label = idx < 0 ? x.name() : name.substring(idx + 7).replace("$", ".");
            Show.Result syntax = text == null ? Show$.MODULE$.mkseq((Seq)Nil$.MODULE$) : Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"("), Show$.MODULE$.printString().apply((Object)text), Show$.MODULE$.printString().apply((Object)")")}));
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)label), syntax, Show$.MODULE$.printString().apply((Object)" ["), Show$.MODULE$.printString().apply((Object)Integer.toString(x.start())), Show$.MODULE$.printString().apply((Object)".."), Show$.MODULE$.printString().apply((Object)Integer.toString(x.end())), Show$.MODULE$.printString().apply((Object)")")}));
        });
    }

    private TokenStructure$() {
        MODULE$ = this;
    }
}

