/*
 * Decompiled with CFR 0.152.
 */
package breeze.plot;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;

public final class ExportGraphics$ {
    public static final ExportGraphics$ MODULE$ = new ExportGraphics$();

    public void writeFile(File file, Function1<Graphics2D, BoxedUnit> draw, int width, int height, int dpi) {
        LazyRef fos$lzy = new LazyRef();
        if (file.getName().toLowerCase().endsWith(".png")) {
            try {
                this.writePNG(ExportGraphics$.fos$1(fos$lzy, file), draw, width, height, dpi);
            }
            finally {
                ExportGraphics$.fos$1(fos$lzy, file).close();
            }
        } else if (file.getName().toLowerCase().endsWith(".eps")) {
            try {
                this.writeEPS(ExportGraphics$.fos$1(fos$lzy, file), draw, width, height);
            }
            finally {
                ExportGraphics$.fos$1(fos$lzy, file).close();
            }
        } else if (file.getName().toLowerCase().endsWith(".pdf")) {
            try {
                this.writePDF(ExportGraphics$.fos$1(fos$lzy, file), draw, width, height);
            }
            finally {
                ExportGraphics$.fos$1(fos$lzy, file).close();
            }
        } else {
            throw new IOException("Unrecognized file extension: should be png, svg, eps, or pdf");
        }
    }

    public int writeFile$default$5() {
        return 72;
    }

    public void writePNG(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height, int dpi) {
        double scale = (double)dpi / 72.0;
        int swidth = (int)((double)width * scale);
        int sheight = (int)((double)height * scale);
        BufferedImage image = new BufferedImage(swidth, sheight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.scale(scale, scale);
        draw.apply((Object)g2d);
        g2d.dispose();
        ImageIO.write((RenderedImage)image, "png", out);
    }

    public int writePNG$default$5() {
        return 72;
    }

    public void writeEPS(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height) {
        EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        g2d.setupDocument(out, width, height);
        draw.apply((Object)g2d);
        g2d.finish();
    }

    public void writePDF(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, float width, float height) {
        try (Document document = new Document();){
            document.setPageSize(new Rectangle(width, height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(width, height);
            Graphics2D g2d = tp.createGraphics(width, height);
            draw.apply((Object)g2d);
            g2d.dispose();
            cb.addTemplate(tp, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    private static final /* synthetic */ FileOutputStream fos$lzycompute$1(LazyRef fos$lzy$1, File file$1) {
        FileOutputStream fileOutputStream;
        LazyRef lazyRef = fos$lzy$1;
        synchronized (lazyRef) {
            fileOutputStream = fos$lzy$1.initialized() ? (FileOutputStream)fos$lzy$1.value() : (FileOutputStream)fos$lzy$1.initialize((Object)new FileOutputStream(file$1));
        }
        return fileOutputStream;
    }

    private static final FileOutputStream fos$1(LazyRef fos$lzy$1, File file$1) {
        return fos$lzy$1.initialized() ? (FileOutputStream)fos$lzy$1.value() : ExportGraphics$.fos$lzycompute$1(fos$lzy$1, file$1);
    }

    private ExportGraphics$() {
    }
}

