/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.generic.UFunc$;
import breeze.io.CSVReader$;
import breeze.io.CSVWriter$;
import breeze.linalg.$times$;
import breeze.linalg.Axis$_0$;
import breeze.linalg.BroadcastedColumns$;
import breeze.linalg.BroadcastedRows$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.MatrixEmptyException;
import breeze.linalg.MatrixLike;
import breeze.linalg.MatrixNotSquareException;
import breeze.linalg.MatrixNotSymmetricException;
import breeze.linalg.NumericOps;
import breeze.linalg.PCA;
import breeze.linalg.Vector;
import breeze.linalg.argsort$;
import breeze.linalg.package;
import breeze.linalg.package$;
import breeze.linalg.scaleAdd$;
import breeze.linalg.sum$;
import breeze.linalg.support.CanCopy;
import breeze.math.Ring;
import breeze.math.Semiring;
import breeze.storage.DefaultArrayValue;
import breeze.storage.DefaultArrayValue$DoubleDefaultArrayValue$;
import java.io.File;
import java.io.FileReader;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.SeqLike;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public <A, X, Y> void axpy(A a, X x, Y y, UFunc.InPlaceImpl3<scaleAdd$, Y, A, X> axpy) {
        axpy.apply(y, a, x);
    }

    public DenseVector<Object> linspace(double a, double b, int length) {
        double increment = (b - a) / (double)(length - 1);
        return (DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp(length, (Function1<Object, Object>)new Serializable(a, increment){
            public static final long serialVersionUID = 0L;
            private final double a$1;
            private final double increment$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return this.a$1 + this.increment$1 * (double)i;
            }
            {
                this.a$1 = a$1;
                this.increment$1 = increment$1;
            }
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double());
    }

    public int linspace$default$3() {
        return 100;
    }

    public <T> T copy(T t, CanCopy<T> canCopy) {
        return canCopy.apply(t);
    }

    public DenseMatrix<Object> csvread(File file, char separator, char quote, char escape, int skipLines) {
        FileReader input = new FileReader(file);
        ObjectRef mat = new ObjectRef(CSVReader$.MODULE$.read(input, separator, quote, escape, skipLines));
        mat.elem = (IndexedSeq)((IndexedSeq)mat.elem).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(IndexedSeq<String> line) {
                return line.length() != 0 && new StringOps(Predef$.MODULE$.augmentString((String)line.head())).nonEmpty();
            }
        });
        input.close();
        return ((IndexedSeq)mat.elem).length() == 0 ? DenseMatrix$.MODULE$.zeros$mDc$sp(0, 0, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$) : (DenseMatrix)DenseMatrix$.MODULE$.tabulate$mDc$sp(((IndexedSeq)mat.elem).length(), ((SeqLike)((IndexedSeq)mat.elem).head()).length(), (Function2<Object, Object, Object>)new Serializable(mat){
            public static final long serialVersionUID = 0L;
            private final ObjectRef mat$2;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                return new StringOps(Predef$.MODULE$.augmentString((String)((SeqLike)((IndexedSeq)this.mat$2.elem).apply(i)).apply(j))).toDouble();
            }
            {
                this.mat$2 = mat$2;
            }
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$);
    }

    public char csvread$default$2() {
        return ',';
    }

    public char csvread$default$3() {
        return '\"';
    }

    public char csvread$default$4() {
        return '\\';
    }

    public int csvread$default$5() {
        return 0;
    }

    public void csvwrite(File file, Matrix<Object> mat, char separator, char quote, char escape, int skipLines) {
        CSVWriter$.MODULE$.writeFile(file, (IndexedSeq<IndexedSeq<String>>)((IndexedSeq)scala.package$.MODULE$.IndexedSeq().tabulate(mat.rows(), mat.cols(), (Function2)new Serializable(mat){
            public static final long serialVersionUID = 0L;
            private final Matrix mat$3;

            public final String apply(int x$1, int x$2) {
                return ((Object)BoxesRunTime.boxToDouble((double)this.mat$3.apply$mcD$sp(x$1, x$2))).toString();
            }
            {
                this.mat$3 = mat$3;
            }
        })), separator, quote, escape);
    }

    public char csvwrite$default$3() {
        return ',';
    }

    public char csvwrite$default$4() {
        return '\u0000';
    }

    public char csvwrite$default$5() {
        return '\\';
    }

    public int csvwrite$default$6() {
        return 0;
    }

    public package.RangeExtender RangeExtender(Range re) {
        return new package.RangeExtender(re);
    }

    public <V> void requireNonEmptyMatrix(Matrix<V> mat) {
        if (mat.cols() == 0 || mat.rows() == 0) {
            throw new MatrixEmptyException();
        }
    }

    public <V> void requireSquareMatrix(Matrix<V> mat) {
        if (mat.rows() != mat.cols()) {
            throw new MatrixNotSquareException();
        }
    }

    public <V> void requireSymmetricMatrix(Matrix<V> mat) {
        this.requireSquareMatrix(mat);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mat.rows()).foreach$mVc$sp((Function1)new Serializable(mat){
            public static final long serialVersionUID = 0L;
            public final Matrix mat$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.requireSymmetricMatrix.1 $outer;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        if (BoxesRunTime.equals(this.$outer.mat$1.apply(this.i$1, j), this.$outer.mat$1.apply(j, this.i$1))) {
                            return;
                        }
                        throw new MatrixNotSymmetricException();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.mat$1 = mat$1;
            }
        });
    }

    public <V1> DenseVector<V1> cross(DenseVector<V1> a, DenseVector<V1> b, Ring<V1> ring, ClassTag<V1> man) {
        Predef$.MODULE$.require(a.length() == 3);
        Predef$.MODULE$.require(b.length() == 3);
        return (DenseVector)DenseVector$.MODULE$.apply(Predef$.MODULE$.genericWrapArray((Object)new Object[]{ring.$minus(ring.$times(a.apply(1), b.apply(2)), ring.$times(a.apply(2), b.apply(1))), ring.$minus(ring.$times(a.apply(2), b.apply(0)), ring.$times(a.apply(0), b.apply(2))), ring.$minus(ring.$times(a.apply(0), b.apply(1)), ring.$times(a.apply(1), b.apply(0)))}), man);
    }

    public <V> double[] ranks(Vector<V> x, Ordering<V> evidence$1) {
        int numTiedValuesAtI;
        Vector<V> a = x;
        IndexedSeq as = argsort$.MODULE$.apply(a, argsort$.MODULE$.argsortQuasiTensorWithOrdering(evidence$1, Predef$.MODULE$.conforms()));
        double[] rv = new double[as.length()];
        for (int i = 0; i < as.length(); i += numTiedValuesAtI) {
            numTiedValuesAtI = 1;
            while (i + numTiedValuesAtI < as.length() && BoxesRunTime.equals(a.apply(as.apply(i + numTiedValuesAtI)), a.apply(as.apply(i)))) {
                ++numTiedValuesAtI;
            }
            double rank2 = (double)(1 + i) + (double)(numTiedValuesAtI - 1) / 2.0;
            for (int j = 0; j < numTiedValuesAtI; ++j) {
                rv[BoxesRunTime.unboxToInt((Object)as.apply((int)(i + j)))] = rank2;
            }
        }
        return rv;
    }

    public <T> DenseMatrix<T> lowerTriangular(Matrix<T> X, Semiring<T> evidence$2, ClassTag<T> evidence$3, DefaultArrayValue<T> evidence$4) {
        int N = X.rows();
        return (DenseMatrix)DenseMatrix$.MODULE$.tabulate(N, N, new Serializable(X, evidence$2){
            public static final long serialVersionUID = 0L;
            private final Matrix X$1;
            private final Semiring evidence$2$1;

            public final T apply(int i, int j) {
                return (T)(j <= i ? this.X$1.apply(i, j) : ((Semiring)Predef$.MODULE$.implicitly((Object)this.evidence$2$1)).zero());
            }
            {
                this.X$1 = X$1;
                this.evidence$2$1 = evidence$2$1;
            }
        }, evidence$3, evidence$4);
    }

    public <T> DenseMatrix<T> upperTriangular(Matrix<T> X, Semiring<T> evidence$5, ClassTag<T> evidence$6, DefaultArrayValue<T> evidence$7) {
        int N = X.rows();
        return (DenseMatrix)DenseMatrix$.MODULE$.tabulate(N, N, new Serializable(X, evidence$5){
            public static final long serialVersionUID = 0L;
            private final Matrix X$2;
            private final Semiring evidence$5$1;

            public final T apply(int i, int j) {
                return (T)(j >= i ? this.X$2.apply(i, j) : ((Semiring)Predef$.MODULE$.implicitly((Object)this.evidence$5$1)).zero());
            }
            {
                this.X$2 = X$2;
                this.evidence$5$1 = evidence$5$1;
            }
        }, evidence$6, evidence$7);
    }

    public PCA princomp(DenseMatrix<Object> x, Option<DenseMatrix<Object>> covmatOpt) {
        Option<DenseMatrix<Object>> option;
        block4: {
            PCA pCA;
            block3: {
                block2: {
                    option = covmatOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    DenseMatrix covmat = (DenseMatrix)some.x();
                    pCA = new PCA(x, covmat);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<DenseMatrix<Object>> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                pCA = new PCA(x, this.cov(x, this.cov$default$2()));
            }
            return pCA;
        }
        throw new MatchError(option);
    }

    public Option<DenseMatrix<Object>> princomp$default$2() {
        return None$.MODULE$;
    }

    public DenseMatrix<Object> scale(DenseMatrix<Object> x, boolean center, boolean scale) {
        DenseMatrix denseMatrix;
        if (center) {
            DenseMatrix xc = (DenseMatrix)((NumericOps)x.apply($times$.MODULE$, scala.package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols()))).$minus(((DenseMatrix)breeze.stats.package$.MODULE$.mean().apply(x, Axis$_0$.MODULE$, UFunc$.MODULE$.collapseUred(DenseMatrix$.MODULE$.handholdCanMapRows(), breeze.stats.package$.MODULE$.mean().reduce_Double(DenseVector$.MODULE$.canIterateValues()), DenseMatrix$.MODULE$.canCollapseRows(ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$)))).toDenseVector$mcD$sp(), BroadcastedRows$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapCols(), DenseVector$.MODULE$.canSubD(), DenseMatrix$.MODULE$.canMapCols(ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$)));
            denseMatrix = scale ? (DenseMatrix)((NumericOps)xc.apply($times$.MODULE$, scala.package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols()))).$colon$div(breeze.stats.package$.MODULE$.stddev().apply(x.apply(scala.package$.MODULE$.$colon$colon(), $times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows())), BroadcastedColumns$.MODULE$.broadcastOp(DenseMatrix$.MODULE$.handholdCanMapRows(), breeze.stats.package$.MODULE$.stddev().reduceDouble(breeze.stats.package$.MODULE$.variance().reduceDouble(breeze.stats.package$.MODULE$.meanAndVariance().reduceDouble(DenseVector$.MODULE$.canIterateValues()))), DenseMatrix$.MODULE$.canCollapseRows(ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$))).toDenseVector$mcD$sp(), BroadcastedRows$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapCols(), DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), DenseMatrix$.MODULE$.canMapCols(ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$))) : xc;
        } else {
            denseMatrix = scale ? (DenseMatrix)((NumericOps)x.apply($times$.MODULE$, scala.package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols()))).$colon$div(this.columnRMS(x), BroadcastedRows$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapCols(), DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), DenseMatrix$.MODULE$.canMapCols(ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$))) : x;
        }
        return denseMatrix;
    }

    public boolean scale$default$2() {
        return true;
    }

    public boolean scale$default$3() {
        return false;
    }

    public DenseMatrix<Object> cov(DenseMatrix<Object> x, boolean center) {
        DenseMatrix<Object> xc = this.scale(x, center, false);
        return (DenseMatrix)((NumericOps)((NumericOps)xc.t(DenseMatrix$.MODULE$.canTranspose())).$times(xc, DenseMatrix$.MODULE$.DenseMatrixDMulDenseMatrixD())).$div$eq(BoxesRunTime.boxToDouble((double)((double)xc.rows() - 1.0)), DenseMatrix$.MODULE$.dm_s_UpdateOp_Double_OpDiv());
    }

    public boolean cov$default$2() {
        return true;
    }

    private DenseVector<Object> columnRMS(DenseMatrix<Object> x) {
        return ((DenseMatrix)((MatrixLike)((NumericOps)sum$.MODULE$.apply(x.$colon$times(x, DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar()), Axis$_0$.MODULE$, UFunc$.MODULE$.collapseUred(DenseMatrix$.MODULE$.handholdCanMapRows(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()), DenseMatrix$.MODULE$.canCollapseRows(ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$)))).$div(BoxesRunTime.boxToDouble((double)((double)x.rows() - 1.0)), DenseMatrix$.MODULE$.op_DM_S_Double_OpDiv())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.sqrt(x);
            }
        }, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))).toDenseVector$mcD$sp();
    }

    private package$() {
        MODULE$ = this;
    }
}

