/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics;

import breeze.generic.UFunc$;
import breeze.linalg.scaleAdd$;
import breeze.numerics.Scaling;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import scala.Int$;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public abstract class Scaling$class {
    public static int scaleArray(Scaling $this, double[] scores, int currentScale) {
        int scaleDelta = $this.computeScaleDelta(scores);
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
        return currentScale + scaleDelta;
    }

    public static int computeScaleDelta(Scaling $this, double[] scores) {
        int maxScale = -10000;
        for (int i = 0; i < scores.length; ++i) {
            double score = scores[i];
            if (score == 0.0) continue;
            int exp = Math.getExponent(score);
            maxScale = package$.MODULE$.max(maxScale, exp);
        }
        return maxScale == -10000 ? 0 : (maxScale > $this.scaleConstant() ? $this.scaleConstant() * (maxScale / $this.scaleConstant()) : (maxScale < -$this.scaleConstant() ? $this.scaleConstant() * (maxScale / $this.scaleConstant()) : 0));
    }

    public static int determineScale(Scaling $this, double score, int oldScale) {
        int maxScale;
        return score != 0.0 ? ((maxScale = Math.getExponent(score)) == -10000 ? oldScale : (maxScale > $this.scaleConstant() ? oldScale + $this.scaleConstant() * (maxScale / $this.scaleConstant()) : (maxScale < -$this.scaleConstant() ? oldScale + $this.scaleConstant() * (maxScale / $this.scaleConstant()) : oldScale))) : Integer.MIN_VALUE;
    }

    public static void scaleArrayToScale(Scaling $this, double[] scores, int currentScale, int targetScale) {
        int scaleDelta = targetScale - currentScale;
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
    }

    public static int sumArrays(Scaling $this, double[] src, int srcScale, double[] dest, int destScale) {
        int n;
        if (destScale == srcScale) {
            breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)1.0), src, dest, scaleAdd$.MODULE$.scaleAddArray_Double());
            n = destScale;
        } else if (destScale - srcScale > 53 + 2 * $this.scaleConstant()) {
            n = destScale;
        } else if (srcScale - destScale > 53 + 2 * $this.scaleConstant()) {
            System.arraycopy(src, 0, dest, 0, dest.length);
            n = srcScale;
        } else if (srcScale > destScale) {
            $this.scaleArrayToScale(dest, destScale, srcScale);
            for (int i = 0; i < dest.length; ++i) {
                int n2 = i;
                dest[n2] = dest[n2] + src[i];
            }
            n = srcScale;
        } else {
            int scaleDelta = destScale - srcScale;
            for (int i = 0; i < dest.length; ++i) {
                int n3 = i;
                dest[n3] = dest[n3] + Math.scalb(src[i], -scaleDelta);
            }
            n = destScale;
        }
        return n;
    }

    public static double unscaleValue(Scaling $this, double score, int currentScale) {
        return Math.scalb(score, currentScale);
    }

    public static double scaleValue(Scaling $this, double score, int currentScale, int targetScale) {
        return Math.scalb(score, currentScale - targetScale);
    }

    public static double toLogSpace(Scaling $this, double score, int currentScale) {
        return package$log$.MODULE$.apply$mDDc$sp(score, package$log$logDoubleImpl$.MODULE$) + (double)currentScale * package$log$.MODULE$.apply$mIDc$sp(2, UFunc$.MODULE$.implicitDoubleUTag(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(int x) {
                return this.apply$mcDI$sp(x);
            }

            public double apply$mcDI$sp(int x) {
                return Int$.MODULE$.int2double(x);
            }
        }, package$log$logDoubleImpl$.MODULE$));
    }

    public static void $init$(Scaling $this) {
    }
}

