/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics.financial;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.numerics.financial.package;
import breeze.numerics.financial.package$End$;
import breeze.numerics.financial.package$Start$;
import breeze.storage.DefaultArrayValue$DoubleDefaultArrayValue$;
import scala.Predef$;
import scala.Tuple3;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public double futureValue(double rate, int numPeriods, double payment, double presentValue, package.PaymentTime when) {
        double d;
        Predef$.MODULE$.require(numPeriods >= 0);
        if (rate == 0.0) {
            d = (double)-1 * (presentValue + payment * (double)numPeriods);
        } else {
            double fromPv = presentValue * scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods);
            double fromPayments = payment * ((1.0 + rate * (double)when.t()) / rate) * (scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods) - 1.0);
            d = (double)-1 * (fromPv + fromPayments);
        }
        return d;
    }

    public package.PaymentTime futureValue$default$5() {
        return package$End$.MODULE$;
    }

    public double presentValue(double rate, int numPeriods, double payment, double futureValue, package.PaymentTime when) {
        double d;
        Predef$.MODULE$.require(numPeriods >= 0);
        if (rate == 0.0) {
            d = (double)-1 * (futureValue + payment * (double)numPeriods);
        } else {
            double denominator = scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods);
            double fromPayments = payment * ((1.0 + rate * (double)when.t()) / rate) * (scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods) - 1.0);
            d = (double)-1 * (futureValue + fromPayments) / denominator;
        }
        return d;
    }

    public package.PaymentTime presentValue$default$5() {
        return package$End$.MODULE$;
    }

    public double payment(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        double d;
        if (rate == 0.0) {
            d = (double)-1 * (futureValue + presentValue) / (double)numPeriods;
        } else {
            double denominator = (1.0 + rate * (double)when.t()) / rate * (scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods) - 1.0);
            d = (double)-1 * (futureValue + presentValue * scala.math.package$.MODULE$.pow(1.0 + rate, (double)numPeriods)) / denominator;
        }
        return d;
    }

    public double payment$default$4() {
        return 0.0;
    }

    public package.PaymentTime payment$default$5() {
        return package$End$.MODULE$;
    }

    public Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> principalInterest(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        package.PaymentTime paymentTime = when;
        package$Start$ package$Start$2 = package$Start$.MODULE$;
        if (!(paymentTime != null ? !paymentTime.equals(package$Start$2) : package$Start$2 != null)) {
            throw new IllegalArgumentException("This method is broken for payment at the start of the period!");
        }
        double pmt = this.payment(rate, numPeriods, presentValue, futureValue, when);
        DenseVector<Object> interestPayment = DenseVector$.MODULE$.zeros$mDc$sp(numPeriods, (ClassTag<Object>)ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$);
        DenseVector<Object> principalPayment = DenseVector$.MODULE$.zeros$mDc$sp(numPeriods, (ClassTag<Object>)ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$);
        DenseVector<Object> principalRemaining = DenseVector$.MODULE$.zeros$mDc$sp(numPeriods, (ClassTag<Object>)ClassTag$.MODULE$.Double(), DefaultArrayValue$DoubleDefaultArrayValue$.MODULE$);
        double principal = presentValue;
        double interest = presentValue * rate;
        for (int index$1 = 0; index$1 < numPeriods; ++index$1) {
            double ip = (double)-1 * scala.math.package$.MODULE$.max(interest, 0.0);
            interest += ip;
            principalRemaining.unsafeUpdate$mcD$sp(index$1, principal += pmt - ip);
            interestPayment.unsafeUpdate$mcD$sp(index$1, ip);
            principalPayment.unsafeUpdate$mcD$sp(index$1, pmt - ip);
            interest += (principal + interest) * rate;
        }
        return new Tuple3(principalPayment, interestPayment, principalRemaining);
    }

    public double principalInterest$default$4() {
        return 0.0;
    }

    public package.PaymentTime principalInterest$default$5() {
        return package$End$.MODULE$;
    }

    public DenseVector<Object> interestPayments(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        return (DenseVector)this.principalInterest(rate, numPeriods, presentValue, futureValue, when)._1();
    }

    public double interestPayments$default$4() {
        return 0.0;
    }

    public package.PaymentTime interestPayments$default$5() {
        return package$End$.MODULE$;
    }

    public DenseVector<Object> principalPayments(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        return (DenseVector)this.principalInterest(rate, numPeriods, presentValue, futureValue, when)._2();
    }

    public double principalPayments$default$4() {
        return 0.0;
    }

    public package.PaymentTime principalPayments$default$5() {
        return package$End$.MODULE$;
    }

    public DenseVector<Object> principalRemaining(double rate, int numPeriods, double presentValue, double futureValue, package.PaymentTime when) {
        return (DenseVector)this.principalInterest(rate, numPeriods, presentValue, futureValue, when)._3();
    }

    public double principalRemaining$default$4() {
        return 0.0;
    }

    public package.PaymentTime principalRemaining$default$5() {
        return package$End$.MODULE$;
    }

    private package$() {
        MODULE$ = this;
    }
}

