/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.DenseVector$canDotD$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.optimize.linear.NNLS;
import breeze.optimize.proximal.QpGenerator$;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class NNLS$
implements Serializable {
    public static NNLS$ MODULE$;

    static {
        new NNLS$();
    }

    public double computeObjectiveValue(DenseMatrix<Object> ata, DenseVector<Object> atb, DenseVector<Object> x) {
        double res = BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)((ImmutableNumericOps)x.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times(ata, DenseMatrix$.MODULE$.implOpMulMatrix_DVTt_DMT_eq_DMT(DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()))).$times(x, Transpose$.MODULE$.transTimesNormalFromDot(DenseVector$canDotD$.MODULE$))) * 0.5 - BoxesRunTime.unboxToDouble((Object)atb.dot(x, DenseVector$canDotD$.MODULE$));
        return res;
    }

    public NNLS apply(int iters) {
        return new NNLS(iters);
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: NNLS n s");
            Predef$.MODULE$.println((Object)"Test NNLS with quadratic function of dimension n for s consecutive solves");
            throw package$.MODULE$.exit(1);
        }
        int problemSize = new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt();
        int numSolves = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        NNLS nnls = new NNLS(this.$lessinit$greater$default$1());
        long nnlsTime = 0L;
        for (int i = 0; i < numSolves; ++i) {
            DenseMatrix<Object> ata = QpGenerator$.MODULE$.getGram(problemSize);
            DenseVector atb = (DenseVector)DenseVector$.MODULE$.rand(problemSize, (Rand)Rand$.MODULE$.gaussian(0.0, 1.0), ClassTag$.MODULE$.Double());
            long startTime = System.nanoTime();
            nnls.minimize(ata, atb);
            nnlsTime += System.nanoTime() - startTime;
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NNLS problemSize ", " solves ", " ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)problemSize), BoxesRunTime.boxToInteger((int)numSolves), BoxesRunTime.boxToDouble((double)((double)nnlsTime / 1000000.0))})));
    }

    public int $lessinit$greater$default$1() {
        return -1;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NNLS$() {
        MODULE$ = this;
    }
}

