/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.regression;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$mcD$sp;
import breeze.stats.regression.LeastSquaresRegressionResult;
import com.github.fommil.netlib.LAPACK;
import java.io.Serializable;
import java.util.Arrays;
import org.netlib.util.intW;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class leastSquaresImplementation$ {
    public static final leastSquaresImplementation$ MODULE$ = new leastSquaresImplementation$();

    public LeastSquaresRegressionResult doLeastSquares(DenseMatrix<Object> data, DenseVector<Object> outputs, double[] workArray) {
        Predef$.MODULE$.require(data.rows() == outputs.size());
        Predef$.MODULE$.require(data.rows() > data.cols() + 1);
        Predef$.MODULE$.require(workArray.length >= 2 * data.rows() * data.cols());
        intW info = new intW(0);
        LAPACK.getInstance().dgels("N", data.rows(), data.cols(), 1, data.data$mcD$sp(), data.rows(), outputs.data$mcD$sp(), data.rows(), workArray, workArray.length, info);
        if (info.val < 0) {
            throw new ArithmeticException("Least squares did not converge.");
        }
        DenseVector$mcD$sp coefficients = new DenseVector$mcD$sp(Arrays.copyOf(outputs.data$mcD$sp(), data.cols()));
        DoubleRef r2 = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.rows() - data.cols()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> r2$1.elem += package$.MODULE$.pow(outputs.data$mcD$sp()[data.cols() + i], 2.0));
        return new LeastSquaresRegressionResult(coefficients, r2.elem);
    }

    private leastSquaresImplementation$() {
    }
}

